#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 Allure
version:              0.11.0.0
visibility:           public
id:                   Allure-0.11.0.0-Eqsy8JXBU3H1AsJDcvkmhW
key:                  Allure-0.11.0.0-Eqsy8JXBU3H1AsJDcvkmhW
license:              AGPL-3.0-or-later
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             http://allureofthestars.com
synopsis:             Near-future Sci-Fi roguelike and tactical squad combat game
description:
    Allure of the Stars is a near-future Sci-Fi roguelike
    and tactical squad combat game. Binaries and the game manual
    are available at the homepage. You can also try the game out
    in the browser at <http://allureofthestars.com/play>.

    Not a single image in this game. You have to imagine everything
    yourself, like with a book (a grown-up book, without pictures).
    Once you learn to imagine things, though, you can keep exploring
    and mastering the world and making up stories for a long time.

    The game is written in Haskell using the LambdaHack roguelike
    game engine <http://hackage.haskell.org/package/LambdaHack>.
    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    are high replayability and auto-balancing through procedural
    content generation and persistent content modification
    based on player behaviour. Contributions are welcome.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game
abi:                  52319aeb9a81994a49593df6c55d7f55
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_Allure
import-dirs:          /usr/lib/ghc-9.0.2/site-local/Allure-0.11.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/Allure-0.11.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/allure
hs-libraries:         HSAllure-0.11.0.0-Eqsy8JXBU3H1AsJDcvkmhW
depends:
    LambdaHack-0.11.0.0-H9HpQrfr6gS7HViTLDUFcn
    async-2.2.4-FN1EWRVHp3S4oHdBJm7ot4 base-4.15.1.0
    enummapset-0.7.1.0-FJP1PDD2Lhw5pM2RxPwayv
    file-embed-0.0.15.0-FF5xUPWKaB3GI64c6hgPnn filepath-1.4.2.1
    ghc-compact-0.1.0.0 hsini-0.5.1.3-1Nyzwa5b55e5T8z88pZ41l
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb
    primitive-0.7.4.0-8RUdbvjRYjOFHQ1vgzaS7Q
    splitmix-0.1.0.4-C7qzaU2AdKXIINiZhLxPNL template-haskell-2.17.0.0
    text-1.2.5.0 th-lift-instances-0.1.20-Cb8K81p9utM1skQxiFjQn2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/allure/html/Allure.haddock
haddock-html:         /usr/share/doc/allure/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

