#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.11.1.0
visibility:           public
id:                   arch-hs-0.11.1.0-Gf8ZJzpKJm88fscMquN9MQ
key:                  arch-hs-0.11.1.0-Gf8ZJzpKJm88fscMquN9MQ
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  0bc4ac9d1799921f83e81c3277965a3f
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.0.2/site-local/arch-hs-0.11.1.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/arch-hs-0.11.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.11.1.0-Gf8ZJzpKJm88fscMquN9MQ
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.0.2/site-local/arch-hs-0.11.1.0/include
depends:
    Cabal-3.4.1.0 Diff-0.4.1-GdxJqSCBWVSImKhqghLkQt
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    algebraic-graphs-0.7-DOMjEgOdDjTKYZFcIeQtc3
    arch-web-0.2-BWm3VP16ijUJd9i7idGTqM base-4.15.1.0
    bytestring-0.10.12.1 conduit-1.3.5-Jq81tBeR2eG6Vm9Wfmg9Au
    conduit-extra-1.3.6-81BNaX6jVC8HfEWFG32czK containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.2 filepath-1.4.2.1
    hackage-db-2.1.3-GmPJahpxMxK2ZEmpUgewCb
    http-client-0.7.13.1-E99uRcHPg6l4pFHjAbr9ZZ
    http-client-tls-0.3.6.3-83gtNL69go4HzvcH7SqbBN
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX
    microlens-0.4.13.1-AoR6D5midYZB5ErWoiySs4
    microlens-th-0.4.3.13-2F8uJinYM5B66CBFDh33gA
    neat-interpolation-0.5.1.3-I2bowZTrM9w4KdMjffuNIr
    optparse-simple-0.1.1.4-CXEZlZvTToJHd74MjUgGwS
    polysemy-1.9.1.1-KVN1Z5FdkfQ2Q6SvHCU7Nq
    prettyprinter-1.7.1-9bwAyMlaUSyJVG7FMXWGKT
    prettyprinter-ansi-terminal-1.1.3-C9dAq9WFsAp2PXcJori7vo
    servant-client-0.19-52veIE2plYRLEUSFddUxoa
    split-0.2.3.5-2QcOUxLgyp8IUTikrwTasf
    tar-conduit-0.4.0-D4Jq7g5RxGDGIYhmNOnqZo template-haskell-2.17.0.0
    text-1.2.5.0

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

