/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.invocation.DefaultInvocationFactory;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.util.Platform;
import org.mockito.internal.util.StringUtil;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;

public class ProxyMockMaker
implements MockMaker {
    private static final Object[] EMPTY = new Object[0];
    private final Method invokeDefault;

    public ProxyMockMaker() {
        Method m;
        try {
            m = InvocationHandler.class.getMethod("invokeDefault", Object.class, Method.class, Object[].class);
        }
        catch (NoSuchMethodException ignored) {
            m = null;
        }
        this.invokeDefault = m;
    }

    @Override
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        Class[] ifaces = new Class[settings.getExtraInterfaces().size() + 1];
        ifaces[0] = settings.getTypeToMock();
        int index = 1;
        for (Class<?> iface : settings.getExtraInterfaces()) {
            ifaces[index++] = iface;
        }
        return (T)Proxy.newProxyInstance(settings.getTypeToMock().getClassLoader(), ifaces, (InvocationHandler)new MockInvocationHandler(handler, settings));
    }

    @Override
    public MockHandler getHandler(Object mock) {
        if (!Proxy.isProxyClass(mock.getClass())) {
            return null;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(mock);
        if (!(handler instanceof MockInvocationHandler)) {
            return null;
        }
        return (MockHandler)((MockInvocationHandler)handler).handler.get();
    }

    @Override
    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        ((MockInvocationHandler)Proxy.getInvocationHandler(mock)).handler.set(newHandler);
    }

    @Override
    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            @Override
            public boolean mockable() {
                return type.isInterface();
            }

            @Override
            public String nonMockableReason() {
                return this.mockable() ? "" : "non-interface";
            }
        };
    }

    private class RealDefaultMethod
    implements RealMethod {
        private final Object proxy;
        private final SerializableMethod serializableMethod;
        private final Object[] args;

        private RealDefaultMethod(Object proxy, Method method, Object[] args) {
            this.proxy = proxy;
            this.serializableMethod = new SerializableMethod(method);
            this.args = args;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            try {
                return ProxyMockMaker.this.invokeDefault.invoke(null, this.proxy, this.serializableMethod.getJavaMethod(), this.args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MockitoException(StringUtil.join("Failed to access default method or invoked method with illegal arguments", "", "Method " + this.serializableMethod.getJavaMethod() + " could not be delegated, this is not supposed to happen", Platform.describe()), e);
            }
        }
    }

    private class MockInvocationHandler
    implements InvocationHandler {
        private final AtomicReference<MockHandler<?>> handler;
        private final MockCreationSettings<?> settings;

        private MockInvocationHandler(MockHandler<?> handler, MockCreationSettings<?> settings) {
            this.handler = new AtomicReference(handler);
            this.settings = settings;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null) {
                args = EMPTY;
            }
            if (method.getDeclaringClass() == Object.class) {
                switch (method.getName()) {
                    case "hashCode": {
                        return System.identityHashCode(proxy);
                    }
                    case "equals": {
                        return proxy == args[0];
                    }
                    case "toString": {
                        break;
                    }
                    default: {
                        throw new MockitoException(StringUtil.join("Unexpected overridable method of Object class found", "", "The method " + method + " was not expected to be declared. Either your JVM build offers non-official API or the current functionality is not supported", Platform.describe()));
                    }
                }
            }
            RealMethod realMethod = ProxyMockMaker.this.invokeDefault == null || Modifier.isAbstract(method.getModifiers()) ? RealMethod.IsIllegal.INSTANCE : new RealDefaultMethod(proxy, method, args);
            return this.handler.get().handle(DefaultInvocationFactory.createInvocation(proxy, method, args, realMethod, this.settings, new LocationImpl()));
        }
    }
}

