/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Consider annotating methods that always throw with @DoNotCall. Read more at https://errorprone.info/bugpattern/DoNotCall", severity=BugPattern.SeverityLevel.WARNING)
public class DoNotCallSuggester
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<String> METHOD_PREFIXES_TO_IGNORE = ImmutableSet.of((Object)"produce", (Object)"provide");
    private static final ImmutableSet<String> METHOD_SUBSTRINGS_TO_IGNORE = ImmutableSet.of((Object)"throw", (Object)"fail", (Object)"exception", (Object)"propagate");
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of((Object)"com.google.errorprone.annotations.DoNotCall", (Object)"java.lang.Override", (Object)"dagger.Provides", (Object)"dagger.producers.Produces", (Object)"net.starlark.java.annot.StarlarkMethod");
    private static final ImmutableSet<String> PARENT_CLASS_TO_IGNORE = ImmutableSet.of((Object)"com.google.inject.AbstractModule");
    private static final ImmutableSet<String> RETURNED_SUPER_TYPES_TO_IGNORE = ImmutableSet.of((Object)"java.lang.Throwable");

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        if (tree.getBody().getStatements().size() != 1) {
            return Description.NO_MATCH;
        }
        if (symbol.getModifiers().contains((Object)Modifier.PRIVATE) || ASTHelpers.methodCanBeOverridden((Symbol.MethodSymbol)symbol)) {
            return Description.NO_MATCH;
        }
        StatementTree statement = (StatementTree)Iterables.getOnlyElement(tree.getBody().getStatements());
        if (!(statement instanceof ThrowTree)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass((Symbol)symbol);
        Type.ClassType enclosingType = ASTHelpers.getType((ClassTree)ASTHelpers.findClass((Symbol.ClassSymbol)enclosingClass, (VisitorState)state));
        for (String parentClass : PARENT_CLASS_TO_IGNORE) {
            Type parentClassType = state.getTypeFromString(parentClass);
            if (!ASTHelpers.isSubtype((Type)enclosingType, (Type)parentClassType, (VisitorState)state)) continue;
            return Description.NO_MATCH;
        }
        if (enclosingClass.isAnonymous()) {
            return Description.NO_MATCH;
        }
        String methodName = tree.getName().toString().toLowerCase();
        for (String methodPrefix : METHOD_PREFIXES_TO_IGNORE) {
            if (!methodName.startsWith(methodPrefix)) continue;
            return Description.NO_MATCH;
        }
        for (String methodSubstring : METHOD_SUBSTRINGS_TO_IGNORE) {
            if (!methodName.contains(methodSubstring)) continue;
            return Description.NO_MATCH;
        }
        for (String annotationToIgnore : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Tree)tree, (String)annotationToIgnore, (VisitorState)state)) continue;
            return Description.NO_MATCH;
        }
        Type returnType = ASTHelpers.getType((Tree)tree.getReturnType());
        for (String returnedSuperType : RETURNED_SUPER_TYPES_TO_IGNORE) {
            Type throwableType = state.getTypeFromString(returnedSuperType);
            if (!ASTHelpers.isSubtype((Type)returnType, (Type)throwableType, (VisitorState)state)) continue;
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).isEmpty()) {
            return Description.NO_MATCH;
        }
        Type thrownType = ASTHelpers.getType((Tree)((ThrowTree)statement).getExpression());
        SuggestedFix fix = SuggestedFix.builder().addImport("com.google.errorprone.annotations.DoNotCall").prefixWith((Tree)tree, "@DoNotCall(\"Always throws " + thrownType + "\") ").build();
        return this.buildDescription(tree).setMessage("Methods that always throw an exception should be annotated with @DoNotCall to prevent calls at compilation time vs. at runtime (note that adding @DoNotCall will break any existing callers of this API).").addFix((Fix)fix).build();
    }
}

