/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;

@BugPattern(summary="Comparison using reference equality instead of value equality", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class ReferenceEquality
extends AbstractReferenceEquality {
    private static final Supplier<Name> EQUALS = VisitorState.memoize((Supplier & Serializable)state -> state.getName("equals"));

    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (!type.isReference()) {
            return false;
        }
        ClassTree classTree = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (classTree == null) {
            return false;
        }
        Type.ClassType classType = ASTHelpers.getType((ClassTree)classTree);
        if (classType == null) {
            return false;
        }
        if (ReferenceEquality.inComparisonMethod(classType, type, state)) {
            return false;
        }
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().enumSym.type, (VisitorState)state)) {
            return false;
        }
        if (ASTHelpers.isSubtype((Type)type, (Type)state.getSymtab().classType, (VisitorState)state)) {
            return false;
        }
        return ReferenceEquality.implementsEquals(type, state);
    }

    private static boolean inComparisonMethod(Type classType, Type type, VisitorState state) {
        Symtab symtab = state.getSymtab();
        LambdaExpressionTree lambdaTree = (LambdaExpressionTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), LambdaExpressionTree.class);
        if (lambdaTree != null) {
            return ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)lambdaTree), (Type)symtab.comparatorType, (VisitorState)state);
        }
        MethodTree methodTree = ASTHelpers.findEnclosingMethod((VisitorState)state);
        if (methodTree == null) {
            return false;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (sym.isStatic()) {
            return false;
        }
        if (ReferenceEquality.overridesMethodOnType(classType, sym, symtab.comparatorType, "compare", state)) {
            return true;
        }
        if (ReferenceEquality.overridesMethodOnType(classType, sym, symtab.comparableType, "compareTo", state) || ReferenceEquality.overridesMethodOnType(classType, sym, symtab.objectType, "equals", state)) {
            return ASTHelpers.isSameType((Type)type, (Type)classType, (VisitorState)state);
        }
        return false;
    }

    private static boolean overridesMethodOnType(Type classType, Symbol.MethodSymbol methodSymbol, Type overriddenType, String overriddenMethodName, VisitorState state) {
        Symbol overriddenMethodSymbol = ReferenceEquality.getOnlyMember(state, overriddenType, overriddenMethodName);
        return ((Name)methodSymbol.getSimpleName()).contentEquals(overriddenMethodName) && methodSymbol.overrides(overriddenMethodSymbol, classType.tsym, state.getTypes(), false);
    }

    private static Symbol getOnlyMember(VisitorState state, Type type, String name) {
        return (Symbol)Iterables.getOnlyElement(type.tsym.members().getSymbolsByName(state.getName(name)));
    }

    public static boolean implementsEquals(Type type, VisitorState state) {
        Name equalsName = (Name)EQUALS.get(state);
        Symbol objectEquals = ReferenceEquality.getOnlyMember(state, state.getSymtab().objectType, "equals");
        for (Type sup : state.getTypes().closure(type)) {
            if (sup.tsym.isInterface()) continue;
            if (ASTHelpers.isSameType((Type)sup, (Type)state.getSymtab().objectType, (VisitorState)state)) {
                return false;
            }
            Scope.WriteableScope scope = sup.tsym.members();
            if (scope == null) continue;
            for (Symbol sym : scope.getSymbolsByName(equalsName)) {
                if (!sym.overrides(objectEquals, type.tsym, state.getTypes(), false)) continue;
                return true;
            }
        }
        return false;
    }
}

