/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import javax.lang.model.element.Element;

@BugPattern(summary="The documented method doesn't actually throw this checked exception.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class InvalidThrows
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new ThrowsChecker(state, methodTree).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class ThrowsChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final MethodTree methodTree;

        private ThrowsChecker(VisitorState state, MethodTree methodTree) {
            this.state = state;
            this.methodTree = methodTree;
        }

        @Override
        public Void visitThrows(ThrowsTree throwsTree, Void unused) {
            Type type;
            ReferenceTree exName = throwsTree.getExceptionName();
            Element element = JavacTrees.instance(this.state.context).getElement(new DocTreePath(this.getCurrentPath(), exName));
            if (element != null && this.isCheckedException(type = (Type)element.asType()) && this.methodTree.getThrows().stream().noneMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)ASTHelpers.getType((Tree)t), (VisitorState)this.state))) {
                this.state.reportMatch(InvalidThrows.this.describeMatch(Utils.diagnosticPosition(this.getCurrentPath(), this.state), (Fix)Utils.replace(throwsTree, "", this.state)));
            }
            return (Void)super.visitThrows(throwsTree, null);
        }

        private boolean isCheckedException(Type type) {
            return type.hasTag(TypeTag.CLASS) && !this.state.getTypes().isAssignable(type, this.state.getSymtab().errorType) && !this.state.getTypes().isAssignable(type, this.state.getSymtab().runtimeExceptionType);
        }
    }
}

