################################################################################
#
# CCTag - Detection of CCTag markers made up of concentric circles
#
# Copyright 2016, Simula Research Laboratory
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

# Config file for CCTag.
#
# This file is used by CMake when find_package(CCTag) is invoked and either
# the directory containing this file either is present in CMAKE_MODULE_PATH
# (if CCTag was installed), or exists in the local CMake package registry if
# the CCTag build directory was exported.
#
# This module defines a namespace CCTag:: and the target needed to compile and
# link against the library. The target automatically propagate the dependencies
# of the library.
#
# In your CMakeLists.txt  file just add the dependency
#
# find_package(CCTag CONFIG REQUIRED)
#
# Then if you want to link it to an executable
#
# add_executable(cctagTest yourfile.cpp)
#
# Then to the library
#
# target_link_libraries(cctagTest PUBLIC CCTag::CCTag)
#
# Note that target_include_directories() is not necessary.
#
################################################################################



####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/CCTag" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################.

include(CMakeFindDependencyMacro)

set(OpenCV_DIR /usr/lib/cmake/opencv4)
find_dependency(OpenCV )
find_dependency(TBB 2021.10.0)
find_dependency(Eigen3 3.3.4)
find_dependency(Boost 1.83.0 REQUIRED COMPONENTS atomic;chrono;date_time;filesystem;program_options;serialization;system;thread;timer;math_c99;stacktrace_basic;unit_test_framework)

include("${CMAKE_CURRENT_LIST_DIR}/CCTagTargets.cmake")
check_required_components("CCTag")
