/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import com.nvidia.common.internal.Activator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SWTUtil {
    public static <T> T call(final Callable<T> callable) throws Exception {
        if (Display.getCurrent() != null) {
            return callable.call();
        }
        final AtomicReference<Object> reference = new AtomicReference<Object>(null);
        final AtomicReference<Object> exceptionReference = new AtomicReference<Object>(null);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    reference.set(callable.call());
                }
                catch (Exception e) {
                    exceptionReference.set(e);
                }
            }
        });
        if (exceptionReference.get() != null) {
            throw (Exception)exceptionReference.get();
        }
        return reference.get();
    }

    public static <T> T callChecked(Callable<T> callable) {
        try {
            return SWTUtil.call(callable);
        }
        catch (Exception e) {
            Activator.log(e);
            throw new IllegalStateException(e);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getActiveWorkbenchWindow();
        }
        return null;
    }

    public static Image getImage(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            case 2: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
        }
        return null;
    }

    public static Image getImage(String sharedImage) {
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        return images.getImage(sharedImage);
    }

    public static Shell getShell() {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return null;
    }

    public static Point getTextExtent(Drawable drawable, String string) {
        GC gc = new GC(drawable);
        try {
            Point point = gc.textExtent(string, 6);
            return point;
        }
        finally {
            if (!gc.isDisposed()) {
                gc.dispose();
            }
        }
    }

    public static boolean isDisposed(Widget widget) {
        return widget == null || widget.isDisposed();
    }

    public static <T extends Widget> T safeDispose(T control) {
        if (!SWTUtil.isDisposed(control)) {
            control.dispose();
        }
        return null;
    }

    public static IEditorPart safeGetActiveEditor(IWorkbenchWindow window) {
        IWorkbenchPage page;
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static void setBackground(Control control, Color backgroundColor) {
        control.setBackground(backgroundColor);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SWTUtil.setBackground(child, backgroundColor);
                ++n2;
            }
        }
    }

    public static void setBackground(Control control, int backgroundColor) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        SWTUtil.setBackground(control, d.getSystemColor(backgroundColor));
    }

    public static void setEnabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Composite && !(control instanceof Combo)) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SWTUtil.setEnabled(child, enabled);
                ++n2;
            }
        }
    }

    public static void setVisible(Control control, boolean visible) {
        control.setVisible(visible);
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).exclude = !visible;
            control.setLayoutData(data);
        } else if (data == null && !visible && control.getParent().getLayout() instanceof GridLayout) {
            GridData gridData = new GridData();
            gridData.exclude = false;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void updateTitle(WizardPage page, IStatus status) {
        if (status == null) {
            SWTUtil.updateTitle(page, Status.OK_STATUS);
        } else {
            IWizardContainer container;
            page.setErrorMessage(null);
            page.setMessage(null);
            page.setPageComplete(status.getSeverity() < 4);
            switch (status.getSeverity()) {
                case 4: {
                    page.setErrorMessage(status.getMessage());
                    break;
                }
                case 2: {
                    page.setMessage(status.getMessage(), 2);
                }
            }
            IWizard wizard = page.getWizard();
            if (wizard != null && (container = wizard.getContainer()) != null && container.getCurrentPage() != null) {
                container.updateButtons();
            }
        }
    }

    private SWTUtil() {
    }
}

