/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalNvlink;
import com.nvidia.viper.model.TimelineKind;
import java.util.ArrayList;
import java.util.List;

public class TimelineNvlink
extends Timeline {
    private TimelineIntervalNvlink nvlinkTransmitInterval;
    private TimelineIntervalNvlink nvlinkReceiveInterval;
    private Long value;

    public TimelineNvlink(String name, TimelineKind kind) {
        super(name, kind);
    }

    public void addNvlinkInterval(TimelineIntervalNvlink nvlinkInterval) {
        if (nvlinkInterval.getKind().equals((Object)TimelineIntervalKind.NVLINK_TRANSMIT)) {
            this.nvlinkTransmitInterval = nvlinkInterval;
        } else if (nvlinkInterval.getKind().equals((Object)TimelineIntervalKind.NVLINK_RECEIVE)) {
            this.nvlinkReceiveInterval = nvlinkInterval;
        }
    }

    @Override
    public List<ITimelineInterval> getIntervals(boolean loadAnalysis) {
        ArrayList<ITimelineInterval> intervals = new ArrayList<ITimelineInterval>();
        intervals.add(this.nvlinkTransmitInterval);
        intervals.add(this.nvlinkReceiveInterval);
        return intervals;
    }

    @Override
    public synchronized void addAdditionalIntervals() {
        if (this.nvlinkTransmitInterval != null) {
            this.addInterval(this.nvlinkTransmitInterval, true);
        }
        if (this.nvlinkReceiveInterval != null) {
            this.addInterval(this.nvlinkReceiveInterval, true);
        }
    }

    @Override
    public int getIntervalRowHeight() {
        return 30;
    }

    public void setMaxValue(long value) {
        this.value = value;
    }

    public Long getMaxValue() {
        return this.value;
    }

    public long getAvgTransmitThroughput() {
        return this.nvlinkTransmitInterval.getAvgThroughput();
    }

    public long getMaxTransmitThroughput() {
        return this.nvlinkTransmitInterval.getMaxThroughput();
    }

    public long getTransmitIdleTime() {
        return this.nvlinkTransmitInterval.getIdleTime();
    }

    public long getAvgReceiveThroughput() {
        return this.nvlinkReceiveInterval.getAvgThroughput();
    }

    public long getMaxReceiveThroughput() {
        return this.nvlinkReceiveInterval.getMaxThroughput();
    }

    public long getReceiveIdleTime() {
        return this.nvlinkReceiveInterval.getIdleTime();
    }
}

