/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.core.Module;

abstract class ColumnBandAdapter {
    protected abstract ReportItemHandle getElementHandle();

    protected Module getModule() {
        return this.getElementHandle().getModule();
    }

    protected abstract SlotHandle getColumns();

    protected abstract int getColumnCount();

    ColumnBandAdapter() {
    }

    protected static int getColumnStartPos(ColumnHandle target) {
        SlotHandle columns = target.getContainerSlotHandle();
        int colStartPos = 1;
        int colPosInSlot = columns.findPosn(target);
        int i = 0;
        while (i < colPosInSlot) {
            ColumnHandle col = (ColumnHandle)columns.get(i);
            colStartPos += col.getRepeatCount();
            ++i;
        }
        return colStartPos;
    }

    protected abstract RowHandle getRow(int var1, int var2, int var3);

    protected int findCellPosition(RowHandle row, int columnToInsert, boolean insert) {
        SlotHandle cells = row.getCells();
        int i = 0;
        while (i < cells.getCount()) {
            CellHandle cell = (CellHandle)cells.get(i);
            int cellPos = this.getCellPosition(cell);
            if (columnToInsert == cellPos) {
                return insert ? i + 1 : i;
            }
            if (columnToInsert < cellPos) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected abstract int getRowCount();

    protected abstract boolean hasDroppingCell(List var1);

    protected List getCellsUnderColumn(int columnNumber) {
        return this.getCellsUnderColumn(columnNumber, true);
    }

    protected abstract List getCellsUnderColumn(int var1, boolean var2);

    protected List getCellsInSlot(SlotHandle handle, int columnIndex, boolean mustBeStartPosition) {
        ArrayList<CellHandle> retValue = new ArrayList<CellHandle>();
        int i = 0;
        while (i < handle.getCount()) {
            RowHandle row = (RowHandle)handle.get(i);
            CellHandle cell = this.getCellsInRow(row, columnIndex, mustBeStartPosition);
            if (cell != null) {
                retValue.add(cell);
            }
            ++i;
        }
        return retValue;
    }

    protected abstract int getCellPosition(CellHandle var1);

    private CellHandle getCellsInRow(RowHandle row, int columnIndex, boolean mustBeStartPosition) {
        SlotHandle cells = row.getCells();
        int i = 0;
        while (i < cells.getCount()) {
            CellHandle cell = (CellHandle)cells.get(i);
            int cellColumnIndex = this.getCellPosition(cell);
            if (cellColumnIndex == columnIndex) {
                return cell;
            }
            if (!mustBeStartPosition && cellColumnIndex < columnIndex && cellColumnIndex + cell.getColumnSpan() >= columnIndex) {
                return cell;
            }
            ++i;
        }
        return null;
    }

    protected abstract List getRowContainerSlots();

    protected final boolean hasParent() {
        return this.getElementHandle().getElement().isVirtualElement() || this.getElementHandle().getExtends() != null;
    }
}

