/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.ui.connection.toolkits;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.Images;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RemotePathCellEditor
extends CellEditor {
    private ToolBar bar;
    private ToolItem browse;
    private final IObservableValue connectionProvider;
    private ToolItem delete;
    private final AtomicBoolean focusInText = new AtomicBoolean(false);
    private boolean ignoreFocus = false;
    private Text text;
    private final IRunnableContext context;

    public RemotePathCellEditor(Composite parent, IRunnableContext context, IObservableValue connectionProvider) {
        super(parent);
        this.context = context;
        this.connectionProvider = connectionProvider;
    }

    public void apply() {
        this.fireApplyEditorValue();
    }

    protected void browse() {
        if (this.connectionProvider == null) {
            this.browseLocalFilesystem();
        } else {
            final IRemoteConnection connection = (IRemoteConnection)this.connectionProvider.getValue();
            Shell shell = this.bar.getShell();
            String path = this.text.getText();
            if (connection != null) {
                try {
                    this.context.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                connection.connect(IRemoteConnection.Service.Files, monitor);
                            }
                            catch (CoreException e) {
                                StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]), 2);
                            }
                        }
                    });
                    String newPath = connection.browse(shell, "Select remote folder containing CUDA libraries", path);
                    if (newPath != null) {
                        this.text.setText(newPath);
                        this.text.selectAll();
                    }
                }
                catch (InvocationTargetException e) {
                    Activator.log(e);
                }
                catch (InterruptedException e) {
                    Activator.log(e);
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
        }
    }

    private void browseLocalFilesystem() {
    }

    private void checkFocus(final Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RemotePathCellEditor.this.text != null && !RemotePathCellEditor.this.text.isDisposed() && RemotePathCellEditor.this.isActivated()) {
                    Control focusControl = display.getFocusControl();
                    if (focusControl == RemotePathCellEditor.this.text && !RemotePathCellEditor.this.focusInText.get()) {
                        RemotePathCellEditor.this.checkFocus(display);
                    } else if (!RemotePathCellEditor.this.bar.isDisposed() && !RemotePathCellEditor.this.focusInText.get() && focusControl != RemotePathCellEditor.this.bar) {
                        RemotePathCellEditor.this.focusLost();
                    }
                }
            }
        });
    }

    private void createButtonsBar(Composite pane) {
        this.bar = new ToolBar(pane, 0x800000);
        this.browse = new ToolItem(this.bar, 0);
        this.browse.setToolTipText("Browse...");
        this.browse.setImage(Images.Browse_Small.getImage());
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePathCellEditor.this.ignoreFocus = true;
                try {
                    RemotePathCellEditor.this.browse();
                }
                finally {
                    RemotePathCellEditor.this.text.setFocus();
                    RemotePathCellEditor.this.ignoreFocus = false;
                }
            }
        });
        this.delete = new ToolItem(this.bar, 0);
        this.delete.setImage(Images.Delete_Small.getImage());
        this.delete.setToolTipText("Delete");
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePathCellEditor.this.ignoreFocus = true;
                try {
                    RemotePathCellEditor.this.text.setText("");
                    RemotePathCellEditor.this.fireApplyEditorValue();
                }
                finally {
                    RemotePathCellEditor.this.ignoreFocus = false;
                }
            }
        });
    }

    protected Control createControl(Composite parent) {
        Composite pane = new Composite(parent, 0){

            public void setBounds(Rectangle rect) {
                super.setBounds(RemotePathCellEditor.this.forceTableWidth((Control)this, rect));
            }
        };
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pane.setLayout((Layout)layout);
        this.text = new Text(pane, 0);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                RemotePathCellEditor.this.focusInText.set(true);
            }

            public void focusLost(FocusEvent e) {
                Display display = RemotePathCellEditor.this.text.getDisplay();
                RemotePathCellEditor.this.checkFocus(display);
                if (!RemotePathCellEditor.this.ignoreFocus) {
                    RemotePathCellEditor.this.focusInText.set(false);
                }
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (RemotePathCellEditor.this.isActivated()) {
                    switch (e.detail) {
                        case 2: {
                            e.doit = false;
                            RemotePathCellEditor.this.fireCancelEditor();
                            break;
                        }
                        case 4: {
                            RemotePathCellEditor.this.fireApplyEditorValue();
                            e.doit = false;
                        }
                    }
                }
            }
        });
        this.createButtonsBar(pane);
        return pane;
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        this.text.selectAll();
        this.text.setFocus();
    }

    protected void doSetValue(Object value) {
        this.text.setText(String.valueOf(value));
    }

    protected Rectangle forceTableWidth(Control control, Rectangle bounds) {
        Rectangle parentClientArea = control.getParent().getClientArea();
        return new Rectangle(bounds.x, bounds.y, parentClientArea.width - bounds.x, bounds.height);
    }
}

