from ctypes import cdll
from pathlib import Path
import os
import sys

if sys.version_info < (3, 6):
    raise RuntimeError("Python 3.6 or later is required.")

try:
    from nsys_recipe.lib import *

    # Add necessary Nsys modules to path.
    modules = ['rules', 'reports', 'python/lib']
    module_paths = [nsys_path.find_installed_file(module) for module in modules]
    sys.path = module_paths + sys.path

    # Load the SQLite extension library.
    cdll.LoadLibrary(nsys_path.find_installed_file('libsqlite3.so.0'))

    # Expert System rules
    from nsys_recipe.cuda_api_sync.cuda_api_sync import CudaApiSync
    from nsys_recipe.cuda_memcpy_async.cuda_memcpy_async import CudaMemcpyAsync
    from nsys_recipe.cuda_memcpy_sync.cuda_memcpy_sync import CudaMemcpySync
    from nsys_recipe.cuda_memset_sync.cuda_memset_sync import CudaMemsetSync
    from nsys_recipe.dx12_mem_ops.dx12_mem_ops import Dx12MemOps
    from nsys_recipe.gpu_gaps.gpu_gaps import GpuGaps
    from nsys_recipe.gpu_time_util.gpu_time_util import GpuTimeUtil

    # Stats reports
    from nsys_recipe.cuda_api_sum.cuda_api_sum import CudaApiSum
    from nsys_recipe.cuda_gpu_kern_sum.cuda_gpu_kern_sum import CudaGpuKernSum
    from nsys_recipe.cuda_gpu_mem_size_sum.cuda_gpu_mem_size_sum import CudaGpuMemSizeSum
    from nsys_recipe.cuda_gpu_mem_time_sum.cuda_gpu_mem_time_sum import CudaGpuMemTimeSum
    from nsys_recipe.nvtx_gpu_proj_trace.nvtx_gpu_proj_trace import NvtxGpuProjTrace
    from nsys_recipe.nvtx_sum.nvtx_sum import NvtxSum
    from nsys_recipe.osrt_sum.osrt_sum import OsrtSum

    # Others
    from nsys_recipe.cuda_gpu_time_util_map.cuda_gpu_time_util_map import CudaGpuTimeUtilMap
    from nsys_recipe.gpu_metric_util_map.gpu_metric_util_map import GpuMetricUtilMap

    from nsys_recipe.cuda_gpu_kern_pace.cuda_gpu_kern_pace import CudaGpuKernPace
    from nsys_recipe.mpi_sum.mpi_sum import MpiSum
    from nsys_recipe.nccl_sum.nccl_sum import NcclSum
    from nsys_recipe.nvtx_gpu_proj_sum.nvtx_gpu_proj_sum import NvtxGpuProjSum
    from nsys_recipe.nvtx_pace.nvtx_pace import NvtxPace

except ModuleNotFoundError as e:
    recipe_dir = Path(__file__).parent
    sys.exit("ERROR: {}\nAll packages listed in '{}' must be installed. "
        "You can automate the installation using the '{}' script. "
        "For more information, please refer to the Nsight Systems User Guide."
        .format(e, recipe_dir / 'requirements/common.txt', recipe_dir / 'install.sh'))
