// DO NOT MODIFY.
// This file was created automatically by CMake.

// QuadDPlugin is the primary UI library for the product.
AppLib.logInfo("Loading QuadDPlugin");

var states = {
    ShowProjectExplorer: "$$.ShowProjectExplorer",
};

addPlugin({
    pluginDependencies: ["CorePlugin"],
    pluginLibrary: "QuadDPlugin",

    hostApplication: {
        multiTargetEnabled: "true",
        usbTargetsEnabled: "true",
        queryEnabled: "true",
        isStandalone: (AppLib.environment.quadd_standalone == true),
    },

    documents:
    {
        fileTypes:
        {
            "qdrep":
            {
                icon: "",
                factoryName: "ReportFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "nsys-rep":
            {
                icon: "",
                factoryName: "ReportFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "nsys-view":
            {
                icon: "",
                factoryName: "ReportViewFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "qdstrm":
            {
                icon: "",
                factoryName: "ImportStreamFactory",
                viewFactories:
                [
                    { factoryName: "ImportStreamWindowFactory", priority: 50 }
                ]
            },
            "ipynb":
            {
                icon: "",
                factoryName: "JupyterFactory",
                viewFactories:
                [
                    { factoryName: "JupyterWindowFactory", priority: 50 }
                ]
            },
            "nsys-analysis":
            {
                icon: "",
                factoryName: "RecipeReportFactory",
                viewFactories:
                [
                    { factoryName: "RecipeReportWindowFactory", priority: 50 }
                ]
            },
            "csv":
            {
                icon: "",
                factoryName: "RecipeTableFactory",
                viewFactories:
                [
                    { factoryName: "RecipeTableWindowFactory", priority: 50 }
                ]
            },
            "etl":
            {
                icon: "",
                factoryName: "ReportFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "qdresolve":
            {
                icon: "",
                factoryName: "ReportFactory",
                viewFactories:
                [
                    { factoryName: "ReportWindowFactory", priority: 50 }
                ]
            },
            "qdproj":
            {
                icon: "",
                factoryName: "ProjectFactory",
                viewFactories:
                [
                    { factoryName: "ProjectWindowFactory", priority: 50 }
                ]
            },
            "qdlaunch":
            {
                icon: "",
                factoryName: "ProjectFactory",
                viewFactories:
                [
                    { factoryName: "ProjectWindowFactory", priority: 50 }
                ]
            },
            "qdprogress":
            {
                icon: "",
                factoryName: "ProfilingProgressFactory",
                viewFactories:
                [
                    { factoryName: "ProfilingProgressWindowFactory", priority: 50 }
                ]
            },
        },

        fileFilters: {
            "Nsight Systems Multi-report views":
            {
                extensions:
                [
                    "nsys-view",
                ],
                sortPriority: 40
            },
            "Nsight Systems Reports":
            {
                extensions:
                [
                    "qdrep",
                    "nsys-rep"
                ],
                sortPriority: 50
            }
        }
    },

    settings: {
        "$$.SystemTrace": {
            order: 90,
            text: qsTr("System Trace"),
            detailsText: qsTr("Settings for the System Trace activity"),
            visible: (AppLib.environment.quadd_standalone != true),
        },

        "$$.Behavior": {
            order: 99,
            text: qsTr("Behavior"),
            parent: (AppLib.environment.quadd_standalone == true ? "" : qsTr("System Trace")),
            properties: {
                "QuadDPlugin.MultipleReportsOpenMode": {
                    order: 105,
                    type: "enum",
                    enumValues: {
                        "askMode": {
                            order: 100,
                            text: qsTr("Ask"),
                        },
                        "separateReportsMode": {
                            order: 101,
                            text: qsTr("Open separate reports"),
                        },
                        "createMultiReportViewMode": {
                            order: 102,
                            text: qsTr("Create a multi-report view"),
                        },
                    },
                    text: qsTr("On multiple report open"),
                    detailsText: qsTr("Whether we need to automatically create a " +
                        "multi-report view on simultaneous opening of multiple reports"),
                    defaultValue: "askMode",
                },

                "QuadDPlugin.SymbolsSearchLocations": {
                    order: 200,
                    type: "directoryPathList",
                    category: qsTr("Symbols search locations"),
                    text: qsTr("Search directories/servers"),
                    detailsText: qsTr("List of locations (directories and servers) to search " +
                        "for symbol files"),
                    defaultValue: qsTr("")
                },
                "QuadDPlugin.SymbolsCacheDirectory": {
                    order: 201,
                    type: "directoryPath",
                    category: qsTr("Symbols search locations"),
                    text: qsTr("Cache directory"),
                    detailsText: qsTr("The symbol cache is the location on your local " +
                        "machine that Nsight Systems places a copy of the symbols it finds " +
                        "on remote locations for future use"),
                    defaultValue: qsTr("")
                },
            },
        },

        "$$.ReportBehavior": {
            order: 100,
            text: qsTr("Report"),
            detailsText: qsTr("You need to reopen report(s) in order for the change of this " +
                "settings to take effect"),
            parent: qsTr("Behavior"),
            properties: {
                "QuadDPlugin.UseCudaNvtxGroups": {
                    order: 105,
                    type: "bool",
                    category: qsTr("Report Behaviour"),
                    text: qsTr("Rename CUDA Kernels by NVTX"),
                    detailsText: qsTr("Rename CUDA Kernels by NVTX ranges."),
                    defaultValue: false
                },
                "QuadDPlugin.UseCudaKernelColors": {
                    order: 106,
                    type: "bool",
                    category: qsTr("Report Behaviour"),
                    text: qsTr("Color CUDA Kernels"),
                    detailsText: qsTr("Apply different color to CUDA kernels."),
                    defaultValue: false
                },
                "QuadDPlugin.TimelineMode": {
                    order: 107,
                    type: "enum",
                    enumValues: {
                        "defaultMode": {
                            order: 100,
                            text: qsTr("CPU rows on top"),
                        },
                        "gpuOnTopMode": {
                            order: 101,
                            text: qsTr("GPU rows on top"),
                        },
                    },
                    category: qsTr("Report Behaviour"),
                    text: qsTr("Timeline mode"),
                    detailsText: qsTr("Switch timeline mode."),
                    defaultValue: "gpuOnTopMode"
                },
                "QuadDPlugin.SymbolSearchVerboseLog": {
                    order: 108,
                    type: "bool",
                    category: qsTr("Report Behaviour"),
                    text: qsTr("Symbol Search verbose log (Windows only)"),
                    detailsText: qsTr("Display the intermediate steps of the symbol search in" +
                        " the report's Symbol Resolution Log."),
                    defaultValue: false
                },
                "QuadDPlugin.CollapseUnresolvedCallstackFrames": {
                    order: 109,
                    type: "bool",
                    category: qsTr("Report Behaviour"),
                    text: qsTr("Collapse unresolved callstack frames"),
                    detailsText: qsTr("Display a single line \"modulename[N frames]\" instead" +
                        " of consecutive callstack frames of same module with unresolved symbols."),
                    defaultValue: true
                },

                "$$.VerticalScrolling": {
                    order: 200,
                    type: "bool",
                    category: qsTr("Vertical scrolling behaviour"),
                    text: qsTr("Scroll vertically when time filter is changed"),
                    detailsText: qsTr("Try to preserve visual context when time filter is applied"),
                    defaultValue: false
                },
            },
        },

        "$$.ProfileBehavior": {
            order: 101,
            text: qsTr("Profile"),
            detailsText: qsTr("You need to rerun trace(s) in order for the change of this " +
                "settings to take effect"),
            parent: qsTr("Behavior"),
            properties: {
                "QuadDPlugin.RetainETWLogFile": {
                    order: 100,
                    type: "bool",
                    visible: true,
                    text: qsTr("Save ETW log files in project folder (Windows only)"),
                    detailsText: qsTr("Keep ETL file. trace rerun required."),
                    defaultValue: true
                },
                "QuadDPlugin.AutomaticallyGenerateReportFileNames": {
                    order: 101,
                    type: "bool",
                    text: qsTr("Derive report file name from collected data (Windows only)"),
                    detailsText: qsTr("Use details of profiled graphics application. Format: " +
                        "[Process Name][GPU Name][Window Resolution][Graphics API] Timestamp.nsys-rep"),
                    defaultValue: false
                },

                "QuadDPlugin.ResolveSymbolsOnReportCreation": {
                    order: 200,
                    type: "bool",
                    text: qsTr("Resolve symbols when creating a report"),
                    detailsText: qsTr("Search for symbol files and attempt to resolve symbols" +
                        " of backtraces when creating a new report."),
                },
            }
        },

        "$$.Notifications": {
            text: qsTr("Notifications"),
            order: 140,
            parent: (AppLib.environment.quadd_standalone == true ? "" : qsTr("System Trace")),
            properties: {
                "QuadDPlugin.ResetNotifications": {
                    category: qsTr("Reset All Notifications"),
                    type: "button",
                    detailsText: qsTr("Click to reset all notifications to the default state"),
                    text: qsTr("Reset notifications"),
                    consecutiveClick: false
                }
            }
        },
    },

    timelineHelp: {
        title: "Timeline Actions and Gestures",
        description: "When navigating the Timeline you can use keyboard shortcuts and mouse gestures. " +
            "If your machine is equipped with a touchpad, you can also use touchpad gestures to " +
            "pan, zoom and scroll vertically.\n\n" +
            "The tables below show a description of common actions with their gesture bindings.",

        shortcutGroups: [{
            title: "Show This Dialog",
            description: "Press the '?' key when Timeline is in focus."
        },
        {
            title: "Navigation with Keyboard and Mouse",
            description: "Here are combinations to use keyboard and mouse to scroll through the Timeline and the tree.",
            shortcuts: [{
                id: "Navigation.PanLeft",
                name: "Pan Left",
                combinations: {
                    common: ["LeftArrow"]
                }
            },
            {
                id: "Navigation.PanRight",
                name: "Pan Right",
                combinations: {
                    common: ["RightArrow"]
                }
            },
            {
                id: "Navigation.ZoomInX",
                name: "Zoom in X-axis",
                combinations: {
                    common: ["Keyboard +", "Keyboard ="],
                    windows: ["CTRL + MouseWheel up"],
                    linux: ["CTRL + MouseWheel up"],
                    macos: ["Cmd + MouseWheel up"]
                }
            },
            {
                id: "Navigation.ZoomOutX",
                name: "Zoom out X-axis",
                combinations: {
                    common: ["Keyboard -"],
                    windows: ["CTRL + MouseWheel down"],
                    linux: ["CTRL + MouseWheel down"],
                    macos: ["Cmd + MouseWheel down"],
                }
            },
            {
                id: "Navigaton.NextRow",
                name: "Next Row",
                combinations: {
                    common: ["ArrowDown"]
                }
            },
            {
                id: "Navigaton.PrevRow",
                name: "Previous Row",
                combinations: {
                    common: ["ArrowUp"]
                }
            },
            {
                id: "Navigation.Undo",
                name: "Undo a Navigation Step",
                combinations: {
                    common: ["Backspace"]
                }
            }]
        },
        {
            title: "Navigation with Touchpad",
            description: "Navigating through the Timeline and the tree with touchpad.",
            shortcuts: [{
                id: "Navigation.PanLeft",
                name: "Pan Left",
                combinations: {
                    common: ["Swipe right with two fingers"]
                }
            },
            {
                id: "Navigation.PanRight",
                name: "Pan Right",
                combinations: {
                    common: ["Swipe left with two fingers"]
                }
            },
            {
                id: "Navigation.ZoomInX",
                name: "Zoom in X-axis",
                combinations: {
                    common: ["Pinch in with touchpad"]
                }
            },
            {
                id: "Navigation.ZoomOutX",
                name: "Zoom out X-axis",
                combinations: {
                    common: ["Pinch out with touchpad"]
                }
            },
            {
                id: "Navigaton.ScrollUp",
                name: "Scroll Tree Up",
                combinations: {
                    common: ["Swipe down with two fingers"]
                }
            },
            {
                id: "Navigaton.ScrollDown",
                name: "Scroll Tree Down",
                combinations: {
                    common: ["Swipe up with two fingers"]
                }
            }]
        },
        {
            title: "Selection of Items",
            description: "You can select an item on the Timeline. " +
                "Selecting items with double-click synchronizes the Timeline and the Events View",

            shortcuts: [{
                id: "Selection.SelectItem",
                name: "Select an Item in the Timeline",
                combinations: {
                    common: ["MouseLeftClick on an item"]
                }
            },
            {
                id: "Selection.SelectItemInEventsView",
                name: "Select an Item in the current Events View",
                combinations: {
                    common: ["MouseLeftDoubleClick on an item"]
                }
            },
            {
                id: "Selection.OpenEventsViewAndSelectItem",
                name: "Open the corresponding Events View and select an Item there",
                combinations: {
                    common: ["Shift + MouseLeftDoubleClick on an item"]
                }
            },
            {
                id: "Selection.FitItemToScreen",
                name: "Select and Fit an Item to Screen",
                combinations: {
                    windows: ["CTRL + MouseLeftDoubleClick on an item"],
                    linux: ["CTRL + MouseLeftDoubleClick on an item"],
                    macos: ["Cmd + MouseLeftDoubleClick on an item"]
                }
            }]
        },
        {
            title: "Selection of a Time Range",
            description: "You can select an time range on the Timeline. " +
                "The selected area and its borders can be dragged with left mouse button. " +
                "Also it has several shortcuts modifying zoom level and time filter.",

            shortcuts: [{
                id: "Selection.SelectTimeRange",
                name: "Select a Time Range",
                combinations: {
                    common: ["Press and drag left mouse button"]
                }
            },
            {
                id: "Selection.SelectTimeRange",
                name: "Drag Selection or Its Border",
                combinations: {
                    common: ["Press and drag left mouse button on a selection"]
                }
            },
            {
                id: "Selection.Deselect",
                name: "Deselect a Time Range",
                combinations: {
                    common: ["Escape", "Click outside a selection"]
                }
            },
            {
                id: "Selection.Zoom",
                name: "Zoom into a Selection",
                combinations: {
                    common: ["Z"]
                }
            },
            {
                id: "Selection.ZoomAndDeselect",
                name: "Zoom into a Selection and Deselect",
                combinations: {
                    common: ["Shift + Z", "MouseLeftDoubleClick on a selection"]
                }
            },
            {
                id: "Selection.Filter",
                name: "Apply Time Filter",
                combinations: {
                    common: ["F"]
                }
            },
            {
                id: "Selection.FilterAndDeselect",
                name: "Apply Time Filter and Deselect",
                combinations: {
                    common: ["Shift + F"]
                }
            }]
        }]
    },
});

if (AppLib.environment.quadd_standalone)
{
    addPlugin({
        pluginDependencies: ["CorePlugin"],
        pluginLibrary: "QuadDPlugin",

        layouts: {
            "default": "Plugins/$$/default.layout",
        },

        hostApplication: {
            title: qsTr("NVIDIA Nsight Systems"),
            defaultWidth: 1366,
            defaultHeight: 768,
            icon: ":/icons/Product.ico",
            docs: "http://docs.nvidia.com/nsight-systems/index.html",
            offlineDocs: "documentation/index.html",
            crashReporterHideStack: true,

            productName: "NVIDIA Nsight Systems",
            organizationName: "NVIDIA Corporation",

            versionUpdates: {
                enabled: true,
                tableUrl: "https://developer.download.nvidia.com/NsightSystems/VersionUpgrades-CTK.json",
            },

            commandBars: {
                "$$.FileMenu": { order: 100 },
                "$$.ViewMenu": { order: 200 },
                "CorePlugin.ToolsMenu": { order: 300 },
                "$$.HelpMenu": { order: 9999 },
            },
        },

        commandLineOptions:
        {
            "operation":
            {
                name: "operation",
                description: "Operation performed with the project",
                valueName: "operation",
            },
            "project-uuid":
            {
                name: "project-uuid",
                description: "UUID of the project which should be opened or created",
                valueName: "project-uuid",
            },
            "working-dir":
            {
                name: "working-dir",
                description: "Working directory of the profiled application",
                valueName: "working-dir",
            },
            "target-path":
            {
                name: "target-path",
                description: "Path to the main binary of the profiled application",
                valueName: "target-path",
            },
            "target-environment":
            {
                name: "target-environment",
                description: "Environment to the profiled application",
                valueName: "target-path",
            },
            "start-args":
            {
                name: "start-args",
                description: "Arguments passed to the profiled application",
                valueName: "start-args",
            },
            "solution-path":
            {
                name: "solution-path",
                description: "Path of the profiled application's Visual Studio solution",
                valueName: "solution-path",
            },
            "secondary-instance-working-directory":
            {
                name: "secondary-instance-working-directory",
                description: "The current directory from which a secondary instance of application started.",
                valueName: "secondary-instance-working-directory",
            },
            "screenshot":
            {
                name: "screenshot",
                description: "Take a screenshot of the loaded report and quit",
            },
            "$$.SingleProcess":
            {
                name: "single-process",
                description: "Use single-process mode for QtWebEngine.",
            },
            "fullscreen":
            {
                name: "fullscreen",
                description: "Open the main window in fullscreen mode",
            }
        },

        documents:
        {
            fileTypes:
            {
                "etl":
                {
                    icon: "",
                    factoryName: "ImportStreamFactory",
                    viewFactories:
                    [
                        { factoryName: "ImportStreamWindowFactory", priority: 50 }
                    ]
                },
                "qdresolve":
                {
                    icon: "",
                    factoryName: "ResolveSymbolsFactory",
                    viewFactories:
                    [
                        { factoryName: "ResolveSymbolsWindowFactory", priority: 50 }
                    ]
                },
                "qdexport":
                {
                    icon: "",
                    factoryName: "ExportSelectorFactory",
                    viewFactories:
                    [
                        { factoryName: "ExportSelectorWindowFactory", priority: 50 }
                    ]
                },
            },

            fileFilters: {
                "Nsight Systems Projects": { extensions: ["qdproj"], sortPriority: 50 },
            }
        },

        toolWindows: {
            "$$.ProjectExplorerWindow": {
                text: qsTr("Project Explorer"),
                sizeMode: "percent",
                deleteOnClose: true,
                layout: "dockWest",
                isFixed: false,
                persistable: true,
                defaultWidth: 250,
                commandBars: {
                },
            }
        },

        commands: {
            "$$.RestoreDefaultLayout": {
                text: qsTr("&Restore Default Layout"),
            },
            "$$.SaveLayout": {
                text: qsTr("Save Layout"),
                shortcut: codeTr("Alt+Shift+S"),
            },
            "$$.NewProject": {
                text: qsTr("&New Project"),
                shortcut: codeTr("Ctrl+N"),
            },
            "$$.NewMultiReportView": {
                text: qsTr("&New multi-report view"),
            },
            "$$.OpenFile": {
                text: qsTr("&Open..."),
                shortcut: codeTr("Ctrl+O"),
            },
            "$$.Import": {
                text: qsTr("&Import..."),
                shortcut: codeTr("Ctrl+I"),
            },
            "$$.Export": {
                text: qsTr("&Export..."),
                shortcut: codeTr("Ctrl+E"),
            },
            "$$.ShowProjectExplorer": {
                text: qsTr("&Show Project Explorer"),
                checkedWithFlags: [states.ShowProjectExplorer],
            },
            "$$.OfflineDocumentationCommand": {
                text: qsTr("Offline Documentation..."),
            },
            "$$.ShowAboutWindow": {
                text: qsTr("&About"),
            },
            "$$.ShowRebelDialog": {
                text: qsTr("&Settings to Analyze CUDA Kernels..."),
            },
            "$$.ShowPreferencesWindow": {
                text: qsTr("&Preferences..."),
            },
        },

        commandGroups: {
            "$$.ProjectGroup": {
                "$$.NewProject": { order: 100 },
                "$$.NewMultiReportView": { order: 110 },
                "$$.OpenFile": { order: 200 },
                "$$.Import": { order: 300 },
                "$$.Export": { order: 400 },
            },
            "$$.FileGroup": {
                "CorePlugin.SaveFile": { order: 120 },
                "CorePlugin.CloseFile": { order: 150 },
            },
            "$$.ViewToolWindowsGroup": {
                "$$.ShowProjectExplorer": { order: 100 },
            },
            "$$.DocumentationGroup": {
                "CorePlugin.DocumentationCommand": { order: 100 },
                "$$.OfflineDocumentationCommand": { order: 150 },
                "CorePlugin.CheckForUpdatesCommand": {order: 200},
            },
            "$$.AboutGroup": {
                "$$.ShowAboutWindow": { order: 100 },
            },
            "$$.RebelPreferencesGroup": {
                "$$.ShowRebelDialog": { order: 100 },
            },
            "$$.LayoutGroup": {
                "$$.RestoreDefaultLayout": { order: 110 },
                "$$.SaveLayout": { order: 120 },
                "CorePlugin.ApplyWindowLayout": { order: 130 },
            }
        },

        commandBars: {
            "$$.FileMenu": {
                type: "menu",
                text: qsTr("&File"),
                commandGroups: {
                    "$$.ProjectGroup": { order: 100 },
                    "$$.FileGroup": { order: 150 },
                    "CorePlugin.ExitGroup": { order: 200 },
                },
            },
            "$$.ViewMenu": {
                type: "menu",
                text: qsTr("&View"),
                commandGroups: {
                    "$$.ViewToolWindowsGroup": { order: 100 },
                    "$$.LayoutGroup": { order: 210 },
                },
            },
            "$$.HelpMenu": {
                type: "menu",
                text: qsTr("&Help"),
                commandGroups: {
                    "$$.DocumentationGroup": { order: 100 },
                    "CorePlugin.FeedbackGroup": { order: 120 },
                    "$$.AboutGroup": { order: 130 },
                },
            },
            "CorePlugin.ToolsMenu": {
                type: "menu",
                text: qsTr("&Tools"),
                commandGroups: {
                    "$$.RebelPreferencesGroup": { order: 130 },
                },
            },

            feedback: {
                mailingAddress: "nsight-systems-feedback@exchange.nvidia.com",
            },
        },

        settings: {
            // TODO (DTSP-2632): This is a workaround for this problem:
            // http://devtools-ru-s1.nvidia.com/gitlab/agora/quadd/merge_requests/4647#note_90779
            "CorePlugin.Privacy": {
                properties: {
                    "CorePlugin.AllowAnalytics": {
                        category: qsTr("Help Improve NVIDIA Software    "),
                    }
                }
            },
        }
    });
}
