# NVIDIA Nsight Systems GUI WebRTC container

Self-isolated Docker container for accessing NVIDIA Nsight Systems through browser using WebRTC.

## Prerequisites

* x86_64 Linux [compaitable with NVIDIA Nsight Systems](https://docs.nvidia.com/nsight-systems/InstallationGuide/index.html#supported-platforms)

* [Docker](https://docs.docker.com/engine/install/)
  
* Internet access for downloading Ubuntu packages inside the container.

## Build

To build the docker container use the follwing command:

    $ sudo ./setup/build-docker.sh

The above command will create a docker image, which can be run using ./start-nsys.sh

### Build environment variables

Following environment variables can be used to configure build parameters.

| Variable | Description                                                                     | Default value |
| :------- | :------------------------------------------------------------------------------ | :------------ |
| USERNAME | User name for NVIDIA Nsight Systems GUI. Password can be set on container start | nvidia        |

### Additional docker build arguments

Additional [docker build](https://docs.docker.com/engine/reference/commandline/build/) arguments may be passed to the build-docker.sh. For example:

    $ sudo ./setup/build-docker.sh --network=host

## Run

To run the docker container the command below can be used:

    $ sudo ./start-nsys.sh

At the end of start-nsys.sh it will provide you with an URL to connect to the WebRTC client.  It will look something like: http://$HOST_IP:8080/. You can use this address in your browser to access Nsight Systems user interface. 

### Additional docker run arguments

Additional [docker run](https://docs.docker.com/engine/reference/commandline/run/) arguments may be passed to the start-nsys.sh. These argument can be used to mount host directories with NVIDIA Nsight Systems reports to the docker container. For example:

    $ sudo ./start-nsys.sh -v $HOME:/mnt/host/home -v /myawesomereports:/mnt/host/myawesomereports


### Runtime environment variables

Can be used to configure runtime parameters.

| Variable                         | Description                                                                                                                                                | Default value                                           |
| :------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------ |
| PASSWORD                         | Password for WebUI. Username can be set only on the build step                                                                                             | nvidia                                                  |
| HOST_IP                          | IP of the server that will be sent to client. This IP should be accessible from the client side to establish client/server connection                      | The IP address of the first available network interface |
| HTTP_PORT                        | Port for HTTP access to Nsight System user interface                                                                                                       | 8080                                                    |
| CONNECTION_UDP_PORT              | UDP port which will be used for handling incomming connection                                                                                              | 8081                                                    |
| FALLBACK_CONNECTION_TCP_PORT     | TCP port which will be used for handling incomming connection in case of failure connection over TCP (can be the same port number as CONNECTION_UDP_PORT ) | 8081                                                    |
| SCREEN                           | Resolution and refresh rate of the screen used for rendering                                                                                               | 1920x1080@30                                            |
| USE_OPENH264_BUILD_CACHE         | Setting this option to false disabling caching of openh264 binaries, so it should be reenabled on each container start                                     | true                                                    |
| OPENH264_BUILD_CACHE_VOLUME_NAME | Directory or docker volume name for openh264 binaries cache                                                                                                | nvidia-devtools-streamer-openh264-volume                |

### Video encoding

By default, the container uses the VP8 codec for video streaming. For an improved experience, the H.264 codec can be enabled by running the script:

    $ sudo docker exec nvidia-devtools-streamer /setup/enable-h264-streaming.sh

Internet should be available from the container to download required libraries.

If USE_OPENH264_BUILD_CACHE was not set to false, openh264 binaries will be cached in OPENH264_BUILD_CACHE_VOLUME_NAME and H.264 codec will be used during further launches of the container.

Currently, only software encoding is supported.

#### Enabling H.264 in a docker container without internet access

    $ sudo -- sh -c 'MY_IMAGE_NAME=my-openh264-nsys-streamer:1.0 USE_OPENH264_BUILD_CACHE=false ./start-nsys.sh && docker exec nvidia-devtools-streamer /setup/enable-h264-streaming.sh && docker commit nvidia-devtools-streamer $MY_IMAGE_NAME && docker save -o my-openh264-nsys-streamer.tar $MY_IMAGE_NAME'

As the result, `my-openh264-nsys-streamer.tar` will contain the image with enabled H.264 codec. This file should be transferred to the target machine without internet access. Then, on a machine without internet access, the container can be started using the following command:

    $ sudo -- sh -c 'CONTAINER_IMAGE=my-openh264-nsys-streamer:1.0 USE_OPENH264_BUILD_CACHE=false docker load -i my-openh264-nsys-streamer.tar && ./start-nsys.sh'

### Volumes

| Docker folder  | Purpose                         | Description                                        |
| :------------- | :------------------------------ | :------------------------------------------------- |
| /mnt/host/logs | Folder with inner services logs | May be useful to send reports to NVIDIA developers |

### Examples

To run the container on 10.10.10.10 network interface, using 8000 HTTP port, 8888 connection port, without caching openh264 binaries:

    $ sudo HOST_IP=10.10.10.10 HTTP_PORT=8000 CONNECTION_UDP_PORT=8888 USE_OPENH264_BUILD_CACHE=false ./start-nsys.sh
