#!/bin/bash -x

# SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

SCRIPT=$(realpath "$0")
HERE=$(dirname "$SCRIPT")

GSTREAMER_INSTALL_PREFIX=/usr
GSTREAMER_TEMP_INSTALL_PREFIX="$OPENH264_DIR_NAME/usr"

/bin/bash -x "${HERE}/openh264-installer/install-binary-openh264-if-downloaded.sh"

if [[ -z `find "${GSTREAMER_INSTALL_PREFIX}" -name "libgstopenh264.so"` ]] &&
    [[ -n `find "${GSTREAMER_TEMP_INSTALL_PREFIX}" -name "libgstopenh264.so"` ]]; then
	cp -r "${GSTREAMER_TEMP_INSTALL_PREFIX}"/* "${GSTREAMER_INSTALL_PREFIX}"
fi

if [[ -n `find "${GSTREAMER_INSTALL_PREFIX}" -name "libgstopenh264.so"` ]]; then
    sudo -H -u $USER bash -c 'echo "export NEKO_VIDEO_CODEC=h264" >> ~/.bashrc'

    supervisorctl stop neko
    supervisorctl start neko
fi