#!/bin/bash -x

# SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

SCRIPT=$(realpath "$0")
HERE=$(dirname "$SCRIPT")

GSTREAMER_INSTALL_PREFIX=/usr
GSTREAMER_TEMP_INSTALL_PREFIX="$OPENH264_DIR_NAME/usr"

mkdir -p "$OPENH264_DIR_NAME"
cd "${OPENH264_DIR_NAME}"
/bin/bash -x "${HERE}/openh264-installer/download-binary-openh264.sh"
/bin/bash -x "${HERE}/openh264-installer/install-binary-openh264-if-downloaded.sh"
mkdir -p "${GSTREAMER_TEMP_INSTALL_PREFIX}"

if [[ -z `find "${GSTREAMER_TEMP_INSTALL_PREFIX}" -name "libgstopenh264.so"` ]]; then
	# install build dependencies
	apt update && apt-get install -y --no-install-recommends \
		autoconf \
		automake \
		libtool \
		build-essential \
		gettext \
		libssl-dev \
		cmake \
		meson \
		ninja-build \
		git \
		wget \
		g++ \
		flex \
		bison \
		xz-utils \
		libglib2.0-dev

	wget https://gstreamer.freedesktop.org/src/gst-plugins-bad/gst-plugins-bad-${GSTREAMER_VERSION}.tar.xz \
		&& tar xvfJ gst-plugins-bad-${GSTREAMER_VERSION}.tar.xz > /dev/null \
		&& cd gst-plugins-bad-${GSTREAMER_VERSION}

	# find all the possible feature
	all_gst_features=$(sed -rn \
			"/^/,/^#.*$/s;^option\('([^']*)'.*type *\: *'feature'.*;\1;p" \
			"./meson_options.txt"
	)

	# disable all features except openh264
	gst_features_conf=()
	for feature in ${all_gst_features} ; do
		if [ ${feature} = "openh264" ] ; then
			gst_features_conf+=( -D${feature}=enabled )
		else
			gst_features_conf+=( -D${feature}=disabled )
		fi
	done

	meson --prefix=${GSTREAMER_TEMP_INSTALL_PREFIX} "${gst_features_conf[@]}" build && ninja -C build && ninja -C build install
fi

/bin/bash -x "${HERE}/enable-h264-streaming-if-installed.sh"
