#!/bin/bash -x

# SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

SCRIPT=$(realpath "$0")
HERE=$(dirname "$SCRIPT")

OPENH264_BIN=http://ciscobinary.openh264.org/libopenh264-2.3.1-linux64.7.so.bz2

apt update && apt-get install -y --no-install-recommends \
    bzip2 \
    wget

if [[ ! -e "${OPENH264_DIR_NAME}/libopenh264.so.7" ]]; then
    wget -O - ${OPENH264_BIN} | bunzip2 > "${OPENH264_DIR_NAME}/libopenh264.so.7"
fi
