#!/bin/bash -x

# SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

SCRIPT=$(realpath "$0")
HERE=$(dirname "$SCRIPT")

OPENH264_INSTALL_PREFIX=/usr
OPENH264_LIB_INSTALL_PREFIX=/usr/lib

if [[ -e "${OPENH264_DIR_NAME}/libopenh264.so.7" && ! -e "${OPENH264_LIB_INSTALL_PREFIX}/libopenh264.so" ]]; then
    rm -f "${OPENH264_LIB_INSTALL_PREFIX}/libopenh264.so.7"
    ln -s -v "${OPENH264_DIR_NAME}/libopenh264.so.7" "${OPENH264_LIB_INSTALL_PREFIX}/libopenh264.so.7"
    rm -f "${OPENH264_LIB_INSTALL_PREFIX}/libopenh264.so"
    ln -s -v "${OPENH264_LIB_INSTALL_PREFIX}/libopenh264.so.7" "${OPENH264_LIB_INSTALL_PREFIX}/libopenh264.so"

    rm -rf "${OPENH264_INSTALL_PREFIX}/include/wels/"
    mkdir -p "${OPENH264_INSTALL_PREFIX}/include/wels/"
    cp "${HERE}"/codec/api/wells/*.h "${OPENH264_INSTALL_PREFIX}/include/wels/"

    rm -f "${OPENH264_LIB_INSTALL_PREFIX}/pkgconfig/openh264.pc"
    mkdir -p "/usr/lib/pkgconfig/"
    cp "${HERE}/openh264.pc" "${OPENH264_LIB_INSTALL_PREFIX}/pkgconfig/openh264.pc"
fi
