import pickle
import os
import glob
import math
import re
import itertools

from collections import deque
import pandas as pd
import numpy as np
import sqlite3


##constants
k_filepath = 'filePath'

k_table_analysis_details='ANALYSIS_DETAILS'
k_table_session_start='TARGET_INFO_SESSION_START_TIME'
k_table_str='StringIds'
k_table_nvtx='NVTX_EVENTS'
k_table_cuda_api='CUPTI_ACTIVITY_KIND_RUNTIME'
k_table_cuda_graph_api='CUDA_GRAPH_EVENTS'
k_table_cuda_kernel='CUPTI_ACTIVITY_KIND_KERNEL'
k_table_cuda_memcpy='CUPTI_ACTIVITY_KIND_MEMCPY'
k_table_cuda_memset='CUPTI_ACTIVITY_KIND_MEMSET'

k_column_graphNodeId='graphNodeId'
k_column_originalGraphNodeId='originalGraphNodeId'
k_column_correlationId='correlationId'

# DTSP-14650: Code cleanup
def load_file(filePath, 
              tableNames):

    file = {
        k_filepath:filePath,
    }
    
    if os.path.exists(filePath) == True:    
        try:
            dbcon = sqlite3.connect("file:"+str(filePath)+"?mode=ro",uri=True)

            print ("Loading: ", filePath)
       
            #DEBUG print name of all tables
            #print(pd.read_sql( "SELECT name FROM sqlite_schema WHERE type ='table' AND name NOT LIKE 'sqlite_%'", dbcon ))

            for tableName, columns in tableNames.items():
                __load_table(file, dbcon, tableName)
            dbcon.close()

        except:
            print("SQLite failed to load file: "+ filePath)
    else:
        print("File does not exist: "+ filePath)
       
    #print(file.keys())
    return file

def __load_table(fileData, dbcon, table_name, columns_name_list=None):
    df=None
    try:
        columns = None
        if(columns_name_list == None):
            columns = "*"
        else:
            columns = " ".join(columns_name_list)
        df = pd.read_sql( ("SELECT " + columns + " FROM " + table_name), dbcon )
        fileData[table_name] = df
        #print("\tLoaded table: ",table_name)
    except:
        print("\tFailed to load table: ",table_name)
        pass
    return df
