#!/usr/bin/env python

import nsysstats

class CUDAKernelExecTrace(nsysstats.StatsReport):

    display_name = 'DEPRECATED - Use cuda_kern_exec_trace instead'
    usage = '{SCRIPT} -- {{DISPLAY_NAME}}'
    should_display = False

    query_stub = """

SELECT
    r.start AS "API Start:ts_ns",
    r.end - r.start AS "API Dur:dur_ns",
    iif(k.start - r.end >= 0, r.end, NULL) AS "Queue Start:ts_ns",
    iif(k.start - r.end >= 0, k.start - r.end, NULL) AS "Queue Dur:dur_ns",
    k.start AS "Kernel Start:ts_ns",
    k.end - k.start AS "Kernel Dur:dur_ns",
    max(r.end, k.end) - r.start AS "Total Dur:dur_ns",
    (r.globalTid >> 24) & 0x00FFFFFF AS PID,
    r.globalTid & 0x00FFFFFF AS TID,
    k.deviceId AS DevId,
    CASE substr(rname.value, -6, 2)
        WHEN '_v'
            THEN substr(rname.value, 1, length(rname.value)-6)
        ELSE rname.value
    END AS "API Function",
    printf('%4d %4d %4d', k.gridX, k.gridY, k.gridZ) AS "GridXYZ",
    printf('%4d %4d %4d', k.blockX, k.blockY, k.blockZ) AS "BlockXYZ",
    kname.value AS "Kernel Name"
FROM
    CUPTI_ACTIVITY_KIND_KERNEL AS k
JOIN
    CUPTI_ACTIVITY_KIND_RUNTIME AS r
    ON      k.correlationId == r.correlationId
        AND k.globalPid == (r.globalTid & 0xFFFFFFFFFF000000)
LEFT JOIN
    StringIds AS rname
    ON r.nameId == rname.id
LEFT JOIN
    StringIds AS kname
    ON kname.id == coalesce(k.{NAME_COL_NAME}, k.demangledName)
ORDER BY 1
"""

    table_checks = {
        'CUPTI_ACTIVITY_KIND_KERNEL':
            "{DBFILE} does not contain CUDA kernel data.",
        'CUPTI_ACTIVITY_KIND_RUNTIME':
            "{DBFILE} does not contain CUDA API data.",
    }

    _arg_opts = [
        [['base'],    {'action': 'store_true'}],
        [['mangled'], {'action': 'store_true'}],
    ]

    def setup(self):
        err = super().setup()
        if err != None:
            return err

        name_col_name = 'demangledName'
        if self.parsed_args.base:
            name_col_name = 'shortName'
        elif (self.parsed_args.mangled and
            self.table_col_exists('CUPTI_ACTIVITY_KIND_KERNEL', 'mangledName')):
            name_col_name = 'mangledName'

        self.query = self.query_stub.format(NAME_COL_NAME = name_col_name)

if __name__ == "__main__":
    CUDAKernelExecTrace.Main()
