/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.sql.task;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.utils.CommonUtils;

public class SQLScriptDataReceiver
implements DBDDataReceiver {
    private Integer rowSize;
    private Writer dumpWriter;

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        if (resultSet == null) {
            return;
        }
        if (this.dumpWriter != null) {
            DBCResultSetMetaData rsMeta = resultSet.getMeta();
            List attributes = rsMeta.getAttributes();
            this.rowSize = attributes.size();
            try {
                this.dumpWriter.append("Columns:\t");
                for (DBCAttributeMetaData attribute : attributes) {
                    this.dumpWriter.append(String.valueOf(attribute.getLabel()) + "\t");
                }
            }
            catch (IOException e1) {
                throw new DBCException("IOException writing to dumpWriter", (Throwable)e1);
            }
        }
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        if (resultSet == null) {
            return;
        }
        if (this.dumpWriter != null) {
            try {
                int i = 0;
                while (i < this.rowSize) {
                    if (resultSet.getAttributeValue(i) != null) {
                        this.dumpWriter.append(CommonUtils.toString((Object)resultSet.getAttributeValue(i))).append("\t");
                    } else {
                        this.dumpWriter.append("NULL\t");
                    }
                    ++i;
                }
                this.dumpWriter.append("\n");
            }
            catch (IOException e) {
                throw new DBCException("IOException writing to dumpWriter", (Throwable)e);
            }
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        if (this.dumpWriter != null) {
            try {
                this.dumpWriter.flush();
            }
            catch (IOException e) {
                throw new DBCException("IOException writing to dumpWriter", (Throwable)e);
            }
        }
    }

    public void close() {
    }

    public void setDumpWriter(Writer writer) {
        this.dumpWriter = writer;
    }

    public Writer getDumpWriter() {
        return this.dumpWriter;
    }
}

