/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.serialize.DTObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerContext;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerRegistry;
import org.jkiss.utils.CommonUtils;

public class DTUtils {
    public static void addSummary(StringBuilder summary, String option, Object value) {
        summary.append("\t").append(option).append(": ").append(value).append("\n");
    }

    public static void addSummary(StringBuilder summary, String option, boolean value) {
        summary.append("\t").append(option).append(": ").append(value ? "Yes" : "No").append("\n");
    }

    public static void addSummary(StringBuilder summary, DataTransferProcessorDescriptor processor, Map<?, ?> props) {
        summary.append(NLS.bind((String)DTMessages.data_transfer_summary_title, (Object)processor.getName())).append(":\n");
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = processor.getProperties();
        int n = dBPPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPPropertyDescriptor prop = dBPPropertyDescriptorArray[n2];
            Object propValue = props.get(prop.getId());
            if (propValue == null) {
                propValue = prop.getDefaultValue();
            }
            if (propValue != null) {
                DTUtils.addSummary(summary, prop.getDisplayName(), propValue);
            }
            ++n2;
        }
    }

    public static String getTableName(DBPDataSource dataSource, DBPNamedObject source, boolean shortName) {
        DBSDataContainer dataContainer;
        SQLQueryContainer queryContainer;
        if (source instanceof DBSEntity) {
            return shortName ? DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)source)) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        String tableName = null;
        if (source instanceof SQLQueryContainer) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, (SQLQueryContainer)source, shortName);
        } else if (source instanceof IAdaptable && (queryContainer = (SQLQueryContainer)((IAdaptable)source).getAdapter(SQLQueryContainer.class)) != null) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, queryContainer, shortName);
        }
        if (tableName == null && source instanceof IAdaptable && (dataContainer = (DBSDataContainer)((IAdaptable)source).getAdapter(DBSDataContainer.class)) instanceof DBSEntity) {
            String string = tableName = shortName ? DBUtils.getQuotedIdentifier((DBSObject)dataContainer) : DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (tableName == null) {
            return shortName ? DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)source.getName()) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return tableName;
    }

    @Nullable
    public static String getTableNameFromQueryContainer(DBPDataSource dataSource, @NotNull SQLQueryContainer queryContainer) {
        if (dataSource == null) {
            return null;
        }
        String nameFromQuery = DTUtils.getTableNameFromQuery(dataSource, queryContainer, true);
        if (CommonUtils.isEmpty((String)nameFromQuery)) {
            return null;
        }
        return nameFromQuery;
    }

    public static String getTableNameFromQuery(DBPDataSource dataSource, SQLQueryContainer queryContainer, boolean shortName) {
        DBCEntityMetaData singleSource;
        SQLScriptElement query = queryContainer.getQuery();
        if (query instanceof SQLQuery && (singleSource = ((SQLQuery)query).getEntityMetadata(true)) != null) {
            SQLDialect dialect = dataSource.getSQLDialect();
            String entity = DTUtils.transformName(dialect, singleSource.getEntityName());
            if (shortName) {
                return entity;
            }
            String schema = DTUtils.transformName(dialect, singleSource.getSchemaName());
            String catalog = DTUtils.transformName(dialect, singleSource.getCatalogName());
            String structSeparator = String.valueOf(dialect.getStructSeparator());
            StringBuilder nameBuilder = new StringBuilder();
            if (catalog != null) {
                nameBuilder.append(catalog).append(structSeparator);
            }
            if (schema != null) {
                nameBuilder.append(schema).append(structSeparator);
            }
            nameBuilder.append(entity);
            return nameBuilder.toString();
        }
        return null;
    }

    @Nullable
    public static String getTargetContainersNameFromQuery(@NotNull SQLQueryContainer queryContainer) {
        List selectEntitiesNames;
        SQLScriptElement query = queryContainer.getQuery();
        if (query instanceof SQLQuery && !CommonUtils.isEmpty((Collection)(selectEntitiesNames = ((SQLQuery)query).getAllSelectEntitiesNames()))) {
            StringJoiner names = new StringJoiner("_");
            selectEntitiesNames.forEach(names::add);
            return names.toString();
        }
        return null;
    }

    @Nullable
    private static String transformName(@NotNull SQLDialect dialect, @Nullable String name) {
        if (name == null) {
            return null;
        }
        if (dialect.isQuotedIdentifier(name)) {
            return name;
        }
        DBPIdentifierCase identifierCase = dialect.storesUnquotedCase();
        return identifierCase.transform(name);
    }

    public static void closeContents(@NotNull DBCResultSet resultSet, @NotNull DBDContent content) {
        if (resultSet.getFeature("local") != null) {
            return;
        }
        content.release();
    }

    @NotNull
    public static List<DBSAttributeBase> getAttributes(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer container, @NotNull Object controller) throws DBException {
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
        if (container instanceof DBSEntity && !(container instanceof DBSDocumentContainer)) {
            for (DBSEntityAttribute attr : CommonUtils.safeList((List)((DBSEntity)container).getAttributes(monitor))) {
                if (DBUtils.isHiddenObject((Object)attr)) continue;
                attributes.add((DBSAttributeBase)attr);
            }
        } else {
            DBCExecutionContext context;
            DBCExecutionContext dBCExecutionContext = context = container instanceof DBPContextProvider ? ((DBPContextProvider)container).getExecutionContext() : DBUtils.getDefaultContext((DBSObject)container, (boolean)false);
            if (context == null) {
                throw new DBCException("No execution context");
            }
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)context.getDataSource(), monitor1 -> {
                MetadataReceiver receiver = new MetadataReceiver(container);
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (DBCSession session = context.openSession(monitor1, DBCExecutionPurpose.META, "Read query meta data");){
                        container.readData((DBCExecutionSource)new AbstractExecutionSource(container, session.getExecutionContext(), controller), session, (DBDDataReceiver)receiver, null, 0L, 1L, 0L, 1);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
                if (receiver.attributes == null) {
                    throw new InvocationTargetException(new DBCException("Query does not contain any attributes"));
                }
                DBDAttributeBinding[] dBDAttributeBindingArray = receiver.attributes;
                int n = receiver.attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                    if (!DBUtils.isHiddenObject((Object)attr)) {
                        attributes.add((DBSAttributeBase)attr);
                    }
                    ++n2;
                }
            });
        }
        return attributes;
    }

    public static <OBJECT_CONTEXT, OBJECT_TYPE> Object deserializeObject(@NotNull DBRRunnableContext runnableContext, SerializerContext serializeContext, OBJECT_CONTEXT objectContext, @NotNull Map<String, Object> objectConfig) throws DBCException {
        String typeID = CommonUtils.toString((Object)objectConfig.get("type"));
        DTObjectSerializer serializer = SerializerRegistry.getInstance().createSerializerByType(typeID);
        if (serializer == null) {
            return null;
        }
        Map location = JSONUtils.getObject(objectConfig, (String)"location");
        return serializer.deserializeObject(runnableContext, serializeContext, objectContext, location);
    }

    public static <OBJECT_CONTEXT, OBJECT_TYPE> Map<String, Object> serializeObject(DBRRunnableContext runnableContext, OBJECT_CONTEXT context, @NotNull OBJECT_TYPE object) {
        DTObjectSerializer serializer = SerializerRegistry.getInstance().createSerializer(object);
        if (serializer == null) {
            return null;
        }
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> location = new LinkedHashMap<String, Object>();
        serializer.serializeObject(runnableContext, context, object, location);
        state.put("type", SerializerRegistry.getInstance().getObjectType(object));
        state.put("location", location);
        return state;
    }

    private static class MetadataReceiver
    implements DBDDataReceiver {
        private final DBSDataContainer container;
        private DBDAttributeBinding[] attributes;

        public MetadataReceiver(DBSDataContainer container) {
            this.container = container;
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.attributes = DBUtils.makeLeafAttributeBindings((DBCSession)session, (DBSDataContainer)this.container, (DBCResultSet)resultSet);
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        }

        public void close() {
        }
    }
}

