/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConsumerGroup;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class ExasolConsumerGroupManager
extends SQLObjectEditor<ExasolConsumerGroup, ExasolDataSource>
implements DBEObjectRenamer<ExasolConsumerGroup> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolConsumerGroup> getObjectsCache(ExasolConsumerGroup object) {
        return object.getDataSource().getConsumerGroupCache();
    }

    protected ExasolConsumerGroup createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new ExasolConsumerGroup((ExasolDataSource)((Object)container), "PG", null, null, null, null, null, null);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolConsumerGroup group = (ExasolConsumerGroup)command.getObject();
        String script = String.format("CREATE CONSUMER GROUP %s WITH CPU_WEIGHT = %d", DBUtils.getQuotedIdentifier((DBSObject)group), group.getCpuWeight());
        if (group.getGroupRamLimit() != null) {
            script = String.valueOf(script) + String.format(",GROUP_TEMP_DB_RAM_LIMIT=%d", group.getGroupRamLimit().longValue());
        }
        if (group.getUserRamLimit() != null) {
            script = String.valueOf(script) + String.format(",USER_TEMP_DB_RAM_LIMIT=%d", group.getUserRamLimit().longValue());
        }
        if (group.getSessionRamLimit() != null) {
            script = String.valueOf(script) + String.format(",SESSION_TEMP_DB_RAM_LIMIT=%d", group.getSessionRamLimit().longValue());
        }
        if (group.getPrecedence() != null) {
            script = String.valueOf(script) + String.format(",PRECEDENCE=%d", (int)group.getPrecedence());
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_consumer_create, script));
        if (!group.getDescription().isEmpty()) {
            actions.add((DBEPersistAction)this.getCommentCommand(group));
        }
    }

    private SQLDatabasePersistAction getCommentCommand(ExasolConsumerGroup group) {
        return new SQLDatabasePersistAction(ExasolMessages.manager_priority_group_comment, String.format("COMMENT ON CONSUMER GROUP %s is '%s'", DBUtils.getQuotedIdentifier((DBSObject)group), ExasolUtils.quoteString(group.getDescription())));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        ExasolConsumerGroup group = (ExasolConsumerGroup)command.getObject();
        Map com = command.getProperties();
        if (com.containsKey("description")) {
            actionList.add((DBEPersistAction)this.getCommentCommand(group));
        }
        ArrayList<String> alters = new ArrayList<String>();
        if (com.containsKey("cpuWeight")) {
            alters.add(String.format("CPU_WEIGHT=%d", group.getCpuWeight()));
        }
        if (com.containsKey("precedence")) {
            alters.add(String.format("PRECEDENCE=%d", (int)group.getPrecedence()));
        }
        if (com.containsKey("groupRamLimit")) {
            alters.add(String.format("GROUP_TEMP_DB_RAM_LIMIT=%d", group.getGroupRamLimit().longValue()));
        }
        if (com.containsKey("userRamLimit")) {
            alters.add(String.format("USER_TEMP_DB_RAM_LIMIT=%d", group.getUserRamLimit().longValue()));
        }
        if (com.containsKey("sessionRamLimit")) {
            alters.add(String.format("SESSION_TEMP_DB_RAM_LIMIT=%d", group.getSessionRamLimit().longValue()));
        }
        if (alters.size() > 0) {
            String modifyPart = alters.stream().collect(Collectors.joining(", "));
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_consumer_alter, String.format("ALTER CONSUMER GROUP %s SET %s", DBUtils.getQuotedIdentifier((DBSObject)group), modifyPart)));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolConsumerGroup group = (ExasolConsumerGroup)command.getObject();
        String script = String.format("DROP CONSUMER GROUP %s", DBUtils.getQuotedIdentifier((DBSObject)group));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_consumer_drop, script));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolConsumerGroup object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolConsumerGroup group = (ExasolConsumerGroup)command.getObject();
        String script = String.format("RENAME CONSUMER GROUP %s to %s", DBUtils.getQuotedIdentifier((DBPDataSource)group.getDataSource(), (String)command.getOldName()), DBUtils.getQuotedIdentifier((DBPDataSource)group.getDataSource(), (String)command.getNewName()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ExasolMessages.manager_consumer_rename, script));
    }
}

