/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLFormatterConfiguration {
    private String formatterId;
    private DBPDataSource dataSource;
    @NotNull
    private DBPIdentifierCase keywordCase;
    private String indentString = "    ";
    private SQLSyntaxManager syntaxManager;
    @NotNull
    private String sourceEncoding = GeneralUtils.DEFAULT_ENCODING;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public SQLFormatterConfiguration(DBPDataSource dataSource, SQLSyntaxManager syntaxManager) {
        this(dataSource, syntaxManager, CommonUtils.notEmpty((String)syntaxManager.getPreferenceStore().getString("sql.format.formatter")).toUpperCase(Locale.ENGLISH));
    }

    public SQLFormatterConfiguration(DBPDataSource dataSource, SQLSyntaxManager syntaxManager, String formatterId) {
        this.dataSource = dataSource;
        this.syntaxManager = syntaxManager;
        this.keywordCase = syntaxManager.getKeywordCase();
        this.formatterId = formatterId;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    public String getFormatterId() {
        return this.formatterId;
    }

    public void setFormatterId(String formatterId) {
        this.formatterId = formatterId;
        this.syntaxManager.getPreferenceStore().setValue("sql.format.formatter", formatterId.toUpperCase(Locale.ENGLISH));
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    @NotNull
    public DBPIdentifierCase getKeywordCase() {
        return this.keywordCase;
    }

    public void setKeywordCase(@NotNull DBPIdentifierCase keyword) {
        this.keywordCase = keyword;
    }

    @NotNull
    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(@NotNull String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public boolean isFunction(String name) {
        return this.syntaxManager.getDialect().getFunctions().contains(name.toUpperCase(Locale.ENGLISH));
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public DBPPreferenceStore getPreferenceStore() {
        return this.syntaxManager.getPreferenceStore();
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }
}

