/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;

public class DataSourceVariableResolver
extends SystemVariablesResolver {
    private final DBPDataSourceContainer dataSourceContainer;
    private final DBPConnectionConfiguration configuration;

    public DataSourceVariableResolver(@Nullable DBPDataSourceContainer dataSourceContainer, @Nullable DBPConnectionConfiguration configuration) {
        this.dataSourceContainer = dataSourceContainer;
        this.configuration = configuration;
    }

    public boolean isSecure() {
        return false;
    }

    protected DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    protected DBPConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String get(String name) {
        block44: {
            block42: {
                if (this.configuration == null) break block42;
                switch (name) {
                    case "host": {
                        return this.configuration.getHostName();
                    }
                    case "port": {
                        return this.configuration.getHostPort();
                    }
                    case "server": {
                        return this.configuration.getServerName();
                    }
                    case "database": {
                        return this.configuration.getDatabaseName();
                    }
                    case "user": {
                        return this.configuration.getUserName();
                    }
                    case "url": {
                        return this.configuration.getUrl();
                    }
                    case "connection.type": {
                        return this.configuration.getConnectionType().getId();
                    }
                }
                if ("password".equals(name) && this.isSecure()) {
                    return this.configuration.getUserPassword();
                }
            }
            if (this.dataSourceContainer == null) break block44;
            switch (name) {
                case "datasource": {
                    return this.dataSourceContainer.getName();
                }
                case "project.path": {
                    return this.dataSourceContainer.getProject().getAbsolutePath().toAbsolutePath().toString();
                }
                case "project.name": {
                    return this.dataSourceContainer.getProject().getName();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
        }
        return super.get(name);
    }
}

