/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PropertyDescriptor
implements DBPPropertyDescriptor,
IPropertyValueListProvider<Object>,
DBPNamedObject2 {
    public static final String CURRENT_DATE_STRING_VAR_PREFIX = "${now as ";
    private static final Log log = Log.getLog(PropertyDescriptor.class);
    public static final String TAG_PROPERTY_GROUP = "propertyGroup";
    public static final String NAME_UNDEFINED = "<undefined>";
    public static final String TAG_PROPERTY = "property";
    public static final String ATTR_ID = "id";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_TYPE = "type";
    private static final String ATTR_REQUIRED = "required";
    private static final String ATTR_DEFAULT_VALUE = "defaultValue";
    private static final String ATTR_VALID_VALUES = "validValues";
    private static final String ATTR_ALLOW_CUSTOM_VALUES = "allowCustomValues";
    private static final String ATTR_FEATURES = "features";
    private static final String ATTR_LENGTH = "length";
    private static final String VALUE_SPLITTER = ",";
    @NotNull
    private final String id;
    private String name;
    private final String description;
    private final String category;
    private transient Class<?> type;
    private PropertyType propertyType;
    private final boolean required;
    private Object defaultValue;
    private Object[] validValues;
    private boolean allowCustomValues = true;
    private final boolean editable;
    @NotNull
    private final PropertyLength length;
    private String[] features;

    public static DBPPropertyDescriptor[] extractPropertyGroups(IConfigurationElement config) {
        ArrayList<DBPPropertyDescriptor> props = new ArrayList<DBPPropertyDescriptor>();
        for (IConfigurationElement prop : ArrayUtils.safeArray((Object[])config.getChildren(TAG_PROPERTY_GROUP))) {
            props.addAll(PropertyDescriptor.extractProperties(prop));
        }
        return props.toArray(new DBPPropertyDescriptor[0]);
    }

    public static List<DBPPropertyDescriptor> extractProperties(IConfigurationElement config) {
        IConfigurationElement[] propElements;
        String category = PropertyDescriptor.getPropertyCategory(config);
        ArrayList<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = propElements = config.getChildren(TAG_PROPERTY);
        int n = propElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prop = iConfigurationElementArray[n2];
            properties.add(new PropertyDescriptor(category, prop));
            ++n2;
        }
        return properties;
    }

    @NotNull
    protected static String getPropertyCategory(IConfigurationElement config) {
        String category = NAME_UNDEFINED;
        if (TAG_PROPERTY_GROUP.equals(config.getName()) && CommonUtils.isEmpty((String)(category = config.getAttribute(ATTR_LABEL)))) {
            category = NAME_UNDEFINED;
        }
        return category;
    }

    public PropertyDescriptor(String category, @NotNull String id, String name, String description, boolean required, Class<?> type, Object defaultValue, Object[] validValues) {
        this.category = category;
        this.id = id;
        this.name = name;
        this.description = description;
        this.required = required;
        this.type = type;
        this.defaultValue = defaultValue;
        this.validValues = validValues;
        this.editable = true;
        this.length = PropertyLength.LONG;
    }

    public PropertyDescriptor(String category, IConfigurationElement config) {
        this.category = category;
        this.id = config.getAttribute(ATTR_ID);
        this.name = config.getAttribute(ATTR_LABEL);
        if (CommonUtils.isEmpty((String)this.name)) {
            this.name = CommonUtils.toString((Object)this.id);
        }
        this.description = config.getAttribute(ATTR_DESCRIPTION);
        this.required = CommonUtils.getBoolean((String)config.getAttribute(ATTR_REQUIRED));
        String typeString = config.getAttribute(ATTR_TYPE);
        if (typeString == null) {
            this.propertyType = PropertyType.t_string;
            this.type = String.class;
        } else {
            try {
                this.propertyType = PropertyType.valueOf("t_" + typeString);
                this.type = this.propertyType.getValueType();
            }
            catch (IllegalArgumentException ex) {
                log.warn(ex);
                this.type = String.class;
            }
        }
        this.defaultValue = PropertyDescriptor.convertString(config.getAttribute(ATTR_DEFAULT_VALUE), this.type);
        String valueList = config.getAttribute(ATTR_VALID_VALUES);
        if (valueList != null) {
            String[] values = valueList.split(VALUE_SPLITTER);
            this.validValues = new Object[values.length];
            int i = 0;
            int valuesLength = values.length;
            while (i < valuesLength) {
                this.validValues[i] = PropertyDescriptor.convertString(values[i], this.type);
                ++i;
            }
        }
        this.allowCustomValues = CommonUtils.getBoolean((String)config.getAttribute(ATTR_ALLOW_CUSTOM_VALUES), (boolean)true);
        String featuresString = config.getAttribute(ATTR_FEATURES);
        if (!CommonUtils.isEmpty((String)featuresString)) {
            this.features = featuresString.split(VALUE_SPLITTER);
        }
        this.editable = true;
        this.length = (PropertyLength)CommonUtils.valueOf(PropertyLength.class, (String)config.getAttribute(ATTR_LENGTH), (Enum)PropertyLength.LONG);
    }

    public static Object convertString(String value, Class<?> valueType) {
        if (!CommonUtils.isEmpty((String)value) && valueType == String.class && value.startsWith(CURRENT_DATE_STRING_VAR_PREFIX)) {
            String pattern = value.substring(9, value.length() - 1);
            return new SimpleDateFormat(pattern).format(new Date());
        }
        return GeneralUtils.convertString(value, valueType);
    }

    public PropertyDescriptor(String category, @NotNull String id, String name, String description, Class<?> type, boolean required, Object defaultValue, String[] validValues, boolean editable) {
        this.category = category;
        this.id = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.required = required;
        this.defaultValue = defaultValue;
        this.validValues = validValues;
        this.editable = editable;
        this.length = PropertyLength.LONG;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isEditable(Object object) {
        return this.editable;
    }

    @Override
    @NotNull
    public PropertyLength getLength() {
        return this.length;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public Class<?> getDataType() {
        return this.type;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean allowCustomValue() {
        return ArrayUtils.isEmpty((Object[])this.validValues) || this.allowCustomValues;
    }

    @Override
    public Object[] getPossibleValues(Object object) {
        return this.validValues;
    }

    @Override
    public String[] getFeatures() {
        Object[] allFeatures = this.features;
        if (this.isRequired()) {
            allFeatures = allFeatures == null ? new String[]{ATTR_REQUIRED} : (String[])ArrayUtils.add(String.class, (Object[])allFeatures, (Object)ATTR_REQUIRED);
        }
        return allFeatures;
    }

    @Override
    public boolean hasFeature(@NotNull String feature) {
        return this.features != null && ArrayUtils.contains((Object[])this.features, (Object)feature);
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.name + ")";
    }

    public static enum PropertyType {
        t_string(String.class),
        t_boolean(Boolean.class),
        t_short(Short.class),
        t_integer(Integer.class),
        t_long(Long.class),
        t_float(Float.class),
        t_double(Double.class),
        t_numeric(Double.class),
        t_file(String.class);

        private final Class<?> valueType;

        private PropertyType(Class<?> valueType) {
            this.valueType = valueType;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }
    }
}

