/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Base64;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class TextWithOpenFile
extends TextWithOpen {
    private final String title;
    private final String[] filterExt;
    private final int style;
    private final boolean binary;
    private boolean openFolder = false;

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, int style, boolean binary) {
        this(parent, title, filterExt, style, binary, false);
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, int style, boolean binary, boolean secured) {
        super(parent, secured);
        this.title = title;
        this.filterExt = filterExt;
        this.style = style;
        this.binary = binary;
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt) {
        this(parent, title, filterExt, 4100, false);
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, boolean binary) {
        this(parent, title, filterExt, 4100, binary);
    }

    public TextWithOpenFile(Composite parent, String title, String[] filterExt, boolean binary, boolean secured) {
        this(parent, title, filterExt, 4100, binary, secured);
    }

    public void setOpenFolder(boolean openFolder) {
        this.openFolder = openFolder;
    }

    @Override
    protected boolean isBinaryContents() {
        return this.binary;
    }

    @Override
    protected void openBrowser() {
        String selected;
        String directory = this.getDialogDirectory();
        if (this.openFolder) {
            DirectoryDialog fd = new DirectoryDialog(this.getShell(), this.style);
            if (directory != null) {
                fd.setFilterPath(directory);
            }
            if (this.title != null) {
                fd.setText(this.title);
            }
            selected = fd.open();
        } else {
            FileDialog fd = new FileDialog(this.getShell(), this.style);
            fd.setText(this.title);
            fd.setFilterExtensions(this.filterExt);
            if (directory != null) {
                DialogUtils.setCurDialogFolder(directory);
            }
            if ((selected = DialogUtils.openFileDialog(fd)) != null && this.isShowFileContentEditor()) {
                Path filePath = Path.of(selected, new String[0]);
                try {
                    if (this.binary) {
                        byte[] bytes = Files.readAllBytes(filePath);
                        selected = Base64.getEncoder().encodeToString(bytes);
                    } else {
                        selected = Files.readString(filePath);
                    }
                }
                catch (IOException e) {
                    DBWorkbench.getPlatformUI().showError("File read error", "Can't read file '" + filePath + "' contents", (Throwable)e);
                }
            }
        }
        if (selected != null) {
            this.setText(selected);
        }
    }

    private String getDialogDirectory() {
        String text = this.getText();
        if (CommonUtils.isEmptyTrimmed((String)text)) {
            return null;
        }
        try {
            String dirPath = IOUtils.getDirectoryPath((String)text);
            if (CommonUtils.isNotEmpty((String)dirPath)) {
                return dirPath;
            }
        }
        catch (InvalidPathException invalidPathException) {}
        return null;
    }
}

