#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-DSXHBXhSPE2FoaKQvaUkX
key:                  dhall-1.41.2-DSXHBXhSPE2FoaKQvaUkX
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  d6ba4ff7cc7fc180f68b4d6ad0e04cd6
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.0.2/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-DSXHBXhSPE2FoaKQvaUkX
depends:
    Diff-0.4.1-GdxJqSCBWVSImKhqghLkQt
    aeson-2.1.2.1-A4BCifdqKBRKymWAxMJ7G4
    aeson-pretty-0.8.9-5lTV2yokao3rqi6vQJbJu
    ansi-terminal-0.11.4-30w7KBHfEQ9CygddjSQvBk
    atomic-write-0.2.0.7-1jXjeWvuXhBIs0MoNozdXi base-4.15.1.0
    base16-bytestring-1.0.2.0-9D56NZe6o4J55Lq4iVKJS0
    bytestring-0.10.12.1 case-insensitive-1.2.1.0-4jgW7rCNZT7HuDvSGowCF
    cborg-0.2.9.0-IXULOApx1j32ebyxBPYcL0
    cborg-json-0.2.5.0-1Eqk2LbAqaOLHb6JQxV1ds containers-0.6.4.1
    contravariant-1.5.5-FtJyCLyWfutGN2UWoJs8qd
    cryptohash-sha256-0.11.102.1-HvF6k2aJaIP1s9SxHh7HNR
    data-fix-0.3.2-F5YI9qAj3M1GeOditmsT5l deepseq-1.4.5.0
    directory-1.3.6.2 dotgen-0.4.3-JbRUtf7kscIJibZz2RQNw
    either-5.0.2-JoRjkhpzqttAh5qInyhDDp exceptions-0.10.4
    filepath-1.4.2.1 half-0.3.1-CXzw62hqHyE5e9ujdqyXzo
    hashable-1.4.2.0-8JSq7I7AhyyZ2Q90BxZWW haskeline-0.8.2
    http-client-0.7.13.1-E99uRcHPg6l4pFHjAbr9ZZ
    http-client-tls-0.3.6.3-83gtNL69go4HzvcH7SqbBN
    http-types-0.12.3-GFhxs6XVQ6bETbOR4vEFmW
    indexed-traversable-0.1.2.1-JwIQVWOpW67GVSWDdLo884
    lens-family-core-2.1.2-JgL24qTIUymKZLaMFOVhTK
    megaparsec-9.3.1-LmiWZGXQazp1nnuwCBnmcX
    mmorph-1.2.0-2iQgHTViuScASaZTADZaI1 mtl-2.2.2
    network-uri-2.6.4.2-18lVeOrHqdkDTTcK9hqBly
    optparse-applicative-0.17.0.0-1t7fxkFVvXn4R1Ycov0fb
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB
    parsers-0.12.11-4GlGGJopDxbEBWyVDgDjI4
    pretty-simple-4.1.2.0-3r5QcyFmBmL1q6KjmO86Iy
    prettyprinter-1.7.1-9bwAyMlaUSyJVG7FMXWGKT
    prettyprinter-ansi-terminal-1.1.3-C9dAq9WFsAp2PXcJori7vo
    profunctors-5.6.2-5HBtTiYfVT6KsCqpwzceco
    repline-0.4.2.0-AbdnKl4MT5R8rpoSYZ99OS
    scientific-0.3.7.0-6CvCEFxXBWR5nYRp7k6pyR
    serialise-0.2.6.0-27A9Nb5MlW16MB4RRJ9c1P template-haskell-2.17.0.0
    text-1.2.5.0 text-manipulate-0.3.1.0-K6q4FKnTlJvFdPitimWBxM
    text-short-0.1.5-CLLiD2mlatGBfIv4YcXASu
    th-lift-instances-0.1.20-Cb8K81p9utM1skQxiFjQn2 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-Km0aDxhChoIJJSbiufyazz
    uri-encode-1.5.0.7-7QlNOHGk1I4KKk7WuZZsfV
    vector-0.13.0.0-9fyHsAonVFcGYv9jtLmfSh

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

