define(["exports","./../emby-apiclient/connectionmanager.js","./../approuter.js","./../dialog/dialog.js","./globalize.js","./dialogs/confirm.js","./dialogs/alert.js"],function(_exports,_connectionmanager,_approuter,_dialog,_globalize,_confirm,_alert){function alertText(options){return(0,_alert.default)(options)}function onItemDeleted(options,serverId,parentId){"back"===options.navigate?_approuter.default.back():options.navigate&&(parentId?_approuter.default.showItem(parentId,serverId):_approuter.default.goHome())}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var DeleteMessages={Item:{single:{text:_globalize.default.translate("ConfirmDeleteItem")+"\n\n"+_globalize.default.translate("AreYouSureToContinue"),title:_globalize.default.translate("HeaderDeleteItem"),confirmText:_globalize.default.translate("Delete")},plural:{text:_globalize.default.translate("ConfirmDeleteItems")+"\n\n"+_globalize.default.translate("AreYouSureToContinue"),title:_globalize.default.translate("HeaderDeleteItems"),confirmText:_globalize.default.translate("Delete")}},Device:{single:{text:_globalize.default.translate("DeleteDeviceConfirmation"),title:_globalize.default.translate("HeaderDeleteDevice"),confirmText:_globalize.default.translate("Delete")},plural:{text:_globalize.default.translate("DeleteDeviceConfirmation"),title:_globalize.default.translate("HeaderDeleteDevice"),confirmText:_globalize.default.translate("Delete")}},Plugin:{single:{text:_globalize.default.translate("UninstallPluginConfirmation"),title:_globalize.default.translate("HeaderUninstallPlugin"),confirmText:_globalize.default.translate("Uninstall")},plural:{text:_globalize.default.translate("UninstallPluginConfirmation"),title:_globalize.default.translate("HeaderUninstallPlugin"),confirmText:_globalize.default.translate("Uninstall")}},Server:{single:{text:"DeleteServerConfirmation",title:_globalize.default.translate("HeaderDeleteServer"),confirmText:_globalize.default.translate("Delete")},plural:{text:"DeleteServerConfirmation",title:_globalize.default.translate("HeaderDeleteServer"),confirmText:_globalize.default.translate("Delete")}},User:{single:{text:"DeleteUserConfirmation",title:_globalize.default.translate("HeaderDeleteUser"),confirmText:_globalize.default.translate("Delete")},plural:{text:"DeleteUserConfirmation",title:_globalize.default.translate("HeaderDeleteUser"),confirmText:_globalize.default.translate("Delete")}}};function getDeleteConfirmOptions(items){var info=DeleteMessages[items[0].Type]||DeleteMessages.Item,info=1<items.length?info.plural:info.single;return(info=Object.assign({},info)).primary="cancel",1===items.length&&(info.text=_globalize.default.translate(info.text,items[0].Name)),info}function deleteItemInternal(item,apiClient,options){var itemId=item.Id;return apiClient.getDeleteInfo(itemId).then(function(deleteInfo){return(0,_confirm.default)({title:_globalize.default.translate("HeaderDeleteItem"),text:function(deleteInfo,item){var msg=deleteInfo.Paths.length?(msg=_globalize.default.translate("ConfirmDeleteItem"),(msg+="\n\n"+_globalize.default.translate("FollowingFilesWillBeDeleted")+"\n"+deleteInfo.Paths.join("\n"))+"\n\n"+_globalize.default.translate("AreYouSureToContinue")):_globalize.default.translate("DeleteItemConfirmation",item.Name);return msg}(deleteInfo,item),html:function(deleteInfo,item){var msg;if(deleteInfo.Paths.length){msg=_globalize.default.translate("ConfirmDeleteItem"),msg+="<p>"+_globalize.default.translate("FollowingFilesWillBeDeleted")+"</p>";for(var i=0,length=deleteInfo.Paths.length;i<length;i++)msg+='<div class="secondaryText">'+deleteInfo.Paths[i]+"</div>";msg+="<p>"+_globalize.default.translate("AreYouSureToContinue")+"</p>"}else msg=_globalize.default.translate("DeleteItemConfirmation",item.Name);return msg}(deleteInfo,item),confirmText:_globalize.default.translate("Delete"),primary:"cancel"}).then(function(){var parentId=item.SeasonId||item.SeriesId||item.ParentId,serverId=item.ServerId;return apiClient.deleteItem(item).then(function(){return onItemDeleted(options,serverId,parentId)},function(err){function result(){return Promise.reject(err)}return alertText(_globalize.default.translate("ErrorDeletingItem")).then(result,result)})})})}function deleteItem(options){var item=options.item,apiClient=_connectionmanager.default.getApiClient(item);return"Server"===item.Type?function(item,options){return(0,_confirm.default)(getDeleteConfirmOptions([item])).then(function(){return _connectionmanager.default.deleteServer(item.Id).then(function(){return onItemDeleted(options)})})}(item,options):"LiveTVTunerDevice"===item.Type?function(item,apiClient,options){return(0,_confirm.default)({title:_globalize.default.translate("HeaderDeleteDevice"),text:_globalize.default.translate("MessageConfirmDeleteTunerDevice"),confirmText:_globalize.default.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.deleteLiveTVTunerDevice(item.Id).then(function(){return onItemDeleted(options)})})}(item,apiClient,options):"LiveTVGuideSource"===item.Type?function(item,apiClient,options){return(0,_confirm.default)({title:_globalize.default.translate("HeaderDeleteProvider"),text:_globalize.default.translate("MessageConfirmDeleteGuideProvider"),confirmText:_globalize.default.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.deleteLiveTVGuideSource(item.Id).then(function(){return onItemDeleted(options)})})}(item,apiClient,options):"ItemImage"===item.Type?function(item,apiClient){return(0,_confirm.default)({text:_globalize.default.translate("ConfirmDeleteImage"),confirmText:_globalize.default.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.deleteItemImage(item.Id,item.ImageType,item.ImageIndex)})}(item,apiClient):"MediaStream"===item.Type&&"Subtitle"===item.StreamType?function(item,apiClient,options){var msg=_globalize.default.translate("MessageAreYouSureDeleteSubtitles");return(0,_confirm.default)({title:_globalize.default.translate("ConfirmDeletion"),text:msg,confirmText:_globalize.default.translate("Delete"),primary:"cancel"}).then(function(){return apiClient.deleteSubtitles(item.ItemId,item.MediaSourceId,item.Index).then(function(){return onItemDeleted(options)})})}(item,apiClient,options):"ApiKey"===item.Type?function(item){return(0,_confirm.default)({text:_globalize.default.translate("MessageConfirmRevokeApiKey"),title:_globalize.default.translate("HeaderConfirmRevokeApiKey"),confirmText:_globalize.default.translate("Delete"),primary:"cancel"}).then(function(){return _connectionmanager.default.getApiClient(item).deleteApiKey(item.AccessToken)})}(item):"VirtualFolder"===item.Type?function(virtualFolder,apiClient,options){return(0,_confirm.default)({text:_globalize.default.translate("MessageAreYouSureYouWishToRemoveLibrary",virtualFolder.Name),title:_globalize.default.translate("HeaderRemoveLibrary"),confirmText:_globalize.default.translate("ButtonRemove"),primary:"cancel"}).then(function(){var refreshAfterChange="true"===options.positionTo.closest(".page").getAttribute("data-refreshlibrary");return apiClient.removeVirtualFolder(virtualFolder,refreshAfterChange)})}(item,apiClient,options):"Series"===item.Type?function(item,apiClient,options){return apiClient.getEpisodes(item.Id,{Limit:1,SortBy:"DatePlayed",SortOrder:"Descending",IsPlayed:!0,UserId:apiClient.getCurrentUserId(),ExcludeLocationTypes:"Virtual"}).then(function(result){return result.Items.length?(0,_dialog.default)({title:_globalize.default.translate("HeaderDeleteSeries"),text:"",buttons:[{name:_globalize.default.translate("Cancel"),id:"cancel",type:"submit"},{name:_globalize.default.translate("HeaderDeleteLastPlayedEpisode"),id:"deletelastplayed",type:"cancel"},{name:_globalize.default.translate("HeaderDeleteSeries"),id:"deleteseries",type:"cancel"}]}).then(function(id){return"deleteseries"===id?deleteItemInternal(item,apiClient,options):"deletelastplayed"===id?deleteItemInternal(result.Items[0],apiClient,options):Promise.reject()}):deleteItemInternal(item,apiClient,options)})}(item,apiClient,options):alwaysDeleteUsingMultiple(item)?(options.items=[item],deleteItems(options)):deleteItemInternal(item,apiClient,options)}function showNoItemsMessage(){return alertText(_globalize.default.translate("NoSelectedItemsSupportOperation"))}function alwaysDeleteUsingMultiple(item){switch(item.Type){case"Device":case"Plugin":case"User":return 1;default:return}}function deleteItems(options){var items=options.items;if(1===items.length&&!alwaysDeleteUsingMultiple(options.items[0]))return options.item=options.items[0],deleteItem(options);return items.length?(0,_confirm.default)(getDeleteConfirmOptions(items)).then(function(){for(var servers=function(items){for(var servers=[],serversMap={},i=0,length=items.length;i<length;i++){var serverId,server,item=items[i],apiClient=_connectionmanager.default.getApiClient(item);apiClient&&((server=serversMap[serverId=apiClient.serverId()])||(serversMap[serverId]=server={apiClient:apiClient,items:[]},servers.push(server)),server.items.push(item))}return servers}(items),promises=[],i=0,length=servers.length;i<length;i++){var server=servers[i],apiClient=server.apiClient,itemsToDelete=server.items;if(itemsToDelete.length)switch(itemsToDelete[0].Type){case"Device":promises.push(apiClient.deleteDevices(itemsToDelete));break;case"Plugin":promises.push(apiClient.uninstallPlugins(itemsToDelete));break;case"User":promises.push(apiClient.deleteUsers(itemsToDelete));break;default:promises.push(apiClient.deleteItems(itemsToDelete))}}return promises.length?Promise.all(promises).catch(function(err){return console.log("error deleting: "+err),alertText(_globalize.default.translate("ErrorDeletingItem"))}):showNoItemsMessage()}):showNoItemsMessage()}_exports.default={deleteItems:deleteItems,deleteItem:deleteItem}});