define(["exports","./events.js"],function(_exports,_events){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var defaultTimeout=2e4,ConnectionMode_Local=0,ConnectionMode_Remote=1,ConnectionMode_Manual=2;function getServerAddress(server,mode){switch(mode){case ConnectionMode_Local:return server.LocalAddress;case ConnectionMode_Manual:return server.ManualAddress;case ConnectionMode_Remote:return server.RemoteAddress;default:return server.ManualAddress||server.LocalAddress||server.RemoteAddress}}function paramsToString(params){var key,values=[];for(key in params){var value=params[key];null!=value&&""!==value&&values.push("".concat(encodeURIComponent(key),"=").concat(encodeURIComponent(value)))}return values.join("&")}function mergeServers(credentialProvider,list1,list2){for(var i=0,length=list2.length;i<length;i++)credentialProvider.addOrUpdateServer(list1,list2[i])}function updateServerInfo(server,systemInfo){systemInfo.ServerName&&(server.Name=systemInfo.ServerName),systemInfo.Id&&(server.Id=systemInfo.Id),systemInfo.LocalAddress&&(server.LocalAddress=systemInfo.LocalAddress),systemInfo.WanAddress&&(server.RemoteAddress=systemInfo.WanAddress)}function getFetchPromise(request,signal){if(signal&&signal.aborted)return Promise.reject(((err=new Error("AbortError")).name="AbortError",err));var abortController,err=request.headers||{},fetchRequest=("json"===request.dataType&&(err.accept="application/json"),{headers:err,method:request.type,credentials:"same-origin"}),boundAbort=(request.timeout&&(boundAbort=(abortController=new AbortController).abort.bind(abortController),signal&&signal.addEventListener("abort",boundAbort),setTimeout(boundAbort,request.timeout),signal=abortController.signal),signal&&(fetchRequest.signal=signal),request.contentType);return request.data&&("string"==typeof request.data?fetchRequest.body=request.data:(fetchRequest.body=paramsToString(request.data),boundAbort=boundAbort||"application/x-www-form-urlencoded; charset=UTF-8")),boundAbort&&(err["Content-Type"]=boundAbort),fetch(request.url,fetchRequest)}function sortServers(a,b){return(b.DateLastAccessed||0)-(a.DateLastAccessed||0)}function setServerProperties(server){server.Type="Server"}function ajax(request,signal){if(request)return request.headers=request.headers||{},console.log("ConnectionManager requesting url: ".concat(request.url)),getFetchPromise(request,signal).then(function(response){return console.log("ConnectionManager response status: ".concat(response.status,", url: ").concat(request.url)),response.status<400?"json"===request.dataType?response.json():"text"===request.dataType?response.text():"application/json"===request.headers.accept?response.json():204===response.status?response.text():response:Promise.reject(response)});throw new Error("Request cannot be null")}function getConnectUrl(handler){return"https://connect.emby.media/service/".concat(handler)}function replaceAll(originalString,strReplace,strWith){strReplace=new RegExp(strReplace,"ig");return originalString.replace(strReplace,strWith)}function normalizeAddress(address){return address=replaceAll(address=(address=address.trim()).toLowerCase().startsWith("http")?address:(address.includes(":443")||address.includes(":8920")?"https://":"http://").concat(address),"Http:","http:"),address=replaceAll(address,"Https:","https:")}function compareVersions(a,b){a=a.split("."),b=b.split(".");for(var i=0,length=Math.max(a.length,b.length);i<length;i++){var aVal=parseInt(a[i]||"0"),bVal=parseInt(b[i]||"0");if(aVal<bVal)return-1;if(bVal<aVal)return 1}return 0}function addAppInfoToConnectRequest(instance,request){request.headers=request.headers||{},request.headers["X-Application"]="".concat(instance.appName(),"/").concat(instance.appVersion())}function getCacheKey(feature,apiClient,argument_2){var viewOnly=(2<arguments.length&&void 0!==argument_2?argument_2:{}).viewOnly,cacheKey="regInfo-".concat(apiClient.serverId());return viewOnly&&(cacheKey+="-viewonly"),cacheKey}function onConnectUserSignIn(instance,user){instance._connectUser=user,_events.default.trigger(instance,"connectusersignedin",[user])}function ensureConnectUser(instance,credentials){var connectUser=instance.connectUser();return(!connectUser||connectUser.Id!==credentials.ConnectUserId)&&credentials.ConnectUserId&&credentials.ConnectAccessToken?(instance._connectUser=null,function(instance,userId,accessToken){if(!userId)throw new Error("null userId");if(accessToken)return ajax({type:"GET",url:"https://connect.emby.media/service/user?id=".concat(userId),dataType:"json",headers:{"X-Application":"".concat(instance.appName(),"/").concat(instance.appVersion()),"X-Connect-UserToken":accessToken}});throw new Error("null accessToken")}(instance,credentials.ConnectUserId,credentials.ConnectAccessToken).then(function(user){return onConnectUserSignIn(instance,user),Promise.resolve()},function(){return Promise.resolve()})):Promise.resolve()}function findServers(serverDiscoveryFn){function onFinish(foundServers){return foundServers.map(function(foundServer){foundServer={Id:foundServer.Id,LocalAddress:function(info){var address;return info.Address&&info.EndpointAddress?(address=info.EndpointAddress.split(":")[0],1<(info=info.Address.split(":")).length&&(info=info[info.length-1],isNaN(parseInt(info))||(address+=":".concat(info))),normalizeAddress(address)):null}(foundServer)||foundServer.Address,Name:foundServer.Name};return foundServer.LastConnectionMode=foundServer.ManualAddress?ConnectionMode_Manual:ConnectionMode_Local,foundServer})}return serverDiscoveryFn().then(function(serverDiscovery){return serverDiscovery.findServers(1e3).then(onFinish,function(){return onFinish([])})})}function afterConnected(instance,apiClient,server,argument_3){var options=3<arguments.length&&void 0!==argument_3?argument_3:{};!0!==options.reportCapabilities&&!1===options.reportCapabilities||!function(instance,apiClient){instance.reportCapabilities(apiClient)}(instance,apiClient),apiClient.enableAutomaticBitrateDetection=options.enableAutomaticBitrateDetection,apiClient.enableWebSocketAutoConnect=!1!==options.enableWebSocket,apiClient.enableWebSocketAutoConnect&&(console.log("calling apiClient.ensureWebSocket"),apiClient.connected=!0,apiClient.ensureWebSocket())}function onLocalUserSignIn(instance,server,serverUrl){return instance._getOrAddApiClient(server,serverUrl),(instance.onLocalUserSignedIn?instance.onLocalUserSignedIn.call(instance,server.Id,server.UserId):Promise.resolve()).then(function(){_events.default.trigger(instance,"localusersignedin",[server.Id,server.UserId])})}function tryReconnectToUrl(instance,url,connectionMode,delay,signal){return console.log("tryReconnectToUrl: "+url),timeout=delay,new Promise(function(resolve){setTimeout(resolve,timeout)}).then(function(){return ajax({url:instance.getEmbyServerUrl(url,"system/info/public"),timeout:defaultTimeout,type:"GET",dataType:"json"},signal).then(function(result){return{url:url,connectionMode:connectionMode,data:result}})});var timeout}function afterConnectValidated(instance,server,credentials,systemInfo,connectionMode,serverUrl,verifyLocalAuthentication,options){if(console.log("connectionManager.afterConnectValidated: "+serverUrl),options=options||{},verifyLocalAuthentication&&server.AccessToken)return function(instance,server,serverUrl){return console.log("connectionManager.validateAuthentication: "+serverUrl),ajax({type:"GET",url:instance.getEmbyServerUrl(serverUrl,"System/Info")+"?api_key="+server.AccessToken,dataType:"json"}).then(function(systemInfo){return updateServerInfo(server,systemInfo),systemInfo},function(){return server.UserId=null,server.AccessToken=null,Promise.resolve()})}(instance,server,serverUrl).then(function(fullSystemInfo){return afterConnectValidated(instance,server,credentials,fullSystemInfo||systemInfo,connectionMode,serverUrl,!1,options)});updateServerInfo(server,systemInfo),server.LastConnectionMode=connectionMode,!1!==options.updateDateLastAccessed&&(server.DateLastAccessed=Date.now());function resolveActions(){return _events.default.trigger(instance,"connected",[result]),Promise.resolve(result)}var verifyLocalAuthentication=instance.credentialProvider(),result=(verifyLocalAuthentication.addOrUpdateServer(credentials.Servers,server),verifyLocalAuthentication.credentials(credentials),{Servers:[]});result.ApiClient=instance._getOrAddApiClient(server,serverUrl),result.ApiClient.setSystemInfo(systemInfo),result.State=server.AccessToken&&!1!==options.enableAutoLogin?"SignedIn":"ServerSignIn",result.Servers.push(server),result.ApiClient.enableAutomaticBitrateDetection=options.enableAutomaticBitrateDetection,result.ApiClient.updateServerInfo(server,serverUrl),instance.resetRegistrationInfo(result.ApiClient,!0);return console.log("connectionManager.afterConnectValidated result.State: "+(result.State||"")),"SignedIn"===result.State?(afterConnected(instance,result.ApiClient,server,options),onLocalUserSignIn(instance,server,serverUrl).then(resolveActions,resolveActions)):resolveActions()}function onSuccessfulConnection(instance,server,systemInfo,connectionMode,serverUrl,options){console.log("connectionManager.onSuccessfulConnection: "+serverUrl);var credentials=instance.credentialProvider().credentials();return options=options||{},credentials.ConnectAccessToken&&!1!==options.enableAutoLogin?ensureConnectUser(instance,credentials).then(function(){return server.ExchangeToken?function(instance,server,serverUrl,credentials){if(!server.ExchangeToken)throw new Error("server.ExchangeToken cannot be null");if(!credentials.ConnectUserId)throw new Error("credentials.ConnectUserId cannot be null");var serverUrl=instance.getEmbyServerUrl(serverUrl,"Connect/Exchange?format=json&ConnectUserId=".concat(credentials.ConnectUserId)),credentials={"X-Emby-Token":server.ExchangeToken},appName=instance.appName(),appVersion=instance.appVersion(),deviceName=instance.deviceName(),instance=instance.deviceId();return appName&&(credentials["X-Emby-Client"]=appName),deviceName&&(credentials["X-Emby-Device-Name"]=encodeURIComponent(deviceName)),instance&&(credentials["X-Emby-Device-Id"]=instance),appVersion&&(credentials["X-Emby-Client-Version"]=appVersion),ajax({type:"GET",url:serverUrl,dataType:"json",headers:credentials}).then(function(auth){return server.UserId=auth.LocalUserId,server.AccessToken=auth.AccessToken,auth},function(){return server.UserId=null,server.AccessToken=null,Promise.reject()})}(instance,server,serverUrl,credentials).then(function(){return afterConnectValidated(instance,server,credentials,systemInfo,connectionMode,serverUrl,!0,options)},function(){return afterConnectValidated(instance,server,credentials,systemInfo,connectionMode,serverUrl,!0,options)}):afterConnectValidated(instance,server,credentials,systemInfo,connectionMode,serverUrl,!0,options)}):afterConnectValidated(instance,server,credentials,systemInfo,connectionMode,serverUrl,!0,options)}var _default=new(function(){function ConnectionManager(){babelHelpers.classCallCheck(this,ConnectionManager),this._apiClients=[],this._apiClientsMap={},this._minServerVersion="4.6.7"}return babelHelpers.createClass(ConnectionManager,[{key:"initialize",value:function(credentialProvider,appStorage,apiClientFactory,serverDiscoveryFn,wakeOnLan,appName,appVersion,deviceName,deviceId,capabilitiesFn,devicePixelRatio,localassetmanager,itemrepository,useractionrepository){if(!appName)throw new Error("Must supply a appName");if(!appVersion)throw new Error("Must supply a appVersion");if(!deviceName)throw new Error("Must supply a deviceName");if(!deviceId)throw new Error("Must supply a deviceId");console.log("Begin ConnectionManager constructor"),_events.default.on(credentialProvider,"credentialsupdated",function(e,data){_events.default.trigger(this,"credentialsupdated",[data])}.bind(this)),this.appStorage=appStorage,this._credentialProvider=credentialProvider,this._appName=appName,this._appVersion=appVersion,this._deviceName=deviceName,this._deviceId=deviceId,this.capabilities=capabilitiesFn,this.apiClientFactory=apiClientFactory,this.wakeOnLan=wakeOnLan,this.serverDiscoveryFn=serverDiscoveryFn,this.devicePixelRatio=devicePixelRatio,this.localassetmanager=localassetmanager,this.itemrepository=itemrepository,this.useractionrepository=useractionrepository}},{key:"appName",value:function(){return this._appName}},{key:"appVersion",value:function(){return this._appVersion}},{key:"deviceName",value:function(){return this._deviceName}},{key:"deviceId",value:function(){return this._deviceId}},{key:"minServerVersion",value:function(val){return val&&(this._minServerVersion=val),this._minServerVersion}},{key:"connectUser",value:function(){return this._connectUser}},{key:"credentialProvider",value:function(){return this._credentialProvider}},{key:"connectUserId",value:function(){return this.credentialProvider().credentials().ConnectUserId}},{key:"connectToken",value:function(){return this.credentialProvider().credentials().ConnectAccessToken}},{key:"getServerInfo",value:function(id){return this.credentialProvider().credentials().Servers.filter(function(s){return s.Id===id})[0]}},{key:"getLastUsedServer",value:function(){var servers=this.credentialProvider().credentials().Servers;return servers.sort(sortServers),servers.length?servers[0]:null}},{key:"getApiClientFromServerInfo",value:function(server,serverUrlToMatch){server.DateLastAccessed=Date.now(),null==server.LastConnectionMode&&server.ManualAddress&&(server.LastConnectionMode=ConnectionMode_Manual);var credentialProvider=this.credentialProvider(),credentials=credentialProvider.credentials();return credentialProvider.addOrUpdateServer(credentials.Servers,server,serverUrlToMatch),credentialProvider.credentials(credentials),this._getOrAddApiClient(server,getServerAddress(server,server.LastConnectionMode))}},{key:"clearData",value:function(){console.log("connection manager clearing data"),this._connectUser=null;var credentialProvider=this.credentialProvider(),credentials=credentialProvider.credentials();credentials.ConnectAccessToken=null,credentials.ConnectUserId=null,credentials.Servers=[],credentialProvider.credentials(credentials)}},{key:"_getOrAddApiClient",value:function(server,serverUrl){var apiClient=server.Id?this.getApiClient(server.Id):null;if(!apiClient&&server.IsLocalServer)for(var i=0,length=this._apiClients.length;i<length;i++){var current=this._apiClients[i];if(current.serverInfo().IsLocalServer){apiClient=current;break}}return apiClient||(apiClient=new this.apiClientFactory(this.appStorage,this.wakeOnLan,serverUrl,this.appName(),this.appVersion(),this.deviceName(),this.deviceId(),this.devicePixelRatio,this.localassetmanager,this.itemrepository,this.useractionrepository),this._apiClients.push(apiClient),apiClient.serverInfo(server),apiClient.setCurrentLocale(this.currentLocale),apiClient.onAuthenticated=function(apiClient,result){var options={},instance=this,credentialProvider=instance.credentialProvider(),credentials=credentialProvider.credentials(),servers=credentials.Servers.filter(function(s){return s.Id===result.ServerId}),server=servers.length?servers[0]:apiClient.serverInfo();return!1!==options.updateDateLastAccessed&&(server.DateLastAccessed=Date.now()),server.Id=result.ServerId,server.UserId=result.User.Id,server.AccessToken=result.AccessToken,credentialProvider.addOrUpdateServer(credentials.Servers,server),credentialProvider.credentials(credentials),apiClient.enableAutomaticBitrateDetection=options.enableAutomaticBitrateDetection,apiClient.serverInfo(server),options.reportCapabilities=!0,afterConnected(instance,apiClient,server,options),apiClient.getPublicSystemInfo().then(function(systemInfo){return updateServerInfo(server,systemInfo),credentialProvider.addOrUpdateServer(credentials.Servers,server),credentialProvider.credentials(credentials),onLocalUserSignIn(instance,server,apiClient.serverAddress())})}.bind(this),_events.default.trigger(this,"apiclientcreated",[apiClient])),console.log("returning instance from getOrAddApiClient"),apiClient}},{key:"setCurrentLocale",value:function(value){this.currentLocale=value;for(var i=0,length=this._apiClients.length;i<length;i++)this._apiClients[i].setCurrentLocale(value)}},{key:"logout",value:function(){console.log("begin connectionManager loguot");for(var promises=[],i=0,length=this._apiClients.length;i<length;i++){var apiClient=this._apiClients[i];apiClient.accessToken()&&promises.push(function(instance,apiClient){var logoutInfo={serverId:(apiClient.serverInfo()||{}).Id};return apiClient.logout().then(function(){_events.default.trigger(instance,"localusersignedout",[logoutInfo])},function(){_events.default.trigger(instance,"localusersignedout",[logoutInfo])})}(this,apiClient))}var instance=this;return Promise.all(promises).then(function(){for(var credentialProvider=instance.credentialProvider(),credentials=credentialProvider.credentials(),servers=credentials.Servers,j=0,numServers=servers.length;j<numServers;j++){var server=servers[j];server.UserId=null,server.AccessToken=null,server.ExchangeToken=null}credentials.Servers=servers,credentials.ConnectAccessToken=null,credentials.ConnectUserId=null,credentialProvider.credentials(credentials),instance._connectUser&&(instance._connectUser=null,_events.default.trigger(instance,"connectusersignedout"))})}},{key:"getSavedServers",value:function(){var credentialProvider=this.credentialProvider();if(!credentialProvider)return console.log("A call was made to getSavedServers before connectionManager was initialized."),[];credentialProvider=credentialProvider.credentials().Servers.slice(0);return credentialProvider.forEach(setServerProperties),credentialProvider.sort(sortServers),credentialProvider}},{key:"getAvailableServers",value:function(){console.log("Begin getAvailableServers");var credentialProvider=this.credentialProvider(),credentials=credentialProvider.credentials();return Promise.all([function(instance,credentials){return console.log("Begin getConnectServers"),credentials.ConnectAccessToken&&credentials.ConnectUserId?ajax({type:"GET",url:"https://connect.emby.media/service/servers?userId=".concat(credentials.ConnectUserId),dataType:"json",headers:{"X-Application":"".concat(instance.appName(),"/").concat(instance.appVersion()),"X-Connect-UserToken":credentials.ConnectAccessToken}}).then(function(servers){return servers.map(function(i){return{ExchangeToken:i.AccessKey,ConnectServerId:i.Id,Id:i.SystemId,Name:i.Name,RemoteAddress:i.Url,LocalAddress:i.LocalAddres}})},function(){return credentials.Servers.slice(0).filter(function(s){return s.ExchangeToken})}):Promise.resolve([])}(this,credentials),findServers(this.serverDiscoveryFn)]).then(function(responses){var connectServers=responses[0],responses=responses[1],servers=credentials.Servers.slice(0);return mergeServers(credentialProvider,servers,responses),mergeServers(credentialProvider,servers,connectServers),(servers=function(servers,connectServers){return servers.filter(function(server){return!server.ExchangeToken||0<connectServers.filter(function(connectServer){return server.Id===connectServer.Id}).length})}(servers,connectServers)).forEach(setServerProperties),servers.sort(sortServers),credentials.Servers=servers,credentialProvider.credentials(credentials),servers})}},{key:"connectToServers",value:function(servers,options){console.log("Begin connectToServers, with ".concat(servers.length," servers"));var firstServer=servers.length?servers[0]:null;return firstServer?this.connectToServer(firstServer,options).then(function(result){return"Unavailable"===result.State&&(result.State="ServerSelection"),console.log("resolving connectToServers with result.State: "+result.State),result}):Promise.resolve({Servers:servers,State:servers.length||this.connectUser()?"ServerSelection":"ConnectSignIn",ConnectUser:this.connectUser()})}},{key:"connectToServer",value:function(server,options){console.log("begin connectToServer"),options=options||{};var instance=this;return function(instance,serverInfo,signal){var addresses=[],addressesStrings=[];if(serverInfo.ManualAddress&&((address=serverInfo.ManualAddress).includes("://127.0.0.1")||!!address.toLowerCase().includes("://localhost"))&&!addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())&&(addresses.push({url:serverInfo.ManualAddress,mode:ConnectionMode_Manual}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.ManualAddressOnly||!serverInfo.LocalAddress||addressesStrings.includes(serverInfo.LocalAddress.toLowerCase())||(addresses.push({url:serverInfo.LocalAddress,mode:ConnectionMode_Local}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.ManualAddress&&!addressesStrings.includes(serverInfo.ManualAddress.toLowerCase())&&(addresses.push({url:serverInfo.ManualAddress,mode:ConnectionMode_Manual}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),serverInfo.ManualAddressOnly||!serverInfo.RemoteAddress||addressesStrings.includes(serverInfo.RemoteAddress.toLowerCase())||(addresses.push({url:serverInfo.RemoteAddress,mode:ConnectionMode_Remote}),addressesStrings.push(addresses[addresses.length-1].url.toLowerCase())),console.log("tryReconnect: "+addressesStrings.join("|")),!addressesStrings.length)return Promise.reject();for(var abortController=new AbortController,address=abortController.abort.bind(abortController),promises=(signal&&signal.addEventListener("abort",address),signal=abortController.signal,[]),i=0,length=addresses.length;i<length;i++)promises.push(tryReconnectToUrl(instance,addresses[i].url,addresses[i].mode,200*i,signal));return Promise.any(promises).then(function(result){return abortController.abort(),result})}(this,server).then(function(result){var serverUrl=result.url,connectionMode=result.connectionMode;return result=result.data,1===compareVersions(instance.minServerVersion(),result.Version)||1===compareVersions(result.Version,"8.0")?(console.log("minServerVersion requirement not met. Server version: "+result.Version),{State:"ServerUpdateNeeded",Servers:[server]}):(server.Id&&result.Id!==server.Id&&!1!==instance.validateServerIds&&updateServerInfo(server={Id:result.Id,ManualAddress:serverUrl},result),function(instance,url,server,result,connectionMode,options){return console.log("connectionManager.resolveIfAvailable: "+url),(instance.validateServerAddress?instance.validateServerAddress(instance,ajax,url):Promise.resolve()).then(function(){return onSuccessfulConnection(instance,server,result,connectionMode,url,options)},function(){return console.log("minServerVersion requirement not met. Server version: "+result.Version),{State:"ServerUpdateNeeded",Servers:[server]}})}(instance,serverUrl,server,result,connectionMode,options))},function(){return{State:"Unavailable",ConnectUser:instance.connectUser()}})}},{key:"connectToAddress",value:function(address,options){if(!address)return Promise.reject();address=normalizeAddress(address);var instance=this;var server={ManualAddress:address,LastConnectionMode:ConnectionMode_Manual};return this.connectToServer(server,options).catch(function(){return console.log("connectToAddress ".concat(address," failed")),Promise.resolve({State:"Unavailable",ConnectUser:instance.connectUser()})})}},{key:"loginToConnect",value:function(username,password){if(!username)return Promise.reject();if(!password)return Promise.reject();var credentialProvider=this.credentialProvider(),instance=this;return ajax({type:"POST",url:"https://connect.emby.media/service/user/authenticate",data:{nameOrEmail:username,rawpw:password},dataType:"json",contentType:"application/x-www-form-urlencoded; charset=UTF-8",headers:{"X-Application":"".concat(this.appName(),"/").concat(this.appVersion())}}).then(function(result){var credentials=credentialProvider.credentials();return credentials.ConnectAccessToken=result.AccessToken,credentials.ConnectUserId=result.User.Id,credentialProvider.credentials(credentials),onConnectUserSignIn(instance,result.User),result})}},{key:"signupForConnect",value:function(options){var email=options.email,username=options.username,password=options.password,passwordConfirm=options.passwordConfirm;if(!email)return Promise.reject({errorCode:"invalidinput"});if(!username)return Promise.reject({errorCode:"invalidinput"});if(!password)return Promise.reject({errorCode:"invalidinput"});if(!passwordConfirm)return Promise.reject({errorCode:"passwordmatch"});if(password!==passwordConfirm)return Promise.reject({errorCode:"passwordmatch"});passwordConfirm={email:email,userName:username,rawpw:password};return options.grecaptcha&&(passwordConfirm.grecaptcha=options.grecaptcha),ajax({type:"POST",url:"https://connect.emby.media/service/register",data:passwordConfirm,dataType:"json",contentType:"application/x-www-form-urlencoded; charset=UTF-8",headers:{"X-Application":"".concat(this.appName(),"/").concat(this.appVersion()),"X-CONNECT-TOKEN":"CONNECT-REGISTER"}}).catch(function(response){return response.json()}).then(function(result){if(result&&result.Status)return"SUCCESS"===result.Status?Promise.resolve(result):Promise.reject({errorCode:result.Status});Promise.reject()})}},{key:"getUserInvitations",value:function(){var connectToken=this.connectToken();if(!connectToken)throw new Error("null connectToken");if(this.connectUserId())return ajax({type:"GET",url:"https://connect.emby.media/service/servers?userId=".concat(this.connectUserId(),"&status=Waiting"),dataType:"json",headers:{"X-Connect-UserToken":connectToken,"X-Application":"".concat(this.appName(),"/").concat(this.appVersion())}});throw new Error("null connectUserId")}},{key:"deleteServer",value:function(serverId){if(!serverId)throw new Error("null serverId");var credentialProvider=this.credentialProvider(),server=credentialProvider.credentials().Servers.filter(function(s){return s.Id===serverId});function onDone(){var credentials=credentialProvider.credentials();return credentials.Servers=credentials.Servers.filter(function(s){return s.Id!==serverId}),credentialProvider.credentials(credentials),Promise.resolve()}if(!(server=server.length?server[0]:null).ConnectServerId)return onDone();var connectToken=this.connectToken(),connectUserId=this.connectUserId();return connectToken&&connectUserId?ajax({type:"DELETE",url:"https://connect.emby.media/service/serverAuthorizations?serverId=".concat(server.ConnectServerId,"&userId=").concat(connectUserId),headers:{"X-Connect-UserToken":connectToken,"X-Application":"".concat(this.appName(),"/").concat(this.appVersion())}}).then(onDone,onDone):onDone()}},{key:"resetRegistrationInfo",value:function(apiClient,onlyResetIfFailed){var appStorage=this.appStorage,removeAll=!1,cacheKey=getCacheKey("themes",apiClient,{viewOnly:!0}),regInfo=JSON.parse(appStorage.getItem(cacheKey)||"{}");!removeAll&&onlyResetIfFailed&&-1!==regInfo.lastValidDate||(appStorage.removeItem(cacheKey),removeAll=!0),cacheKey=getCacheKey("themes",apiClient,{viewOnly:!1}),regInfo=JSON.parse(appStorage.getItem(cacheKey)||"{}"),!removeAll&&onlyResetIfFailed&&-1!==regInfo.lastValidDate||(appStorage.removeItem(cacheKey),removeAll=!0),onlyResetIfFailed||_events.default.trigger(this,"resetregistrationinfo")}},{key:"getRegistrationInfo",value:function(feature,apiClient,options){var params={serverId:apiClient.serverId(),deviceId:this.deviceId(),deviceName:this.deviceName(),appName:this.appName(),appVersion:this.appVersion()},cacheKey=((options=options||{}).viewOnly&&(params.viewOnly=options.viewOnly),getCacheKey(feature,apiClient,options)),appStorage=this.appStorage,feature=JSON.parse(appStorage.getItem(cacheKey)||"{}"),timeSinceLastValidation=Date.now()-(feature.lastValidDate||0);if(timeSinceLastValidation<=864e5)return console.log("getRegistrationInfo returning cached info"),Promise.resolve();if(options.useCachedFailure&&-1===feature.lastValidDate)return Promise.reject();var regCacheValid=timeSinceLastValidation<=864e5*(feature.cacheExpirationDays||7);if(!params.serverId)return Promise.reject();options=apiClient.getCurrentUserId();if(options&&"81f53802ea0247ad80618f55d9b4ec3c"===options.toLowerCase()&&"21585256623b4beeb26d5d3b09dec0ac"===params.serverId.toLowerCase())return Promise.reject();timeSinceLastValidation=ajax({url:"https://mb3admin.com/admin/service/registration/validateDevice?"+paramsToString(params),type:"POST",dataType:"json"}).then(function(response){return appStorage.setItem(cacheKey,JSON.stringify({lastValidDate:Date.now(),deviceId:params.deviceId,cacheExpirationDays:response.cacheExpirationDays,lastUpdated:Date.now()})),Promise.resolve()},function(response){var status=(response||{}).status;{if(console.log("getRegistrationInfo response: "+status),status&&status<500&&appStorage.setItem(cacheKey,JSON.stringify({lastValidDate:-1,deviceId:params.deviceId,cacheExpirationDays:0,lastUpdated:Date.now()})),403===status)return Promise.reject("overlimit");if(status&&status<500)return Promise.reject();if(status=response,console.log("getRegistrationInfo failed: "+status),regCacheValid)return console.log("getRegistrationInfo returning cached info"),Promise.resolve();throw status}});return regCacheValid?(console.log("getRegistrationInfo returning cached info"),Promise.resolve()):timeSinceLastValidation}},{key:"createPin",value:function(){var request={type:"POST",url:getConnectUrl("pin"),data:{deviceId:this.deviceId()},dataType:"json"};return addAppInfoToConnectRequest(this,request),ajax(request)}},{key:"getPinStatus",value:function(pinInfo){if(!pinInfo)throw new Error("pinInfo cannot be null");pinInfo={deviceId:pinInfo.DeviceId,pin:pinInfo.Pin},pinInfo={type:"GET",url:"".concat(getConnectUrl("pin"),"?").concat(paramsToString(pinInfo)),dataType:"json"};return addAppInfoToConnectRequest(this,pinInfo),ajax(pinInfo)}},{key:"exchangePin",value:function(pinInfo){if(!pinInfo)throw new Error("pinInfo cannot be null");var credentialProvider=this.credentialProvider(),instance=this;return function(instance,pinInfo){if(pinInfo)return pinInfo={type:"POST",url:getConnectUrl("pin/authenticate"),data:{deviceId:pinInfo.DeviceId,pin:pinInfo.Pin},dataType:"json"},addAppInfoToConnectRequest(instance,pinInfo),ajax(pinInfo);throw new Error("pinInfo cannot be null")}(this,pinInfo).then(function(result){var credentials=credentialProvider.credentials();return credentials.ConnectAccessToken=result.AccessToken,credentials.ConnectUserId=result.UserId,credentialProvider.credentials(credentials),ensureConnectUser(instance,credentials)})}},{key:"connect",value:function(options){console.log("Begin connect");var instance=this;return instance.getAvailableServers().then(function(servers){return instance.connectToServers(servers,options)})}},{key:"handleMessageReceived",value:function(msg){var serverId=msg.ServerId;if(serverId){serverId=this.getApiClient(serverId);if(serverId){if("string"==typeof msg.Data)try{msg.Data=JSON.parse(msg.Data)}catch(err){console.log("Error in handleMessageReceived JSON.parse: ".concat(err))}serverId.handleMessageReceived(msg)}}}},{key:"onNetworkChanged",value:function(){for(var apiClients=this._apiClients,i=0,length=apiClients.length;i<length;i++)apiClients[i].onNetworkChanged()}},{key:"onAppResume",value:function(){for(var apiClients=this._apiClients,i=0,length=apiClients.length;i<length;i++)apiClients[i].ensureWebSocket()}},{key:"isLoggedIntoConnect",value:function(){return!(!this.connectToken()||!this.connectUserId())}},{key:"getApiClients",value:function(){for(var servers=this.getSavedServers(),i=0,length=servers.length;i<length;i++){var serverUrl,server=servers[i];!server.Id||(serverUrl=getServerAddress(server,server.LastConnectionMode))&&this._getOrAddApiClient(server,serverUrl)}return this._apiClients}},{key:"getApiClient",value:function(item){if(!item)throw new Error("item or serverId cannot be null");var serverId=(serverId=item.ServerId)||(item.Id&&"Server"===item.Type?item.Id:item);if(serverId&&(apiClient=this._apiClientsMap[serverId]))return apiClient;for(var apiClients=this._apiClients,i=0,length=apiClients.length;i<length;i++){var apiClient,serverInfo=(apiClient=apiClients[i]).serverInfo();if(!serverInfo||serverInfo.Id===serverId)return apiClient}return null}},{key:"getEmbyServerUrl",value:function(baseUrl,handler){return baseUrl.endsWith("/")&&(baseUrl=baseUrl.substring(0,baseUrl.length-1)),"".concat(baseUrl,"/emby/").concat(handler)}},{key:"reportCapabilities",value:function(apiClient){return this.capabilities().then(function(capabilities){return apiClient.reportCapabilities(capabilities)})}}]),ConnectionManager}());_exports.default=_default});