define(["exports","../utils/events.js","../utils/logger.js","../../browser.js","./player-events.js","../core/transmuxer.js","../core/transmuxing-events.js","../core/mse-controller.js","../core/mse-events.js","./player-errors.js","../config.js","../utils/exception.js"],function(_exports,_events,_logger,_browser,_playerEvents,_transmuxer,_transmuxingEvents,_mseController,_mseEvents,_playerErrors,_config,_exception){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var FlvPlayer=function(){function FlvPlayer(mediaDataSource,config){if(babelHelpers.classCallCheck(this,FlvPlayer),this.TAG="FlvPlayer",this._type="FlvPlayer",this._emitter=new _events.default,this._config=(0,_config.createDefaultConfig)(),"object"==typeof config&&Object.assign(this._config,config),"flv"!==mediaDataSource.type.toLowerCase())throw new _exception.InvalidArgumentException("FlvPlayer requires an flv MediaDataSource input!");!0===mediaDataSource.isLive&&(this._config.isLive=!0),this.e={onvLoadedMetadata:this._onvLoadedMetadata.bind(this),onvSeeking:this._onvSeeking.bind(this),onvCanPlay:this._onvCanPlay.bind(this),onvStalled:this._onvStalled.bind(this),onvProgress:this._onvProgress.bind(this)},self.performance&&self.performance.now?this._now=self.performance.now.bind(self.performance):this._now=Date.now,this._pendingSeekTime=null,this._requestSetTime=!1,this._seekpointRecord=null,this._progressChecker=null,this._mediaDataSource=mediaDataSource,this._mediaElement=null,this._msectl=null,this._transmuxer=null,this._mseSourceOpened=!1,this._hasPendingLoad=!1,this._receivedCanPlay=!1,this._mediaInfo=null,this._statisticsInfo=null;mediaDataSource=_browser.default.chrome&&((config=navigator.userAgent.match(/Chrome\/(\d+)/i))?parseInt(config[1]):0)<=50;this._alwaysSeekKeyframe=!(!mediaDataSource&&!_browser.default.edge),this._alwaysSeekKeyframe&&(this._config.accurateSeek=!1)}return babelHelpers.createClass(FlvPlayer,[{key:"destroy",value:function(){null!=this._progressChecker&&(window.clearInterval(this._progressChecker),this._progressChecker=null),this._transmuxer&&this.unload(),this._mediaElement&&this.detachMediaElement(),this.e=null,this._mediaDataSource=null,this._emitter.removeAllListeners(),this._emitter=null}},{key:"on",value:function(event,listener){var _this=this;event===_playerEvents.default.MEDIA_INFO?null!=this._mediaInfo&&Promise.resolve().then(function(){_this._emitter.emit(_playerEvents.default.MEDIA_INFO,_this.mediaInfo)}):event===_playerEvents.default.STATISTICS_INFO&&null!=this._statisticsInfo&&Promise.resolve().then(function(){_this._emitter.emit(_playerEvents.default.STATISTICS_INFO,_this.statisticsInfo)}),this._emitter.addListener(event,listener)}},{key:"off",value:function(event,listener){this._emitter.removeListener(event,listener)}},{key:"attachMediaElement",value:function(mediaElement){var _this2=this;if((this._mediaElement=mediaElement).addEventListener("loadedmetadata",this.e.onvLoadedMetadata),mediaElement.addEventListener("seeking",this.e.onvSeeking),mediaElement.addEventListener("canplay",this.e.onvCanPlay),mediaElement.addEventListener("stalled",this.e.onvStalled),mediaElement.addEventListener("progress",this.e.onvProgress),this._msectl=new _mseController.default(this._config),this._msectl.on(_mseEvents.default.UPDATE_END,this._onmseUpdateEnd.bind(this)),this._msectl.on(_mseEvents.default.BUFFER_FULL,this._onmseBufferFull.bind(this)),this._msectl.on(_mseEvents.default.SOURCE_OPEN,function(){_this2._mseSourceOpened=!0,_this2._hasPendingLoad&&(_this2._hasPendingLoad=!1,_this2.load())}),this._msectl.on(_mseEvents.default.ERROR,function(info){_this2._emitter.emit(_playerEvents.default.ERROR,_playerErrors.ErrorTypes.MEDIA_ERROR,_playerErrors.ErrorDetails.MEDIA_MSE_ERROR,info)}),this._msectl.attachMediaElement(mediaElement),null!=this._pendingSeekTime)try{mediaElement.currentTime=this._pendingSeekTime,this._pendingSeekTime=null}catch(e){}}},{key:"detachMediaElement",value:function(){this._mediaElement&&(this._msectl.detachMediaElement(),this._mediaElement.removeEventListener("loadedmetadata",this.e.onvLoadedMetadata),this._mediaElement.removeEventListener("seeking",this.e.onvSeeking),this._mediaElement.removeEventListener("canplay",this.e.onvCanPlay),this._mediaElement.removeEventListener("stalled",this.e.onvStalled),this._mediaElement.removeEventListener("progress",this.e.onvProgress),this._mediaElement=null),this._msectl&&(this._msectl.destroy(),this._msectl=null)}},{key:"load",value:function(){var _this3=this;if(!this._mediaElement)throw new _exception.IllegalStateException("HTMLMediaElement must be attached before load()!");if(this._transmuxer)throw new _exception.IllegalStateException("FlvPlayer.load() has been called, please call unload() first!");this._hasPendingLoad||(this._config.deferLoadAfterSourceOpen&&!1===this._mseSourceOpened?this._hasPendingLoad=!0:(0<this._mediaElement.readyState&&(this._requestSetTime=!0,this._mediaElement.currentTime=0),this._transmuxer=new _transmuxer.default(this._mediaDataSource,this._config),this._transmuxer.on(_transmuxingEvents.default.INIT_SEGMENT,function(type,is){_this3._msectl.appendInitSegment(is)}),this._transmuxer.on(_transmuxingEvents.default.MEDIA_SEGMENT,function(type,ms){var currentTime;_this3._msectl.appendMediaSegment(ms),_this3._config.lazyLoad&&!_this3._config.isLive&&(currentTime=_this3._mediaElement.currentTime,ms.info.endDts>=1e3*(currentTime+_this3._config.lazyLoadMaxDuration)&&null==_this3._progressChecker&&(_logger.default.v(_this3.TAG,"Maximum buffering duration exceeded, suspend transmuxing task"),_this3._suspendTransmuxer()))}),this._transmuxer.on(_transmuxingEvents.default.LOADING_COMPLETE,function(){_this3._msectl.endOfStream(),_this3._emitter.emit(_playerEvents.default.LOADING_COMPLETE)}),this._transmuxer.on(_transmuxingEvents.default.RECOVERED_EARLY_EOF,function(){_this3._emitter.emit(_playerEvents.default.RECOVERED_EARLY_EOF)}),this._transmuxer.on(_transmuxingEvents.default.IO_ERROR,function(detail,info){_this3._emitter.emit(_playerEvents.default.ERROR,_playerErrors.ErrorTypes.NETWORK_ERROR,detail,info)}),this._transmuxer.on(_transmuxingEvents.default.DEMUX_ERROR,function(detail,info){_this3._emitter.emit(_playerEvents.default.ERROR,_playerErrors.ErrorTypes.MEDIA_ERROR,detail,{code:-1,msg:info})}),this._transmuxer.on(_transmuxingEvents.default.MEDIA_INFO,function(mediaInfo){_this3._mediaInfo=mediaInfo,_this3._emitter.emit(_playerEvents.default.MEDIA_INFO,Object.assign({},mediaInfo))}),this._transmuxer.on(_transmuxingEvents.default.METADATA_ARRIVED,function(metadata){_this3._emitter.emit(_playerEvents.default.METADATA_ARRIVED,metadata)}),this._transmuxer.on(_transmuxingEvents.default.SCRIPTDATA_ARRIVED,function(data){_this3._emitter.emit(_playerEvents.default.SCRIPTDATA_ARRIVED,data)}),this._transmuxer.on(_transmuxingEvents.default.STATISTICS_INFO,function(statInfo){_this3._statisticsInfo=_this3._fillStatisticsInfo(statInfo),_this3._emitter.emit(_playerEvents.default.STATISTICS_INFO,Object.assign({},_this3._statisticsInfo))}),this._transmuxer.on(_transmuxingEvents.default.RECOMMEND_SEEKPOINT,function(milliseconds){_this3._mediaElement&&!_this3._config.accurateSeek&&(_this3._requestSetTime=!0,_this3._mediaElement.currentTime=milliseconds/1e3)}),this._transmuxer.open()))}},{key:"unload",value:function(){this._mediaElement&&this._mediaElement.pause(),this._msectl&&this._msectl.seek(0),this._transmuxer&&(this._transmuxer.close(),this._transmuxer.destroy(),this._transmuxer=null)}},{key:"play",value:function(){return this._mediaElement.play()}},{key:"pause",value:function(){this._mediaElement.pause()}},{key:"type",get:function(){return this._type}},{key:"buffered",get:function(){return this._mediaElement.buffered}},{key:"duration",get:function(){return this._mediaElement.duration}},{key:"volume",get:function(){return this._mediaElement.volume},set:function(value){this._mediaElement.volume=value}},{key:"muted",get:function(){return this._mediaElement.muted},set:function(muted){this._mediaElement.muted=muted}},{key:"currentTime",get:function(){return this._mediaElement?this._mediaElement.currentTime:0},set:function(seconds){this._mediaElement?this._internalSeek(seconds):this._pendingSeekTime=seconds}},{key:"mediaInfo",get:function(){return Object.assign({},this._mediaInfo)}},{key:"statisticsInfo",get:function(){return null==this._statisticsInfo&&(this._statisticsInfo={}),this._statisticsInfo=this._fillStatisticsInfo(this._statisticsInfo),Object.assign({},this._statisticsInfo)}},{key:"_fillStatisticsInfo",value:function(statInfo){var hasQualityInfo,quality,decoded,dropped;return statInfo.playerType=this._type,this._mediaElement instanceof HTMLVideoElement&&(hasQualityInfo=!0,dropped=decoded=0,this._mediaElement.getVideoPlaybackQuality?(decoded=(quality=this._mediaElement.getVideoPlaybackQuality()).totalVideoFrames,dropped=quality.droppedVideoFrames):null!=this._mediaElement.webkitDecodedFrameCount?(decoded=this._mediaElement.webkitDecodedFrameCount,dropped=this._mediaElement.webkitDroppedFrameCount):hasQualityInfo=!1,hasQualityInfo&&(statInfo.decodedFrames=decoded,statInfo.droppedFrames=dropped)),statInfo}},{key:"_onmseUpdateEnd",value:function(){if(this._config.lazyLoad&&!this._config.isLive){for(var buffered=this._mediaElement.buffered,currentTime=this._mediaElement.currentTime,currentRangeEnd=0,i=0;i<buffered.length;i++){var start=buffered.start(i),end=buffered.end(i);if(start<=currentTime&&currentTime<end){currentRangeEnd=end;break}}currentRangeEnd>=currentTime+this._config.lazyLoadMaxDuration&&null==this._progressChecker&&(_logger.default.v(this.TAG,"Maximum buffering duration exceeded, suspend transmuxing task"),this._suspendTransmuxer())}}},{key:"_onmseBufferFull",value:function(){_logger.default.v(this.TAG,"MSE SourceBuffer is full, suspend transmuxing task"),null==this._progressChecker&&this._suspendTransmuxer()}},{key:"_suspendTransmuxer",value:function(){this._transmuxer&&(this._transmuxer.pause(),null==this._progressChecker&&(this._progressChecker=window.setInterval(this._checkProgressAndResume.bind(this),1e3)))}},{key:"_checkProgressAndResume",value:function(){for(var currentTime=this._mediaElement.currentTime,buffered=this._mediaElement.buffered,needResume=!1,i=0;i<buffered.length;i++){var from=buffered.start(i),to=buffered.end(i);if(from<=currentTime&&currentTime<to){currentTime>=to-this._config.lazyLoadRecoverDuration&&(needResume=!0);break}}needResume&&(window.clearInterval(this._progressChecker),this._progressChecker=null,needResume&&(_logger.default.v(this.TAG,"Continue loading from paused position"),this._transmuxer.resume()))}},{key:"_isTimepointBuffered",value:function(seconds){for(var buffered=this._mediaElement.buffered,i=0;i<buffered.length;i++){var from=buffered.start(i),to=buffered.end(i);if(from<=seconds&&seconds<to)return!0}return!1}},{key:"_internalSeek",value:function(seconds){var videoBeginTime,directSeek=this._isTimepointBuffered(seconds),directSeekBegin=!1,directSeekBeginTime=0;seconds<1&&0<this._mediaElement.buffered.length&&(((videoBeginTime=this._mediaElement.buffered.start(0))<1&&seconds<videoBeginTime||_browser.default.safari)&&(directSeekBegin=!0,directSeekBeginTime=_browser.default.safari?.1:videoBeginTime)),directSeekBegin?(this._requestSetTime=!0,this._mediaElement.currentTime=directSeekBeginTime):directSeek?(this._alwaysSeekKeyframe?(videoBeginTime=this._msectl.getNearestKeyframe(Math.floor(1e3*seconds)),this._requestSetTime=!0,this._mediaElement.currentTime=null!=videoBeginTime?videoBeginTime.dts/1e3:seconds):(this._requestSetTime=!0,this._mediaElement.currentTime=seconds),null!=this._progressChecker&&this._checkProgressAndResume()):(null!=this._progressChecker&&(window.clearInterval(this._progressChecker),this._progressChecker=null),this._msectl.seek(seconds),this._transmuxer.seek(Math.floor(1e3*seconds)),this._config.accurateSeek&&(this._requestSetTime=!0,this._mediaElement.currentTime=seconds))}},{key:"_checkAndApplyUnbufferedSeekpoint",value:function(){var target;this._seekpointRecord&&(this._seekpointRecord.recordTime<=this._now()-100?(target=this._mediaElement.currentTime,this._seekpointRecord=null,this._isTimepointBuffered(target)||(null!=this._progressChecker&&(window.clearTimeout(this._progressChecker),this._progressChecker=null),this._msectl.seek(target),this._transmuxer.seek(Math.floor(1e3*target)),this._config.accurateSeek&&(this._requestSetTime=!0,this._mediaElement.currentTime=target))):window.setTimeout(this._checkAndApplyUnbufferedSeekpoint.bind(this),50))}},{key:"_checkAndResumeStuckPlayback",value:function(stalled){var media=this._mediaElement;stalled||!this._receivedCanPlay||media.readyState<2?0<(stalled=media.buffered).length&&media.currentTime<stalled.start(0)&&(_logger.default.w(this.TAG,"Playback seems stuck at ".concat(media.currentTime,", seek to ").concat(stalled.start(0))),this._requestSetTime=!0,this._mediaElement.currentTime=stalled.start(0),this._mediaElement.removeEventListener("progress",this.e.onvProgress)):this._mediaElement.removeEventListener("progress",this.e.onvProgress)}},{key:"_onvLoadedMetadata",value:function(e){null!=this._pendingSeekTime&&(this._mediaElement.currentTime=this._pendingSeekTime,this._pendingSeekTime=null)}},{key:"_onvSeeking",value:function(e){var target=this._mediaElement.currentTime,buffered=this._mediaElement.buffered;if(this._requestSetTime)this._requestSetTime=!1;else{if(target<1&&0<buffered.length){var buffered=buffered.start(0);if(buffered<1&&target<buffered||_browser.default.safari)return this._requestSetTime=!0,void(this._mediaElement.currentTime=_browser.default.safari?.1:buffered)}if(this._isTimepointBuffered(target))return this._alwaysSeekKeyframe&&null!=(buffered=this._msectl.getNearestKeyframe(Math.floor(1e3*target)))&&(this._requestSetTime=!0,this._mediaElement.currentTime=buffered.dts/1e3),void(null!=this._progressChecker&&this._checkProgressAndResume());this._seekpointRecord={seekPoint:target,recordTime:this._now()},window.setTimeout(this._checkAndApplyUnbufferedSeekpoint.bind(this),50)}}},{key:"_onvCanPlay",value:function(e){this._receivedCanPlay=!0,this._mediaElement.removeEventListener("canplay",this.e.onvCanPlay)}},{key:"_onvStalled",value:function(e){this._checkAndResumeStuckPlayback(!0)}},{key:"_onvProgress",value:function(e){this._checkAndResumeStuckPlayback()}}]),FlvPlayer}();_exports.default=FlvPlayer});