define(["exports","./dom.js","./layoutmanager.js"],function(_exports,_dom,_layoutmanager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var scopes=[];function getElementToAutoFocus(view,options){var element;return options&&!1===options.findAutoFocusElement||!(element=view.querySelector(".autofocus"))||!isCurrentlyFocusableInternal(element)?getFocusableElements(view,1,".noautofocus",options)[0]||getFocusableElements(view,1,null,options)[0]:element}function autoFocus(view,options){view=getElementToAutoFocus(view,options);return view&&focus(view,options),view}function focus(element,options){for(;element.classList.contains("focusable");){var autoFocusElement=getElementToAutoFocus(element,options);if(!autoFocusElement)break;element=autoFocusElement}focusInternal(element,options)}function focusInternal(element,options){try{var preventScroll=options?options.preventScroll:null;null==preventScroll&&_layoutmanager.default.tv&&(preventScroll=!0),element.focus({preventScroll:preventScroll})}catch(err){console.log("Error in focusManager.autoFocus: "+err)}}var focusableTagNames=["INPUT","TEXTAREA","SELECT","BUTTON","A"],focusableQuerySelectors=focusableTagNames.map(function(t){return t+':not([tabindex="-1"]):not(:disabled)'}),focusableQuery=(focusableQuerySelectors.push(".focusable"),focusableQuerySelectors.join(","));var focusableParentQuery=focusableTagNames.join(",")+",.focusable";function focusableParent(elem){return elem.closest(focusableParentQuery)||elem}function isCurrentlyFocusableInternal(elem){return null!==elem.offsetParent}var defaultScope=document.body;function getCurrentScope(){return scopes[scopes.length-1]||defaultScope}function getFocusableElements(parent,limit,excludeSelector,options){for(var elems,fn=(parent=parent||getCurrentScope()).getFocusableElements,focusableElements=(elems=(elems=fn?fn(parent,document.activeElement,null,options):elems)||parent.querySelectorAll(function(excludeSelector){if(!excludeSelector)return focusableQuery;for(var newQuerySelectors=[focusableQuerySelectors.length],i=0,length=focusableQuerySelectors.length;i<length;i++)newQuerySelectors[i]=focusableQuerySelectors[i]+":not("+excludeSelector+")";return newQuerySelectors.join(",")}(excludeSelector)),[]),i=0,length=elems.length;i<length;i++){var elem=elems[i];if(null!==elem.offsetParent&&(focusableElements.push(elem),limit&&focusableElements.length>=limit))break}return focusableElements}var focusContainerQueries=[".focuscontainer,.focuscontainer-x",".focuscontainer,.focuscontainer-x",".focuscontainer,.focuscontainer-y,.focuscontainer-up",".focuscontainer,.focuscontainer-y,.focuscontainer-down"];function getBoundingClientRect(elem){return elem.getBoundingClientRect()}function getNearestElement(activeElement,activeElementRect,direction,focusableElements,focusableContainer){for(var nearestElement,activeElementTop=activeElementRect.top,activeElementLeft=activeElementRect.left,point1x=parseFloat(activeElementLeft)||0,point1y=parseFloat(activeElementTop)||0,point2x=parseFloat(point1x+activeElementRect.width-1)||point1x,point2y=parseFloat(point1y+activeElementRect.height-1)||point1y,minDistance=1/0,i=0,length=focusableElements.length;i<length;i++){var curr=focusableElements[i];if(curr!==activeElement&&curr!==focusableContainer){var elementRect=getBoundingClientRect(curr),elementRectWidth=elementRect.width,elementRectHeight=elementRect.height,elementRectLeft=elementRect.left,elementRectTop=elementRect.top;if(elementRectWidth||elementRectHeight){switch(direction){case 0:if(activeElementLeft<=elementRectLeft)continue;if(elementRect.right===activeElementRect.right)continue;break;case 1:if(elementRect.right<=activeElementRect.right)continue;if(elementRectLeft===activeElementLeft)continue;break;case 2:if(activeElementTop<=elementRectTop)continue;if(elementRect.bottom>=activeElementRect.bottom)continue;break;case 3:if(elementRect.bottom<=activeElementRect.bottom)continue;if(elementRectTop<=activeElementTop)continue}var x2=elementRectLeft+elementRectWidth-1,y2=elementRectTop+elementRectHeight-1,distX=void 0,distY=void 0;switch(direction){case 0:var intersectY=intersects(point1y,point2y,elementRectTop,y2),distX=Math.abs(point1x-Math.min(point1x,x2)),distY=intersectY?0:1+Math.min(Math.abs(point1y-y2),Math.abs(point2y-elementRectTop));break;case 1:intersectY=intersects(point1y,point2y,elementRectTop,y2);distX=Math.abs(point2x-Math.max(point2x,elementRectLeft)),distY=intersectY?0:1+Math.min(Math.abs(point1y-y2),Math.abs(point2y-elementRectTop));break;case 2:var intersectX=intersects(point1x,point2x,elementRectLeft,x2);distY=Math.abs(point1y-Math.min(point1y,y2)),distX=intersectX?0:1+Math.min(Math.abs(point1x-x2),Math.abs(point2x-elementRectLeft));break;case 3:intersectX=intersects(point1x,point2x,elementRectLeft,x2);distY=Math.abs(point2y-Math.max(point2y,elementRectTop)),distX=intersectX?0:1+Math.min(Math.abs(point1x-x2),Math.abs(point2x-elementRectLeft))}elementRectWidth=Math.sqrt(distX*distX+distY*distY);elementRectWidth<minDistance&&(nearestElement=curr,minDistance=elementRectWidth)}}}return nearestElement}function nav(activeElement,direction){var focusableContainer,nearestElement,fn,activeElementRect,container=(activeElement=(activeElement=activeElement||document.activeElement)&&focusableParent(activeElement))?function(elem,direction){return direction=focusContainerQueries[direction],elem.closest(direction)||defaultScope}(activeElement,direction):getCurrentScope();activeElement?(focusableContainer=activeElement.closest(".focusable"),fn=(fn=container.getFocusableElements)&&fn(nearestElement,activeElement,direction)||container.querySelectorAll(focusableQuery),(nearestElement=getNearestElement(activeElement,activeElementRect=getBoundingClientRect(activeElement),direction,fn,focusableContainer))&&("autofocus"===(fn=(nearestElement=activeElement&&(fn=nearestElement.closest(".focusable"))&&fn!==nearestElement&&focusableContainer!==fn?fn:nearestElement).getAttribute("data-focusabletype"))?autoFocus(nearestElement):"nearest"===fn?(activeElementRect=getNearestElement(activeElement,activeElementRect=activeElementRect||getBoundingClientRect(activeElement),direction,(fn=nearestElement.getFocusableElements)&&fn(nearestElement,activeElement,direction)||nearestElement.querySelectorAll(focusableQuery),focusableContainer))?focusInternal(activeElementRect):autoFocus(nearestElement):focusInternal(nearestElement,{}))):autoFocus(container,{findAutoFocusElement:!1})}function intersectsInternal(a1,a2,b1,b2){return a1<=b1&&b1<=a2||a1<=b2&&b2<=a2}function intersects(a1,a2,b1,b2){return intersectsInternal(a1,a2,b1,b2)||intersectsInternal(b1,b2,a1,a2)}_exports.default={autoFocus:autoFocus,focus:focus,focusableParent:focusableParent,moveLeft:function(sourceElement){nav(sourceElement,0)},moveRight:function(sourceElement){nav(sourceElement,1)},moveUp:function(sourceElement){nav(sourceElement,2)},moveDown:function(sourceElement){nav(sourceElement,3)},sendText:function(text){document.activeElement.value=text},isCurrentlyFocusable:function(elem){return!!elem.matches(focusableQuery)&&null!==elem.offsetParent},pushScope:function(elem){scopes.push(elem)},popScope:function(elem){var arr;elem=elem,-1<(elem=(arr=scopes).indexOf(elem))&&arr.splice(elem,1)},hasExclusiveFocusScope:function(){return scopes.length},getCurrentScope:getCurrentScope}});