define(["./../common/playback/playbackmanager.js","./../common/servicelocator.js","./../emby-apiclient/connectionmanager.js","./../emby-apiclient/events.js","./../common/globalize.js","./../cardbuilder/cardbuilder.js","./../common/datetime.js","./../layoutmanager.js","./../dom.js","./../common/itemhelper.js","./../shortcuts.js","./../emby-elements/emby-button/paper-icon-button-light.js","./../emby-elements/userdatabuttons/emby-ratingbutton.js","./../common/inputmanager.js","./../focusmanager.js","./../common/usersettings/usersettings.js"],function(_playbackmanager,_servicelocator,_connectionmanager,_events,_globalize,_cardbuilder,_datetime,_layoutmanager,_dom,_itemhelper,_shortcuts,_paperIconButtonLight,_embyRatingbutton,_inputmanager,_focusmanager,_usersettings){var currentPlayer,currentTimeElement,nowPlayingImageElement,nowPlayingTextElement,nowPlayingBarTVTextElement,nowPlayingBarFavoriteButton,muteButton,volumeSlider,volumeSliderContainer,playPauseButtons,positionSlider,toggleRepeatButton,remoteControlButton,stopButtonRight,isEnabled,appFooter,currentMode,currentPlayerSupportedCommands=[],lastUpdateTime=0,lastPlayerState={},currentRuntimeTicks=0,isVisibilityAllowed=!0,headerElement=document.querySelector(".skinHeader");function onSlideDownComplete(e){var elem=e.currentTarget;elem===e.target&&elem.classList.contains("nowPlayingBar-hidden")&&elem.classList.add("hide")}function onInputCommand(e){"up"===e.detail.command&&_focusmanager.default.focus(nowPlayingBarTVTextElement)}function slideUp(elem){if(!elem._visible){if(elem._visible=!0,"tv"===currentMode)return elem.classList.remove("nowPlayingBar-hidden","hide"),headerElement.classList.add("skinHeader-withnowplaying"),document.documentElement.classList.add("withheadernowplaying"),_inputmanager.default.off(headerElement,onInputCommand),void _inputmanager.default.on(headerElement,onInputCommand);elem.classList.remove("hide"),elem.offsetWidth,elem.classList.remove("nowPlayingBar-hidden")}}function onPlayPauseClick(){_playbackmanager.default.playPause(currentPlayer)}function onStopClick(){currentPlayer&&_playbackmanager.default.stop(currentPlayer)}var nowPlayingBarElement,currentImgUrl,currentItemId,dragCounter=0;function onDragEnter(e){e.dataTransfer.dropEffect="copy";e=window.CurrentDragInfo,e=e?e.item:null;e&&_playbackmanager.default.canQueue(e)&&(this.classList.add("nowPlayingBar-dragging-over"),dragCounter++)}function onDragOver(e){e.dataTransfer.dropEffect="copy";var data=window.CurrentDragInfo,data=data?data.item:null;data&&_playbackmanager.default.canQueue(data)&&e.preventDefault()}function onDragLeave(e){var data=window.CurrentDragInfo,data=data?data.item:null;data&&_playbackmanager.default.canQueue(data)&&0===--dragCounter&&this.classList.remove("nowPlayingBar-dragging-over")}function onDragEnd(e){this.classList.remove("nowPlayingBar-dragging-over")}function onItemFetchedForQueue(item){var text;_playbackmanager.default.canQueue(item)&&(_playbackmanager.default.queue({items:[item]}),text={text:_globalize.default.translate("HeaderAddedToPlayQueue"),icon:"&#xe03b;"},require(["toast"],function(toast){toast(text)}))}function onDrop(e){dragCounter=0,e.preventDefault(),this.classList.remove("nowPlayingBar-dragging-over");var apiClient,e=window.CurrentDragInfo,e=e?e.item:null;e.ServerId&&e.Id&&(apiClient=_connectionmanager.default.getApiClient(e)).getItem(apiClient.getCurrentUserId(),e.Id).then(onItemFetchedForQueue)}function showRemoteControl(){require(["appRouter"],function(appRouter){appRouter.showNowPlaying()})}function getNowPlayingBar(){return nowPlayingBarElement?Promise.resolve(nowPlayingBarElement):(currentMode=_layoutmanager.default.tv?"tv":null,require(["tv"===currentMode?"appHeader":"appFooter","css!modules/nowplayingbar/nowplayingbar.css","emby-slider"]).then(function(responses){appFooter=responses[0];responses="tv"===currentMode?headerElement:appFooter.element;if(!(nowPlayingBarElement=responses.querySelector(".nowPlayingBar"))){responses.insertAdjacentHTML("afterbegin",(className=html="",html+='<div class="nowPlayingBar hide nowPlayingBar-hidden'+(className+="tv"===currentMode?" nowPlayingBar-tv headerNowPlaying headerSection":" nowPlayingBar-footer nowPlayingBar-footer-transition")+'">',"tv"!==currentMode&&(html+='<div class="nowPlayingBarTop">'),html=(html=(html=(html=(html=(html=(html=(html=(html=(html=html+("tv"===currentMode?'<div class="nowPlayingBarPositionContainer nowPlayingBarPositionContainer-tv sliderContainer">':'<div class="nowPlayingBarPositionContainer sliderContainer">')+'<input type="range" is="emby-slider" pin step=".01" min="0" max="100" value="0" class="nowPlayingBarPositionSlider" tabindex="-1" data-hoverthumb="true" data-thumbclass="nowPlayingBarPositionSliderThumb" data-sliderbackgroundclass="nowPlayingBarPositionContainer-background" />')+"</div>"+("tv"===currentMode?'<div class="nowPlayingBarInfoContainer nowPlayingBarInfoContainer-tv">':'<div class="nowPlayingBarInfoContainer">'))+("tv"===currentMode?'<div class="nowPlayingBarImage nowPlayingBarImage-tv" loading="lazy"></div>':'<div class="nowPlayingBarImage" loading="lazy"></div>')+'<div class="nowPlayingBarText nowPlayingBar-hidetv"></div>')+'</div><button is="emby-button" type="button" class="nowPlayingBarTVText'+(className="tv"===currentMode?"":" hide")+' button-link button-link-color-inherit" tabindex="-1"></button>')+("tv"===currentMode?'<div class="nowPlayingBarCenter nowPlayingBarCenter-tv">':'<div class="nowPlayingBarCenter">')+'<button is="paper-icon-button-light" class="nowPlayingBar-hidetv previousTrackButton mediaButton md-icon">&#xE045;</button>')+'<button is="paper-icon-button-light" class="nowPlayingBar-hidetv playPauseButton mediaButton md-icon">&#xE034;</button><button is="paper-icon-button-light" class="nowPlayingBar-hidetv stopButton mediaButton md-icon">stop</button>')+'<button is="paper-icon-button-light" class="nowPlayingBar-hidetv nextTrackButton mediaButton md-icon">&#xE044;</button>'+("tv"===currentMode?'<div class="nowPlayingBarCurrentTime"></div>':'<div class="nowPlayingBarCurrentTime nowPlayingBarCurrentTime-autohide"></div>'))+'</div><div class="nowPlayingBarRight nowPlayingBar-hidetv">')+'<button is="paper-icon-button-light" class="nowPlayingBar-hidetv nowPlayingBarMuteButton muteButton mediaButton hide md-icon">&#xE050;</button><div class="sliderContainer nowPlayingBarVolumeSliderContainer hide" style="width:100px;vertical-align:middle;display:inline-flex;">')+'<input type="range" is="emby-slider" pin step="1" min="0" max="100" value="0" class="nowPlayingBarVolumeSlider" tabindex="-1" data-hoverthumb="true" /></div>',className="toggleButtonIcon",_dom.default.allowBackdropFilter()&&(className+=" toggleButtonIcon-backdropfilter"),html=(html=(html=(html+='<button is="paper-icon-button-light" class="nowPlayingBar-hidetv toggleRepeatButton toggleButton mediaButton md-icon '+className+'">&#xE040;</button>')+'<button is="emby-ratingbutton" type="button" class="nowPlayingBar-hidetv nowPlayingBarFavoriteButton listItemButton paper-icon-button-light md-icon">&#xE87D;</button><button is="paper-icon-button-light" class="nowPlayingBar-hidetv playPauseButton playPauseButton-right mediaButton md-icon">&#xE034;</button>')+'<button is="paper-icon-button-light" class="nowPlayingBar-hidetv stopButton stopButton-right mediaButton md-icon">stop</button><button is="paper-icon-button-light" class="nowPlayingBar-hidetv remoteControlButton mediaButton md-icon autortl">&#xe241;</button>')+"</div></div>",html="tv"!==currentMode?(html+='<div class="nowPlayingBarDropOverlay">')+'<h3 style="margin:0;"><i class="md-icon button-icon button-icon-left autortl" style="font-size:150%;">&#xe03b;</i>'+_globalize.default.translate("HeaderAddToPlayQueue")+"</h3></div></div>":html)),nowPlayingBarElement=responses.querySelector(".nowPlayingBar"),_shortcuts.default.on(nowPlayingBarElement);var html,className=nowPlayingBarElement;"tv"!==currentMode&&_dom.default.addEventListener(className,_dom.default.whichTransitionEvent(),onSlideDownComplete,{passive:!0}),currentTimeElement=className.querySelector(".nowPlayingBarCurrentTime"),nowPlayingImageElement=className.querySelector(".nowPlayingBarImage"),nowPlayingTextElement=className.querySelector(".nowPlayingBarText"),nowPlayingBarTVTextElement=className.querySelector(".nowPlayingBarTVText"),nowPlayingBarFavoriteButton=className.querySelector(".nowPlayingBarFavoriteButton"),(muteButton=className.querySelector(".muteButton")).addEventListener("click",function(){currentPlayer&&_playbackmanager.default.toggleMute(currentPlayer)}),stopButtonRight=className.querySelector(".stopButton-right");for(var stopButtons=className.querySelectorAll(".stopButton"),i=0,length=stopButtons.length;i<length;i++)stopButtons[i].addEventListener("click",onStopClick);for(var _i=0,_length=(playPauseButtons=className.querySelectorAll(".playPauseButton")).length;_i<_length;_i++)playPauseButtons[_i].addEventListener("click",onPlayPauseClick);className.querySelector(".nextTrackButton").addEventListener("click",function(){currentPlayer&&_playbackmanager.default.nextTrack(currentPlayer)}),className.querySelector(".previousTrackButton").addEventListener("click",function(){currentPlayer&&_playbackmanager.default.previousTrack(currentPlayer)}),(remoteControlButton=className.querySelector(".remoteControlButton")).addEventListener("click",showRemoteControl),(toggleRepeatButton=className.querySelector(".toggleRepeatButton")).addEventListener("click",function(){currentPlayer&&_playbackmanager.default.toggleRepeatMode(currentPlayer)}),volumeSlider=className.querySelector(".nowPlayingBarVolumeSlider"),volumeSliderContainer=className.querySelector(".nowPlayingBarVolumeSliderContainer"),volumeSlider.addEventListener("change",function(){currentPlayer&&currentPlayer.setVolume(this.value)}),(positionSlider=className.querySelector(".nowPlayingBarPositionSlider")).addEventListener("change",function(){var newPercent;currentPlayer&&(newPercent=parseFloat(this.value),_playbackmanager.default.seekPercent(newPercent,currentPlayer))}),positionSlider.getBubbleText=function(value){if(!lastPlayerState||!lastPlayerState.NowPlayingItem||!currentRuntimeTicks)return"--:--";var ticks=currentRuntimeTicks;return _datetime.default.getDisplayRunningTime(ticks/100*value)},className.addEventListener("click",function(e){e.target.closest("BUTTON:not(.nowPlayingBarTVText),INPUT,A")||showRemoteControl()}),className.addEventListener("dragover",onDragOver),className.addEventListener("dragend",onDragEnd),className.addEventListener("dragenter",onDragEnter),className.addEventListener("dragleave",onDragLeave),className.addEventListener("drop",onDrop)}return Promise.resolve(nowPlayingBarElement)}))}function updatePlayPauseState(isPaused){var i,length;if(playPauseButtons)if(isPaused)for(i=0,length=playPauseButtons.length;i<length;i++)playPauseButtons[i].innerHTML="&#xE037;";else for(i=0,length=playPauseButtons.length;i<length;i++)playPauseButtons[i].innerHTML="&#xE034;"}function updatePlayerStateInternal(event,state,player){isVisibilityAllowed?("tv"!==currentMode&&appFooter&&appFooter.setWithContent(!0),getNowPlayingBar().then(slideUp)):hideNowPlayingBar(),lastPlayerState=state;var playerInfo=_playbackmanager.default.getPlayerInfo(player),playState=state.PlayState||{},playerInfo=(updatePlayPauseState(playState.IsPaused),playerInfo.supportedCommands||[]),nowPlayingItem=(currentPlayerSupportedCommands=playerInfo,state.NowPlayingItem||{});!playerInfo.includes("SetRepeatMode")||player.isLocalPlayer&&"Video"===nowPlayingItem.MediaType?toggleRepeatButton.classList.add("hide"):toggleRepeatButton.classList.remove("hide"),player.isLocalPlayer&&"Video"===nowPlayingItem.MediaType?(remoteControlButton.innerHTML="&#xe5d0;",stopButtonRight.classList.remove("hide")):(remoteControlButton.innerHTML="&#xe241;",stopButtonRight.classList.add("hide")),updateRepeatModeDisplay(playState.RepeatMode),updatePlayerVolumeState(playState.IsMuted,playState.VolumeLevel),positionSlider&&!positionSlider.dragging&&(positionSlider.disabled=!playState.CanSeek||"tv"===currentMode,playerInfo=state.MediaSource&&null==state.MediaSource.RunTimeTicks,positionSlider.setIsClear(playerInfo)),updateTimeDisplay(playState.PositionTicks,nowPlayingItem.RunTimeTicks,_playbackmanager.default.getBufferedRanges(player)),function(state){var state=state.NowPlayingItem,textLines=state?getNowPlayingNames(state,null,!0):[],textLines=(nowPlayingTextElement.innerHTML=textLines.join(""),nowPlayingBarTVTextElement.innerHTML=(state?getNowPlayingNames(state):[]).join(" - "),state?function(item,options){if(!item)throw new Error("item cannot be null!");if("Episode"===item.Type){if((options=options||{}).type=options.type||"Primary","Primary"===options.type&&item.SeriesPrimaryImageTag)return options.tag=item.SeriesPrimaryImageTag,{url:_connectionmanager.default.getApiClient(item).getImageUrl(item.SeriesId,options),aspect:"2/3"};if("Thumb"===options.type&&item.ParentThumbImageTag)return options.tag=item.ParentThumbImageTag,{url:_connectionmanager.default.getApiClient(item).getImageUrl(item.ParentThumbItemId,options),aspect:"16/9"}}return null}(state,{height:70})||function(item,options){if(!item)throw new Error("item cannot be null!");if((options=options||{}).type=options.type||"Primary",item.ImageTags&&item.ImageTags[options.type])return options.tag=item.ImageTags[options.type],{url:_connectionmanager.default.getApiClient(item).getImageUrl(item.PrimaryImageItemId||item.Id,options),aspect:item.PrimaryImageAspectRatio?item.PrimaryImageAspectRatio.toString():"1"};if(item.AlbumId&&item.AlbumPrimaryImageTag)return options.tag=item.AlbumPrimaryImageTag,{url:_connectionmanager.default.getApiClient(item).getImageUrl(item.AlbumId,options),aspect:"1"};return null}(state,{height:70}):null),url=textLines?textLines.url:null;url!==currentImgUrl&&((currentImgUrl=url)?(nowPlayingImageElement.style["aspect-ratio"]=textLines.aspect,nowPlayingImageElement.style.backgroundImage="url('"+url+"')",nowPlayingImageElement.classList.remove("defaultCardBackground","defaultCardBackground0"),nowPlayingImageElement.innerHTML=""):(nowPlayingImageElement.style.backgroundImage="",nowPlayingImageElement.style["aspect-ratio"]="1",nowPlayingImageElement.classList.add("defaultCardBackground","defaultCardBackground0"),nowPlayingImageElement.innerHTML='<i class="md-icon nowPlayingBarDefaultItemIcon autortl">'+_cardbuilder.default.getDefaultIcon(state)+"</i>"));state.Id?currentItemId!==state.Id&&(currentItemId=state.Id,(textLines=_connectionmanager.default.getApiClient(state.ServerId)).getItem(textLines.getCurrentUserId(),state.Id).then(function(item){nowPlayingBarFavoriteButton.setItem(item),nowPlayingBarFavoriteButton.classList.remove("hide")})):(currentItemId=null,nowPlayingBarFavoriteButton.classList.add("hide"),nowPlayingBarFavoriteButton.setItem(null))}(state)}function updateRepeatModeDisplay(repeatMode){var icon=toggleRepeatButton,btnRepeatMode=toggleRepeatButton;"RepeatAll"===repeatMode?(icon.innerHTML="&#xE040;",icon.classList.add("toggleButtonIcon-active"),btnRepeatMode.classList.add("toggleButton-active")):"RepeatOne"===repeatMode?(icon.innerHTML="&#xE041;",icon.classList.add("toggleButtonIcon-active"),btnRepeatMode.classList.add("toggleButton-active")):(icon.innerHTML="&#xE040;",icon.classList.remove("toggleButtonIcon-active"),btnRepeatMode.classList.remove("toggleButton-active"))}function updateTimeDisplay(positionTicks,runtimeTicks,bufferedRanges){var pct;positionSlider&&!positionSlider.dragging&&(runtimeTicks?(pct=positionTicks/runtimeTicks,positionSlider.setValue(pct*=100)):positionSlider.setValue(0)),positionSlider&&!runtimeTicks&&positionSlider.setBufferedRanges(bufferedRanges,runtimeTicks,positionTicks),currentTimeElement&&(pct=null==positionTicks?"--:--":_datetime.default.getDisplayRunningTime(positionTicks),runtimeTicks&&(pct+=" / "+_datetime.default.getDisplayRunningTime(runtimeTicks)),currentTimeElement.innerHTML=pct)}function updatePlayerVolumeState(isMuted,volumeLevel){var supportedCommands=currentPlayerSupportedCommands,showMuteButton=!0,showVolumeSlider=!0;-1===supportedCommands.indexOf("ToggleMute")&&(showMuteButton=!1),muteButton.innerHTML=isMuted?"&#xE04F;":"&#xE050;",-1===supportedCommands.indexOf("SetVolume")&&(showVolumeSlider=!1),showMuteButton?muteButton.classList.remove("hide"):muteButton.classList.add("hide"),volumeSlider&&(showVolumeSlider?volumeSliderContainer.classList.remove("hide"):volumeSliderContainer.classList.add("hide"),volumeSlider.dragging||volumeSlider.setValue(volumeLevel||0))}function getTextActionButton(item,text,serverId,enableButton){if(text=text||_itemhelper.default.getDisplayName(item),!enableButton)return text;enableButton="<button "+_shortcuts.default.getShortcutAttributesHtml(item,{serverId:serverId})+' type="button" class="itemAction button-link button-inherit-color" data-action="link" is="emby-button">';return enableButton+text+"</button>"}function getNowPlayingNames(nowPlayingItem,includeNonNameInfo,enableTextLinks){var topText=nowPlayingItem.Name,bottomText=("Video"===nowPlayingItem.MediaType&&(topText=_itemhelper.default.getDisplayName(nowPlayingItem,{})),nowPlayingItem.AlbumId&&"Audio"===nowPlayingItem.MediaType&&(topText=getTextActionButton({Id:nowPlayingItem.AlbumId,Name:nowPlayingItem.Album,Type:"MusicAlbum",IsFolder:!0,ServerId:nowPlayingItem.ServerId},topText,null,enableTextLinks)),""),includeNonNameInfo=(nowPlayingItem.ArtistItems&&nowPlayingItem.ArtistItems.length?bottomText=nowPlayingItem.ArtistItems.map(function(a){return getTextActionButton({Id:a.Id,Name:a.Name,Type:"MusicArtist",IsFolder:!0,ServerId:nowPlayingItem.ServerId},null,null,enableTextLinks)}).join(", "):nowPlayingItem.SeriesName||nowPlayingItem.Album?(bottomText=topText,topText=nowPlayingItem.SeriesName||nowPlayingItem.Album,nowPlayingItem.SeriesId&&(topText=getTextActionButton({Id:nowPlayingItem.SeriesId,Name:nowPlayingItem.SeriesName,Type:"Series",IsFolder:!0,ServerId:nowPlayingItem.ServerId},topText,null,enableTextLinks))):nowPlayingItem.ProductionYear&&!1!==includeNonNameInfo&&(bottomText=nowPlayingItem.ProductionYear),[]);return enableTextLinks?(includeNonNameInfo.push("<div>"+topText+"</div>"),bottomText&&includeNonNameInfo.push('<div class="secondaryText">'+bottomText+"</div>")):(includeNonNameInfo.push('<div class="nowPlayingBarTVText-element">'+topText+"</div>"),bottomText&&includeNonNameInfo.push('<div class="nowPlayingBarTVText-element">'+bottomText+"</div>")),includeNonNameInfo}function onPlaybackStart(e,state){onStateChanged.call(this,e,state)}function onRepeatModeChange(e){isEnabled&&updateRepeatModeDisplay(_playbackmanager.default.getRepeatMode(this))}function hideNowPlayingBar(){isEnabled=!1,nowPlayingBarElement&&function(elem){if(elem._visible){if(elem._visible=!1,"tv"===currentMode)return _inputmanager.default.off(headerElement,onInputCommand),elem.classList.add("nowPlayingBar-hidden","hide"),headerElement.classList.remove("skinHeader-withnowplaying"),document.documentElement.classList.remove("withheadernowplaying");elem.classList.remove("nowPlayingBar-footer-transition"),elem.offsetWidth,elem.classList.add("nowPlayingBar-footer-transition"),elem.offsetWidth,elem.classList.add("nowPlayingBar-hidden")}}(nowPlayingBarElement),"tv"!==currentMode&&appFooter&&appFooter.setWithContent(!1)}function onPlaybackStopped(e,state){this.isLocalPlayer?"Audio"!==state.NextMediaType&&"Video"!==state.NextMediaType&&hideNowPlayingBar():state.NextMediaType||hideNowPlayingBar()}function onPlayPauseStateChanged(e){isEnabled&&updatePlayPauseState(this.paused())}function onStateChanged(event,state){var player=this;if(state.IsBackgroundPlayback)hideNowPlayingBar();else if(state.NowPlayingItem){if(player.isLocalPlayer&&state.NowPlayingItem){if("Video"===state.NowPlayingItem.MediaType)if(!_usersettings.default.enableVideoUnderUI())return void hideNowPlayingBar();if("Audio"!==state.NowPlayingItem.MediaType&&"Video"!==state.NowPlayingItem.MediaType)return void hideNowPlayingBar()}isEnabled=!0,nowPlayingBarElement?updatePlayerStateInternal(0,state,player):getNowPlayingBar().then(function(){updatePlayerStateInternal(0,state,player)})}else hideNowPlayingBar()}function onTimeUpdate(e){var now;!isEnabled||(now=Date.now())-lastUpdateTime<700||(lastUpdateTime=now,currentRuntimeTicks=_playbackmanager.default.duration(this),updateTimeDisplay(_playbackmanager.default.currentTime(this),currentRuntimeTicks,_playbackmanager.default.getBufferedRanges(this)))}function onVolumeChanged(e){isEnabled&&updatePlayerVolumeState(this.isMuted(),this.getVolume())}function refreshFromPlayer(player){var state=_playbackmanager.default.getPlayerState(player);onStateChanged.call(player,{type:"init"},state)}function bindToPlayer(player){player!==currentPlayer&&(!function(){var player=currentPlayer;player&&(_events.default.off(player,"playbackstart",onPlaybackStart),_events.default.off(player,"statechange",onPlaybackStart),_events.default.off(player,"repeatmodechange",onRepeatModeChange),_events.default.off(player,"playbackstop",onPlaybackStopped),_events.default.off(player,"volumechange",onVolumeChanged),_events.default.off(player,"pause",onPlayPauseStateChanged),_events.default.off(player,"unpause",onPlayPauseStateChanged),_events.default.off(player,"timeupdate",onTimeUpdate),currentPlayer=null,hideNowPlayingBar())}(),(currentPlayer=player)&&(refreshFromPlayer(player),_events.default.on(player,"playbackstart",onPlaybackStart),_events.default.on(player,"statechange",onPlaybackStart),_events.default.on(player,"repeatmodechange",onRepeatModeChange),_events.default.on(player,"playbackstop",onPlaybackStopped),_events.default.on(player,"volumechange",onVolumeChanged),_events.default.on(player,"pause",onPlayPauseStateChanged),_events.default.on(player,"unpause",onPlayPauseStateChanged),_events.default.on(player,"timeupdate",onTimeUpdate)))}_events.default.on(_playbackmanager.default,"playerchange",function(e,player){bindToPlayer(player)}),bindToPlayer(_playbackmanager.default.getCurrentPlayer()),document.addEventListener("viewbeforeshow",function(e){!function(e){return!1!==e.detail.enableMediaControl&&!("tv"===currentMode&&!e.detail.enableMediaControlTV)}(e)?isVisibilityAllowed&&(isVisibilityAllowed=!1,hideNowPlayingBar()):isVisibilityAllowed||(isVisibilityAllowed=!0,currentPlayer?refreshFromPlayer(currentPlayer):hideNowPlayingBar())})});