define(["./../dom.js"],function(_dom){function DataTransfer(){this.dropEffect="move",this.effectAllowed="all",this._data={}}function DragDropTouch(){if(this._lastClick=0,DragDropTouch._instance)throw"DragDropTouch instance already created.";"ontouchstart"in document&&(this._boundTouchMove=this._touchmove.bind(this),this._boundTouchEnd=this._touchend.bind(this),this._boundContextMenu=this._contextMenu.bind(this),_dom.default.addEventListener(document,"touchstart",this._touchstart.bind(this),{passive:!0}),this._boundOnPressHoldTimeoutFired=this.onPressHoldTimeoutFired.bind(this))}Object.defineProperty(DataTransfer.prototype,"types",{get:function(){return Object.keys(this._data)},enumerable:!0,configurable:!0}),DataTransfer.prototype.clearData=function(type){null!=type?delete this._data[type]:this._data=null},DataTransfer.prototype.getData=function(type){return this._data[type]||""},DataTransfer.prototype.setData=function(type,value){this._data[type]=value},DataTransfer.prototype.setDragImage=function(img,offsetX,offsetY){var ddt=DragDropTouch._instance;ddt._imgCustom=img,ddt._imgOffset={x:offsetX,y:offsetY}},DragDropTouch.prototype.addAdditionalEventListeners=function(dragSource){_dom.default.addEventListener(document,"touchmove",this._boundTouchMove,{passive:!1,capture:!1}),_dom.default.addEventListener(dragSource,"touchend",this._boundTouchEnd,{passive:!0}),_dom.default.addEventListener(dragSource,"touchcancel",this._boundTouchEnd,{passive:!0}),_dom.default.addEventListener(dragSource,"contextmenu",this._boundContextMenu,{passive:!0})},DragDropTouch.prototype.removeAdditionalEventListeners=function(dragSource){_dom.default.removeEventListener(document,"touchmove",this._boundTouchMove,{passive:!1,capture:!1}),(dragSource=dragSource||this._dragSource)&&(_dom.default.removeEventListener(dragSource,"touchend",this._boundTouchEnd,{passive:!0}),_dom.default.removeEventListener(dragSource,"touchcancel",this._boundTouchEnd,{passive:!0}),_dom.default.removeEventListener(dragSource,"contextmenu",this._boundContextMenu,{passive:!0}))},DragDropTouch.prototype.onPressHoldTimeoutFired=function(){this._isDragEnabled=!0;var scrollingElement=this._dragSource.closest(".scrollY");scrollingElement&&scrollingElement.classList.add("drag-preventScrollY")},DragDropTouch.prototype._contextMenu=function(e){this.removeAdditionalEventListeners(e.currentTarget),this._destroyImage(),this._reset()},DragDropTouch.prototype._touchstart=function(e){var target,src;this._shouldHandle(e)&&(this._reset(),(src=(target=e.target).closest('[draggable="true"]'))&&(this.addAdditionalEventListeners(src),this._dragSource=src,this._ptDown=this._getPoint(e),this._lastTouch=e,src=target.classList.contains("dragHandle")?100:DragDropTouch._PRESSHOLDAWAIT,this._pressHoldInterval=setTimeout(this._boundOnPressHoldTimeoutFired,src)))},DragDropTouch.prototype._touchmove=function(e){var dragEnabled=this._isDragEnabled;!dragEnabled&&this._getDelta(e)>DragDropTouch._PRESSHOLDMARGIN?this._reset():dragEnabled&&e&&e.touches&&e.touches.length&&(dragEnabled=this._getTarget(e),this._dragSource&&!this._img&&this._shouldStartDragging(e)&&(this._dispatchEvent(e,"dragstart",this._dragSource),this._createImage(e),this._dispatchEvent(e,"dragenter",dragEnabled)),this._img&&(!1!==(this._lastTouch=e).cancelable&&e.preventDefault(),dragEnabled!==this._lastTarget&&(this._dispatchEvent(this._lastTouch,"dragleave",this._lastTarget),this._dispatchEvent(e,"dragenter",dragEnabled),this._lastTarget=dragEnabled),this._moveImage(e),this._isDropZone=this._dispatchEvent(e,"dragover",dragEnabled)))},DragDropTouch.prototype._touchend=function(e){this.removeAdditionalEventListeners(e.currentTarget),this._destroyImage(),this._shouldHandle(e)&&this._dragSource&&(e.type.indexOf("cancel")<0&&this._isDropZone&&this._dispatchEvent(this._lastTouch,"drop",this._lastTarget),this._dispatchEvent(this._lastTouch,"dragend",this._dragSource)),this._reset()},DragDropTouch.prototype._shouldHandle=function(e){return e&&!e.defaultPrevented&&e.touches&&e.touches.length<2},DragDropTouch.prototype._shouldStartDragging=function(e){e=this._getDelta(e);return DragDropTouch._PRESSHOLDTHRESHOLD<e},DragDropTouch.prototype._reset=function(){var dragSource=this._dragSource;dragSource&&(this.removeAdditionalEventListeners(dragSource),(dragSource=dragSource.closest(".scrollY"))&&dragSource.classList.remove("drag-preventScrollY")),this._destroyImage(),this._dragSource=null,this._lastTouch=null,this._lastTarget=null,this._ptDown=null,this._isDragEnabled=!1,this._isDropZone=!1,this._dataTransfer=new DataTransfer,clearInterval(this._pressHoldInterval)},DragDropTouch.prototype._getPoint=function(e,page){return e&&e.touches&&(e=e.touches[0]),{x:page?e.pageX:e.clientX,y:page?e.pageY:e.clientY}},DragDropTouch.prototype._getDelta=function(e){if(!this._ptDown)return 0;e=this._getPoint(e);return Math.abs(e.x-this._ptDown.x)+Math.abs(e.y-this._ptDown.y)},DragDropTouch.prototype._getTarget=function(e){for(var e=this._getPoint(e),el=document.elementFromPoint(e.x,e.y);el&&"none"===getComputedStyle(el).pointerEvents;)el=el.parentElement;return el},DragDropTouch.prototype._createImage=function(e){this._img&&this._destroyImage();var pt,src=this._imgCustom||this._dragSource;this._img=src.cloneNode(!0),this._copyStyle(src,this._img),this._img.style.top=this._img.style.left="-9999px",this._imgCustom||(src=src.getBoundingClientRect(),pt=this._getPoint(e),this._imgOffset={x:pt.x-src.left,y:pt.y-src.top},this._img.style.opacity=DragDropTouch._OPACITY.toString()),this._moveImage(e),document.body.appendChild(this._img)},DragDropTouch.prototype._destroyImage=function(){var parentElement,img=this._img;img&&(parentElement=img.parentElement)&&parentElement.removeChild(img),this._img=null,this._imgCustom=null},DragDropTouch.prototype._moveImage=function(e){var _this=this;requestAnimationFrame(function(){var pt,s;_this._img&&(pt=_this._getPoint(e,!0),(s=_this._img.style).position="absolute",s.pointerEvents="none",s.zIndex="999999",s.left=Math.round(pt.x-_this._imgOffset.x)+"px",s.top=Math.round(pt.y-_this._imgOffset.y)+"px")})},DragDropTouch.prototype._copyProps=function(dst,src,props){for(var i=0;i<props.length;i++){var p=props[i];dst[p]=src[p]}},DragDropTouch.prototype._copyStyle=function(src,dst){DragDropTouch._rmvAtts.forEach(function(att){dst.removeAttribute(att)}),src instanceof HTMLCanvasElement&&((cDst=dst).width=(cSrc=src).width,cDst.height=cSrc.height,cDst.getContext("2d").drawImage(cSrc,0,0));for(var cSrc,cDst,cs=getComputedStyle(src),i=0;i<cs.length;i++){var key=cs[i];key.indexOf("transition")<0&&(dst.style[key]=cs[key])}for(dst.style.pointerEvents="none",i=0;i<src.children.length;i++)this._copyStyle(src.children[i],dst.children[i]);dst.style.transform="none",dst.style.translate="none",dst.style.scale="none"},DragDropTouch.prototype._dispatchEvent=function(e,type,target){var evt,t;return!(!e||!target)&&(evt=document.createEvent("Event"),t=e.touches?e.touches[0]:e,evt.initEvent(type,!0,!0),evt.button=0,evt.which=evt.buttons=1,this._copyProps(evt,e,DragDropTouch._kbdProps),this._copyProps(evt,t,DragDropTouch._ptProps),evt.dataTransfer=this._dataTransfer,target.dispatchEvent(evt),evt.defaultPrevented)},DragDropTouch._instance=new DragDropTouch,DragDropTouch._THRESHOLD=5,DragDropTouch._OPACITY=.9,DragDropTouch._PRESSHOLDAWAIT=400,DragDropTouch._PRESSHOLDMARGIN=25,DragDropTouch._PRESSHOLDTHRESHOLD=5,DragDropTouch._rmvAtts="id,class,style,draggable".split(","),DragDropTouch._kbdProps="altKey,ctrlKey,metaKey,shiftKey".split(","),DragDropTouch._ptProps="pageX,pageY,clientX,clientY,screenX,screenY".split(",")});