define(["exports","./../layoutmanager.js","./../browser.js","./../dom.js","./../focusmanager.js"],function(_exports,_layoutmanager,_browser,_dom,_focusmanager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,require(["scrollStyles"]);var preventScrollSupported=function(){var supported=!1;try{var focusOptions={};Object.defineProperty(focusOptions,"preventScroll",{get:function(){return supported=!0},enumerable:!0,configurable:!0}),document.createElement("div").focus(focusOptions)}catch(err){console.log("error testing preventScroll support: "+err)}return supported}(),allowAnimatedScroll=function(){if(!CSS.supports("transform","scale(1)"))return!1;var cores=navigator.hardwareConcurrency||4;return!(cores<4)&&(!((2400<=(screen.width||screen.availWidth||0)||1400<=(screen.height||screen.availHeight||0))&&cores<6)&&(!((navigator.deviceMemory||0)<2)&&(!!_dom.default.supportsEventListenerOnce()&&(!!document.documentElement.animate&&!_browser.default.web0s))))}();function within(number,start,end){var min=start<end?start:end,start=end<start?start:end;return number<min?min:start<number?start:number}function onFrameClick(e){1===e.which&&(e=_focusmanager.default.focusableParent(e.target))&&e!==document.activeElement&&_focusmanager.default.focus(e,{preventScroll:!0})}function resetScrollTop(){this.scrollTop=0}var wheelEvent=document.implementation.hasFeature("Event.wheel","3.0")?"wheel":"mousewheel",interactiveElements=["INPUT","SELECT","TEXTAREA"],abs=Math.abs,round=Math.round;var isSmoothScrollSupported="scrollBehavior"in document.documentElement.style;function Scroller(frame,options){var options=Object.assign({},{slidee:null,horizontal:!1,mouseWheel:!0,scrollBy:100,dragSource:null,dragThreshold:3,speed:0},options),slideeElement=(options.forceNativeScroll||isSmoothScrollSupported&&(_browser.default.firefox&&!_layoutmanager.default.tv||!1!==options.allowNativeSmoothScroll)?options.enableNativeScroll=!0:options.forceSmoothScroll?options.enableNativeScroll=!1:_layoutmanager.default.tv&&allowAnimatedScroll||(options.enableNativeScroll=!0),options.inlineMultiplier="rtl"===document.dir?-1:1,(this.options=options).slidee),slideeElement=(this.listenerCount=0,this._pos={start:0,center:0,end:0,scrollLeft:0,scrollTop:0},this.dragSourceElement=options.dragSource||frame,this.currentDelta=0,this.initialized=0,this.slideeElement=slideeElement,this.options=options,this.dragging={},this.contentRects=[],this.resizeListeners=[],frame);this.nativeScrollElement=slideeElement,this.frame=frame,this.requiresReflow=!0,this.frameSize={width:0,height:0},this.slideeSize={width:0,height:0},this.onSourceClickFn=function(event){var dragging=this.dragging;!dragging.locked&&0<Math.abs(dragging.delta)&&(dragging.locked=1,event.preventDefault(),event.stopPropagation(),(event.currentTarget||event.target).removeEventListener(event.type,this.onSourceClickFn))}.bind(this),this.onScrollForCachingFn=function(e){this._cachedScrollTop=null,this._cachedScrollLeft=null}.bind(this)}function onResize(entries){var contentRects=this.contentRects,hasResize=!1;this._cachedScrollTop=null,this._cachedScrollLeft=null,this._cachedScrollHeight=null,this._cachedScrollWidth=null,this._frameRect=null;for(var i=0,length=entries.length;i<length;i++){var entry=entries[i];if(entry){var newRect=entry.contentRect;if(0!==newRect.width&&0!==newRect.height){entry=contentRects?function(contentRects,target){for(var i=0,length=contentRects.length;i<length;i++){var _rect=contentRects[i];if(_rect.target===target)return _rect}var rect={target:target};return contentRects.push(rect),rect}(contentRects,entry.target):null;if(entry&&(newRect.width!==entry.width||newRect.height!==entry.height)){entry.width=newRect.width,entry.height=newRect.height,hasResize=!0;break}}}}hasResize&&(this.options.enableNativeScroll?this.requiresReflow=!0:load(this,!1));var listeners=this.resizeListeners;if(listeners)for(var _i=0,_length=listeners.length;_i<_length;_i++)listeners[_i](entries)}function load(instance,isInit){instance.requiresReflow=!0,isInit||(instance.ensureSizeInfo(),instance.options.enableNativeScroll||(isInit=instance._pos,isInit=within(instance.getScrollPosition(),isInit.start,isInit.end),instance.scrollToPosition({position:isInit})),instance.requiresReflow=!0)}function onDragEnd(instance){var dragging=instance.dragging,dragHandler=(dragging.released=!0,instance.dragHandler);dragHandler&&(_dom.default.removeEventListener(document,"pointermove",dragHandler,{passive:!0}),_dom.default.removeEventListener(document,"pointerup",dragHandler,{passive:!0})),setTimeout(function(){dragging.source.removeEventListener("click",instance.onSourceClickFn)}),dragging.init=0}function dragHandler(event){var dragging=this.dragging,options=this.options,released="pointerup"===event.type,touches=getTouches(event),touches=touches&&touches.length?touches[0]:event,pathX=touches.clientX-dragging.initX,touches=touches.clientY-dragging.initY,horizontal=options.horizontal,absDelta=(dragging.delta=horizontal?pathX:touches,Math.abs(dragging.delta));if(released||!(absDelta<1)){if(!dragging.init){if(absDelta<options.dragThreshold)return released?onDragEnd(this):void 0;if(!(horizontal?abs(pathX)>abs(touches):abs(pathX)<abs(touches)))return onDragEnd(this);dragging.init=1}event.preventDefault();options=dragging.initPos-dragging.delta,pathX=event.timeStamp,touches=pathX-dragging.startTime;released?(onDragEnd(this),touches<200&&absDelta<=0||(event=function(current,start,time,deceleration){var start=current-start,duration=(time=Math.abs(start)/time)/(deceleration=void 0===deceleration?6e-4:deceleration);return{destination:Math.round(current+time/(2*deceleration)*(start<0?-1:1)),duration:duration}}(options,dragging.momentumPos,touches,void(this.getScrollSize(),getFrameSize(this,horizontal))),options=Math.max(0,event.destination))):300<touches&&(dragging.startTime=pathX,dragging.momentumPos=options),this.scrollToPosition({behavior:released?"smooth":"instant",position:options})}}function getFrameSize(instance,horizontal){null==horizontal&&(horizontal=instance.options.horizontal);instance=instance.frameSize;return horizontal?instance.width:instance.height}function getTouches(e){return e.changedTouches||e.targetTouches||e.touches}function onDragStart(event){var options,touches,dragging=this.dragging;dragging.init||function(element){for(;element;){if(interactiveElements.includes(element.tagName))return 1;element=element.parentNode}}(event.target)||(options=this.options,event.preventDefault(),dragging.init=0,dragging.startTime=event.timeStamp,dragging.source=event.target,touches=(touches=getTouches(event))&&touches.length?touches[0]:event,dragging.initX=touches.clientX,dragging.initY=touches.clientY,dragging.momentumPos=dragging.initPos=this.getScrollPosition(),dragging.delta=0,dragging.locked=0,dragging.source.addEventListener("click",this.onSourceClickFn),options.enableNativeScroll||(event=this.dragHandler,_dom.default.addEventListener(document,"pointermove",event,{}),_dom.default.addEventListener(document,"pointerup",event,{})))}function addFrameResizeObserver(instance){instance.frameResizeObserver||(instance.frameResizeObserver=new ResizeObserver(onResize.bind(instance),{}),instance.options.enableNativeScroll?instance.frameResizeObserver.observe(instance.nativeScrollElement):(instance.options.dynamicFrameSizing&&instance.frameResizeObserver.observe(instance.slideeElement),instance.frameResizeObserver.observe(instance.frame)))}function scrollNative(instance,pos){var elem=instance.nativeScrollElement;return elem.scroll?elem.scroll(pos):elem.scrollTo&&"instant"!==pos.behavior?elem.scrollTo(Math.round(pos.left||0),Math.round(pos.top||0)):(null!=pos.left&&(elem.scrollLeft=Math.round(pos.left)),null!=pos.top&&(elem.scrollTop=Math.round(pos.top))),instance._cachedScrollLeft=null,instance._cachedScrollTop=null,!1===pos.useDelayedPromise?Promise.resolve():isSmoothScrollSupported&&"instant"!==pos.behavior?setTimeoutPromise(100):setTimeoutPromise(0)}Scroller.prototype.init=function(){var options,frame,slideeElement,nativeScrollElement;if(!this.initialized)return options=this.options,frame=this.frame,slideeElement=this.slideeElement,options.enableNativeScroll?(nativeScrollElement=this.nativeScrollElement,options.horizontal?(nativeScrollElement.classList.add("scrollX"),!1!==options.hideScrollbar&&nativeScrollElement.classList.add("hiddenScrollX"),_layoutmanager.default.tv&&!1!==options.allowNativeSmoothScroll&&nativeScrollElement.classList.add("smoothScrollX")):(nativeScrollElement.classList.add("scrollY"),options.hideScrollbar&&nativeScrollElement.classList.add("hiddenScrollY"),_layoutmanager.default.tv&&!1!==options.allowNativeSmoothScroll&&nativeScrollElement.classList.add("smoothScrollY"),options.forceScrollbar&&nativeScrollElement.classList.add("overflowYScroll"))):frame.style.overflow="hidden",options.horizontal?(frame.classList.add("scrollFrameX"),slideeElement.classList.add("scrollSliderX")):(slideeElement.classList.add("scrollSliderY"),frame.classList.add("scrollFrameY")),nativeScrollElement=onDragStart.bind(this),this.dragStartHandler=nativeScrollElement,slideeElement=function(event){this.ensureSizeInfo();this._pos;var options=this.options,scrollBy=options.scrollBy;scrollBy&&(event=function(event,instance){var options=instance.options;return instance.currentDelta=(options.horizontal?event.deltaY||event.deltaX:event.deltaY)||-event.wheelDelta,options.enableNativeScroll||(instance.currentDelta/=1===event.deltaMode?3:100),instance.currentDelta}(event,this),options.enableNativeScroll?(isSmoothScrollSupported&&(event*=12),this.scrollBy(event)):this.scrollBy(scrollBy*event))}.bind(this),this.scrollHandler=slideeElement,options.enableNativeScroll&&_layoutmanager.default.tv&&options.focusScroll&&_dom.default.addEventListener(this.dragSourceElement,"mousedown",nativeScrollElement,{}),options.enableNativeScroll&&!_layoutmanager.default.tv||addFrameResizeObserver(this),options.enableNativeScroll?options.horizontal&&options.mouseWheel&&_dom.default.addEventListener(frame,wheelEvent,slideeElement,{passive:!0}):(this.dragSourceElement.style["touch-action"]="none",window.PointerEvent?_dom.default.addEventListener(this.dragSourceElement,"pointerdown",nativeScrollElement,{}):(_dom.default.addEventListener(this.dragSourceElement,"touchstart",nativeScrollElement,{}),_dom.default.addEventListener(this.dragSourceElement,"mousedown",nativeScrollElement,{})),options.mouseWheel&&_dom.default.addEventListener(frame,wheelEvent,slideeElement,{passive:!0})),_layoutmanager.default.tv&&(_dom.default.addEventListener(frame,"click",onFrameClick,{passive:!0,capture:!0}),options.focusScroll&&(nativeScrollElement=this.focusHandler=function(e){e=e.target,(e=_focusmanager.default.focusableParent(e))&&this.to(this.options.focusScroll,e,{useDelayedPromise:!1,offset:this.options.focusScrollOffset})}.bind(this),_dom.default.addEventListener(frame,"focus",nativeScrollElement,{capture:!0,passive:!0}))),this.dragHandler=dragHandler.bind(this),this.initialized=1,load(this,!0),this};var SupportsTranslateProperty=CSS.supports("translate","40px 100px"),TranslateProperty=SupportsTranslateProperty?"translate":"transform";function setTimeoutPromise(delay){return new Promise(function(resolve,reject){setTimeout(resolve,delay)})}function renderAnimateWithTransform(instance,scrollOptions,horizontal,immediate,useDelayedPromise){var options=instance.options,speed=options.speed,immediate=(immediate&&(speed=0),scrollOptions.left),top=scrollOptions.top,immediate=(null==immediate&&(immediate=instance.getScrollLeft()),null==top&&(top=instance.getScrollTop()),function(left,top){return left||top?SupportsTranslateProperty?left+"px "+top+"px":"translate("+left+"px, "+top+"px)":"none"}(-round(immediate),-round(top),options.horizontal)),top=instance.slideeElement,options=instance._lastTransitionValue,top=top.style,newTransitionValue=TranslateProperty+" "+speed+"ms ease-out";return newTransitionValue!==options&&(top.transition=newTransitionValue,instance._lastTransitionValue=newTransitionValue),function(style,value){requestAnimationFrame(function(){style[TranslateProperty]=value})}(top,immediate),null!=scrollOptions.left&&(instance._pos.scrollLeft=scrollOptions.left),null!=scrollOptions.top&&(instance._pos.scrollTop=scrollOptions.top),function(instance){instance.options.dispatchScrollEvent&&instance.frame.dispatchEvent(new CustomEvent(instance.getScrollEventName(),{bubbles:!0,cancelable:!1}))}(instance),!1===useDelayedPromise?Promise.resolve():setTimeoutPromise(speed)}var EmptyScrollOptions={};function parsePxToInt(value){return value.endsWith("px")?(value=value.substring(0,value.length-2),parseInt(value)):0}Scroller.prototype.slideTo=function(scrollOptions,fullItemPos){this.ensureSizeInfo();var pos=this._pos,options=this.options,horizontal=options.horizontal,immediate=(options.enableNativeScroll||(horizontal?null!=scrollOptions.left&&(scrollOptions.left=within(scrollOptions.left,pos.start,pos.end)):null!=scrollOptions.top&&(scrollOptions.top=within(scrollOptions.top,pos.start,pos.end))),"instant"===(scrollOptions=scrollOptions||EmptyScrollOptions).behavior);if(options.skipSlideToWhenVisible||scrollOptions.skipWhenVisible)if(fullItemPos){if(fullItemPos.isVisible)return Promise.resolve()}else if(scrollOptions.itemSize){var fullItemPos=scrollOptions.itemSize/2,slideeOffset=options.enableNativeScroll?this.getScrollContainerBoundingClientRect():this.slideeElement.getBoundingClientRect(),left=scrollOptions.left,top=scrollOptions.top,top=(null==left&&(left=this.getScrollLeft()),null==top&&(top=this.getScrollTop()),{itemBoundingClientRect:{width:horizontal?scrollOptions.itemSize:null,height:horizontal?null:scrollOptions.itemSize,left:horizontal?slideeOffset.left+left-fullItemPos:null,top:horizontal?null:slideeOffset.top+top-fullItemPos,right:horizontal?slideeOffset.left+left+fullItemPos:null}}),left=(options.enableNativeScroll&&(slideeOffset=horizontal?this.getScrollLeft():this.getScrollTop(),horizontal?(top.itemBoundingClientRect.left-=slideeOffset,top.itemBoundingClientRect.right-=slideeOffset):top.itemBoundingClientRect.top-=slideeOffset),this.getElementPosition(null,horizontal,top));if(left.isVisible||scrollOptions.skipWhenAnyVisible&&left.anyVisible)return Promise.resolve()}fullItemPos=scrollOptions.useDelayedPromise;return options.enableNativeScroll?(slideeOffset=isSmoothScrollSupported&&!_layoutmanager.default.tv?"smooth":"auto",scrollNative(this,{left:scrollOptions.left,top:scrollOptions.top,behavior:immediate?"instant":slideeOffset,useDelayedPromise:fullItemPos})):null!=scrollOptions.left&&scrollOptions.left!==pos.scrollLeft||null!=scrollOptions.top&&scrollOptions.top!==pos.scrollTop?renderAnimateWithTransform(this,scrollOptions,0,immediate,fullItemPos):Promise.resolve()},Scroller.prototype.scrollToPosition=function(pos){var options=this.options;if(null!=pos.position&&(options.horizontal?pos.left=pos.position:pos.top=pos.position,pos.position=null,delete pos.position),!options.enableNativeScroll)return this.slideTo(pos);var hasLeft=null!=pos.left,hasTop=null!=pos.top;if(!hasLeft||!hasTop)if(options.horizontal){if(hasLeft)return this.slideTo(pos)}else if(hasTop)return this.slideTo(pos);return pos.behavior="instant",scrollNative(this,pos)},Scroller.prototype.getElementPosition=function(item,horizontal,scrollOptions){var options=this.options,enableNativeScroll=(this.nativeScrollElement,options.enableNativeScroll),slideeOffset=enableNativeScroll?this.getScrollContainerBoundingClientRect():this.slideeElement.getBoundingClientRect(),itemOffset=(null==scrollOptions?void 0:scrollOptions.itemBoundingClientRect)||item.getBoundingClientRect(),multiplier=horizontal?this.getScrollLeftMultiplier():this.getScrollTopMultiplier(),slideeOffset=horizontal?-1===multiplier?itemOffset.right-slideeOffset.right:itemOffset.left-slideeOffset.left:itemOffset.top-slideeOffset.top,itemOffset=horizontal?itemOffset.width:itemOffset.height,item=(itemOffset||0===itemOffset||(itemOffset=item[horizontal?"offsetWidth":"offsetHeight"]),options.centerOffset||0),options=horizontal?this.getScrollLeft():this.getScrollTop(),enableNativeScroll=(enableNativeScroll&&(slideeOffset+=options),slideeOffset),scrollOptions=(scrollOptions&&(enableNativeScroll+=scrollOptions.offset||0),this.ensureSizeInfo(),getFrameSize(this,horizontal)),horizontal=Math.abs(options),options=horizontal+scrollOptions,item=enableNativeScroll+item-(scrollOptions/2-itemOffset/2)*multiplier,scrollOptions=enableNativeScroll-(scrollOptions-itemOffset)*multiplier,multiplier=Math.abs(slideeOffset),slideeOffset=horizontal<=enableNativeScroll&&multiplier+itemOffset<=options;return{start:enableNativeScroll,center:item,end:scrollOptions,isVisible:slideeOffset,anyVisible:slideeOffset||horizontal<=enableNativeScroll+itemOffset&&multiplier<=options}};var paddingInlineStartProp=CSS.supports("padding-inline-start","0")?"padding-inline-start":CSS.supports("-webkit-padding-start","0")?"-webkit-padding-start":"padding-left",paddingInlineEndProp=CSS.supports("padding-inline-end","0")?"padding-inline-end":CSS.supports("-webkit-padding-end","0")?"-webkit-padding-end":"padding-right";function getSlideePadding(slideeElement,horizontal){try{var style=getComputedStyle(slideeElement),startPadding=style.getPropertyValue(horizontal?paddingInlineStartProp:"padding-top"),endPadding=style.getPropertyValue(horizontal?paddingInlineEndProp:"padding-bottom");return parsePxToInt(startPadding)+parsePxToInt(endPadding)}catch(err){console.log("error in getSlideePadding: "+err)}}Scroller.prototype.ensureSizeInfo=function(){var options,horizontal,newFrameSize,frame;this.requiresReflow&&(this.requiresReflow=!1,frame=this.frame,newFrameSize={},((horizontal=(options=this.options).horizontal)||options.dualScroll)&&(newFrameSize.width=frame.offsetWidth),horizontal&&!options.dualScroll||(newFrameSize.height=frame.offsetHeight),this.frameSize=newFrameSize,options.enableNativeScroll||(options.dynamicFrameSizing?(frame=this.slideeElement,this.slideeSize={width:Math.max(frame.offsetWidth,frame.scrollWidth)+getSlideePadding(frame,!0),height:Math.max(frame.offsetHeight,frame.scrollHeight)+getSlideePadding(frame,!1)}):this.slideeSize={width:5e6,height:5e6},this._pos.end=Math.max(this.getScrollSize()-getFrameSize(this,horizontal),0)*this.getScrollMultiplier()))},Scroller.prototype.getScrollEventName=function(){return this.options.enableNativeScroll?"scroll":"scrollanimate"},Scroller.prototype.getScrollContainerBoundingClientRect=function(){if(!this.frameResizeObserver)return addFrameResizeObserver(this),this.nativeScrollElement.getBoundingClientRect();var rect=this._frameRect;return null==rect&&(rect=this.nativeScrollElement.getBoundingClientRect(),this._frameRect=rect),rect},Scroller.prototype.getScrollSlider=function(){return this.slideeElement},Scroller.prototype.addScrollEventListener=function(fn,options){this.listenerCount++,this.options.dispatchScrollEvent=0<this.listenerCount,this.options.cacheScrollPositions=this.options.dispatchScrollEvent&&preventScrollSupported,this.options.cacheScrollPositions&&this.addScrollCacheListener();var elem=this.options.enableNativeScroll?this.nativeScrollElement:this.frame;_dom.default.addEventListener(elem,this.getScrollEventName(),fn,options)},Scroller.prototype.removeScrollEventListener=function(fn,options){this.listenerCount=Math.max(this.listenerCount-1,0),this.options.dispatchScrollEvent=0<this.listenerCount,this.options.cacheScrollPositions=this.options.dispatchScrollEvent&&preventScrollSupported,this.options.cacheScrollPositions||this.removeScrollCacheListener();var elem=this.options.enableNativeScroll?this.nativeScrollElement:this.frame;_dom.default.removeEventListener(elem,this.getScrollEventName(),fn,options)},Scroller.prototype.addScrollCacheListener=function(){!this.options.enableNativeScroll||this._scrollCacheListenerBound||(this._scrollCacheListenerBound=!0,_dom.default.addEventListener(this.nativeScrollElement,"scroll",this.onScrollForCachingFn,{passive:!0}))},Scroller.prototype.removeScrollCacheListener=function(){var elem=this.nativeScrollElement;elem&&(this._scrollCacheListenerBound=!1,_dom.default.removeEventListener(elem,"scroll",this.onScrollForCachingFn,{passive:!0}))},Scroller.prototype.addResizeObserver=function(fn){addFrameResizeObserver(this),this.resizeListeners&&this.resizeListeners.push(fn)},Scroller.prototype.removeResizeObserver=function(fn){this.resizeListeners&&-1<(fn=this.resizeListeners.indexOf(fn))&&this.resizeListeners.splice(fn,1)},Scroller.prototype.isNativeScroll=function(item){return this.options.enableNativeScroll},Scroller.prototype.getScrollPosition=function(){return this.options.horizontal?this.getScrollLeft():this.getScrollTop()},Scroller.prototype.getLastScrollPosition=function(){return this.options.horizontal?this.getLastScrollLeft():this.getLastScrollTop()},Scroller.prototype.getScrollLeft=function(){var options=this.options;return options.enableNativeScroll?options.cacheScrollPositions?(null==(options=this._cachedScrollLeft)&&(options=this.nativeScrollElement.scrollLeft,this._cachedScrollLeft=options),options):this.nativeScrollElement.scrollLeft:this._pos.scrollLeft},Scroller.prototype.getScrollMultiplier=function(){return this.options.horizontal?this.getScrollLeftMultiplier():this.getScrollTopMultiplier()},Scroller.prototype.getScrollLeftMultiplier=function(){return this.options.inlineMultiplier},Scroller.prototype.getScrollTopMultiplier=function(){return 1},Scroller.prototype.getLastScrollLeft=function(){return this._cachedScrollLeft},Scroller.prototype.getScrollTop=function(){var options=this.options;return options.enableNativeScroll?options.cacheScrollPositions?(null==(options=this._cachedScrollTop)&&(options=this.nativeScrollElement.scrollTop,this._cachedScrollTop=options),options):this.nativeScrollElement.scrollTop:this._pos.scrollTop},Scroller.prototype.getLastScrollTop=function(){return this._cachedScrollTop},Scroller.prototype.getScrollSize=function(){return this.options.horizontal?this.getScrollWidth():this.getScrollHeight()},Scroller.prototype.getScrollWidth=function(){if(!this.options.enableNativeScroll)return this.slideeSize.width;addFrameResizeObserver(this);var value=this._cachedScrollWidth;return value||(value=this.nativeScrollElement.scrollWidth,this._cachedScrollWidth=value),value},Scroller.prototype.getScrollHeight=function(){if(!this.options.enableNativeScroll)return this.slideeSize.height;addFrameResizeObserver(this);var value=this._cachedScrollHeight;return value||(value=this.nativeScrollElement.scrollHeight,this._cachedScrollHeight=value),value},Scroller.prototype.scrollBy=function(delta,scrollOptions){var options;delta&&((options=this.options).enableNativeScroll?options.horizontal?this.nativeScrollElement.scrollLeft+=delta:this.nativeScrollElement.scrollTop+=delta:((scrollOptions=scrollOptions||{}).position=this.getScrollPosition()+delta,this.scrollToPosition(scrollOptions)))},Scroller.prototype.to=function(location,item,scrollOptions){var horizontal=this.options.horizontal,item=this.getElementPosition(item,horizontal,scrollOptions);scrollOptions=scrollOptions||{},horizontal?scrollOptions.left=item[location]:scrollOptions.top=item[location],this.slideTo(scrollOptions,item)},Scroller.prototype.toStart=function(item,scrollOptions){this.to("start",item,scrollOptions)},Scroller.prototype.toEnd=function(item,scrollOptions){this.to("end",item,scrollOptions)},Scroller.prototype.toCenter=function(item,scrollOptions){this.to("center",item,scrollOptions)},Scroller.prototype.scrollBackwards=function(){this.scrollBy(0-this.options.scrollBy)},Scroller.prototype.scrollForwards=function(){this.scrollBy(this.options.scrollBy)},Scroller.prototype.notifyResized=function(){onResize.call(this,[])},Scroller.prototype.destroy=function(){this.frameResizeObserver&&(this.frameResizeObserver.disconnect(),this.frameResizeObserver=null);var frame=this.frame,dragSourceElement=this.dragSourceElement,selfScrollHandler=(_dom.default.removeEventListener(frame,"scroll",resetScrollTop,{passive:!0}),this.scrollHandler),selfScrollHandler=(selfScrollHandler&&_dom.default.removeEventListener(frame,wheelEvent,selfScrollHandler,{passive:!0}),this.dragStartHandler),dragSourceElement=(selfScrollHandler&&(_dom.default.removeEventListener(dragSourceElement,"touchstart",selfScrollHandler,{passive:!0}),_dom.default.removeEventListener(dragSourceElement,"mousedown",selfScrollHandler,{passive:!0}),_dom.default.removeEventListener(dragSourceElement,"pointerdown",selfScrollHandler,{passive:!0})),this.focusHandler);return dragSourceElement&&_dom.default.removeEventListener(frame,"focus",dragSourceElement,{capture:!0,passive:!0}),_dom.default.removeEventListener(frame,"click",onFrameClick,{passive:!0,capture:!0}),this.removeScrollCacheListener(),this.scrollHandler=null,this.dragSourceElement=null,this.initialized=null,this.nativeScrollElement=null,this.frame=null,this.options=null,this.slideeSize=null,this._pos=null,this.requiresReflow=null,this.frameSize=null,this.dragging=null,this.contentRects=null,this.dragHandler=null,this.dragStartHandler=null,this.onSourceClickFn=null,this.onScrollForCachingFn=null,this.resizeListeners=null,this._cachedScrollTop=null,this._cachedScrollLeft=null,this._cachedScrollHeight=null,this._cachedScrollWidth=null,this._frameRect=null,this},Scroller.create=function(frame,options){frame=new Scroller(frame,options);return Promise.resolve(frame)},_exports.default=Scroller});