# When this file is run by CMake through the find_package command, the
# following targets will exist:
#
#   f3d::f3d           Target that contains the F3D executable
#
#   f3d::libf3d        Target that contains the libf3d
#
# The following local variables will also be defined:
#
#   f3d_MODULE_EXTERNAL_RENDERING  Will be enabled if F3D was built with external rendering support
#   f3d_MODULE_RAYTRACING          Will be enabled if F3D was built with raytracing support
#   f3d_MODULE_EXR                 Will be enabled if F3D was built with OpenEXR images support
#   f3d_BINDINGS_PYTHON            Will be enabled if F3D was built with python bindings
#   f3d_BINDINGS_JAVA              Will be enabled if F3D was built with java bindings
#   f3d_INCLUDE_DIR                Absolute path to the include directory of public f3d library classes
#   f3d_CONFIG_DIR                 Path to F3D configuration directory, can be absolute or relative
#   f3d_PLUGINS_INSTALL_DIR        Relative path to F3D plugins install directory


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was f3dConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/f3d" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(f3d_MODULE_EXTERNAL_RENDERING "ON")
set(f3d_MODULE_RAYTRACING "ON")
set(f3d_MODULE_EXR "OFF")
set(f3d_BINDINGS_PYTHON "ON")
set(f3d_BINDINGS_JAVA "ON")
set(f3d_CONFIG_DIR "/etc/f3d")
set(f3d_PLUGINS_INSTALL_DIR "lib")

# Provide a f3d_embed_file method for embedding image into source code
include("${CMAKE_CURRENT_LIST_DIR}/f3dEmbed.cmake")

# Provide macros used to create a plugin
include("${CMAKE_CURRENT_LIST_DIR}/f3dPlugin.cmake")

include("${CMAKE_CURRENT_LIST_DIR}/f3dTargets.cmake")
set_and_check(f3d_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
check_required_components(f3d)
