/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class LicensePane
extends JPanel {
    private final String lineSeparator = System.getProperty("line.separator");

    public LicensePane(Dimension d, String licensePath) {
        JTextArea licText = new JTextArea(this.getLicenseText(this.getClass().getResourceAsStream(licensePath)));
        licText.setEditable(false);
        licText.setFont(new Font("Courier", 0, 12));
        JScrollPane licPane = new JScrollPane();
        licPane = new JScrollPane(licText);
        licPane.setPreferredSize(d);
        licPane.setVerticalScrollBarPolicy(20);
        licPane.setHorizontalScrollBarPolicy(30);
        this.setLayout(new BorderLayout());
        this.add((Component)licPane, "Center");
        licText.setCaretPosition(0);
    }

    private String getLicenseText(InputStream is) {
        StringBuilder license = new StringBuilder();
        try {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(is));){
                String buf = r.readLine();
                while (buf != null) {
                    license.append(buf);
                    license.append(this.lineSeparator);
                    buf = r.readLine();
                }
            }
            is.close();
        }
        catch (Exception e) {
            Util.errMsg(this, "The license text could not be opened.\n\nPlease consult file 'readme.txt' for installation guidelines\n\nSimplyHTML and all of its parts are distributed under\nthe terms and conditions of the GNU General Public License (GPL).\nYou may want to obtain a free and complete distribution package at\nhttps://www.lightdev.com", e);
        }
        return license.toString();
    }
}

