/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.CopiedImageSources;
import com.lightdev.app.shtm.HTMLText;
import com.lightdev.app.shtm.HTMLTextSelection;
import com.lightdev.app.shtm.Remover;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorKit;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.Util;
import com.lightdev.app.shtm.bugfix.MapElementRemovingWorkaround;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;

public class SHTMLEditorPane
extends JEditorPane
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private static final String DO_NOTHING = "do nothing";
    private static final String TAB = "\t";
    private static final String TAB_REPLACEMENT = "    ";
    private static final boolean OLD_JAVA_VERSION = System.getProperty("java.version").compareTo("1.5.0") < 0;
    private JPopupMenu popup;
    private final ListManager listManager = new ListManager();
    private PasteMode pasteMode;
    private boolean forceConstantPasteMode;
    public static final int THIS_CELL = 0;
    public static final int THIS_COLUMN = 1;
    public static final int THIS_ROW = 2;
    public static final int ALL_CELLS = 3;
    public static final String DEFAULT_TABLE_WIDTH = "80%";
    public static final String DEFAULT_VERTICAL_ALIGN = "top";
    DropTarget dropTarget = null;
    DragSource dragSource = null;
    private int lastSelStart = 0;
    private int lastSelEnd = 0;
    private int dndEventLocation = 0;
    private boolean dragStartedHere = false;
    private static final List elementsContainingParagraphs = Arrays.asList(HTML.Tag.BODY.toString(), HTML.Tag.TH.toString(), HTML.Tag.TD.toString());
    static Action toggleBulletListAction = null;
    static Action toggleNumberListAction = null;
    public static final String newListItemAction = "newListItem";
    public static final String insertLineBreakAction = "insertLineBreak";
    public static final String deletePrevCharAction = "deletePrevChar";
    public static final String deleteNextCharAction = "deleteNextChar";
    public static final String moveUpAction = "moveUp";
    public static final String homeAction = "home";
    public static final String shiftHomeAction = "shiftHome";
    public static final String shiftEndAction = "shiftEnd";
    public static final String endAction = "end";
    public static final String moveDownAction = "moveDown";
    private final DataFlavor htmlTextDataFlavor = new DataFlavor(HTMLText.class, "HTMLText");

    private static DataFlavor getSupportedHtmlFlavor(Transferable t) {
        try {
            DataFlavor prototypeFlavor = new DataFlavor("text/html; class=java.lang.String");
            for (DataFlavor dataFlavor : t.getTransferDataFlavors()) {
                if (!dataFlavor.getPrimaryType().equals(prototypeFlavor.getPrimaryType()) || !dataFlavor.getSubType().equals(prototypeFlavor.getSubType()) || !dataFlavor.getRepresentationClass().equals(prototypeFlavor.getRepresentationClass())) continue;
                return dataFlavor;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't fetch appropriate text/html DataFlavor!");
        }
        return null;
    }

    public SHTMLEditorPane() {
        this.setCaretColor(Color.black);
        this.setNavigationFilter(new MyNavigationFilter());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                String linkURL;
                if ((ev.getModifiers() & 2) != 0 && (linkURL = SHTMLEditorPane.this.getURLOfExistingLink()) != null) {
                    SHTMLPanelImpl panel = SHTMLPanelImpl.getOwnerSHTMLPanel((Component)ev.getSource());
                    panel.openHyperlink(linkURL);
                }
            }

            private void maybeShowPopup(MouseEvent e) {
                if (SHTMLEditorPane.this.popup != null && e.isPopupTrigger()) {
                    SHTMLEditorPane.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setPasteModeFromPrefs();
        this.adjustKeyBindings();
        this.initDnd();
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new SHTMLEditorKit();
    }

    @Override
    public void updateUI() {
        if (this.getDocument() == null) {
            this.setEditorKit(this.createDefaultEditorKit());
        }
        super.updateUI();
    }

    @Override
    public void setUI(TextUI newUI) {
        super.setUI(newUI);
        this.getInputMap(0).put(KeyStroke.getKeyStroke('\u0004'), DO_NOTHING);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control T"), DO_NOTHING);
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control H"), DO_NOTHING);
    }

    @Override
    public SHTMLDocument getDocument() {
        Document document = super.getDocument();
        return (SHTMLDocument)document;
    }

    @Override
    public void setDocument(Document doc) {
        SHTMLDocument shtmlDoc = (SHTMLDocument)doc;
        super.setDocument(shtmlDoc);
    }

    public PasteMode getPasteMode() {
        if (this.forceConstantPasteMode) {
            return this.pasteMode;
        }
        return PasteMode.getPasteModeFromPrefs();
    }

    public void setPasteMode(PasteMode pasteMode) {
        this.pasteMode = pasteMode;
        this.forceConstantPasteMode = true;
    }

    public void setPasteModeFromPrefs() {
        this.forceConstantPasteMode = false;
    }

    private void adjustKeyBindings() {
        ActionMap myActionMap = new ActionMap();
        InputMap myInputMap = new InputMap();
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        myActionMap.put("nextTableCell", new TabAction("nextTableCell"));
        myInputMap.put(tab, "nextTableCell");
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 1);
        myActionMap.put("prevTableCell", new ShiftTabAction("prevTableCell"));
        myInputMap.put(shiftTab, "prevTableCell");
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        myActionMap.put(newListItemAction, new NewParagraphAction());
        myInputMap.put(enter, newListItemAction);
        KeyStroke lineBreak = KeyStroke.getKeyStroke(10, 1);
        myActionMap.put(insertLineBreakAction, new InsertLineBreakAction());
        myInputMap.put(lineBreak, insertLineBreakAction);
        KeyStroke backspace = KeyStroke.getKeyStroke(8, 0);
        myActionMap.put(deletePrevCharAction, new DeletePrevCharAction());
        myInputMap.put(backspace, deletePrevCharAction);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        myActionMap.put(deleteNextCharAction, new DeleteNextCharAction());
        myInputMap.put(delete, deleteNextCharAction);
        myActionMap.put(moveUpAction, new MoveUpAction());
        myInputMap.put(KeyStroke.getKeyStroke(38, 0), moveUpAction);
        myActionMap.put(moveDownAction, new MoveDownAction());
        myInputMap.put(KeyStroke.getKeyStroke(40, 0), moveDownAction);
        myActionMap.put(homeAction, new HomeAction());
        myInputMap.put(KeyStroke.getKeyStroke(36, 0), homeAction);
        myActionMap.put(endAction, new EndAction());
        myInputMap.put(KeyStroke.getKeyStroke(35, 0), endAction);
        myActionMap.put(shiftHomeAction, new ShiftHomeAction());
        myInputMap.put(KeyStroke.getKeyStroke(36, 1), shiftHomeAction);
        myActionMap.put(shiftEndAction, new ShiftEndAction());
        myInputMap.put(KeyStroke.getKeyStroke(35, 1), shiftEndAction);
        myActionMap.setParent(this.getActionMap());
        myInputMap.setParent(this.getInputMap());
        this.setActionMap(myActionMap);
        this.setInputMap(0, myInputMap);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        int maximumEndSelection = this.getDocument().getLastDocumentPosition();
        if (this.getSelectionStart() >= maximumEndSelection && ks.getKeyCode() != 37 && ks.getKeyCode() != 38 && ks.getKeyCode() != 36) {
            return true;
        }
        if (this.getSelectionEnd() >= maximumEndSelection) {
            this.setSelectionEnd(maximumEndSelection - 1);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public void setText(String text) {
        SHTMLDocument doc = this.getDocument();
        doc.startCompoundEdit();
        if (text == null || text.isEmpty()) {
            text = "<html><body><p></p></body></html>";
        }
        doc.putProperty("AdditionalComments", null);
        MapElementRemovingWorkaround.removeAllMapElements(doc);
        try {
            doc.remove(0, doc.getLength());
            if (text == null || text.isEmpty()) {
                return;
            }
            StringReader r = new StringReader(text);
            SHTMLEditorKit kit = (SHTMLEditorKit)this.getEditorKit();
            kit.read(r, (Document)doc, 0);
            kit.setStandardSuffix(doc);
        }
        catch (IOException | BadLocationException ioe) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
        this.setCaretPosition(0);
        doc.endCompoundEdit();
        if (OLD_JAVA_VERSION) {
            SHTMLPanelImpl.getOwnerSHTMLPanel(this).purgeUndos();
        }
    }

    private int getValidPosition(int position) {
        SHTMLDocument doc = this.getDocument();
        int lastValidPosition = doc.getLastDocumentPosition() - 1;
        if (position > lastValidPosition) {
            position = lastValidPosition;
        }
        int startPos = 0;
        if (doc.getDefaultRootElement().getElementCount() > 1) {
            startPos = doc.getDefaultRootElement().getElement(1).getStartOffset();
        }
        return Math.max(position, startPos);
    }

    public void applyListAttributes(AttributeSet a) {
        SHTMLDocument doc = this.getDocument();
        Element list = this.listManager.getListElement(this.getSelectionStart());
        if (list != null && a.getAttributeCount() > 0) {
            doc.addAttributes(list, a);
        }
    }

    public void toggleList(String listTag, AttributeSet attributeSet, boolean forceOff) {
        this.listManager.toggleList(listTag, attributeSet, forceOff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewTable(int colCount) {
        int selectionStart;
        block12: {
            selectionStart = this.getSelectionStart();
            StringWriter sw = new StringWriter();
            SHTMLDocument doc = this.getDocument();
            SHTMLWriter w = new SHTMLWriter((Writer)sw, doc);
            String table = HTML.Tag.TABLE.toString();
            String tr = HTML.Tag.TR.toString();
            String td = HTML.Tag.TD.toString();
            String th = HTML.Tag.TH.toString();
            String p = HTML.Tag.P.toString();
            boolean insertPlainTable = !Util.preferenceIsTrue("table.insertStyle", "true");
            boolean insertTableHeader = Util.preferenceIsTrue("table.insertHeader");
            try {
                int i;
                SimpleAttributeSet tableAttributeSet = new SimpleAttributeSet();
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.WIDTH, DEFAULT_TABLE_WIDTH);
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_STYLE, "solid");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_TOP_WIDTH, "0");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_RIGHT_WIDTH, "0");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_BOTTOM_WIDTH, "0");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_LEFT_WIDTH, "0");
                tableAttributeSet.addAttribute(HTML.Attribute.BORDER, "0");
                w.writeStartTag(table, insertPlainTable ? null : tableAttributeSet);
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.WIDTH, 100 / colCount + "%");
                tableAttributeSet.addAttribute(HTML.Attribute.VALIGN, DEFAULT_VERTICAL_ALIGN);
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_TOP_WIDTH, "1");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_RIGHT_WIDTH, "1");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_BOTTOM_WIDTH, "1");
                Util.styleSheet().addCSSAttribute(tableAttributeSet, CSS.Attribute.BORDER_LEFT_WIDTH, "1");
                SimpleAttributeSet pSet = new SimpleAttributeSet();
                Util.styleSheet().addCSSAttribute(pSet, CSS.Attribute.MARGIN_TOP, "1");
                Util.styleSheet().addCSSAttribute(pSet, CSS.Attribute.MARGIN_RIGHT, "1");
                Util.styleSheet().addCSSAttribute(pSet, CSS.Attribute.MARGIN_BOTTOM, "1");
                Util.styleSheet().addCSSAttribute(pSet, CSS.Attribute.MARGIN_LEFT, "1");
                tableAttributeSet.removeAttribute(HTML.Attribute.BORDER);
                if (insertTableHeader) {
                    w.writeStartTag(tr, null);
                    for (i = 0; i < colCount; ++i) {
                        w.writeStartTag(th, insertPlainTable ? null : tableAttributeSet);
                        w.writeStartTag(p, insertPlainTable ? null : pSet);
                        w.writeEndTag(p);
                        w.writeEndTag(th);
                    }
                    w.writeEndTag(tr);
                }
                w.writeStartTag(tr, null);
                for (i = 0; i < colCount; ++i) {
                    w.writeStartTag(td, insertPlainTable ? null : tableAttributeSet);
                    w.writeStartTag(p, insertPlainTable ? null : pSet);
                    w.writeEndTag(p);
                    w.writeEndTag(td);
                }
                w.writeEndTag(tr);
                w.writeEndTag(table);
                Element para = doc.getParagraphElement(selectionStart);
                if (para == null) {
                    throw new Exception("no text selected");
                }
                Element parent = para.getParentElement();
                while (!parent.getName().equalsIgnoreCase(HTML.Tag.BODY.toString()) && !parent.getName().equalsIgnoreCase(HTML.Tag.TD.toString())) {
                    para = parent;
                    parent = parent.getParentElement();
                }
                if (para == null) break block12;
                try {
                    doc.startCompoundEdit();
                    doc.insertBeforeStart(para, sw.getBuffer().toString());
                }
                catch (Exception e) {
                    Util.errMsg(null, e.getMessage(), e);
                }
                finally {
                    doc.endCompoundEdit();
                }
            }
            catch (Exception ex) {
                Util.errMsg(null, ex.getMessage(), ex);
            }
        }
        this.select(selectionStart, selectionStart);
    }

    public void insertAnchor(String anchorName) {
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            SimpleAttributeSet aSet = new SimpleAttributeSet();
            aSet.addAttribute(HTML.Attribute.NAME, anchorName);
            SimpleAttributeSet set = new SimpleAttributeSet();
            set.addAttribute(HTML.Tag.A, aSet);
            this.applyAttributes(set, false);
        }
    }

    public void insertBreak() {
        int caretPos = this.getCaretPosition();
        SHTMLDocument doc = this.getDocument();
        try {
            ((SHTMLEditorKit)this.getEditorKit()).insertHTML(doc, caretPos, "<BR>", 0, 0, HTML.Tag.BR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCaretPosition(caretPos + 1);
    }

    public void setLink(String linkText, String href, String className) {
        this.setLink(linkText, href, className, null, null);
    }

    public void setLink(String linkText, String href, String className, String linkImage, Dimension size) {
        if (linkImage == null) {
            this.setTextLink(this.getCurrentLinkElement(), href, className, linkText, this.getDocument());
        } else {
            this.setImageLink(this.getDocument(), this.getCurrentLinkElement(), href, className, linkImage, size);
        }
    }

    private void setImageLink(SHTMLDocument doc, Element e, String href, String className, String linkImage, Dimension size) {
        String a = HTML.Tag.A.toString();
        SimpleAttributeSet set = new SimpleAttributeSet();
        set.addAttribute(HTML.Attribute.HREF, href);
        String sStyleName = Util.getResourceString("standardStyleName");
        if (className != null && !className.equalsIgnoreCase(sStyleName)) {
            set.addAttribute(HTML.Attribute.CLASS, className);
        }
        StringWriter sw = new StringWriter();
        SHTMLWriter w = new SHTMLWriter((Writer)sw, doc);
        try {
            w.writeStartTag(a, set);
            set = new SimpleAttributeSet();
            set.addAttribute(HTML.Attribute.SRC, Util.getRelativePath(new File(doc.getBase().getFile()), new File(linkImage)));
            set.addAttribute(HTML.Attribute.BORDER, "0");
            if (size != null) {
                set.addAttribute(HTML.Attribute.WIDTH, String.valueOf((int)size.getWidth()));
                set.addAttribute(HTML.Attribute.HEIGHT, String.valueOf((int)size.getHeight()));
            }
            w.writeStartTag(HTML.Tag.IMG.toString(), set);
            w.writeEndTag(a);
            if (e != null) {
                System.out.println("SHTMLEditorPane.setImageLink setOuterHTML html='" + sw.getBuffer() + "'");
                doc.setOuterHTML(e, sw.getBuffer().toString());
            } else {
                int start = this.getSelectionStart();
                if (start < this.getSelectionEnd()) {
                    this.replaceSelection("");
                    System.out.println("SHTMLEditorPane.setImageLink insertAfterEnd html='" + sw.getBuffer() + "'");
                    doc.insertAfterEnd(doc.getCharacterElement(start), sw.getBuffer().toString());
                }
            }
        }
        catch (Exception ex) {
            Util.errMsg(this, ex.getMessage(), ex);
        }
    }

    private void setTextLink(Element e, String href, String className, String linkText, SHTMLDocument doc) {
        int start;
        String sStyleName = Util.getResourceString("standardStyleName");
        SimpleAttributeSet set = new SimpleAttributeSet();
        SimpleAttributeSet aSet = new SimpleAttributeSet();
        if (href != null) {
            aSet.addAttribute(HTML.Attribute.HREF, href);
            if (className != null && !className.equalsIgnoreCase(sStyleName)) {
                aSet.addAttribute(HTML.Attribute.CLASS, className);
            }
        }
        if (e != null) {
            set.addAttributes(e.getAttributes());
            if (href != null) {
                set.addAttribute(HTML.Tag.A, aSet);
            } else {
                set.removeAttribute(HTML.Tag.A);
            }
            int start2 = e.getStartOffset();
            int length = e.getEndOffset() - start2;
            try {
                if (linkText == null) {
                    linkText = doc.getText(start2, length);
                }
                doc.replace(start2, length, linkText, set);
            }
            catch (BadLocationException ex) {
                Util.errMsg(this, ex.getMessage(), ex);
            }
        } else if (href != null && (start = this.getSelectionStart()) < this.getSelectionEnd()) {
            set.addAttribute(HTML.Tag.A, aSet);
            try {
                if (linkText == null) {
                    linkText = doc.getText(start, this.getSelectionEnd() - start);
                }
                this.replaceSelection(linkText);
                doc.setCharacterAttributes(start, linkText.length(), set, false);
            }
            catch (BadLocationException ex) {
                Util.errMsg(this, ex.getMessage(), ex);
            }
        }
    }

    public void removeAnchor(String anchorName) {
        ElementIterator eli = new ElementIterator(this.getDocument());
        Element elem = eli.first();
        while (elem != null) {
            Object nameAttr;
            AttributeSet attrs = elem.getAttributes();
            Object link = attrs.getAttribute(HTML.Tag.A);
            if (link != null && (nameAttr = ((AttributeSet)link).getAttribute(HTML.Attribute.NAME)) != null && nameAttr.toString().equalsIgnoreCase(anchorName)) {
                SimpleAttributeSet newSet = new SimpleAttributeSet(attrs);
                newSet.removeAttribute(HTML.Tag.A);
                SHTMLDocument doc = this.getDocument();
                int start = elem.getStartOffset();
                doc.setCharacterAttributes(elem.getStartOffset(), elem.getEndOffset() - start, newSet, true);
            }
            elem = eli.next();
        }
    }

    public void insertTableColumn() {
        Element cell = this.getCurrentTableCell();
        if (cell != null) {
            this.createTableColumn(cell, Util.getElementIndex(cell), true);
        }
    }

    public void appendTableColumn() {
        Element cell = this.getCurrentTableCell();
        if (cell != null) {
            Element lastCell = this.getLastTableCell(cell);
            this.createTableColumn(lastCell, Util.getElementIndex(cell), false);
        }
    }

    private void createTableColumn(Element cell, int cIndex, boolean before) {
        SHTMLDocument doc = this.getDocument();
        doc.startCompoundEdit();
        Element table = cell.getParentElement().getParentElement();
        Element srcCell = table.getElement(0).getElement(cIndex);
        SimpleAttributeSet set = new SimpleAttributeSet();
        Object attr = set.getAttribute(CSS.Attribute.WIDTH);
        if (attr != null) {
            int width = (int)Util.getAbsoluteAttrVal(attr);
            String unit = Util.getLastAttrUnit();
            String widthString = width / 2 + unit;
            Util.styleSheet().addCSSAttribute(set, CSS.Attribute.WIDTH, widthString);
        }
        for (int rIndex = 0; rIndex < table.getElementCount(); ++rIndex) {
            srcCell = table.getElement(rIndex).getElement(cIndex);
            doc.addAttributes(srcCell, set);
            try {
                if (before) {
                    doc.insertBeforeStart(srcCell, this.createTableCellHTML(srcCell));
                    continue;
                }
                doc.insertAfterEnd(srcCell, this.createTableCellHTML(srcCell));
                continue;
            }
            catch (IOException | BadLocationException ioe) {
                Util.errMsg(null, ioe.getMessage(), ioe);
            }
        }
        doc.endCompoundEdit();
    }

    public void appendTableRow() {
        Element cell = this.getCurrentTableCell();
        if (cell != null) {
            this.createTableRow(cell.getParentElement(), Util.getRowIndex(cell), false, null);
        }
    }

    public void insertTableRow(String forcedCellName) {
        Element cell = this.getCurrentTableCell();
        if (cell != null) {
            this.createTableRow(cell.getParentElement(), Util.getRowIndex(cell), true, forcedCellName);
        }
    }

    private void createTableRow(Element srcRow, int rowIndex, boolean before, String forcedCellName) {
        try {
            if (before) {
                this.getDocument().insertBeforeStart(srcRow, this.createTableRowHTML(srcRow, forcedCellName));
                if (rowIndex == 0) {
                    ++rowIndex;
                }
            } else {
                this.getDocument().insertAfterEnd(srcRow, this.createTableRowHTML(srcRow, forcedCellName));
                ++rowIndex;
            }
        }
        catch (IOException | BadLocationException ioe) {
            Util.errMsg(null, ioe.getMessage(), ioe);
        }
    }

    private String createTableRowHTML(Element modelRow, String forcedCellName) {
        StringWriter stringWriter = new StringWriter();
        SHTMLWriter shtmlWriter = new SHTMLWriter((Writer)stringWriter, this.getDocument());
        String tr = HTML.Tag.TR.toString();
        try {
            shtmlWriter.writeStartTag(tr, modelRow.getAttributes());
            for (int i = 0; i < modelRow.getElementCount(); ++i) {
                Element modelCell = modelRow.getElement(i);
                String cellName = forcedCellName != null ? forcedCellName : modelCell.getName();
                this.createTableCellHTML(shtmlWriter, modelCell, cellName);
            }
            shtmlWriter.writeEndTag(tr);
        }
        catch (IOException ex) {
            Util.errMsg(null, ex.getMessage(), ex);
        }
        return stringWriter.getBuffer().toString();
    }

    private void createTableCellHTML(SHTMLWriter w, Element cell, String cellName) throws IOException {
        w.writeStartTag(cellName, cell.getAttributes());
        Element paragraph = cell.getElement(0);
        String parName = "p";
        if (!"p".equalsIgnoreCase(HTML.Tag.IMPLIED.toString())) {
            w.writeStartTag("p", paragraph.getAttributes());
            w.writeEndTag("p");
        }
        w.writeEndTag(cellName);
    }

    private String createTableCellHTML(Element srcCell) {
        StringWriter sw = new StringWriter();
        SHTMLWriter w = new SHTMLWriter((Writer)sw, this.getDocument());
        try {
            this.createTableCellHTML(w, srcCell, srcCell.getName());
        }
        catch (IOException e) {
            Util.errMsg(null, e.getMessage(), e);
        }
        return sw.getBuffer().toString();
    }

    public void deleteTableRow() {
        Element cell = this.getCurrentTableCell();
        int finalCaretPosition = cell.getStartOffset();
        if (cell != null) {
            this.removeElement(cell.getParentElement());
            int docLength = this.getDocument().getLength();
            this.setCaretPosition(Math.min(docLength, finalCaretPosition));
        }
    }

    public void deleteTableCol() {
        Element cell = this.getCurrentTableCell();
        if (cell == null) {
            return;
        }
        Element row = cell.getParentElement();
        int lastColIndex = row.getElementCount() - 1;
        if (lastColIndex <= 0) {
            return;
        }
        int cIndex = Util.getElementIndex(cell);
        int offset = -1;
        if (cIndex == 0) {
            offset *= -1;
        }
        Object attrC = cell.getAttributes().getAttribute(CSS.Attribute.WIDTH);
        Object attrA = row.getElement(cIndex + offset).getAttributes().getAttribute(CSS.Attribute.WIDTH);
        SimpleAttributeSet set = null;
        if (attrC != null && attrA != null) {
            int widthC = (int)Util.getAbsoluteAttrVal(attrC);
            String cUnit = Util.getLastAttrUnit();
            int widthA = (int)Util.getAbsoluteAttrVal(attrA);
            String aUnit = Util.getLastAttrUnit();
            if (aUnit.equalsIgnoreCase(cUnit)) {
                int width = 0;
                width += widthC;
                if ((width += widthA) > 0) {
                    String widthString = width + cUnit;
                    set = new SimpleAttributeSet(row.getElement(cIndex + offset).getAttributes());
                    Util.styleSheet().addCSSAttribute(set, CSS.Attribute.WIDTH, widthString);
                }
            }
        }
        Element table = row.getParentElement();
        SHTMLDocument doc = this.getDocument();
        doc.startCompoundEdit();
        if (cIndex < lastColIndex) {
            offset = 0;
        }
        for (int rIndex = table.getElementCount() - 1; rIndex >= 0; --rIndex) {
            row = table.getElement(rIndex);
            try {
                doc.removeElements(row, cIndex, 1);
            }
            catch (BadLocationException ble) {
                Util.errMsg(null, ble.getMessage(), ble);
            }
            if (set == null) continue;
            doc.addAttributes(row.getElement(cIndex + offset), set);
        }
        doc.endCompoundEdit();
    }

    public void toggleTableHeaderCell() {
        int originalCaretPosition = this.getCaretPosition();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        Element tableCell = this.getTableCell(selectionStart);
        while (tableCell != null && tableCell.getStartOffset() <= selectionEnd) {
            String content;
            String newContent = content = this.elementToHTML(tableCell);
            if (content.matches("(?is)\\s*<td.*")) {
                newContent = content.replaceFirst("(?is)^\\s*<td", "<th").replaceFirst("(?is)</td>\\s*$", "</th>");
            } else if (content.matches("(?is)\\s*<th.*")) {
                newContent = content.replaceFirst("(?is)^\\s*<th", "<td").replaceFirst("(?is)</th>\\s*$", "</td>");
            }
            Element row = tableCell.getParentElement();
            int tableCellIdx = row.getElementIndex(tableCell.getStartOffset());
            try {
                this.getDocument().setOuterHTML(tableCell, newContent);
            }
            catch (Exception exception) {
                // empty catch block
            }
            tableCell = row.getElement(tableCellIdx);
            tableCell = this.getNextCell(tableCell);
        }
        this.setCaretPosition(originalCaretPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTableRowUp() {
        Element tableCell = this.getCurrentTableCell();
        Element tableRow = tableCell.getParentElement();
        Element table = tableRow.getParentElement();
        int indexOfRowInTable = table.getElementIndex(this.getCaretPosition());
        if (indexOfRowInTable == 0) {
            return;
        }
        try {
            int i;
            this.getDocument().startCompoundEdit();
            SHTMLWriter writer = new SHTMLWriter(this.getDocument());
            writer.writeStartTag(table);
            for (i = 0; i < indexOfRowInTable - 1; ++i) {
                writer.write(table.getElement(i));
            }
            writer.write(tableRow);
            writer.write(table.getElement(indexOfRowInTable - 1));
            for (i = indexOfRowInTable + 1; i < table.getElementCount(); ++i) {
                writer.write(table.getElement(i));
            }
            writer.writeEndTag(table);
            int offsetWithinCurrentRow = this.getCaretPosition() - tableRow.getStartOffset();
            int finalCaretPosition = table.getElement(indexOfRowInTable - 1).getStartOffset() + offsetWithinCurrentRow;
            this.getDocument().setOuterHTML(table, writer.getWrittenString());
            this.setCaretPosition(finalCaretPosition);
        }
        catch (Exception exception) {
        }
        finally {
            this.getDocument().endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTableColumnLeft() {
        Element tableCell = this.getCurrentTableCell();
        Element tableRow = tableCell.getParentElement();
        Element table = tableRow.getParentElement();
        int indexOfCellInRow = tableRow.getElementIndex(this.getCaretPosition());
        if (indexOfCellInRow == 0) {
            return;
        }
        try {
            this.getDocument().startCompoundEdit();
            SHTMLWriter writer = new SHTMLWriter(this.getDocument());
            writer.writeStartTag(table);
            for (int rowIdx = 0; rowIdx < table.getElementCount(); ++rowIdx) {
                int i;
                Element row = table.getElement(rowIdx);
                writer.writeStartTag(row);
                for (i = 0; i < indexOfCellInRow - 1; ++i) {
                    writer.write(row.getElement(i));
                }
                writer.write(row.getElement(indexOfCellInRow));
                writer.write(row.getElement(indexOfCellInRow - 1));
                for (i = indexOfCellInRow + 1; i < row.getElementCount(); ++i) {
                    writer.write(row.getElement(i));
                }
                writer.writeEndTag(row);
            }
            writer.writeEndTag(table);
            int offsetWithinCurrentCell = this.getCaretPosition() - tableCell.getStartOffset();
            int finalCaretPosition = tableRow.getElement(indexOfCellInRow - 1).getStartOffset() + offsetWithinCurrentCell;
            this.getDocument().setOuterHTML(table, writer.getWrittenString());
            this.setCaretPosition(finalCaretPosition);
        }
        catch (Exception exception) {
        }
        finally {
            this.getDocument().endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTableColumnRight() {
        Element tableCell = this.getCurrentTableCell();
        Element tableRow = tableCell.getParentElement();
        Element table = tableRow.getParentElement();
        int indexOfCellInRow = tableRow.getElementIndex(this.getCaretPosition());
        if (indexOfCellInRow == tableRow.getElementCount() - 1) {
            return;
        }
        try {
            this.getDocument().startCompoundEdit();
            SHTMLWriter writer = new SHTMLWriter(this.getDocument());
            writer.writeStartTag(table);
            for (int rowIdx = 0; rowIdx < table.getElementCount(); ++rowIdx) {
                int i;
                Element row = table.getElement(rowIdx);
                writer.writeStartTag(row);
                for (i = 0; i < indexOfCellInRow; ++i) {
                    writer.write(row.getElement(i));
                }
                writer.write(row.getElement(indexOfCellInRow + 1));
                writer.write(row.getElement(indexOfCellInRow));
                for (i = indexOfCellInRow + 2; i < row.getElementCount(); ++i) {
                    writer.write(row.getElement(i));
                }
                writer.writeEndTag(row);
            }
            Element cellToTheRight = tableRow.getElement(indexOfCellInRow + 1);
            int finalCaretPosition = this.getCaretPosition() + cellToTheRight.getEndOffset() - cellToTheRight.getStartOffset();
            this.getDocument().setOuterHTML(table, writer.getWrittenString());
            this.setCaretPosition(finalCaretPosition);
        }
        catch (Exception exception) {
        }
        finally {
            this.getDocument().endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTableRowDown() {
        Element tableCell = this.getCurrentTableCell();
        if (tableCell == null) {
            return;
        }
        Element tableRow = tableCell.getParentElement();
        Element table = tableRow.getParentElement();
        int indexOfRowInTable = table.getElementIndex(this.getCaretPosition());
        if (indexOfRowInTable == table.getElementCount() - 1) {
            return;
        }
        try {
            int i;
            this.getDocument().startCompoundEdit();
            SHTMLWriter writer = new SHTMLWriter(this.getDocument());
            writer.writeStartTag(table);
            for (i = 0; i < indexOfRowInTable; ++i) {
                writer.write(table.getElement(i));
            }
            writer.write(table.getElement(indexOfRowInTable + 1));
            writer.write(tableRow);
            for (i = indexOfRowInTable + 2; i < table.getElementCount(); ++i) {
                writer.write(table.getElement(i));
            }
            writer.writeEndTag(table);
            Element rowBelow = table.getElement(indexOfRowInTable + 1);
            int finalCaretPosition = this.getCaretPosition() + rowBelow.getEndOffset() - rowBelow.getStartOffset();
            this.getDocument().setOuterHTML(table, writer.getWrittenString());
            this.setCaretPosition(finalCaretPosition);
        }
        catch (Exception exception) {
        }
        finally {
            this.getDocument().endCompoundEdit();
        }
    }

    private void removeElement(Element element) {
        try {
            int start = element.getStartOffset();
            Element parent = element.getParentElement();
            if (parent.getName().equalsIgnoreCase("body")) {
                this.getDocument().remove(start, element.getEndOffset() - start);
            } else {
                int i;
                int indexInParent = parent.getElementIndex(element.getStartOffset());
                SHTMLWriter writer = new SHTMLWriter(this.getDocument());
                writer.writeStartTag(parent);
                for (i = 0; i < indexInParent; ++i) {
                    writer.write(parent.getElement(i));
                }
                for (i = indexInParent + 1; i < parent.getElementCount(); ++i) {
                    writer.write(parent.getElement(i));
                }
                writer.writeEndTag(parent);
                this.getDocument().setOuterHTML(parent, writer.getWrittenString());
            }
        }
        catch (Exception ex) {
            Util.errMsg(null, ex.getMessage(), ex);
        }
    }

    public void applyTableAttributes(AttributeSet a) {
        Element cell = this.getCurrentTableCell();
        if (cell != null) {
            Element table = cell.getParentElement().getParentElement();
            if (a.getAttributeCount() > 0) {
                this.getDocument().addAttributes(table, a);
            }
        }
    }

    private void refresh() {
        int pos = this.getCaretPosition();
        String data = this.getText();
        this.setText("");
        this.setText(data);
        this.setCaretPosition(pos);
    }

    public void applyCellAttributes(AttributeSet a, int range) {
        Element cell = this.getCurrentTableCell();
        int cIndex = 0;
        SHTMLDocument doc = this.getDocument();
        if (cell != null) {
            Element row = cell.getParentElement();
            Element table = row.getParentElement();
            switch (range) {
                case 0: {
                    doc.addAttributes(cell, a);
                    break;
                }
                case 2: {
                    for (cIndex = 0; cIndex < row.getElementCount(); ++cIndex) {
                        Element aCell = row.getElement(cIndex);
                        doc.addAttributes(aCell, a);
                    }
                    break;
                }
                case 1: {
                    int rIndex;
                    cIndex = Util.getElementIndex(cell);
                    for (rIndex = 0; rIndex < table.getElementCount(); ++rIndex) {
                        Element aCell = table.getElement(rIndex).getElement(cIndex);
                        doc.addAttributes(aCell, a);
                    }
                    break;
                }
                case 3: {
                    int rIndex;
                    for (rIndex = 0; rIndex < table.getElementCount(); ++rIndex) {
                        row = table.getElement(rIndex);
                        for (cIndex = 0; cIndex < row.getElementCount(); ++cIndex) {
                            Element aCell = row.getElement(cIndex);
                            doc.addAttributes(aCell, a);
                        }
                    }
                    break;
                }
            }
        }
    }

    private int getColNumber(Element cell) {
        int i = 0;
        Element thisRow = cell.getParentElement();
        int last = thisRow.getElementCount() - 1;
        Element aCell = thisRow.getElement(i);
        if (aCell != cell) {
            while (i < last && aCell != cell) {
                aCell = thisRow.getElement(++i);
            }
        }
        return i;
    }

    public void goNextCell(Element cell) {
        if (cell == this.getLastTableCell(cell)) {
            this.appendTableRow();
            this.setCaretPosition(this.getNextCell(cell).getStartOffset());
        } else {
            this.setCaretPosition(this.getNextCell(cell).getStartOffset());
        }
    }

    public void goPrevCell(Element cell) {
        if (cell != this.getFirstTableCell(cell)) {
            cell = this.getPrevCell(cell);
            int newPos = cell.getStartOffset();
            this.select(newPos, newPos);
        }
    }

    private Element getNextCell(Element cell) {
        Element nextCell = null;
        Element row = cell.getParentElement();
        Element nextRow = null;
        Element table = row.getParentElement();
        int lastCellIdx = row.getElementCount() - 1;
        Element lastCellInRow = row.getElement(lastCellIdx);
        if (lastCellInRow != cell) {
            Element runningCell = lastCellInRow;
            int cellIdx = lastCellIdx;
            while (cellIdx > 0 && runningCell != cell) {
                nextCell = runningCell;
                runningCell = row.getElement(--cellIdx);
            }
        } else {
            int rowIdx = table.getElementCount() - 1;
            Element aRow = table.getElement(rowIdx);
            while (aRow != row) {
                nextRow = aRow;
                aRow = table.getElement(--rowIdx);
            }
            nextCell = nextRow == null || nextRow.getElementCount() == 0 ? null : nextRow.getElement(0);
        }
        return nextCell;
    }

    private Element getPrevCell(Element cell) {
        Element thisRow = cell.getParentElement();
        Element table = thisRow.getParentElement();
        Element prevCell = null;
        int i = 0;
        Element aCell = thisRow.getElement(i);
        if (aCell != cell) {
            while (aCell != cell) {
                prevCell = aCell;
                aCell = thisRow.getElement(i++);
            }
        } else {
            Element prevRow = null;
            Element aRow = table.getElement(i);
            while (aRow != thisRow) {
                prevRow = aRow;
                aRow = table.getElement(i++);
            }
            prevCell = prevRow.getElement(prevRow.getElementCount() - 1);
        }
        return prevCell;
    }

    private Element getLastTableCell(Element cell) {
        Element table = cell.getParentElement().getParentElement();
        Element lastRow = table.getElement(table.getElementCount() - 1);
        return lastRow.getElement(lastRow.getElementCount() - 1);
    }

    private Element getFirstTableCell(Element cell) {
        Element table = cell.getParentElement().getParentElement();
        return table.getElement(0).getElement(0);
    }

    public Element getCurrentTableCell() {
        return this.getTableCell(this.getCaretPosition());
    }

    public Element getCurrentLinkElement() {
        Element element2 = null;
        Object linkAttribute = null;
        Object href = null;
        for (Element element = this.getDocument().getCharacterElement(this.getSelectionStart()); element != null && linkAttribute == null; element = element.getParentElement()) {
            element2 = element;
            linkAttribute = element.getAttributes().getAttribute(HTML.Tag.A);
            if (linkAttribute == null) continue;
            href = ((AttributeSet)linkAttribute).getAttribute(HTML.Attribute.HREF);
        }
        if (linkAttribute != null && href != null) {
            return element2;
        }
        return null;
    }

    public Element getTableCell(int position) {
        Element element = this.getDocument().getCharacterElement(position);
        return Util.findElementUp("td", "th", element);
    }

    String getURLOfExistingLink() {
        boolean foundLink;
        Element linkElement = this.getCurrentLinkElement();
        boolean bl = foundLink = linkElement != null;
        if (!foundLink) {
            return null;
        }
        AttributeSet elemAttrs = linkElement.getAttributes();
        Object linkAttr = elemAttrs.getAttribute(HTML.Tag.A);
        Object href = ((AttributeSet)linkAttr).getAttribute(HTML.Attribute.HREF);
        return href != null ? href.toString() : null;
    }

    public Element getCurrentParagraphElement() {
        return this.getDocument().getParagraphElement(this.getCaretPosition());
    }

    @Override
    public void replaceSelection(String content) {
        if (content != null) {
            String expandedContent = content.replaceAll(TAB, TAB_REPLACEMENT);
            super.replaceSelection(expandedContent);
        } else {
            super.replaceSelection(content);
        }
    }

    public void replaceSelection(HTMLText replacementHTMLText) {
        SHTMLDocument document = this.getDocument();
        Caret caret = this.getCaret();
        if (document != null) {
            try {
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                if (p0 != p1) {
                    document.remove(p0, p1 - p0);
                }
                if (replacementHTMLText != null) {
                    this.pasteHTML(replacementHTMLText, p0);
                }
            }
            catch (Exception e) {
                this.getToolkit().beep();
            }
        }
    }

    private void pasteHTML(HTMLText pastedHTMLText, int position) throws Exception {
        SHTMLDocument sDocument = this.getDocument();
        if (!pastedHTMLText.usesStringRepresenation()) {
            pastedHTMLText.pasteHTML(sDocument, position);
            return;
        }
        String pasteHtmlTextModified = pastedHTMLText.getHTMLText();
        Element characterElement = sDocument.getCharacterElement(position);
        Element paragraphElement = characterElement.getParentElement();
        if (position == paragraphElement.getStartOffset()) {
            Element cellElement;
            Element lastElementInCell;
            if (this.caretWithinTableCell() && pastedHTMLText.isOneCellInOneRow()) {
                pasteHtmlTextModified = pasteHtmlTextModified.replaceAll("(?ims).*<td.*?>", "").replaceAll("(?ims)</td.*?>.*", "");
            }
            if (!HTMLText.containsParagraphTags(pasteHtmlTextModified)) {
                sDocument.insertAfterStart(paragraphElement, pasteHtmlTextModified);
                Element newParagraph = this.getCurrentParagraphElement();
                String elementHtmlText = this.elementToHTML(newParagraph);
                String fixedContent = elementHtmlText.replaceAll("(?ims)\\s*</p>", "</p>");
                sDocument.setOuterHTML(newParagraph, fixedContent);
                this.setCaretPosition(newParagraph.getEndOffset() - 1);
                return;
            }
            if (this.caretWithinTableCell() && pasteHtmlTextModified.matches("(?ims).*<table.*")) {
                String strippedHTMLText = pasteHtmlTextModified.replaceAll("(?ims).*<table.*?>", "").replaceAll("(?ims)</table.*?>.*", "");
                Element cellElement2 = this.getCurrentTableCell();
                Element tableRowElement = cellElement2.getParentElement();
                sDocument.insertBeforeStart(tableRowElement, strippedHTMLText);
                return;
            }
            sDocument.insertBeforeStart(paragraphElement, pasteHtmlTextModified);
            if (this.caretWithinTableCell() && this.elementIsEmptyParagraph(lastElementInCell = (cellElement = this.getCurrentTableCell()).getElement(cellElement.getElementCount() - 1))) {
                this.removeElement(lastElementInCell);
                this.setCaretPosition(cellElement.getEndOffset() - 1);
            }
            return;
        }
        if (paragraphElement.getEndOffset() == position + 1) {
            if (HTMLText.containsParagraphTags(pasteHtmlTextModified)) {
                sDocument.insertAfterEnd(paragraphElement, pasteHtmlTextModified);
            } else {
                sDocument.insertBeforeEnd(paragraphElement, pasteHtmlTextModified);
            }
            return;
        }
        String newHtml = pastedHTMLText.splitPaste(sDocument, characterElement, paragraphElement, position, pasteHtmlTextModified, HTMLText.containsParagraphTags(pasteHtmlTextModified));
        int paragraphOldEndOffset = paragraphElement.getEndOffset();
        int oldCaretPosition = this.getCaretPosition();
        sDocument.setOuterHTML(paragraphElement, newHtml);
        Element newParagraphElement = this.getDocument().getParagraphElement(oldCaretPosition);
        this.setCaretPosition(oldCaretPosition + newParagraphElement.getEndOffset() - paragraphOldEndOffset);
    }

    public void initDnd() {
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SHTMLEditorPane.this.this_mouseReleased(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SHTMLEditorPane.this.this_mouseClicked(e);
            }
        });
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        int selStart = this.getSelectionStart();
        try {
            if (this.lastSelEnd > this.lastSelStart && selStart >= this.lastSelStart && selStart < this.lastSelEnd) {
                this.dragStartedHere = true;
                this.select(this.lastSelStart, this.lastSelEnd);
                HTMLText text = new HTMLText();
                int start = this.getSelectionStart();
                text.copyHTML(this, start, this.getSelectionEnd() - start);
                HTMLTextSelection trans = new HTMLTextSelection(text);
                this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, trans, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        this.dragStartedHere = false;
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        this.dndEventLocation = this.viewToModel(event.getLocation());
        try {
            this.setCaretPosition(this.dndEventLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent event) {
        this.dndEventLocation = this.viewToModel(event.getLocation());
        if (this.dndEventLocation >= this.lastSelStart && this.dndEventLocation <= this.lastSelEnd) {
            event.rejectDrop();
            this.select(this.lastSelStart, this.lastSelEnd);
        } else {
            SHTMLDocument doc = this.getDocument();
            doc.startCompoundEdit();
            try {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(this.htmlTextDataFlavor)) {
                    event.acceptDrop(2);
                    HTMLText s = (HTMLText)transferable.getTransferData(this.htmlTextDataFlavor);
                    this.doDrop(event, s);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    event.acceptDrop(2);
                    String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.doDrop(event, s);
                } else {
                    event.rejectDrop();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                event.rejectDrop();
            }
            finally {
                doc.endCompoundEdit();
            }
        }
    }

    private void doDrop(DropTargetDropEvent event, Object s) {
        int removeOffset = 0;
        int moveOffset = 0;
        this.setCaretPosition(this.dndEventLocation);
        if (s instanceof HTMLText) {
            this.replaceSelection((HTMLText)s);
        } else if (s instanceof String) {
            this.replaceSelection((String)s);
        }
        if (this.dndEventLocation < this.lastSelStart) {
            removeOffset = s.toString().length();
        } else {
            moveOffset = s.toString().length();
        }
        int newSelEnd = this.dndEventLocation + (this.lastSelEnd - this.lastSelStart) - moveOffset;
        int newSelStart = this.dndEventLocation - moveOffset;
        if (this.dragStartedHere) {
            this.lastSelStart += removeOffset;
            this.lastSelEnd += removeOffset;
            this.select(this.lastSelStart, this.lastSelEnd);
            this.replaceSelection("");
        }
        this.lastSelEnd = newSelEnd;
        this.lastSelStart = newSelStart;
        this.select(this.lastSelStart, this.lastSelEnd);
        event.getDropTargetContext().dropComplete(true);
    }

    void this_mouseReleased(MouseEvent e) {
        this.lastSelStart = this.getSelectionStart();
        this.lastSelEnd = this.getSelectionEnd();
    }

    void this_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.lastSelStart = this.getSelectionStart();
            this.lastSelEnd = this.getSelectionEnd();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public TransferHandler getTransferHandler() {
        final TransferHandler defaultTransferHandler = super.getTransferHandler();
        if (defaultTransferHandler == null) {
            return null;
        }
        class LocalTransferHandler
        extends TransferHandler {
            LocalTransferHandler() {
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                return defaultTransferHandler.canImport(comp, transferFlavors);
            }

            @Override
            public void exportAsDrag(JComponent comp, InputEvent e, int action) {
                defaultTransferHandler.exportAsDrag(comp, e, action);
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                SHTMLDocument document = SHTMLEditorPane.this.getDocument();
                if (document.getParagraphElement(SHTMLEditorPane.this.getSelectionStart()) != document.getParagraphElement(SHTMLEditorPane.this.getSelectionEnd())) {
                    defaultTransferHandler.exportToClipboard(comp, clip, action);
                    return;
                }
                try {
                    HTMLText htmlText = new HTMLText();
                    int start = SHTMLEditorPane.this.getSelectionStart();
                    htmlText.copyHTML(SHTMLEditorPane.this, start, SHTMLEditorPane.this.getSelectionEnd() - start);
                    final HTMLTextSelection additionalContents = new HTMLTextSelection(htmlText);
                    Clipboard temp = new Clipboard("");
                    defaultTransferHandler.exportToClipboard(comp, temp, action);
                    final Transferable defaultContents = temp.getContents(this);
                    if (defaultContents == null) {
                        return;
                    }
                    clip.setContents(new Transferable(){

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            DataFlavor[] defaultFlavors = defaultContents.getTransferDataFlavors();
                            DataFlavor[] additionalFlavors = additionalContents.getTransferDataFlavors();
                            DataFlavor[] resultFlavor = new DataFlavor[defaultFlavors.length + additionalFlavors.length];
                            System.arraycopy(defaultFlavors, 0, resultFlavor, 0, defaultFlavors.length);
                            System.arraycopy(additionalFlavors, 0, resultFlavor, defaultFlavors.length, additionalFlavors.length);
                            return resultFlavor;
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return additionalContents.isDataFlavorSupported(flavor) || defaultContents.isDataFlavorSupported(flavor);
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            if (additionalContents.isDataFlavorSupported(flavor)) {
                                return additionalContents.getTransferData(flavor);
                            }
                            return defaultContents.getTransferData(flavor);
                        }
                    }, null);
                }
                catch (Exception e) {
                    SHTMLEditorPane.this.getToolkit().beep();
                }
            }

            @Override
            public int getSourceActions(JComponent c) {
                return defaultTransferHandler.getSourceActions(c);
            }

            @Override
            public Icon getVisualRepresentation(Transferable t) {
                return defaultTransferHandler.getVisualRepresentation(t);
            }

            @Override
            public boolean importData(JComponent comp, Transferable transferable) {
                SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
                doc.startCompoundEdit();
                boolean result = false;
                try {
                    if (SHTMLEditorPane.this.getPasteMode() == PasteMode.PASTE_PLAIN_TEXT) {
                        String content = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                        if (content != null) {
                            SHTMLEditorPane.this.replaceSelection(content);
                        }
                        result = true;
                    } else if (transferable.isDataFlavorSupported(SHTMLEditorPane.this.htmlTextDataFlavor)) {
                        HTMLText htmlText = (HTMLText)transferable.getTransferData(SHTMLEditorPane.this.htmlTextDataFlavor);
                        SHTMLEditorPane.this.replaceSelection(htmlText);
                        result = true;
                    } else {
                        DataFlavor htmlFlavor = SHTMLEditorPane.getSupportedHtmlFlavor(transferable);
                        String stringContent = null;
                        String htmlContent = null;
                        if (htmlFlavor != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            htmlContent = (String)transferable.getTransferData(htmlFlavor);
                            if (htmlContent.charAt(0) == '\ufffd') {
                                return this.importDataWithoutHtmlFlavor(comp, transferable);
                            }
                            stringContent = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            String bodyContent = new Remover(htmlContent).removeFirstAndBefore("body").removeLastAndAfter("/body").getProcessedText().replaceAll("<!--(?:Start|End)Fragment-->", "");
                            HTMLText htmlText = new HTMLText(bodyContent, stringContent);
                            doc.copyingExternalImages(Util.getPreference("images_copied_by_editor", CopiedImageSources.ANY_ABSOLUTE_URL), () -> SHTMLEditorPane.this.replaceSelection(htmlText));
                            result = true;
                        } else {
                            result = this.importExternalData(comp, transferable);
                        }
                    }
                }
                catch (Exception e) {
                    SHTMLEditorPane.this.getToolkit().beep();
                }
                doc.endCompoundEdit();
                return result;
            }

            private boolean importExternalData(JComponent comp, Transferable t) throws ClassNotFoundException, UnsupportedFlavorException, IOException {
                String s;
                DataFlavor htmlFlavor = new DataFlavor("text/html; class=java.lang.String");
                if (t.isDataFlavorSupported(htmlFlavor) && (s = (String)t.getTransferData(htmlFlavor)).charAt(0) == '\ufffd') {
                    return this.importDataWithoutHtmlFlavor(comp, t);
                }
                return this.defaultImportData(comp, t);
            }

            private boolean importDataWithoutHtmlFlavor(JComponent comp, final Transferable t) {
                return this.defaultImportData(comp, new Transferable(){

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        if (this.isValid(flavor)) {
                            return t.getTransferData(flavor);
                        }
                        throw new UnsupportedFlavorException(flavor);
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        DataFlavor[] transferDataFlavors = t.getTransferDataFlavors();
                        int counter = 0;
                        for (int i = 0; i < transferDataFlavors.length; ++i) {
                            if (!this.isValid(transferDataFlavors[i])) continue;
                            ++counter;
                        }
                        DataFlavor[] validDataFlavors = new DataFlavor[counter];
                        int j = 0;
                        for (int i = 0; i < transferDataFlavors.length; ++i) {
                            DataFlavor flavor = transferDataFlavors[i];
                            if (!this.isValid(flavor)) continue;
                            validDataFlavors[j++] = flavor;
                        }
                        return validDataFlavors;
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return this.isValid(flavor) && t.isDataFlavorSupported(flavor);
                    }

                    private boolean isValid(DataFlavor flavor) {
                        return !flavor.isMimeTypeEqual("text/html");
                    }
                });
            }

            private boolean defaultImportData(JComponent comp, Transferable t) {
                return defaultTransferHandler.importData(comp, t);
            }
        }
        return new LocalTransferHandler();
    }

    public void removeCharacterAttributes() {
        int p1;
        int p0 = this.getSelectionStart();
        if (p0 != (p1 = this.getSelectionEnd())) {
            SHTMLDocument doc = this.getDocument();
            doc.startCompoundEdit();
            SHTMLEditorKit.removeCharacterAttributes(doc, null, p0, p1 - p0);
            doc.endCompoundEdit();
        }
    }

    public void removeParagraphAttributes() {
        int p0 = this.getSelectionStart();
        int p1 = this.getSelectionEnd();
        SHTMLDocument doc = this.getDocument();
        doc.removeParagraphAttributes(p0, p1 - p0 + 1);
        this.select(p0, p1);
    }

    public void applyAttributes(AttributeSet attributeSet, boolean applyToCompleteParagraph) {
        this.applyAttributes(attributeSet, applyToCompleteParagraph, false);
    }

    public void applyAttributes(AttributeSet attributeSet, boolean applyToCompleteParagraph, boolean replace) {
        SHTMLDocument doc = this.getDocument();
        this.requestFocus();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        if (applyToCompleteParagraph) {
            doc.setParagraphAttributes(selectionStart, selectionEnd - selectionStart, attributeSet, replace);
        } else if (selectionEnd != selectionStart) {
            doc.setCharacterAttributes(selectionStart, selectionEnd - selectionStart, attributeSet, replace);
        } else {
            MutableAttributeSet inputAttributes = ((SHTMLEditorKit)this.getEditorKit()).getInputAttributes();
            inputAttributes.addAttributes(attributeSet);
        }
    }

    public void applyCharacterTag(String tag) {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        SHTMLDocument doc = this.getDocument();
        doc.startCompoundEdit();
        doc.endCompoundEdit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyParagraphTag(String tag, Vector overwritableTags) {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        StringWriter stringWriter = new StringWriter();
        SHTMLDocument doc = this.getDocument();
        try {
            doc.startCompoundEdit();
            SHTMLWriter writer = new SHTMLWriter((Writer)stringWriter, doc);
            Element paragraphElement = doc.getParagraphElement(selectionStart);
            int regionStart = paragraphElement.getStartOffset();
            int regionEnd = Math.max(paragraphElement.getEndOffset(), selectionEnd);
            Element parentOfparagraphElement = paragraphElement.getParentElement();
            int replaceStart = -1;
            int replaceEnd = -1;
            int index = -1;
            int elementsToRemoveCount = 0;
            int elementCount = parentOfparagraphElement.getElementCount();
            for (int i = 0; i < elementCount; ++i) {
                Element child = parentOfparagraphElement.getElement(i);
                int elementStart = child.getStartOffset();
                int elementEnd = child.getEndOffset();
                if ((elementStart < regionStart || elementStart >= regionEnd) && (elementEnd <= regionEnd || elementEnd > regionEnd)) continue;
                ++elementsToRemoveCount;
                if (overwritableTags.contains(child.getName())) {
                    writer.writeStartTag(tag, child.getAttributes());
                    writer.writeChildElements(child);
                    writer.writeEndTag(tag);
                } else if (child.getName().equals(HTML.Tag.IMPLIED.toString()) && elementsContainingParagraphs.contains(parentOfparagraphElement.getName())) {
                    writer.writeStartTag(tag, null);
                    writer.write(child);
                    writer.writeEndTag(tag);
                } else {
                    writer.write(child);
                    continue;
                }
                if (index < 0) {
                    index = i;
                }
                if (replaceStart < 0 || replaceStart > elementStart) {
                    replaceStart = elementStart;
                }
                if (replaceEnd >= 0 && replaceEnd >= elementEnd) continue;
                replaceEnd = elementEnd;
            }
            if (index > -1) {
                doc.insertAfterEnd(parentOfparagraphElement.getElement(index), stringWriter.getBuffer().toString());
                doc.removeElements(parentOfparagraphElement, index, elementsToRemoveCount);
            }
        }
        catch (Exception e) {
            Util.errMsg(this, e.getMessage(), e);
        }
        finally {
            doc.endCompoundEdit();
        }
    }

    private void performToggleListAction(ActionEvent e, String elemName) {
        if (elemName.equalsIgnoreCase(HTML.Tag.UL.toString())) {
            if (toggleBulletListAction == null) {
                Component c = (Component)e.getSource();
                SHTMLPanelImpl panel = SHTMLPanelImpl.getOwnerSHTMLPanel(c);
                toggleBulletListAction = panel.dynRes.getAction("toggleBullets");
            }
            toggleBulletListAction.actionPerformed(e);
        } else if (elemName.equalsIgnoreCase(HTML.Tag.OL.toString())) {
            if (toggleNumberListAction == null) {
                Component c = (Component)e.getSource();
                SHTMLPanelImpl panel = SHTMLPanelImpl.getOwnerSHTMLPanel(c);
                toggleNumberListAction = panel.dynRes.getAction("toggleNumbers");
            }
            toggleNumberListAction.actionPerformed(e);
        }
    }

    void updateInputAttributes() {
        ((SHTMLEditorKit)this.getEditorKit()).updateInputAttributes(this);
        this.fireCaretUpdate(new CaretEvent(this){

            @Override
            public int getDot() {
                return SHTMLEditorPane.this.getSelectionStart();
            }

            @Override
            public int getMark() {
                return SHTMLEditorPane.this.getSelectionEnd();
            }
        });
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public void setPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    private boolean caretWithinTableCell() {
        Element tableCell = this.getCurrentTableCell();
        return tableCell != null;
    }

    public String elementToHTML(Element element) {
        SHTMLDocument document = this.getDocument();
        StringWriter stringWriter = new StringWriter();
        SHTMLWriter shtmlWriter = new SHTMLWriter((Writer)stringWriter, document);
        try {
            shtmlWriter.write(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.getBuffer().toString();
    }

    private boolean elementIsEmptyParagraph(Element element) {
        String elementContent = this.elementToHTML(element);
        return elementContent.matches("(?ims)\\s*<p[^>]*>\\s*</p>\\s*");
    }

    private void performDefaultKeyStrokeAction(int keyCode, int modifiers, ActionEvent event) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        Object key = this.getInputMap().getParent().get(keyStroke);
        if (key != null) {
            this.getActionMap().getParent().get(key).actionPerformed(event);
        }
    }

    public boolean tryDefaultKeyStrokeActionWithinCell(int keyCode, int modifiers, ActionEvent event) {
        int originalCaretPosition = this.getCaretPosition();
        Element cellElement = this.getCurrentTableCell();
        this.performDefaultKeyStrokeAction(keyCode, modifiers, event);
        Element cellElementAfter = this.getCurrentTableCell();
        if (cellElement == cellElementAfter) {
            return true;
        }
        this.setCaretPosition(originalCaretPosition);
        return false;
    }

    @Override
    public String getSelectedText() {
        String text = super.getSelectedText();
        return text != null ? text.replace('\u00a0', ' ') : null;
    }

    private class ListManager {
        private ListManager() {
        }

        private Element getParagraphElement(int pos) {
            Element paragraphElement = SHTMLEditorPane.this.getDocument().getParagraphElement(pos);
            if (paragraphElement.getName().equalsIgnoreCase("p-implied")) {
                paragraphElement = paragraphElement.getParentElement();
            }
            return paragraphElement;
        }

        private Element getListParent(Element elem) {
            Element listParent = elem.getParentElement();
            if (elem.getName().equalsIgnoreCase(HTML.Tag.LI.toString())) {
                listParent = listParent.getParentElement();
            }
            return listParent;
        }

        private Element getListItemElement(int caretPosition) {
            Element paragraphElement = this.getParagraphElement(caretPosition);
            return Util.findElementUp(HTML.Tag.LI.toString(), paragraphElement);
        }

        private Element getListElement(int caretPosition) {
            Element paragraphElement = this.getParagraphElement(caretPosition);
            return Util.findElementUp("ul", "ol", paragraphElement);
        }

        private boolean isValidParentElement(Element e) {
            String name = e.getName();
            return name.equalsIgnoreCase(HTML.Tag.BODY.toString()) || name.equalsIgnoreCase(HTML.Tag.TD.toString()) || name.equalsIgnoreCase(HTML.Tag.LI.toString());
        }

        private boolean isValidElement(Element e) {
            String name = e.getName();
            return name.equalsIgnoreCase(HTML.Tag.P.toString()) || name.equalsIgnoreCase(HTML.Tag.UL.toString()) || name.equalsIgnoreCase(HTML.Tag.OL.toString()) || name.equalsIgnoreCase(HTML.Tag.H1.toString()) || name.equalsIgnoreCase(HTML.Tag.H2.toString()) || name.equalsIgnoreCase(HTML.Tag.H3.toString()) || name.equalsIgnoreCase(HTML.Tag.H4.toString()) || name.equalsIgnoreCase(HTML.Tag.H5.toString()) || name.equalsIgnoreCase(HTML.Tag.H6.toString());
        }

        private boolean isListRootElement(Element e) {
            String name = e.getName();
            return name.equalsIgnoreCase(HTML.Tag.UL.toString()) || name.equalsIgnoreCase(HTML.Tag.OL.toString());
        }

        private void listOff() throws IOException, BadLocationException {
            int elementIdx;
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            int selectionEnd = SHTMLEditorPane.this.getSelectionEnd();
            Element firstParagraphElement = this.getParagraphElement(selectionStart);
            int fistParagraphElementStart = firstParagraphElement.getStartOffset();
            int lastParagraphElementEnd = this.getParagraphElement(selectionEnd).getEndOffset();
            Element parentOfTheListElement = this.getListParent(firstParagraphElement);
            if (this.isListElement(parentOfTheListElement)) {
                return;
            }
            SHTMLWriter sHTMLwriter = new SHTMLWriter(SHTMLEditorPane.this.getDocument());
            Element nextElement = null;
            for (elementIdx = 0; elementIdx < parentOfTheListElement.getElementCount() && (nextElement = parentOfTheListElement.getElement(elementIdx)).getEndOffset() <= fistParagraphElementStart; ++elementIdx) {
            }
            Element startElementToBeReplaced = nextElement;
            int nrElementsToBeReplaced = 1;
            int listItemIdx = 0;
            Element listItemElement = null;
            if (nextElement.getStartOffset() < fistParagraphElementStart) {
                sHTMLwriter.writeStartTag(nextElement);
                ++elementIdx;
                while ((listItemElement = nextElement.getElement(listItemIdx)).getStartOffset() != fistParagraphElementStart) {
                    sHTMLwriter.write(listItemElement);
                    ++listItemIdx;
                }
                sHTMLwriter.writeEndTag(nextElement);
                while (listItemIdx < nextElement.getElementCount() && (listItemElement = nextElement.getElement(listItemIdx)).getStartOffset() < lastParagraphElementEnd) {
                    sHTMLwriter.writeStartTag("p", null);
                    sHTMLwriter.writeChildElements(listItemElement);
                    sHTMLwriter.writeEndTag("p");
                    ++listItemIdx;
                }
            }
            if (nextElement.getEndOffset() <= lastParagraphElementEnd) {
                while (elementIdx < parentOfTheListElement.getElementCount() && (nextElement = parentOfTheListElement.getElement(elementIdx)).getEndOffset() <= lastParagraphElementEnd) {
                    if (nextElement != startElementToBeReplaced && nextElement.getStartOffset() < lastParagraphElementEnd) {
                        ++nrElementsToBeReplaced;
                    }
                    if (this.isListRootElement(nextElement)) {
                        for (listItemIdx = 0; listItemIdx < nextElement.getElementCount(); ++listItemIdx) {
                            sHTMLwriter.writeStartTag("p", null);
                            sHTMLwriter.writeChildElements(nextElement.getElement(listItemIdx));
                            sHTMLwriter.writeEndTag("p");
                        }
                    } else {
                        sHTMLwriter.writeStartTag("p", null);
                        sHTMLwriter.writeChildElements(nextElement);
                        sHTMLwriter.writeEndTag("p");
                    }
                    ++elementIdx;
                }
            }
            if (elementIdx <= parentOfTheListElement.getElementCount() && nextElement.getStartOffset() < lastParagraphElementEnd) {
                if (nextElement != startElementToBeReplaced) {
                    ++nrElementsToBeReplaced;
                }
                while (listItemIdx < nextElement.getElementCount() && (listItemElement = nextElement.getElement(listItemIdx)).getStartOffset() < lastParagraphElementEnd) {
                    sHTMLwriter.writeStartTag("p", null);
                    sHTMLwriter.writeChildElements(listItemElement);
                    sHTMLwriter.writeEndTag("p");
                    ++listItemIdx;
                }
                if (listItemIdx < nextElement.getElementCount()) {
                    sHTMLwriter.writeStartTag(nextElement);
                    while (listItemIdx < nextElement.getElementCount()) {
                        listItemElement = nextElement.getElement(listItemIdx);
                        sHTMLwriter.write(listItemElement);
                        ++listItemIdx;
                    }
                    sHTMLwriter.writeEndTag(nextElement);
                }
            }
            SHTMLEditorPane.this.getDocument().replaceHTML(startElementToBeReplaced, nrElementsToBeReplaced, sHTMLwriter.getWrittenString());
        }

        private void listOn(String listTag, AttributeSet attributeSet, boolean forceOff) throws IOException, BadLocationException {
            int i;
            Element after;
            Element listRoot;
            Element before;
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            int selectionEnd = SHTMLEditorPane.this.getSelectionEnd();
            Element firstParagraphElement = this.getParagraphElement(selectionStart);
            int fistParagraphElementStart = firstParagraphElement.getStartOffset();
            int lastParagraphElementEnd = this.getParagraphElement(selectionEnd).getEndOffset();
            Element parentElement = this.getListParent(firstParagraphElement);
            Element startElementToBeRemoved = null;
            int removeCount = 0;
            SHTMLWriter writer = new SHTMLWriter(SHTMLEditorPane.this.getDocument());
            if (fistParagraphElementStart > 0 && (before = this.getParagraphElement(fistParagraphElementStart - 1)).getName().equalsIgnoreCase(HTML.Tag.LI.toString()) && (listRoot = before.getParentElement()).getParentElement() == parentElement && listRoot.getName().equalsIgnoreCase(listTag)) {
                fistParagraphElementStart = listRoot.getStartOffset();
            }
            if (lastParagraphElementEnd < SHTMLEditorPane.this.getDocument().getLength() - 1 && (after = this.getParagraphElement(lastParagraphElementEnd)).getName().equalsIgnoreCase(HTML.Tag.LI.toString()) && (listRoot = after.getParentElement()).getParentElement() == parentElement && listRoot.getName().equalsIgnoreCase(listTag)) {
                lastParagraphElementEnd = listRoot.getEndOffset();
            }
            Element next = null;
            for (i = 0; i < parentElement.getElementCount() && (next = parentElement.getElement(i)).getEndOffset() <= fistParagraphElementStart; ++i) {
            }
            startElementToBeRemoved = next;
            removeCount = 1;
            int j = 0;
            Element li = null;
            if (next.getStartOffset() < fistParagraphElementStart) {
                ++i;
                writer.writeStartTag(next);
                while ((li = next.getElement(j)).getStartOffset() != fistParagraphElementStart) {
                    writer.write(li);
                    ++j;
                }
                writer.writeEndTag(next);
                writer.writeStartTag(listTag, attributeSet);
                while (j < next.getElementCount() && (li = next.getElement(j)).getStartOffset() < lastParagraphElementEnd) {
                    writer.write(li);
                    ++j;
                }
            } else {
                writer.writeStartTag(listTag, attributeSet);
            }
            if (next.getEndOffset() <= lastParagraphElementEnd) {
                while (i < parentElement.getElementCount() && (next = parentElement.getElement(i)).getEndOffset() <= lastParagraphElementEnd) {
                    if (startElementToBeRemoved != next && next.getStartOffset() < lastParagraphElementEnd) {
                        ++removeCount;
                    }
                    if (this.isListRootElement(next)) {
                        writer.writeChildElements(next);
                    } else {
                        writer.writeStartTag("li", null);
                        writer.writeChildElements(next);
                        writer.writeEndTag("li");
                    }
                    ++i;
                }
            }
            if (i < parentElement.getElementCount() && next.getStartOffset() < lastParagraphElementEnd) {
                if (startElementToBeRemoved != next) {
                    ++removeCount;
                }
                while (j < next.getElementCount() && (li = next.getElement(j)).getStartOffset() < lastParagraphElementEnd) {
                    writer.write(li);
                    ++j;
                }
                writer.writeEndTag(listTag);
                if (j < next.getElementCount()) {
                    writer.writeStartTag(next);
                    while (j < next.getElementCount()) {
                        li = next.getElement(j);
                        writer.write(li);
                        ++j;
                    }
                    writer.writeEndTag(next);
                }
            } else {
                writer.writeEndTag(listTag);
            }
            SHTMLEditorPane.this.getDocument().replaceHTML(startElementToBeRemoved, removeCount, writer.getWrittenString());
        }

        private boolean switchOn(String listTag, AttributeSet attributeSet, boolean forceOff, int start, int end, Element parentElement) throws SwitchListException {
            boolean listOn = false;
            int count = parentElement.getElementCount();
            for (int i = 0; i < count && !listOn; ++i) {
                Element elem = parentElement.getElement(i);
                if (elem.getStartOffset() >= start && elem.getEndOffset() <= end && !this.isValidElement(elem)) {
                    throw new SwitchListException();
                }
                int eStart = elem.getStartOffset();
                int eEnd = elem.getEndOffset();
                if (elem.getName().equalsIgnoreCase(listTag) || !(eStart > start && eStart < end || eEnd > start && eEnd < end) && (start < eStart || end > eEnd)) continue;
                listOn = true;
            }
            return listOn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleList(String listTag, AttributeSet attributeSet, boolean forceOff) {
            try {
                Element last;
                int selectionStart = SHTMLEditorPane.this.getSelectionStart();
                int selectionEnd = SHTMLEditorPane.this.getSelectionEnd();
                Element firstParagraphElement = this.getParagraphElement(selectionStart);
                int fistParagraphElementStart = firstParagraphElement.getStartOffset();
                int lastParagraphElementEnd = this.getParagraphElement(selectionEnd).getEndOffset();
                Element parentElement = this.getListParent(firstParagraphElement);
                SHTMLEditorPane.this.getDocument().startCompoundEdit();
                if (selectionStart != selectionEnd && parentElement != this.getListParent(last = this.getParagraphElement(lastParagraphElementEnd - 1))) {
                    throw new SwitchListException();
                }
                if (!this.switchOn(listTag, attributeSet, forceOff, fistParagraphElementStart, lastParagraphElementEnd, parentElement) || forceOff) {
                    this.listOff();
                } else {
                    this.listOn(listTag, attributeSet, forceOff);
                }
                if (selectionStart == selectionEnd) {
                    SHTMLEditorPane.this.setCaretPosition(selectionStart);
                } else {
                    SHTMLEditorPane.this.select(selectionStart, selectionEnd);
                }
                SHTMLEditorPane.this.requestFocus();
            }
            catch (SwitchListException selectionStart) {
            }
            catch (Exception e) {
                Util.errMsg(null, e.getMessage(), e);
            }
            finally {
                SHTMLEditorPane.this.getDocument().endCompoundEdit();
            }
        }

        private boolean isListElement(Element element) {
            return "ul".equalsIgnoreCase(element.getName()) || "ol".equalsIgnoreCase(element.getName());
        }

        private boolean isListItemElement(Element element) {
            return "li".equalsIgnoreCase(element.getName());
        }

        private boolean caretAtTheBeginningOfListItem() {
            Element parent = SHTMLEditorPane.this.getCurrentParagraphElement().getParentElement();
            return "li".equalsIgnoreCase(parent.getName()) && SHTMLEditorPane.this.getCaretPosition() == parent.getStartOffset();
        }

        private boolean caretWithinListItem() {
            Element currentParagraphElement = SHTMLEditorPane.this.getCurrentParagraphElement();
            if (currentParagraphElement == null) {
                return false;
            }
            Element parent = currentParagraphElement.getParentElement();
            return parent != null && "li".equalsIgnoreCase(parent.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void increaseIndent(boolean includingSubitems) {
            int selectionEnd;
            Element paragraphElement = SHTMLEditorPane.this.getCurrentParagraphElement();
            Element listItemElement = paragraphElement.getParentElement();
            if (!this.isListItemElement(listItemElement)) {
                return;
            }
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            if (selectionStart == (selectionEnd = SHTMLEditorPane.this.getSelectionEnd()) || this.getListElement(selectionStart) != this.getListElement(selectionEnd)) {
                selectionStart = SHTMLEditorPane.this.getCaretPosition();
                selectionEnd = SHTMLEditorPane.this.getCaretPosition();
            }
            Element list = this.getListElement(selectionStart);
            int indexOfSelectionStart = list.getElementIndex(selectionStart);
            int indexOfSelectionEnd = list.getElementIndex(selectionEnd);
            try {
                int i;
                SHTMLEditorPane.this.getDocument().startCompoundEdit();
                SHTMLWriter writer = new SHTMLWriter(SHTMLEditorPane.this.getDocument());
                writer.writeStartTag(list);
                for (int i2 = 0; i2 < indexOfSelectionStart - 1; ++i2) {
                    writer.write(list.getElement(i2));
                }
                Element tagModel = null;
                tagModel = indexOfSelectionStart > 0 && this.isListElement(list.getElement(indexOfSelectionStart - 1)) ? list.getElement(indexOfSelectionStart - 1) : (indexOfSelectionEnd + 1 < list.getElementCount() && this.isListElement(list.getElement(indexOfSelectionEnd + 1)) ? list.getElement(indexOfSelectionEnd + 1) : list);
                if (indexOfSelectionStart == 0) {
                    return;
                }
                Element newParentListItem = list.getElement(indexOfSelectionStart - 1);
                writer.writeStartTag(newParentListItem);
                writer.writeChildElements(newParentListItem);
                writer.writeStartTag(tagModel);
                for (i = indexOfSelectionStart; i <= indexOfSelectionEnd; ++i) {
                    int j;
                    if (includingSubitems) {
                        writer.write(list.getElement(i));
                        continue;
                    }
                    Element listItem = list.getElement(i);
                    writer.writeStartTag(listItem);
                    for (j = 0; j < listItem.getElementCount(); ++j) {
                        if (this.isListElement(listItem.getElement(j))) continue;
                        writer.write(listItem.getElement(j));
                    }
                    writer.writeEndTag(listItem);
                    for (j = 0; j < listItem.getElementCount(); ++j) {
                        if (!this.isListElement(listItem.getElement(j))) continue;
                        writer.writeChildElements(listItem.getElement(j));
                    }
                }
                writer.writeEndTag(tagModel);
                writer.writeEndTag(newParentListItem);
                for (i = indexOfSelectionEnd + 1; i < list.getElementCount(); ++i) {
                    writer.write(list.getElement(i));
                }
                writer.writeEndTag(list);
                String newContent = writer.getWrittenString().replaceAll("(?ims)</ul>\\s*<ul[^>]*>", "").replaceAll("(?ims)</ol>\\s*<ol[^>]*>", "");
                SHTMLEditorPane.this.getDocument().setOuterHTML(list, newContent);
                SHTMLEditorPane.this.select(selectionStart, selectionEnd);
            }
            catch (Exception exception) {
            }
            finally {
                SHTMLEditorPane.this.getDocument().endCompoundEdit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decreaseIndent(boolean includingSubitems) {
            int selectionEnd;
            Element paragraphElement = SHTMLEditorPane.this.getCurrentParagraphElement();
            Element parent = paragraphElement.getParentElement();
            if (!this.isListItemElement(parent)) {
                return;
            }
            Element list = parent.getParentElement();
            Element outerListItem = list.getParentElement();
            if (!this.isListItemElement(outerListItem)) {
                return;
            }
            Element outerList = outerListItem.getParentElement();
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            if (selectionStart == (selectionEnd = SHTMLEditorPane.this.getSelectionEnd()) || this.getListElement(selectionStart) != this.getListElement(selectionEnd)) {
                selectionStart = SHTMLEditorPane.this.getCaretPosition();
                selectionEnd = SHTMLEditorPane.this.getCaretPosition();
            }
            int indexOfSelectionStart = list.getElementIndex(selectionStart);
            int indexOfSelectionEnd = list.getElementIndex(selectionEnd);
            int indexOfSelectionInOuterItem = outerListItem.getElementIndex(selectionStart);
            int indexOfSelectionInOuterList = outerList.getElementIndex(selectionStart);
            try {
                int i;
                SHTMLEditorPane.this.getDocument().startCompoundEdit();
                SHTMLWriter writer = new SHTMLWriter(SHTMLEditorPane.this.getDocument());
                writer.writeStartTag(outerList);
                for (i = 0; i < indexOfSelectionInOuterList; ++i) {
                    writer.write(outerList.getElement(i));
                }
                writer.writeStartTag(outerListItem);
                for (i = 0; i < indexOfSelectionInOuterItem; ++i) {
                    writer.write(outerListItem.getElement(i));
                }
                if (indexOfSelectionStart > 0) {
                    writer.writeStartTag(list);
                    for (i = 0; i < indexOfSelectionStart; ++i) {
                        writer.write(list.getElement(i));
                    }
                    writer.writeEndTag(list);
                }
                writer.writeEndTag(outerListItem);
                for (i = indexOfSelectionStart; i <= indexOfSelectionEnd - 1; ++i) {
                    if (includingSubitems) {
                        writer.write(list.getElement(i));
                        continue;
                    }
                    this.writeListItemForDecreaseIndent(writer, list.getElement(i), includingSubitems, false);
                }
                this.writeListItemForDecreaseIndent(writer, list.getElement(indexOfSelectionEnd), includingSubitems, true);
                if (indexOfSelectionEnd + 1 < list.getElementCount()) {
                    writer.writeStartTag(list);
                    for (i = indexOfSelectionEnd + 1; i < list.getElementCount(); ++i) {
                        writer.write(list.getElement(i));
                    }
                    writer.writeEndTag(list);
                }
                writer.writeEndTag(list.getElement(indexOfSelectionEnd));
                if (indexOfSelectionInOuterItem + 1 < outerListItem.getElementCount()) {
                    writer.writeStartTag(outerListItem);
                    for (i = indexOfSelectionInOuterItem + 1; i < outerListItem.getElementCount(); ++i) {
                        writer.write(outerListItem.getElement(i));
                    }
                    writer.writeEndTag(outerListItem);
                }
                for (i = indexOfSelectionInOuterList + 1; i < outerList.getElementCount(); ++i) {
                    writer.write(outerList.getElement(i));
                }
                writer.writeEndTag(outerList);
                String newContent = writer.getWrittenString().replaceAll("(?ims)</ul>\\s*<ul>", "").replaceAll("(?ims)</ol>\\s*<ol>", "");
                SHTMLEditorPane.this.getDocument().setOuterHTML(outerList, newContent);
                SHTMLEditorPane.this.select(selectionStart, selectionEnd);
            }
            catch (Exception exception) {
            }
            finally {
                SHTMLEditorPane.this.getDocument().endCompoundEdit();
            }
        }

        private void writeListItemForDecreaseIndent(SHTMLWriter writer, Element listItem, boolean includingSubitems, boolean withoutEndTag) {
            try {
                writer.writeStartTag(listItem);
                if (includingSubitems) {
                    writer.writeChildElements(listItem);
                } else {
                    int j;
                    boolean childListItemsPresent = false;
                    for (j = 0; j < listItem.getElementCount(); ++j) {
                        if (this.isListElement(listItem.getElement(j))) {
                            childListItemsPresent = true;
                            continue;
                        }
                        writer.write(listItem.getElement(j));
                    }
                    if (childListItemsPresent) {
                        writer.writeStartTag(listItem.getParentElement());
                        for (j = 0; j < listItem.getElementCount(); ++j) {
                            if (!this.isListElement(listItem.getElement(j))) continue;
                            writer.write(listItem.getElement(j));
                        }
                        writer.writeEndTag(listItem.getParentElement());
                    }
                }
                if (!withoutEndTag) {
                    writer.writeEndTag(listItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean deleteNextChar(ActionEvent actionEvent) {
            Element paragraphElement;
            boolean emptyParagraph;
            int nextPosition = SHTMLEditorPane.this.getCaretPosition() + 1;
            SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
            Element listAtNextPosition = this.getListElement(nextPosition);
            Element listItemAtNextPosition = this.getListItemElement(nextPosition);
            if (listAtNextPosition != null && listItemAtNextPosition != null && listItemAtNextPosition.getStartOffset() < listAtNextPosition.getStartOffset()) {
                return false;
            }
            if (listAtNextPosition != null && listAtNextPosition.getStartOffset() == nextPosition) {
                boolean isSurroundingList;
                if (!this.caretWithinListItem()) {
                    if (SHTMLEditorPane.this.elementIsEmptyParagraph(SHTMLEditorPane.this.getCurrentParagraphElement())) {
                        return false;
                    }
                    this.mergeSecondElementIntoFirst(this.getParagraphElement(SHTMLEditorPane.this.getCaretPosition()), listItemAtNextPosition);
                    return true;
                }
                Element listAtCaret = this.getListElement(SHTMLEditorPane.this.getCaretPosition());
                boolean bl = isSurroundingList = listAtCaret.getStartOffset() <= listAtNextPosition.getStartOffset() && listAtCaret.getEndOffset() >= listAtNextPosition.getEndOffset();
                if (isSurroundingList) {
                    this.mergeNestedListItemIntoParent(this.getListItemElement(SHTMLEditorPane.this.getCaretPosition()), listItemAtNextPosition);
                    return true;
                }
                return false;
            }
            if (this.caretWithinListItem() && (emptyParagraph = SHTMLEditorPane.this.elementIsEmptyParagraph(paragraphElement = SHTMLEditorPane.this.getCurrentParagraphElement()))) {
                SHTMLEditorPane.this.removeElement(paragraphElement);
                return true;
            }
            if (listItemAtNextPosition != null && listItemAtNextPosition.getStartOffset() == nextPosition) {
                this.mergeSecondElementIntoFirst(this.getListItemElement(SHTMLEditorPane.this.getCaretPosition()), listItemAtNextPosition);
                return true;
            }
            Element listElementAtCurrentPosition = this.getListElement(SHTMLEditorPane.this.getCaretPosition());
            Element parentElementOfNextPosition = doc.getParagraphElement(nextPosition).getParentElement();
            if (listElementAtCurrentPosition != null && !this.isListItemElement(parentElementOfNextPosition)) {
                if ("body".equalsIgnoreCase(parentElementOfNextPosition.getName()) || SHTMLEditorPane.this.getTableCell(SHTMLEditorPane.this.getCaretPosition()) == SHTMLEditorPane.this.getTableCell(nextPosition)) {
                    this.mergeSecondElementIntoFirst(this.getListItemElement(SHTMLEditorPane.this.getCaretPosition()), this.getParagraphElement(nextPosition));
                } else {
                    SHTMLEditorPane.this.performDefaultKeyStrokeAction(39, 0, actionEvent);
                }
                return true;
            }
            return false;
        }

        private boolean deletePrevChar(ActionEvent actionEvent) {
            Element paragraphElement;
            boolean emptyParagraph;
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            Element list = this.getListElement(selectionStart);
            Element listItemAtSelectionStart = this.getListItemElement(selectionStart);
            if (list != null && listItemAtSelectionStart != null && listItemAtSelectionStart.getStartOffset() < list.getStartOffset()) {
                return false;
            }
            if (list != null && list.getStartOffset() == selectionStart) {
                boolean isSurroundingList;
                Element listAtPrevPosition;
                Element element = listAtPrevPosition = selectionStart == 0 ? null : this.getListElement(selectionStart - 1);
                if (listAtPrevPosition == null) {
                    SHTMLEditorPane.this.performToggleListAction(actionEvent, list.getName());
                    return true;
                }
                boolean bl = isSurroundingList = listAtPrevPosition.getStartOffset() <= list.getStartOffset() && listAtPrevPosition.getEndOffset() >= list.getEndOffset();
                if (isSurroundingList) {
                    this.mergeNestedListItemIntoParent(this.getListItemElement(selectionStart - 1), listItemAtSelectionStart);
                    return true;
                }
                return false;
            }
            if (this.caretWithinListItem() && (emptyParagraph = SHTMLEditorPane.this.elementIsEmptyParagraph(paragraphElement = SHTMLEditorPane.this.getCurrentParagraphElement()))) {
                SHTMLEditorPane.this.removeElement(paragraphElement);
                SHTMLEditorPane.this.setCaretPosition(SHTMLEditorPane.this.getCaretPosition() - 1);
                return true;
            }
            if (listItemAtSelectionStart != null && listItemAtSelectionStart.getStartOffset() == selectionStart) {
                int previousPosition = listItemAtSelectionStart.getStartOffset() - 1;
                this.mergeSecondElementIntoFirst(this.getListItemElement(previousPosition), listItemAtSelectionStart);
                SHTMLEditorPane.this.setCaretPosition(previousPosition);
                return true;
            }
            if (selectionStart > 0) {
                int previousPosition = selectionStart - 1;
                Element listElementAtPreviousPosition = this.getListElement(previousPosition);
                Element parentElement = SHTMLEditorPane.this.getCurrentParagraphElement().getParentElement();
                if (listElementAtPreviousPosition != null && !"li".equalsIgnoreCase(parentElement.getName())) {
                    if ("body".equalsIgnoreCase(parentElement.getName()) || SHTMLEditorPane.this.getTableCell(previousPosition) == SHTMLEditorPane.this.getTableCell(selectionStart)) {
                        this.mergeSecondElementIntoFirst(this.getListItemElement(previousPosition), this.getParagraphElement(selectionStart));
                    } else {
                        SHTMLEditorPane.this.performDefaultKeyStrokeAction(37, 0, actionEvent);
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean containsNestedListItems(Element listItem) {
            for (int i = 0; i < listItem.getElementCount(); ++i) {
                if (!this.isListElement(listItem.getElement(i))) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mergeSecondElementIntoFirst(Element first, Element second) {
            SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
            SHTMLWriter writer = new SHTMLWriter(doc);
            doc.startCompoundEdit();
            try {
                int finalCaretPosition = first.getEndOffset() - 1;
                writer.writeStartTag(first);
                writer.writeChildElements(first);
                writer.removeLastWrittenNewline();
                writer.writeChildElements(second);
                writer.writeEndTag(first);
                SHTMLEditorPane.this.getDocument().setOuterHTML(first, writer.getWrittenString());
                SHTMLEditorPane.this.removeElement(second);
                finalCaretPosition = Math.min(finalCaretPosition, first.getEndOffset() - 1);
                SHTMLEditorPane.this.setCaretPosition(finalCaretPosition);
            }
            catch (IOException | BadLocationException e) {
                e.printStackTrace();
            }
            finally {
                doc.endCompoundEdit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mergeNestedListItemIntoParent(Element parentListItem, Element childListItem) {
            SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
            SHTMLWriter writer = new SHTMLWriter(doc);
            doc.startCompoundEdit();
            try {
                int i;
                if (!this.isListItemElement(parentListItem)) {
                    return;
                }
                int finalCaretPosition = parentListItem.getElement(0).getEndOffset() - 1;
                writer.writeStartTag(parentListItem);
                for (i = 0; i < parentListItem.getElementCount(); ++i) {
                    if (this.isListElement(parentListItem.getElement(i))) continue;
                    writer.write(parentListItem.getElement(i));
                }
                writer.removeLastWrittenNewline();
                writer.writeChildElements(childListItem);
                for (i = 0; i < parentListItem.getElementCount(); ++i) {
                    Element list;
                    if (!this.isListElement(parentListItem.getElement(i)) || (list = parentListItem.getElement(i)).getElementCount() < 2) continue;
                    writer.writeStartTag(list);
                    for (int j = 0; j < list.getElementCount(); ++j) {
                        if (list.getElement(j) == childListItem) continue;
                        writer.write(list.getElement(j));
                    }
                    writer.writeEndTag(list);
                }
                writer.writeEndTag(parentListItem);
                SHTMLEditorPane.this.getDocument().setOuterHTML(parentListItem, writer.getWrittenString());
                SHTMLEditorPane.this.setCaretPosition(finalCaretPosition);
            }
            catch (IOException | BadLocationException e) {
                e.printStackTrace();
            }
            finally {
                doc.endCompoundEdit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void newListItem() {
            block12: {
                SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
                int caretPosition = SHTMLEditorPane.this.getCaretPosition();
                Element listItemElement = SHTMLEditorPane.this.listManager.getListItemElement(caretPosition);
                if (listItemElement == null) {
                    return;
                }
                try {
                    int eo;
                    String listItemContent = SHTMLEditorPane.this.elementToHTML(listItemElement);
                    if (listItemContent.matches("(?ims)\\s*<li[^>]*>\\s*</li>\\s*")) {
                        this.toggleList("", null, true);
                        return;
                    }
                    int so = listItemElement.getStartOffset();
                    if (so == (eo = listItemElement.getEndOffset())) break block12;
                    StringWriter stringWriter = new StringWriter();
                    SHTMLWriter writer = new SHTMLWriter((Writer)stringWriter, doc);
                    writer.writeStartTag(listItemElement);
                    if (caretPosition > so) {
                        SHTMLWriter htmlStartWriter = new SHTMLWriter((Writer)stringWriter, doc, so, caretPosition - so);
                        htmlStartWriter.writeChildElements(listItemElement);
                    }
                    writer.writeEndTag(listItemElement);
                    writer.writeStartTag(listItemElement);
                    if (!this.containsNestedListItems(listItemElement) || listItemElement.getElement(0).getEndOffset() - 1 == caretPosition) {
                        // empty if block
                    }
                    if (caretPosition < eo - 1) {
                        SHTMLWriter htmlEndWriter = new SHTMLWriter((Writer)stringWriter, doc, caretPosition, eo - caretPosition);
                        htmlEndWriter.writeChildElements(listItemElement);
                    }
                    writer.writeEndTag(listItemElement);
                    String text = stringWriter.toString();
                    try {
                        doc.startCompoundEdit();
                        doc.setOuterHTML(listItemElement, text);
                    }
                    catch (Exception e) {
                        Util.errMsg(null, e.getMessage(), e);
                    }
                    finally {
                        doc.endCompoundEdit();
                    }
                    SHTMLEditorPane.this.setCaretPosition(caretPosition + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        class SwitchListException
        extends Exception {
            SwitchListException() {
            }
        }
    }

    private class InsertLineBreakAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            block10: {
                try {
                    int eo;
                    int so;
                    SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
                    int caretPosition = SHTMLEditorPane.this.getCaretPosition();
                    Element paragraphElement = doc.getParagraphElement(caretPosition);
                    if (paragraphElement == null || (so = paragraphElement.getStartOffset()) == (eo = paragraphElement.getEndOffset())) break block10;
                    StringWriter writer = new StringWriter();
                    if (caretPosition > so) {
                        SHTMLWriter htmlStartWriter = new SHTMLWriter((Writer)writer, doc, so, caretPosition - so);
                        htmlStartWriter.writeChildElements(paragraphElement);
                    }
                    if (!doc.getCharacterElement(caretPosition).getName().equalsIgnoreCase(HTML.Tag.BR.toString())) {
                        writer.write("<br>");
                    }
                    if (caretPosition < eo - 1) {
                        SHTMLWriter htmlEndWriter = new SHTMLWriter((Writer)writer, doc, caretPosition, eo - caretPosition);
                        htmlEndWriter.writeChildElements(paragraphElement);
                    }
                    String text = writer.toString();
                    try {
                        doc.startCompoundEdit();
                        doc.setInnerHTML(paragraphElement, text);
                    }
                    catch (Exception e) {
                        Util.errMsg(null, e.getMessage(), e);
                    }
                    finally {
                        doc.endCompoundEdit();
                    }
                    SHTMLEditorPane.this.setCaretPosition(caretPosition + 1);
                }
                catch (Exception e) {
                    Util.errMsg(null, e.getMessage(), e);
                }
            }
        }
    }

    private class ShiftTabAction
    extends AbstractAction {
        public ShiftTabAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SHTMLEditorPane.this.listManager.caretAtTheBeginningOfListItem()) {
                SHTMLEditorPane.this.listManager.decreaseIndent(true);
                return;
            }
            Element cell = SHTMLEditorPane.this.getCurrentTableCell();
            if (cell != null) {
                SHTMLEditorPane.this.goPrevCell(cell);
                return;
            }
            if (SHTMLEditorPane.this.listManager.caretWithinListItem()) {
                SHTMLEditorPane.this.listManager.decreaseIndent(true);
                return;
            }
            SHTMLEditorPane.this.performDefaultKeyStrokeAction(9, 1, ae);
        }
    }

    private class TabAction
    extends AbstractAction {
        public TabAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SHTMLEditorPane.this.listManager.caretAtTheBeginningOfListItem()) {
                SHTMLEditorPane.this.listManager.increaseIndent(true);
                return;
            }
            Element cell = SHTMLEditorPane.this.getCurrentTableCell();
            if (cell != null) {
                SHTMLEditorPane.this.goNextCell(cell);
                return;
            }
            if (SHTMLEditorPane.this.listManager.caretWithinListItem()) {
                SHTMLEditorPane.this.listManager.increaseIndent(true);
                return;
            }
            if (Util.preferenceIsTrue("table.insertNewOnTabKey", "false")) {
                SHTMLEditorPane.this.insertNewTable(3);
            }
        }
    }

    private class NewParagraphAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                int caretPosition = SHTMLEditorPane.this.getCaretPosition();
                Element listItemElement = SHTMLEditorPane.this.listManager.getListItemElement(caretPosition);
                if (listItemElement != null) {
                    SHTMLEditorPane.this.listManager.newListItem();
                    return;
                }
                SHTMLEditorPane.this.performDefaultKeyStrokeAction(10, 0, ae);
            }
            catch (Exception e) {
                Util.errMsg(null, e.getMessage(), e);
            }
        }
    }

    private class ShiftEndAction
    extends AbstractAction {
        private ShiftEndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SHTMLEditorPane.this.caretWithinTableCell()) {
                int originalCaretPosition = SHTMLEditorPane.this.getCaretPosition();
                if (SHTMLEditorPane.this.tryDefaultKeyStrokeActionWithinCell(35, 1, e)) {
                    return;
                }
                int newCaretPosition = SHTMLEditorPane.this.getCurrentParagraphElement().getEndOffset() - 1;
                if (newCaretPosition > originalCaretPosition) {
                    SHTMLEditorPane.this.select(originalCaretPosition, newCaretPosition);
                } else {
                    SHTMLEditorPane.this.select(newCaretPosition, originalCaretPosition);
                }
            } else {
                SHTMLEditorPane.this.performDefaultKeyStrokeAction(35, 1, e);
            }
        }
    }

    private class ShiftHomeAction
    extends AbstractAction {
        private ShiftHomeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SHTMLEditorPane.this.caretWithinTableCell()) {
                int originalCaretPosition = SHTMLEditorPane.this.getCaretPosition();
                if (SHTMLEditorPane.this.tryDefaultKeyStrokeActionWithinCell(36, 1, e)) {
                    return;
                }
                int newCaretPosition = SHTMLEditorPane.this.getCurrentParagraphElement().getStartOffset();
                if (newCaretPosition > originalCaretPosition) {
                    SHTMLEditorPane.this.select(originalCaretPosition, newCaretPosition);
                } else {
                    SHTMLEditorPane.this.select(newCaretPosition, originalCaretPosition);
                }
            } else {
                SHTMLEditorPane.this.performDefaultKeyStrokeAction(36, 1, e);
            }
        }
    }

    private class EndAction
    extends AbstractAction {
        private EndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SHTMLEditorPane.this.caretWithinTableCell()) {
                if (SHTMLEditorPane.this.tryDefaultKeyStrokeActionWithinCell(35, 0, e)) {
                    return;
                }
                SHTMLEditorPane.this.setCaretPosition(SHTMLEditorPane.this.getCurrentParagraphElement().getEndOffset() - 1);
            } else {
                SHTMLEditorPane.this.performDefaultKeyStrokeAction(35, 0, e);
            }
        }
    }

    private class HomeAction
    extends AbstractAction {
        private HomeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SHTMLEditorPane.this.caretWithinTableCell()) {
                if (SHTMLEditorPane.this.tryDefaultKeyStrokeActionWithinCell(36, 0, e)) {
                    return;
                }
                SHTMLEditorPane.this.setCaretPosition(SHTMLEditorPane.this.getCurrentParagraphElement().getStartOffset());
            } else {
                SHTMLEditorPane.this.performDefaultKeyStrokeAction(36, 0, e);
            }
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SHTMLEditorPane.this.caretWithinTableCell()) {
                if (SHTMLEditorPane.this.tryDefaultKeyStrokeActionWithinCell(40, 0, e)) {
                    return;
                }
                Element cellElement = SHTMLEditorPane.this.getCurrentTableCell();
                Element rowElement = cellElement.getParentElement();
                Element tableElement = rowElement.getParentElement();
                int cellIndexInRow = rowElement.getElementIndex(cellElement.getStartOffset());
                int rowIndexInTable = tableElement.getElementIndex(rowElement.getStartOffset());
                if (rowIndexInTable < tableElement.getElementCount() - 1) {
                    Element nextRowElement = tableElement.getElement(rowIndexInTable + 1);
                    int elementCount = nextRowElement.getElementCount();
                    if (elementCount > 0) {
                        Element targetCellElement = nextRowElement.getElement(Math.min(elementCount, cellIndexInRow));
                        SHTMLEditorPane.this.setCaretPosition(targetCellElement.getStartOffset() - 1);
                    } else {
                        SHTMLEditorPane.this.setCaretPosition(tableElement.getEndOffset() - 1);
                    }
                } else {
                    SHTMLEditorPane.this.setCaretPosition(tableElement.getEndOffset() - 1);
                }
            }
            SHTMLEditorPane.this.performDefaultKeyStrokeAction(40, 0, e);
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SHTMLEditorPane.this.caretWithinTableCell()) {
                if (SHTMLEditorPane.this.getCaretPosition() == 0) {
                    Element tableElement = SHTMLEditorPane.this.getCurrentTableCell().getParentElement().getParentElement();
                    try {
                        SHTMLEditorPane.this.getDocument().insertBeforeStart(tableElement, "<p></p>");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (SHTMLEditorPane.this.tryDefaultKeyStrokeActionWithinCell(38, 0, e)) {
                    return;
                }
                Element cellElement = SHTMLEditorPane.this.getCurrentTableCell();
                Element rowElement = cellElement.getParentElement();
                Element tableElement = rowElement.getParentElement();
                int cellIndexInRow = rowElement.getElementIndex(cellElement.getStartOffset());
                int rowIndexInTable = tableElement.getElementIndex(rowElement.getStartOffset());
                if (rowIndexInTable > 0) {
                    Element previousRowElement = tableElement.getElement(rowIndexInTable - 1);
                    int elementCount = previousRowElement.getElementCount();
                    if (elementCount > 0) {
                        Element targetCellElement = previousRowElement.getElement(Math.min(elementCount, cellIndexInRow));
                        SHTMLEditorPane.this.setCaretPosition(targetCellElement.getEndOffset());
                    } else {
                        SHTMLEditorPane.this.setCaretPosition(tableElement.getStartOffset());
                    }
                } else {
                    SHTMLEditorPane.this.setCaretPosition(tableElement.getStartOffset());
                }
            }
            SHTMLEditorPane.this.performDefaultKeyStrokeAction(38, 0, e);
        }
    }

    private class DeleteNextCharAction
    extends AbstractAction {
        private DeleteNextCharAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            if (selectionStart == SHTMLEditorPane.this.getSelectionEnd()) {
                SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
                if (selectionStart >= doc.getLastDocumentPosition() - 1) {
                    return;
                }
                boolean intervention = this.treatTables(actionEvent);
                if (intervention) {
                    return;
                }
                intervention = SHTMLEditorPane.this.listManager.deleteNextChar(actionEvent);
                if (intervention) {
                    return;
                }
            }
            SHTMLEditorPane.this.performDefaultKeyStrokeAction(127, 0, actionEvent);
        }

        private boolean treatTables(ActionEvent event) {
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            int nextPosition = selectionStart + 1;
            Element elem = null;
            SHTMLDocument doc = SHTMLEditorPane.this.getDocument();
            elem = SHTMLEditorPane.this.getCurrentTableCell();
            if (elem == null || elem.getEndOffset() == nextPosition) {
                // empty if block
            }
            if (nextPosition < doc.getLength() && (elem = SHTMLEditorPane.this.getTableCell(nextPosition)) != null && elem.getStartOffset() == nextPosition) {
                Element paragraphElement = SHTMLEditorPane.this.getCurrentParagraphElement();
                boolean emptyParagraph = SHTMLEditorPane.this.elementIsEmptyParagraph(paragraphElement);
                if (!SHTMLEditorPane.this.caretWithinTableCell() && emptyParagraph) {
                    return false;
                }
                if (SHTMLEditorPane.this.caretWithinTableCell() && emptyParagraph) {
                    SHTMLEditorPane.this.removeElement(paragraphElement);
                    SHTMLEditorPane.this.setCaretPosition(SHTMLEditorPane.this.getCaretPosition() - 1);
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    private class DeletePrevCharAction
    extends AbstractAction {
        private DeletePrevCharAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SHTMLDocument doc;
            int selectionStart = SHTMLEditorPane.this.getSelectionStart();
            int selectionEnd = SHTMLEditorPane.this.getSelectionEnd();
            if (selectionEnd >= (doc = SHTMLEditorPane.this.getDocument()).getLastDocumentPosition()) {
                return;
            }
            if (selectionStart == selectionEnd) {
                Element tableCell;
                boolean intervention = SHTMLEditorPane.this.listManager.deletePrevChar(actionEvent);
                if (intervention) {
                    return;
                }
                Element element = tableCell = selectionStart == 0 ? null : SHTMLEditorPane.this.getTableCell(selectionStart - 1);
                if (tableCell != null && tableCell.getEndOffset() == selectionStart) {
                    SHTMLEditorPane.this.performDefaultKeyStrokeAction(37, 0, actionEvent);
                    return;
                }
            }
            SHTMLEditorPane.this.performDefaultKeyStrokeAction(8, 0, actionEvent);
        }
    }

    private class MyNavigationFilter
    extends NavigationFilter {
        private MyNavigationFilter() {
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            dot = SHTMLEditorPane.this.getValidPosition(dot);
            super.moveDot(fb, dot, bias);
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            dot = SHTMLEditorPane.this.getValidPosition(dot);
            super.setDot(fb, dot, bias);
        }
    }

    public static enum PasteMode {
        PASTE_HTML("Paste as HTML"),
        PASTE_PLAIN_TEXT("Paste as plain-text");

        private final String displayName;

        private PasteMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public PasteMode invert() {
            if (this == PASTE_HTML) {
                return PASTE_PLAIN_TEXT;
            }
            if (this == PASTE_PLAIN_TEXT) {
                return PASTE_HTML;
            }
            throw new RuntimeException("Expected value for SHTMLEditorPane.PasteMode: " + this.name());
        }

        static PasteMode getPasteModeFromPrefs() {
            return Util.getPreference("default_paste_mode", PASTE_HTML);
        }
    }
}

