/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLDocument;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;

public class SHTMLWriter
extends HTMLWriter {
    private static final char NB_SPACE = '\u00a0';
    private Element element;
    private Writer writer = null;
    private boolean replaceEntities;
    private boolean inTextArea;
    private int inPreLevel = 0;
    private char[] tempChars;
    private static final Map<Character, String> HTML_CHAR_ENTITIES = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('<'), "&lt;");
            this.put(Character.valueOf('>'), "&gt;");
            this.put(Character.valueOf('&'), "&amp;");
            this.put(Character.valueOf('\"'), "&quot;");
            this.put(Character.valueOf('<'), "&lt;");
            this.put(Character.valueOf('\u00a0'), "&nbsp;");
        }
    };
    private final Vector<HTML.Tag> tags = new Vector(10);
    private final Vector<Object> tagValues = new Vector(10);
    private final Vector<HTML.Tag> tagsToRemove = new Vector(10);
    private final MutableAttributeSet convAttr = new SimpleAttributeSet();
    private static final Object[][] explicitTags = new Object[][]{{CSS.Attribute.FONT_WEIGHT, "bold", HTML.Tag.B}, {CSS.Attribute.FONT_STYLE, "italic", HTML.Tag.I}, {CSS.Attribute.TEXT_DECORATION, "underline", HTML.Tag.U}, {CSS.Attribute.TEXT_DECORATION, "line-through", HTML.Tag.STRIKE}, {CSS.Attribute.VERTICAL_ALIGN, "sup", HTML.Tag.SUP}, {CSS.Attribute.VERTICAL_ALIGN, "sub", HTML.Tag.SUB}, {CSS.Attribute.TEXT_DECORATION, "line-through", HTML.Tag.STRIKE}};

    public SHTMLWriter(Writer w, HTMLDocument doc, int pos, int len) {
        super(w, doc, pos, len);
        this.writer = w;
    }

    public SHTMLWriter(HTMLDocument doc) {
        this((Writer)new StringWriter(), doc);
    }

    public SHTMLWriter(Writer w, HTMLDocument doc) {
        this(w, doc, 0, doc instanceof SHTMLDocument ? ((SHTMLDocument)doc).getLastDocumentPosition() : doc.getLength());
    }

    @Override
    protected ElementIterator getElementIterator() {
        if (this.element == null) {
            return super.getElementIterator();
        }
        return new ElementIterator(this.element);
    }

    @Override
    protected void output(char[] chars, int start, int length) throws IOException {
        if (!this.replaceEntities) {
            this.directOutput(chars, start, length);
            return;
        }
        if (this.inPreLevel == 0) {
            this.replaceMultipleSpacesByNonBreakingSpaces(chars, start, length);
        }
        this.outputEscaped(chars, start, length);
    }

    private void outputEscaped(char[] chars, int start, int length) throws IOException {
        int last = start;
        length += start;
        for (int counter = start; counter < length; ++counter) {
            char c = chars[counter];
            String replacement = this.entity(c);
            if (replacement == null) continue;
            this.directOutput(chars, last, counter - last);
            this.directOutput(replacement);
            last = counter + 1;
        }
        if (last < length) {
            this.directOutput(chars, last, length - last);
        }
    }

    protected String entity(char c) {
        if (c < ' ') {
            return "&#x" + Integer.toHexString(c) + ';';
        }
        return HTML_CHAR_ENTITIES.get(Character.valueOf(c));
    }

    private void replaceMultipleSpacesByNonBreakingSpaces(char[] chars, int start, int length) {
        if (chars[start] == ' ') {
            chars[start] = 160;
        }
        int last = start + length - 1;
        for (int i = start + 1; i < last; ++i) {
            if (chars[i] != ' ' || chars[i - 1] != '\u00a0' && chars[i + 1] != ' ') continue;
            chars[i] = 160;
        }
    }

    private void directOutput(char[] content, int start, int length) throws IOException {
        this.getWriter().write(content, start, length);
        this.setCurrentLineLength(this.getCurrentLineLength() + length);
    }

    private void directOutput(String string) throws IOException {
        int length = string.length();
        if (this.tempChars == null || this.tempChars.length < length) {
            this.tempChars = new char[length];
        }
        string.getChars(0, length, this.tempChars, 0);
        this.directOutput(this.tempChars, 0, length);
    }

    @Override
    protected void startTag(Element elem) throws IOException, BadLocationException {
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PRE)) {
            ++this.inPreLevel;
        }
        super.startTag(elem);
    }

    @Override
    protected void endTag(Element elem) throws IOException {
        if (this.matchNameAttribute(elem.getAttributes(), HTML.Tag.PRE)) {
            --this.inPreLevel;
        }
        super.endTag(elem);
    }

    @Override
    protected void text(Element elem) throws BadLocationException, IOException {
        boolean replaceEntitiesOld = this.replaceEntities;
        this.replaceEntities = true;
        super.text(elem);
        this.replaceEntities = replaceEntitiesOld;
    }

    @Override
    protected void textAreaContent(AttributeSet attr) throws BadLocationException, IOException {
        boolean replaceEntitiesOld = this.replaceEntities;
        this.inTextArea = true;
        this.replaceEntities = true;
        super.textAreaContent(attr);
        this.inTextArea = false;
        this.replaceEntities = replaceEntitiesOld;
    }

    @Override
    public void write() throws IOException, BadLocationException {
        this.replaceEntities = false;
        super.write();
    }

    @Override
    protected void writeLineSeparator() throws IOException {
        boolean pre = this.replaceEntities;
        this.replaceEntities = false;
        super.writeLineSeparator();
        this.replaceEntities = pre;
    }

    @Override
    protected void indent() throws IOException {
        if (this.inTextArea) {
            return;
        }
        boolean pre = this.replaceEntities;
        this.replaceEntities = false;
        super.indent();
        this.replaceEntities = pre;
    }

    synchronized void write(Element element) throws IOException, BadLocationException {
        this.element = element;
        try {
            this.write();
        }
        catch (IOException | BadLocationException e) {
            element = null;
            throw e;
        }
    }

    public void writeChildElements(Element parentElement) throws IOException, BadLocationException {
        for (int i = 0; i < parentElement.getElementCount(); ++i) {
            Element childElement = parentElement.getElement(i);
            this.write(childElement);
        }
    }

    private static void convertStyleToHTMLStyle(AttributeSet source, MutableAttributeSet target) {
        if (source == null) {
            return;
        }
        Enumeration<?> sourceAttributeNames = source.getAttributeNames();
        String value = "";
        while (sourceAttributeNames.hasMoreElements()) {
            Object sourceAttributeName = sourceAttributeNames.nextElement();
            if (sourceAttributeName instanceof CSS.Attribute) {
                if (!value.isEmpty()) {
                    value = value + "; ";
                }
                value = value + sourceAttributeName + ": " + source.getAttribute(sourceAttributeName);
                continue;
            }
            target.addAttribute(sourceAttributeName, source.getAttribute(sourceAttributeName));
        }
        if (!value.isEmpty()) {
            target.addAttribute(HTML.Attribute.STYLE, value);
        }
    }

    @Override
    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Element element;
        Object endTag;
        Object nameTag = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
        Object object = endTag = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
        if (nameTag != null && endTag != null && endTag instanceof String && endTag.equals("true")) {
            return;
        }
        if (attributeSet instanceof Element && ((element = (Element)((Object)attributeSet)).isLeaf() || element.getName().equalsIgnoreCase("p-implied"))) {
            this.superWriteAttributes(attributeSet);
            return;
        }
        SimpleAttributeSet convertedAttributeSet = new SimpleAttributeSet();
        SHTMLWriter.convertStyleToHTMLStyle(attributeSet, convertedAttributeSet);
        Enumeration<?> attributeNames = convertedAttributeSet.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object attributeName = attributeNames.nextElement();
            if (attributeName instanceof HTML.Tag || attributeName instanceof StyleConstants || attributeName == HTML.Attribute.ENDTAG) continue;
            Object attributeValue = convertedAttributeSet.getAttribute(attributeName);
            this.writeAttribute(attributeName, attributeValue);
        }
    }

    private void superWriteAttributes(AttributeSet attr) throws IOException {
        attr = this.convertToHTML(attr);
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object attributeName = names.nextElement();
            if (attributeName instanceof HTML.Tag || attributeName instanceof StyleConstants || attributeName == HTML.Attribute.ENDTAG) continue;
            Object attributeValue = attr.getAttribute(attributeName);
            this.writeAttribute(attributeName, attributeValue);
        }
    }

    private void writeAttribute(Object attributeName, Object attributeValue) throws IOException {
        this.write(" " + attributeName + "=\"");
        this.writeEscaped(String.valueOf(attributeValue));
        this.write("\"");
    }

    private void writeEscaped(String content) throws IOException {
        int size = content.length();
        if (this.tempChars == null || this.tempChars.length < size) {
            this.tempChars = new char[size];
        }
        content.getChars(0, size, this.tempChars, 0);
        this.outputEscaped(this.tempChars, 0, size);
    }

    private void writeElementsUntil(Element e, Element end) throws IOException, BadLocationException {
        if (e.isLeaf()) {
            this.write(e);
        } else if (e != end) {
            this.startTag(e);
            int childCount = e.getElementCount();
            for (int index = 0; index < childCount; ++index) {
                this.writeElementsUntil(e.getElement(index), end);
            }
            this.endTag(e);
        }
    }

    void write(Element startElement, Element endElement) throws IOException, BadLocationException {
        Element parentElement = startElement.getParentElement();
        int count = parentElement.getElementCount();
        int i = 0;
        Element e = parentElement.getElement(i);
        while (i < count && e != startElement) {
            e = parentElement.getElement(i++);
        }
        while (i < count) {
            this.writeElementsUntil(e, endElement);
            e = parentElement.getElement(i++);
        }
    }

    void writeStartTag(Element elem) throws IOException, BadLocationException {
        super.startTag(elem);
    }

    void writeEndTag(Element elem) throws IOException {
        super.endTag(elem);
    }

    void writeEndTag(String elementName) throws IOException {
        this.indent();
        this.write('<');
        this.write('/');
        this.write(elementName);
        this.write('>');
        this.writeLineSeparator();
    }

    void writeStartTag(String elementName, AttributeSet attributes) throws IOException {
        this.indent();
        this.write('<');
        this.write(elementName);
        if (attributes != null) {
            this.writeAttributes(attributes);
        }
        this.write('>');
        this.writeLineSeparator();
    }

    @Override
    public void write(String string) throws IOException {
        this.writer.write(string);
    }

    public String toString() {
        if (this.writer instanceof StringWriter) {
            StringWriter stringWriter = (StringWriter)this.writer;
            return stringWriter.getBuffer().toString();
        }
        return super.toString();
    }

    String getWrittenString() {
        if (this.writer instanceof StringWriter) {
            StringWriter stringWriter = (StringWriter)this.writer;
            return stringWriter.getBuffer().toString();
        }
        return null;
    }

    void removeLastWrittenNewline() {
        if (this.writer instanceof StringWriter) {
            StringWriter stringWriter = (StringWriter)this.writer;
            int charIdx = stringWriter.getBuffer().length();
            while (stringWriter.getBuffer().charAt(--charIdx) <= '\r') {
                stringWriter.getBuffer().deleteCharAt(charIdx);
            }
        }
    }

    @Override
    protected void writeEmbeddedTags(AttributeSet attr) throws IOException {
        AttributeSet htmlAttr = this.convertToHTML(attr);
        Enumeration<?> names = htmlAttr.getAttributeNames();
        while (names.hasMoreElements()) {
            HTML.Tag tag;
            Object name = names.nextElement();
            if (!(name instanceof HTML.Tag) || (tag = (HTML.Tag)name) == HTML.Tag.FORM || this.tags.contains(tag)) continue;
            this.write('<');
            this.write(tag.toString());
            Object o = htmlAttr.getAttribute(tag);
            if (o != null && o instanceof AttributeSet) {
                this.writeAttributes((AttributeSet)o);
            }
            this.write('>');
            this.tags.addElement(tag);
            this.tagValues.addElement(o);
        }
    }

    @Override
    protected void closeOutUnwantedEmbeddedTags(AttributeSet attr) throws IOException {
        HTML.Tag t;
        this.tagsToRemove.removeAllElements();
        attr = this.convertToHTML(attr);
        int firstIndex = -1;
        int size = this.tags.size();
        for (int i = size - 1; i >= 0; --i) {
            t = this.tags.elementAt(i);
            Object tValue = this.tagValues.elementAt(i);
            if (attr != null && !this.noMatchForTagInAttributes(attr, t, tValue)) continue;
            firstIndex = i;
            this.tagsToRemove.addElement(t);
        }
        if (firstIndex != -1) {
            int i;
            boolean removeAll = size - firstIndex == this.tagsToRemove.size();
            for (i = size - 1; i >= firstIndex; --i) {
                t = this.tags.elementAt(i);
                if (removeAll || this.tagsToRemove.contains(t)) {
                    this.tags.removeElementAt(i);
                    this.tagValues.removeElementAt(i);
                }
                this.write('<');
                this.write('/');
                this.write(t.toString());
                this.write('>');
            }
            size = this.tags.size();
            for (i = firstIndex; i < size; ++i) {
                t = this.tags.elementAt(i);
                this.write('<');
                this.write(t.toString());
                Object o = this.tagValues.elementAt(i);
                if (o != null && o instanceof AttributeSet) {
                    this.writeAttributes((AttributeSet)o);
                }
                this.write('>');
            }
        }
    }

    private boolean noMatchForTagInAttributes(AttributeSet attr, HTML.Tag t, Object tagValue) {
        if (attr != null && attr.isDefined(t)) {
            Object newValue = attr.getAttribute(t);
            if (tagValue == null ? newValue == null : newValue != null && tagValue.equals(newValue)) {
                return false;
            }
        }
        return true;
    }

    private AttributeSet convertToHTML(AttributeSet attr) {
        this.convAttr.removeAttributes(this.convAttr);
        this.convertToHTML40(attr, this.convAttr);
        return this.convAttr;
    }

    private void convertToHTML40(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object attributeValue = from.getAttribute(key);
            if (key == CSS.Attribute.FONT_SIZE) {
                attributeValue = this.cssFontSizeFromHtmlFont(attributeValue);
            }
            if (key instanceof CSS.Attribute) {
                if (SHTMLWriter.containsExplicitTag(from.getAttributeNames(), (CSS.Attribute)key, attributeValue)) continue;
                value = (value.isEmpty() ? key : value + " " + key) + ": " + attributeValue + ";";
                continue;
            }
            if (key == HTML.Tag.FONT) continue;
            to.addAttribute(key, attributeValue);
        }
        if (!value.isEmpty()) {
            if (this.matchNameAttribute(from, HTML.Tag.CONTENT)) {
                SimpleAttributeSet styleAttribute = new SimpleAttributeSet();
                styleAttribute.addAttribute(HTML.Attribute.STYLE, value);
                to.addAttribute(HTML.Tag.SPAN, styleAttribute);
            } else {
                to.addAttribute(HTML.Attribute.STYLE, value);
            }
        }
    }

    private Object cssFontSizeFromHtmlFont(Object cssFontSizeValue) {
        if (cssFontSizeValue == null) {
            return null;
        }
        String cssFontSizeString = cssFontSizeValue.toString();
        if (cssFontSizeString.length() != 1) {
            return cssFontSizeValue;
        }
        int fontSizeIndex = cssFontSizeString.charAt(0) - 49;
        String[] cssFontSizes = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
        if (fontSizeIndex >= 0 && fontSizeIndex < cssFontSizes.length) {
            return cssFontSizes[fontSizeIndex];
        }
        return cssFontSizeValue;
    }

    private static boolean containsExplicitTag(Enumeration<?> keys, CSS.Attribute key, Object attributeValue) {
        for (Object[] cssTagTripple : explicitTags) {
            if (key != cssTagTripple[0] || !attributeValue.toString().equals(cssTagTripple[1])) continue;
            return SHTMLWriter.containsValue(keys, cssTagTripple[2]);
        }
        return false;
    }

    private static boolean containsValue(Enumeration<?> values, Object value) {
        while (values.hasMoreElements()) {
            if (!values.nextElement().equals(value)) continue;
            return true;
        }
        return false;
    }
}

