/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.Util;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.CSS;

class SizeSelectorPanel
extends JPanel
implements AttributeComponent,
ActionListener {
    private final Object attributeKey;
    private final Object htmlAttrKey;
    private final JSpinner valueSelector;
    private JComboBox unitSelector;
    private JLabel unitName;
    private int setValueCalls = 0;
    private int originalValue = 0;
    private String originalUnit;
    private boolean allowNegative = false;
    public static final String UNIT_PT = "pt";
    public static final String UNIT_PERCENT = "%";
    public static final String[] UNIT_VALUES = new String[]{"pt", "%"};
    public static final int UNIT_TYPE_PT = 0;
    public static final int UNIT_TYPE_PERCENT = 1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_LABEL = 1;
    public static final int TYPE_COMBO = 2;

    public SizeSelectorPanel(Object key, Object htmlKey, boolean allowNegative) {
        super(new FlowLayout());
        this.attributeKey = key;
        this.htmlAttrKey = htmlKey;
        this.valueSelector = new JSpinner(new SpinnerNumberModel());
        this.add(this.valueSelector);
        this.originalUnit = this.getUnit();
        this.allowNegative = allowNegative;
    }

    public SizeSelectorPanel(Object key, Object htmlKey, boolean allowNegative, int type) {
        this(key, htmlKey, allowNegative);
        switch (type) {
            case 1: {
                this.unitName = new JLabel(UNIT_PT);
                this.add(this.unitName);
                break;
            }
            case 2: {
                this.unitSelector = new JComboBox<String>(UNIT_VALUES);
                this.unitSelector.addActionListener(this);
                this.add(this.unitSelector);
            }
        }
        this.originalUnit = this.getUnit();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.unitSelector)) {
            this.adjustMinMax(this.unitSelector.getSelectedItem().toString());
        }
    }

    public void setValue(String val) {
        String unit = null;
        int newVal = 0;
        float aVal = Util.getAbsoluteAttrVal(val);
        unit = Util.getLastAttrUnit();
        this.adjustMinMax(unit);
        if (this.unitSelector != null) {
            this.unitSelector.setSelectedItem(unit);
        } else if (this.unitName != null) {
            this.unitName.setText(unit);
        }
        newVal = (int)aVal;
        this.valueSelector.setValue(newVal);
        if (++this.setValueCalls < 2) {
            this.originalValue = newVal;
            this.originalUnit = unit;
        }
    }

    @Override
    public boolean setValue(AttributeSet a) {
        boolean success = false;
        Object valObj = a.getAttribute(this.attributeKey);
        if (valObj != null) {
            this.setValue(valObj.toString());
            success = true;
        } else if (this.htmlAttrKey != null && (valObj = a.getAttribute(this.htmlAttrKey)) != null) {
            this.setValue(valObj.toString());
            success = true;
        }
        return success;
    }

    private void adjustMinMax(String unit) {
        SpinnerNumberModel model = (SpinnerNumberModel)this.valueSelector.getModel();
        int minVal = 0;
        if (this.allowNegative) {
            minVal = Integer.MIN_VALUE;
        }
        if (unit.equalsIgnoreCase(UNIT_PERCENT)) {
            model.setMinimum(Integer.valueOf(minVal));
            model.setMaximum(Integer.valueOf(100));
        } else {
            model.setMinimum(Integer.valueOf(minVal));
            model.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        }
    }

    public String getUnit() {
        String unit = "";
        unit = this.unitSelector != null ? this.unitSelector.getSelectedItem().toString() : (this.unitName != null ? this.unitName.getText() : UNIT_PT);
        if (unit.equalsIgnoreCase(UNIT_PT)) {
            unit = "";
        }
        return unit;
    }

    public boolean valueChanged() {
        Integer value = (Integer)this.valueSelector.getValue();
        return value != this.originalValue || this.getUnit() != this.originalUnit;
    }

    public String getAttr() {
        Integer value = (Integer)this.valueSelector.getValue();
        String unit = this.getUnit();
        return value.toString() + unit;
    }

    public Integer getIntValue() {
        return (Integer)this.valueSelector.getValue();
    }

    @Override
    public AttributeSet getValue() {
        SimpleAttributeSet a = new SimpleAttributeSet();
        Integer value = this.getIntValue();
        String unit = this.getUnit();
        if (this.valueChanged()) {
            if (this.attributeKey instanceof CSS.Attribute) {
                Util.styleSheet().addCSSAttribute(a, (CSS.Attribute)this.attributeKey, value.toString() + unit);
            } else {
                a.addAttribute(this.attributeKey, value.toString());
                if (this.htmlAttrKey != null) {
                    a.addAttribute(this.htmlAttrKey, value.toString());
                }
            }
        }
        return a;
    }

    @Override
    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet a = new SimpleAttributeSet();
            Integer value = this.getIntValue();
            String unit = this.getUnit();
            if (this.attributeKey instanceof CSS.Attribute) {
                Util.styleSheet().addCSSAttribute(a, (CSS.Attribute)this.attributeKey, value.toString() + unit);
            } else {
                a.addAttribute(this.attributeKey, value.toString());
                if (this.htmlAttrKey != null) {
                    a.addAttribute(this.htmlAttrKey, value.toString());
                }
            }
            return a;
        }
        return this.getValue();
    }

    public JSpinner getValueSelector() {
        return this.valueSelector;
    }
}

