/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.GString;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.CyclicScriptReferenceException;
import org.freeplane.plugin.script.DependencyHighlighter;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FormulaCache;
import org.freeplane.plugin.script.FormulaDependencies;
import org.freeplane.plugin.script.FormulaThreadLocalStacks;
import org.freeplane.plugin.script.NodeScript;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.dependencies.RelatedElements;

public class FormulaUtils {
    private static final Pattern FIRST_CHARACTER_IN_HTML = Pattern.compile("(?m)>\\s*[^<\\s]");

    public static Object evalIfScript(NodeModel nodeModel, String text) {
        if (FormulaUtils.textContainsFormula(text)) {
            String script = FormulaUtils.scriptOf(text);
            Object scriptResult = FormulaUtils.executeScript(nodeModel, script);
            return scriptResult instanceof GString ? scriptResult.toString() : scriptResult;
        }
        return text;
    }

    public static Object safeEvalIfScript(NodeModel nodeModel, String text) {
        try {
            return FormulaUtils.evalIfScript(nodeModel, text);
        }
        catch (Exception e) {
            LogUtils.info((String)("could not interpret as a formula (ignored): " + text + " due to " + e.getMessage()));
            return text;
        }
    }

    public static boolean textContainsFormula(String text) {
        return FormulaUtils.startsWithEqualSign(text) && FormulaUtils.secondCharIsntSpecial(text.charAt(1));
    }

    private static boolean startsWithEqualSign(String text) {
        return text != null && text.length() >= 2 && text.charAt(0) == '=';
    }

    private static boolean secondCharIsntSpecial(char secondChar) {
        return secondChar != '=' && secondChar != '>';
    }

    public static boolean containsFormula(Object object) {
        return object instanceof String && FormulaUtils.containsFormula((String)object);
    }

    public static boolean containsFormula(String text) {
        if (HtmlUtils.isHtml((String)text)) {
            return FormulaUtils.htmlContainsFormula(text);
        }
        return FormulaUtils.textContainsFormula(text);
    }

    private static boolean htmlContainsFormula(String text) {
        Matcher matcher = FIRST_CHARACTER_IN_HTML.matcher(text);
        return matcher.find() && text.charAt(matcher.end() - 1) == '=';
    }

    public static Object executeScript(ScriptContext scriptContext, Supplier<Object> computation) {
        return FormulaCache.getOrThrowCachedResult(scriptContext, computation);
    }

    public static Object executeScript(NodeModel nodeModel, String script) {
        NodeScript nodeScript = new NodeScript(nodeModel, script);
        ScriptContext scriptContext = new ScriptContext(nodeScript);
        ScriptingPermissions restrictedPermissions = ScriptingPermissions.getFormulaPermissions();
        return FormulaCache.getOrThrowCachedResult(scriptContext, () -> {
            Object result = FormulaUtils.evaluateLoggingExceptions(scriptContext, restrictedPermissions);
            return result;
        });
    }

    private static Object evaluateLoggingExceptions(ScriptContext scriptContext, ScriptingPermissions restrictedPermissions) {
        try {
            return FormulaUtils.evaluateCheckingForCyclesAndNonNullResult(scriptContext, restrictedPermissions);
        }
        catch (ExecuteScriptException e) {
            NodeScript nodeScript = scriptContext.getNodeScript();
            NodeModel node = nodeScript.node;
            URL url = node.getMap().getURL();
            String nodeLocation = url != null ? url.toString() : "Unsaved map ";
            String message = "Error on evaluating formula in map " + nodeLocation + ", node " + node.getID() + ",\nScript '" + nodeScript.script + "'";
            LogUtils.warn((String)message, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object evaluateCheckingForCyclesAndNonNullResult(ScriptContext scriptContext, ScriptingPermissions restrictedPermissions) {
        NodeScript nodeScript = scriptContext.getNodeScript();
        if (!FormulaThreadLocalStacks.INSTANCE.push(scriptContext)) {
            if (FormulaThreadLocalStacks.INSTANCE.ignoresCycles()) {
                return 0;
            }
            FormulaUtils.showCyclicDependency(nodeScript);
            String message = TextUtils.format((String)"formula.error.circularReference", (Object[])new Object[]{nodeScript.node.getID(), HtmlUtils.htmlToPlain((String)nodeScript.script)});
            Controller.getCurrentController().getViewController().out(TextUtils.getShortText((String)message, (int)80, (String)"..."));
            throw new ExecuteScriptException(new CyclicScriptReferenceException(message));
        }
        try {
            Object value = ScriptingEngine.executeScript(nodeScript.node, nodeScript.script, scriptContext, restrictedPermissions);
            if (value == null) {
                throw new ExecuteScriptException("Null pointer returned by formula");
            }
            Object object = value;
            return object;
        }
        finally {
            FormulaThreadLocalStacks.INSTANCE.pop();
        }
    }

    private static void showCyclicDependency(NodeScript nodeScript) {
        Controller controller = Controller.getCurrentController();
        if (controller.getMap() != nodeScript.node.getMap()) {
            return;
        }
        List<NodeScript> cycle = FormulaThreadLocalStacks.INSTANCE.findCycle(nodeScript);
        Configurable configurable = controller.getMapViewManager().getMapViewConfiguration();
        DependencyHighlighter dependencyHighlighter = new DependencyHighlighter(LinkController.getController(), configurable);
        if (!cycle.isEmpty()) {
            dependencyHighlighter.showCyclicDependency(nodeScript);
        }
    }

    public static RelatedElements getRelatedElements(NodeModel node, Object object) {
        RelatedElements accessedValues;
        if (FormulaCache.ENABLE_CACHING && FormulaUtils.containsFormula(object) && (accessedValues = FormulaCache.of(node.getMap()).getAccessedValues(node, FormulaUtils.scriptOf((String)object))) != null) {
            return accessedValues;
        }
        return new RelatedElements(node);
    }

    public static String scriptOf(String object) {
        return object.substring(1);
    }

    public static void clearCache(MapModel map) {
        FormulaDependencies.clearCache(map);
    }

    public static void evaluateAllFormulas(MapModel map) {
        FormulaUtils.clearCache(map);
        FormulaUtils.evaluateOutdatedFormulas(map);
    }

    public static void evaluateOutdatedFormulas(MapModel map) {
        FormulaUtils.cacheAllRecursively(map.getRootNode());
    }

    private static void cacheAllRecursively(NodeModel node) {
        FormulaUtils.cacheIfFormula(node, node.getUserObject());
        NodeAttributeTableModel attributeTableModel = (NodeAttributeTableModel)node.getExtension(NodeAttributeTableModel.class);
        if (attributeTableModel != null) {
            attributeTableModel.getAttributes().stream().forEach(a -> FormulaUtils.cacheIfFormula(node, a.getValue()));
        }
        node.getChildren().stream().forEach(FormulaUtils::cacheAllRecursively);
    }

    public static void cacheIfFormula(NodeModel node, Object maybeFormula) {
        try {
            if (maybeFormula instanceof String) {
                FormulaUtils.evalIfScript(node, (String)maybeFormula);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

