/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import groovy.lang.Closure;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.api.Node;
import org.freeplane.api.NodeCondition;
import org.freeplane.api.NodeRO;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.condition.DelegateCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.format.FormattedNumber;
import org.freeplane.features.format.IFormattedObject;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeStream;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.Convertible;
import org.freeplane.plugin.script.proxy.ConvertibleDate;
import org.freeplane.plugin.script.proxy.ConvertibleNodeText;
import org.freeplane.plugin.script.proxy.ConvertibleNumber;
import org.freeplane.plugin.script.proxy.ConvertibleText;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

public class ProxyUtils {
    static List<? extends Node> createNodeList(final List<NodeModel> list, final ScriptContext scriptContext) {
        return new AbstractList<Node>(){
            private final List<NodeModel> nodeModels;
            {
                this.nodeModels = list;
            }

            @Override
            public Node get(int index) {
                NodeModel nodeModel = this.nodeModels.get(index);
                return new NodeProxy(nodeModel, scriptContext);
            }

            @Override
            public int size() {
                return this.nodeModels.size();
            }
        };
    }

    static List<? extends Node> find(ICondition condition, NodeModel node, ScriptContext scriptContext) {
        return ProxyUtils.createNodeList(ProxyUtils.findImpl(condition, node, false), scriptContext);
    }

    static List<? extends Node> findAll(NodeModel node, ScriptContext scriptContext, boolean depthFirst) {
        return ProxyUtils.createNodeList(ProxyUtils.findImpl(null, node, depthFirst), scriptContext);
    }

    static List<? extends Node> find(Closure<Boolean> closure, NodeModel node, ScriptContext scriptContext) {
        return ProxyUtils.find(ProxyUtils.createCondition(closure, scriptContext), node, scriptContext);
    }

    static List<? extends Node> find(boolean withAncestors, boolean withDescendants, Closure<Boolean> closure, NodeModel node, ScriptContext scriptContext) {
        return ProxyUtils.find(withAncestors, withDescendants, ProxyUtils.createCondition(closure, scriptContext), node, scriptContext);
    }

    private static List<? extends Node> find(boolean withAncestors, boolean withDescendants, ICondition createCondition, NodeModel node, ScriptContext scriptContext) {
        Filter filter = Filter.createFilter((ICondition)createCondition, (boolean)withAncestors, (boolean)withDescendants, (boolean)false, null);
        filter.calculateFilterResults(node);
        List<NodeModel> allNodes = ProxyUtils.findImpl(null, node, false);
        return ProxyUtils.createNodeList(allNodes.stream().filter(arg_0 -> ((Filter)filter).isVisible(arg_0)).collect(Collectors.toList()), scriptContext);
    }

    static ICondition createCondition(Closure<Boolean> closure, ScriptContext scriptContext) {
        DelegateCondition condition = closure == null ? null : new DelegateCondition(node -> ProxyUtils.checkNode(closure, scriptContext, node), "Closure");
        return condition;
    }

    private static boolean checkNode(Closure<Boolean> closure, ScriptContext scriptContext, NodeModel node) {
        try {
            Boolean result = (Boolean)closure.call(new Object[]{new NodeProxy(node, scriptContext)});
            if (result == null) {
                throw new RuntimeException("find(): closure returned null instead of boolean/Boolean");
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("find(): closure returned " + e.getMessage() + " instead of boolean/Boolean");
        }
    }

    static List<? extends Node> find(NodeCondition condition, NodeModel node, ScriptContext scriptContext) {
        return ProxyUtils.find(ProxyUtils.createCondition(condition, scriptContext), node, scriptContext);
    }

    static List<? extends Node> find(boolean withAncestors, boolean withDescendants, NodeCondition condition, NodeModel node, ScriptContext scriptContext) {
        return ProxyUtils.find(withAncestors, withDescendants, ProxyUtils.createCondition(condition, scriptContext), node, scriptContext);
    }

    static ICondition createCondition(NodeCondition condition, ScriptContext scriptContext) {
        DelegateCondition filterCondition = condition == null ? null : new DelegateCondition(node -> condition.check((NodeRO)new NodeProxy(node, scriptContext)), "Code");
        return filterCondition;
    }

    private static List<NodeModel> findImpl(ICondition condition, NodeModel node, boolean depthFirst) {
        Stream<NodeModel> nodes;
        Stream<Object> stream = nodes = depthFirst ? NodeStream.bottomUpOf((NodeModel)node) : NodeStream.of((NodeModel)node);
        if (condition != null) {
            nodes = nodes.filter(arg_0 -> ((ICondition)condition).checkNode(arg_0));
        }
        return nodes.collect(Collectors.toList());
    }

    public static List<Proxy.Node> createListOfChildren(final NodeModel nodeModel, final ScriptContext scriptContext) {
        return new ArrayList<Proxy.Node>(new AbstractList<Proxy.Node>(){

            @Override
            public Proxy.Node get(int index) {
                NodeModel child = nodeModel.getChildAt(index);
                return new NodeProxy(child, scriptContext);
            }

            @Override
            public int size() {
                return nodeModel.getChildCount();
            }
        });
    }

    public static Convertible attributeValueToConvertible(NodeModel nodeModel, ScriptContext scriptContext, Object value) {
        if (value instanceof IFormattedObject) {
            value = ((IFormattedObject)value).getObject();
        }
        if (value instanceof Number) {
            return new ConvertibleNumber((Number)value);
        }
        if (value instanceof Date) {
            return new ConvertibleDate((Date)value);
        }
        return new ConvertibleText(nodeModel, scriptContext, value == null ? null : value.toString());
    }

    public static Convertible nodeModelToConvertible(NodeModel nodeModel, ScriptContext scriptContext) {
        Object value = nodeModel.getUserObject();
        if (value instanceof IFormattedObject) {
            value = ((IFormattedObject)value).getObject();
        }
        if (value instanceof Number) {
            return new ConvertibleNumber((Number)value);
        }
        if (value instanceof Date) {
            return new ConvertibleDate((Date)value);
        }
        return new ConvertibleNodeText(nodeModel, scriptContext);
    }

    public static <T> List<T> createList(final Collection<T> collection) {
        return new AbstractList<T>(){
            private int lastIndex;
            private Iterator<T> iterator;

            @Override
            public T get(int index) {
                if (index >= this.size()) {
                    throw new NoSuchElementException();
                }
                if (index == 0) {
                    return collection.iterator().next();
                }
                if (this.iterator == null || index <= this.lastIndex) {
                    this.lastIndex = -1;
                    this.iterator = collection.iterator();
                }
                try {
                    Object object = null;
                    while (this.lastIndex < index) {
                        object = this.iterator.next();
                        ++this.lastIndex;
                    }
                    return object;
                }
                catch (ConcurrentModificationException e) {
                    this.iterator = null;
                    return this.get(index);
                }
            }

            @Override
            public int indexOf(Object o) {
                Iterator it = this.iterator();
                int i = -1;
                while (it.hasNext()) {
                    ++i;
                    Object next = it.next();
                    if (o != next && (o == null || !o.equals(next))) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public int lastIndexOf(Object o) {
                Iterator it = this.iterator();
                int i = -1;
                int result = -1;
                while (it.hasNext()) {
                    ++i;
                    Object next = it.next();
                    if (o != next && (o == null || !o.equals(next))) continue;
                    result = i;
                }
                return result;
            }

            @Override
            public Iterator<T> iterator() {
                return collection.iterator();
            }

            @Override
            public int size() {
                return collection.size();
            }
        };
    }

    static Object transformObject(Object objectToTransform, String pattern) {
        Object object = ProxyUtils.createFormattedObjectIfPossible(objectToTransform, pattern);
        if (object instanceof IFormattedObject) {
            return object;
        }
        if (object instanceof Number) {
            return new FormattedNumber((Number)object);
        }
        if (object instanceof Date) {
            return ProxyUtils.createDefaultFormattedDate((Date)object);
        }
        if (object instanceof Calendar) {
            return ProxyUtils.createDefaultFormattedDate(((Calendar)object).getTime());
        }
        if (object instanceof Hyperlink || object instanceof URI) {
            return object;
        }
        return Convertible.toString(object);
    }

    private static Object createFormattedObjectIfPossible(Object object, String pattern) {
        if (object instanceof String) {
            Object object1 = object;
            String oldFormat = pattern;
            object = ((MTextController)TextController.getController()).guessObject(object1, oldFormat);
        } else if (pattern != null) {
            object = FormatController.format((Object)object, (String)pattern);
        }
        return object;
    }

    static FormattedDate createDefaultFormattedDate(Date date) {
        return FormattedDate.createDefaultFormattedDate((long)date.getTime(), (String)"date");
    }

    static FormattedDate createDefaultFormattedDateTime(Date date) {
        return FormattedDate.createDefaultFormattedDate((long)date.getTime(), (String)"datetime");
    }
}

