/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application.survey;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.freeplane.core.resources.ResourceController;

public class FreeplaneSurveyProperties {
    private static final long ONE_DAY_IN_MILLISECONDS = 86400000L;
    static final String NEVER_SHOW_SURVEY_PROPERTY = "neverShowSurvey";
    static final String NEXT_SURVEY_CHECK_DAY_PROPERTY = "nextSurveyCheck";
    private static final String REMIND_ME_LATER_PROPERTY = "remindMeAboutSurveyIsActive";
    static final String FILLED_SURVEY = "filledSurvey";
    private static final String SURVEY_URL_PROPERTY = "surveyUrl";
    private final ResourceController resourceController = ResourceController.getResourceController();
    private final long nextCheckDay = this.resourceController.getLongProperty("nextSurveyCheck", 0L);
    private boolean remindMeLaterIsActive = this.resourceController.getBooleanProperty("remindMeAboutSurveyIsActive", false);

    public FreeplaneSurveyProperties() {
        if (this.remindMeLaterIsActive) {
            this.resourceController.setProperty(REMIND_ME_LATER_PROPERTY, false);
        }
    }

    void setNextSurveyDay(int minimalDaysBetweenSurveys) {
        this.resourceController.setProperty(NEXT_SURVEY_CHECK_DAY_PROPERTY, this.dayNow() + (long)minimalDaysBetweenSurveys);
    }

    long getNextCheckDay() {
        return this.nextCheckDay;
    }

    private long dayNow() {
        return new Date().getTime() / 86400000L;
    }

    void markSurveyAsFilled(String surveyId) {
        this.resourceController.setProperty(this.filledSurveyPropertyOf(surveyId), "true");
    }

    private String filledSurveyPropertyOf(String surveyId) {
        return "filledSurvey." + surveyId;
    }

    void setNeverShowSurvey() {
        this.resourceController.setProperty(NEVER_SHOW_SURVEY_PROPERTY, "true");
    }

    public boolean mayAskUserToFillSurveys() {
        return !this.resourceController.getBooleanProperty(NEVER_SHOW_SURVEY_PROPERTY) && this.isLanguageSupported();
    }

    private boolean isLanguageSupported() {
        return this.resourceController.getLanguageCode().equals("en");
    }

    boolean mayAskUserToFillSurvey(String surveyId) {
        return this.mayAskUserToFillSurveys() && !this.hasUserAlreadyFilled(surveyId) && this.mayAskUserAgain();
    }

    boolean mayAskUserAgain() {
        return this.dayNow() > this.getNextCheckDay();
    }

    private boolean hasUserAlreadyFilled(String surveyId) {
        return Boolean.parseBoolean(this.resourceController.getProperty(this.filledSurveyPropertyOf(surveyId), "false"));
    }

    private URL getSurveyUrl() {
        try {
            String surveyUrl = this.resourceController.getProperty(SURVEY_URL_PROPERTY) + "_en.properties";
            return new URL(surveyUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream openRemoteConfiguration() throws IOException {
        return this.getSurveyUrl().openStream();
    }

    public void activateRemindMeLater() {
        this.resourceController.setProperty(REMIND_ME_LATER_PROPERTY, "true");
    }

    public boolean remindMeLaterIsActive() {
        return this.remindMeLaterIsActive;
    }
}

