/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.WindowConfigurationStorage;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.main.mindmapmode.stylemode.DialogController;
import org.freeplane.main.mindmapmode.stylemode.SModeController;
import org.freeplane.main.mindmapmode.stylemode.SModeControllerFactory;

public class EditStylesAction
extends AFreeplaneAction {
    private Controller mainController = null;
    private SModeController modeController;
    protected JDialog dialog;
    private Component currentMapView;
    private MapModel currentMap;

    public EditStylesAction() {
        super("EditStylesAction");
    }

    public void actionPerformed(ActionEvent e) {
        Controller currentController = Controller.getCurrentController();
        this.currentMap = currentController.getMap();
        MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)this.currentMap);
        MapModel styleMap = mapStyleModel.getStyleMap();
        if (styleMap == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"no_styles_found_in_map"));
            return;
        }
        IMapViewManager mapViewManager = currentController.getMapViewManager();
        this.currentMapView = mapViewManager.getMapViewComponent();
        mapViewManager.changeToMapView((Component)null);
        IUndoHandler undoHandler = (IUndoHandler)this.currentMap.getExtension(IUndoHandler.class);
        styleMap.putExtension(IUndoHandler.class, (IExtension)undoHandler);
        undoHandler.startTransaction();
        this.init();
        SModeController modeController = this.getModeController();
        modeController.getMapController().createMapView(styleMap);
        Controller controller = modeController.getController();
        IMapViewManager styleMapViewManager = controller.getMapViewManager();
        JComponent mapViewComponent = styleMapViewManager.getMapViewComponent();
        ((DialogController)controller.getViewController()).setMapView(mapViewComponent);
        this.dialog.setVisible(true);
    }

    void commit() {
        LogicalStyleController.getController().refreshMapLaterUndoable(this.currentMap);
        ModeController currentModeController = Controller.getCurrentModeController();
        currentModeController.commit();
    }

    private void rollback() {
        Controller.getCurrentModeController().rollback();
    }

    SModeController getModeController() {
        return this.modeController;
    }

    private void init() {
        this.mainController = Controller.getCurrentController();
        if (this.dialog != null) {
            Controller.setCurrentController((Controller)((Controller)this.dialog.getRootPane().getClientProperty(Controller.class)));
            return;
        }
        Frame parentFrame = UITools.getCurrentFrame();
        this.dialog = new JDialog(parentFrame);
        this.dialog.applyComponentOrientation(parentFrame.getComponentOrientation());
        this.dialog.setLocationRelativeTo(this.mainController.getViewController().getCurrentRootComponent());
        WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(this.getKey() + ".dialog");
        windowConfigurationStorage.restoreDialogPositions(this.dialog);
        this.dialog.setModal(true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditStylesAction.this.getModeController().tryToCloseDialog();
            }
        });
        Controller styleDialogController = SModeControllerFactory.getInstance().createController(this.dialog);
        this.modeController = (SModeController)styleDialogController.getModeController();
        ViewController viewController = styleDialogController.getViewController();
        viewController.init(styleDialogController);
        this.dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(EditStylesAction.this.getKey() + ".dialog");
                windowConfigurationStorage.storeDialogPositions(EditStylesAction.this.dialog);
                IMapViewManager mapViewManager = EditStylesAction.this.modeController.getController().getMapViewManager();
                MapModel map = mapViewManager.getModel();
                IUndoHandler undoHandler = (IUndoHandler)map.getExtension(IUndoHandler.class);
                boolean stylesChanged = EditStylesAction.this.modeController.getStatus() == 0 && undoHandler.canUndo();
                Exception loggedException = null;
                try {
                    if (stylesChanged) {
                        EditStylesAction.this.commit();
                    } else {
                        EditStylesAction.this.rollback();
                    }
                }
                catch (Exception ex) {
                    loggedException = ex;
                }
                super.componentHidden(e);
                map.setSaved(true);
                EditStylesAction.this.modeController.getMapController().closeWithoutSaving(map);
                Controller.setCurrentController((Controller)EditStylesAction.this.mainController);
                if (loggedException != null) {
                    LogUtils.severe((Throwable)loggedException);
                }
                EditStylesAction.this.mainController.getMapViewManager().changeToMapView(EditStylesAction.this.currentMapView);
                EditStylesAction.this.currentMapView = null;
                EditStylesAction.this.currentMap = null;
            }
        });
    }
}

