/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.DoubleClickTimer;
import org.freeplane.core.ui.IEditHandler;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultNodeMouseMotionListener;

public class MNodeMotionListener
extends DefaultNodeMouseMotionListener
implements IMouseListener {
    private Point dragStartingPoint = null;
    private Quantity<LengthUnit> originalHGap;
    private Quantity<LengthUnit> originalAssignedBaseHGap;
    private List<NodeModel> selection;
    private List<NodeModel> parentSelection;
    private List<Quantity<LengthUnit>> originalHGaps;
    private List<Quantity<LengthUnit>> originalAssignedBaseHGaps;
    private List<Quantity<LengthUnit>> originalAssignedVGaps;
    private Quantity<LengthUnit> originalAssignedParentVGap;
    private Quantity<LengthUnit> effectiveParentVGap;
    private Quantity<LengthUnit> effectiveBaseHGap;
    private Quantity<LengthUnit> originalShiftY;
    private NodeView draggedNodeView;
    private static final String EDIT_ON_DOUBLE_CLICK = "edit_on_double_click";

    Point getDragStartingPoint() {
        return this.dragStartingPoint;
    }

    private int getHGapChange(Point dragNextPoint, boolean usesHorizontalLayout) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int distance = usesHorizontalLayout ? dragNextPoint.y - this.dragStartingPoint.y : dragNextPoint.x - this.dragStartingPoint.x;
        int hGapChange = (int)((float)distance / mapView.getZoom());
        if (this.getNode().isTopOrLeft(mapView.getRoot().getModel())) {
            hGapChange = -hGapChange;
        }
        return hGapChange;
    }

    private int getNodeShiftYChange(Point dragNextPoint, boolean usesHorizontalLayout) {
        Controller controller = Controller.getCurrentController();
        MapView mapView = (MapView)controller.getMapViewManager().getMapViewComponent();
        int distance = usesHorizontalLayout ? dragNextPoint.x - this.dragStartingPoint.x : dragNextPoint.y - this.dragStartingPoint.y;
        int shiftYChange = (int)((float)distance / mapView.getZoom());
        return shiftYChange;
    }

    public boolean isDragActive() {
        return this.dragStartingPoint != null;
    }

    public void mouseClicked(MouseEvent e) {
        boolean shouldEditOrResetPosition;
        boolean bl = shouldEditOrResetPosition = e.getButton() == 1 && e.getClickCount() == 2 && this.doubleClickTimer.getDelay() > 0;
        if (shouldEditOrResetPosition) {
            MainView mainView = (MainView)e.getComponent();
            if (mainView.getMouseArea().equals((Object)MouseArea.MOTION)) {
                Controller controller = Controller.getCurrentController();
                MLocationController locationController = (MLocationController)LocationController.getController((ModeController)controller.getModeController());
                if (e.getModifiersEx() == 0) {
                    NodeView nodeV = mainView.getNodeView();
                    NodeModel node = nodeV.getModel();
                    Set currentSelection = controller.getSelection().getSelection();
                    if (currentSelection.size() > 1) {
                        currentSelection.forEach(n -> locationController.moveNodePosition((NodeModel)n, (Quantity<LengthUnit>)LocationModel.DEFAULT_HGAP, (Quantity<LengthUnit>)LocationModel.getModel((NodeModel)n).getShiftY()));
                    }
                    locationController.moveNodePosition(node, (Quantity<LengthUnit>)LocationModel.DEFAULT_HGAP, (Quantity<LengthUnit>)LocationModel.DEFAULT_SHIFT_Y);
                    return;
                }
                if (Compat.isCtrlEvent((MouseEvent)e)) {
                    NodeView nodeV = mainView.getNodeView();
                    Set currentSelection = controller.getSelection().getSelection();
                    if (currentSelection.size() > 1) {
                        currentSelection.forEach(n -> {
                            NodeModel parentNode = n.getParentNode();
                            locationController.setBaseHGapToChildren(parentNode, (Quantity<LengthUnit>)LocationModel.DEFAULT_HGAP);
                            locationController.setCommonVGapBetweenChildren(parentNode, (Quantity<LengthUnit>)LocationModel.DEFAULT_VGAP);
                        });
                    } else {
                        NodeModel parentNode = nodeV.getParentView().getModel();
                        locationController.setBaseHGapToChildren(parentNode, (Quantity<LengthUnit>)LocationModel.DEFAULT_HGAP);
                        locationController.setCommonVGapBetweenChildren(parentNode, (Quantity<LengthUnit>)LocationModel.DEFAULT_VGAP);
                    }
                    return;
                }
            } else if (Compat.isPlainEvent((MouseEvent)e) && !this.isInFoldingRegion(e) && !mainView.isInDragRegion(e.getPoint())) {
                MTextController textController = MTextController.getController();
                textController.getEventQueue().activate(e);
                textController.edit(IEditHandler.FirstAction.EDIT_CURRENT, false);
            }
        }
        super.mouseClicked(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.isDragActive()) {
            return;
        }
        MainView mainView = (MainView)e.getSource();
        NodeView nodeV = mainView.getNodeView();
        MapView mapView = nodeV.getMap();
        ModeController modeController = mapView.getModeController();
        if (modeController.canEdit(mapView.getModel()) && mainView.isInDragRegion(e.getPoint())) {
            mainView.setMouseArea(MouseArea.MOTION);
            mainView.setCursor(Cursor.getPredefinedCursor(13));
            return;
        }
        super.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        if (!this.isDragActive()) {
            super.mouseExited(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        MapView mapView = MapView.getMapView((Component)e.getComponent());
        mapView.select();
        this.doubleClickTimer.cancel();
        ModeController modeController = mapView.getModeController();
        if (modeController.canEdit(mapView.getModel()) && this.editsOnDoubleClick()) {
            this.doubleClickTimer.setDelay(DoubleClickTimer.MAX_TIME_BETWEEN_CLICKS);
        } else {
            this.doubleClickTimer.setDelay(0);
        }
        if (this.isInDragRegion(e)) {
            NodeView nodeView;
            NodeModel node;
            if ((e.getModifiersEx() & 0x400) == 1024 && modeController.canEdit((node = (nodeView = this.getNodeView(e)).getModel()).getMap())) {
                this.nodeSelector.stopTimerForDelayedSelection();
                Point point = e.getPoint();
                UITools.convertPointToAncestor((Component)nodeView, (Point)point, JScrollPane.class);
                this.findGridPoint(point);
                this.draggedNodeView = nodeView;
                this.dragStartingPoint = point;
                LocationModel parentLocationMode = LocationModel.getModel((NodeModel)node.getParentNode());
                this.originalAssignedParentVGap = parentLocationMode.getVGap();
                this.originalAssignedBaseHGap = parentLocationMode.getBaseHGap();
                NodeModel childDistanceContainer = this.draggedNodeView.getParentView().getModel();
                LocationController extension = (LocationController)modeController.getExtension(LocationController.class);
                this.effectiveParentVGap = extension.getCommonVGapBetweenChildren(childDistanceContainer);
                this.effectiveBaseHGap = extension.getBaseHGapToChildren(childDistanceContainer);
                this.originalHGap = LocationModel.getModel((NodeModel)node).getHGap();
                this.originalShiftY = LocationModel.getModel((NodeModel)node).getShiftY();
                List selectedNodes = modeController.getController().getSelection().getSortedSelection(true);
                if (selectedNodes.size() > 1) {
                    this.originalAssignedBaseHGaps = new ArrayList<Quantity<LengthUnit>>();
                    this.originalAssignedVGaps = new ArrayList<Quantity<LengthUnit>>();
                    this.originalHGaps = new ArrayList<Quantity<LengthUnit>>(selectedNodes.size());
                    selectedNodes.forEach(n -> this.originalHGaps.add((Quantity<LengthUnit>)LocationModel.getModel((NodeModel)n).getHGap()));
                    HashSet parentSelection = new HashSet();
                    selectedNodes.forEach(n -> {
                        NodeModel parentNode = n.getParentNode();
                        if (parentNode != null && parentSelection.add(parentNode)) {
                            LocationModel parentLocationModel = LocationModel.getModel((NodeModel)parentNode);
                            this.originalAssignedBaseHGaps.add((Quantity<LengthUnit>)parentLocationModel.getBaseHGap());
                            this.originalAssignedVGaps.add((Quantity<LengthUnit>)parentLocationModel.getVGap());
                        }
                    });
                    this.selection = new ArrayList<NodeModel>(selectedNodes);
                    this.parentSelection = new ArrayList<NodeModel>(parentSelection);
                }
            }
        } else {
            super.mousePressed(e);
        }
    }

    private NodeView getNodeView(MouseEvent e) {
        return ((MainView)e.getSource()).getNodeView();
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.isDragActive()) {
            if (!this.getNodeView(e).isSelected()) {
                super.mouseDragged(e);
            }
            return;
        }
        if (this.draggedNodeView.getParentView() == null) {
            this.resetPositions();
            this.stopDrag();
            return;
        }
        if ((e.getModifiersEx() & 0x400) == 1024) {
            boolean movesSingleNodeInBothDirections;
            final MainView mainView = (MainView)e.getSource();
            final MapView mapView = this.draggedNodeView.getMap();
            Point point = e.getPoint();
            UITools.convertPointToAncestor((Component)this.draggedNodeView, (Point)point, JScrollPane.class);
            this.findGridPoint(point);
            Controller controller = Controller.getCurrentController();
            ModeController modeController = controller.getModeController();
            Point dragNextPoint = point;
            boolean changesDistanceBetweenChildren = Compat.isCtrlEvent((MouseEvent)e);
            boolean usesHorizontalLayout = this.draggedNodeView.getAncestorWithVisibleContent().usesHorizontalLayout();
            NodeModel node = this.getNode();
            int hGapChange = this.getHGapChange(dragNextPoint, usesHorizontalLayout);
            int shiftYChange = this.getNodeShiftYChange(dragNextPoint, usesHorizontalLayout);
            int minimumIntentionalTwoDirectionChange = 8;
            boolean bl = movesSingleNodeInBothDirections = Compat.isShiftEvent((MouseEvent)e) || Math.abs(hGapChange) > minimumIntentionalTwoDirectionChange && Math.abs(shiftYChange) > minimumIntentionalTwoDirectionChange;
            if (!changesDistanceBetweenChildren) {
                boolean isShiftYChanged;
                LocationModel locationModel = LocationModel.createLocationModel((NodeModel)node);
                boolean isHgapChanged = this.originalHGap.toBaseUnitsRounded() + hGapChange != locationModel.getHGap().toBaseUnitsRounded();
                boolean bl2 = isShiftYChanged = this.originalShiftY.toBaseUnitsRounded() + shiftYChange != locationModel.getShiftY().toBaseUnitsRounded();
                if (!isHgapChanged && !isShiftYChanged) {
                    return;
                }
                if (movesSingleNodeInBothDirections || Math.abs(hGapChange) >= Math.abs(shiftYChange)) {
                    Quantity newHGap = this.originalHGap.add((double)hGapChange, (Enum)LengthUnit.px);
                    this.setCurrentHGap((Quantity<LengthUnit>)newHGap);
                    if (!movesSingleNodeInBothDirections) {
                        locationModel.setShiftY(this.originalShiftY);
                    }
                }
                if (movesSingleNodeInBothDirections || Math.abs(hGapChange) < Math.abs(shiftYChange)) {
                    locationModel.setShiftY(this.originalShiftY.add((double)shiftYChange, (Enum)LengthUnit.px));
                    if (!movesSingleNodeInBothDirections && !locationModel.getHGap().equals(this.originalHGap)) {
                        this.resetHGaps();
                    }
                }
                MapController mapController = modeController.getMapController();
                if (this.movesMultipleNodes()) {
                    this.selection.forEach(arg_0 -> ((MapController)mapController).nodeRefresh(arg_0));
                } else {
                    mapController.nodeRefresh(node);
                }
            } else {
                boolean isVgapChanged;
                NodeModel parentNode = this.draggedNodeView.getParentView().getModel();
                int newVGap = Math.max(0, this.effectiveParentVGap.toBaseUnitsRounded() + (usesHorizontalLayout ? shiftYChange : -shiftYChange));
                LocationModel locationModel = LocationModel.createLocationModel((NodeModel)parentNode);
                boolean isHgapChanged = this.originalHGap.toBaseUnitsRounded() + hGapChange != locationModel.getBaseHGap().toBaseUnitsRounded();
                boolean bl3 = isVgapChanged = locationModel.getVGap().toBaseUnitsRounded() != newVGap;
                if (!isVgapChanged && !isHgapChanged) {
                    return;
                }
                if (movesSingleNodeInBothDirections || Math.abs(hGapChange) >= Math.abs(shiftYChange)) {
                    Quantity newHGap = this.effectiveBaseHGap.add((double)hGapChange, (Enum)LengthUnit.px);
                    this.setCurrentBaseHGap((Quantity<LengthUnit>)newHGap);
                    if (!movesSingleNodeInBothDirections) {
                        this.resetVGaps();
                    }
                }
                if (movesSingleNodeInBothDirections || Math.abs(hGapChange) < Math.abs(shiftYChange)) {
                    this.setCurrentVGap((Quantity<LengthUnit>)new Quantity((double)newVGap, (Enum)LengthUnit.px).in((Enum)LengthUnit.pt));
                    if (!movesSingleNodeInBothDirections) {
                        this.resetBaseHGaps();
                    }
                }
                MapController mapController = modeController.getMapController();
                if (this.movesMultipleNodes()) {
                    this.parentSelection.forEach(arg_0 -> ((MapController)mapController).nodeRefresh(arg_0));
                } else {
                    mapController.nodeRefresh(node.getParentNode());
                }
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!mainView.isShowing()) {
                        return;
                    }
                    Rectangle r = mainView.getBounds();
                    UITools.convertRectangleToAncestor((Component)mainView.getParent(), (Rectangle)r, (Component)mapView);
                    boolean isEventPointVisible = mapView.getVisibleRect().contains(r);
                    if (!isEventPointVisible) {
                        mapView.scrollRectToVisible(r);
                    }
                }
            });
        }
    }

    private void setCurrentHGap(Quantity<LengthUnit> newHGap) {
        if (this.movesMultipleNodes()) {
            this.selection.forEach(n -> LocationModel.createLocationModel((NodeModel)n).setHGap(newHGap));
        } else {
            LocationModel.createLocationModel((NodeModel)this.getNode()).setHGap(newHGap);
        }
    }

    private void setCurrentVGap(Quantity<LengthUnit> newVGap) {
        if (this.movesMultipleNodes()) {
            this.parentSelection.forEach(n -> LocationModel.createLocationModel((NodeModel)n).setVGap(newVGap));
        } else {
            LocationModel.createLocationModel((NodeModel)this.getNode().getParentNode()).setVGap(newVGap);
        }
    }

    private void setCurrentBaseHGap(Quantity<LengthUnit> newHGap) {
        if (this.movesMultipleNodes()) {
            this.parentSelection.forEach(n -> LocationModel.createLocationModel((NodeModel)n).setBaseHGap(newHGap));
        } else {
            LocationModel.createLocationModel((NodeModel)this.getNode().getParentNode()).setBaseHGap(newHGap);
        }
    }

    private boolean movesMultipleNodes() {
        return this.selection != null;
    }

    private void findGridPoint(Point point) {
        int gridSize = ResourceController.getResourceController().getLengthProperty("grid_size");
        if (gridSize <= 2) {
            return;
        }
        point.x -= point.x % gridSize;
        point.y -= point.y % gridSize;
    }

    public void mouseReleased(MouseEvent e) {
        MainView v = (MainView)e.getSource();
        if (!v.contains(e.getX(), e.getY())) {
            v.setMouseArea(MouseArea.OUT);
        }
        if (!this.isDragActive()) {
            super.mouseReleased(e);
            return;
        }
        NodeModel node = this.getNode();
        ModeController modeController = this.draggedNodeView.getMap().getModeController();
        Controller controller = modeController.getController();
        NodeView parentView = this.draggedNodeView.getParentView();
        if (parentView == null) {
            this.resetPositions();
            this.stopDrag();
            return;
        }
        NodeModel parentNode = parentView.getModel();
        MLocationController locationController = (MLocationController)LocationController.getController((ModeController)controller.getModeController());
        Quantity parentVGap = locationController.getCommonVGapBetweenChildren(parentNode);
        Quantity baseHGap = locationController.getBaseHGapToChildren(parentNode);
        Quantity hgap = LocationModel.getModel((NodeModel)node).getHGap();
        Quantity shiftY = LocationModel.getModel((NodeModel)node).getShiftY();
        this.adjustNodeIndices();
        this.resetPositions();
        locationController.moveNodePosition(node, (Quantity<LengthUnit>)hgap, (Quantity<LengthUnit>)shiftY);
        locationController.setBaseHGapToChildren(parentNode, (Quantity<LengthUnit>)baseHGap);
        locationController.setCommonVGapBetweenChildren(parentNode, (Quantity<LengthUnit>)parentVGap);
        if (this.movesMultipleNodes()) {
            this.selection.forEach(n -> {
                if (n != node) {
                    locationController.moveNodePosition((NodeModel)n, (Quantity<LengthUnit>)hgap, (Quantity<LengthUnit>)LocationModel.getModel((NodeModel)n).getShiftY());
                }
            });
            this.parentSelection.forEach(n -> {
                if (n != node) {
                    locationController.setBaseHGapToChildren((NodeModel)n, (Quantity<LengthUnit>)baseHGap);
                    locationController.setCommonVGapBetweenChildren((NodeModel)n, (Quantity<LengthUnit>)parentVGap);
                }
            });
        }
        this.stopDrag();
    }

    private NodeModel getNode() {
        return this.draggedNodeView.getModel();
    }

    private void adjustNodeIndices() {
        NodeModel[] selectedsBackup = null;
        NodeModel node = this.getNode();
        if (FreeNode.isFreeNode((NodeModel)node)) {
            selectedsBackup = this.adjustNodeIndexBackupSelection(this.draggedNodeView, selectedsBackup);
        } else {
            NodeModel[] siblingNodes;
            MapView map = this.draggedNodeView.getMap();
            for (NodeModel sibling : siblingNodes = node.getParentNode().getChildren().toArray(new NodeModel[0])) {
                if (!FreeNode.isFreeNode((NodeModel)sibling)) continue;
                NodeView siblingV = map.getNodeView(sibling);
                selectedsBackup = this.adjustNodeIndexBackupSelection(siblingV, selectedsBackup);
            }
        }
        if (selectedsBackup != null) {
            ModeController modeController = this.draggedNodeView.getMap().getModeController();
            Controller controller = modeController.getController();
            controller.getSelection().replaceSelection(selectedsBackup);
        }
    }

    private NodeModel[] adjustNodeIndexBackupSelection(NodeView nodeV, NodeModel[] selectedsBackup) {
        NodeModel node = nodeV.getModel();
        int newIndex = this.calculateNewFreeNodeIndex(nodeV);
        if (newIndex != -1) {
            ModeController modeController = nodeV.getMap().getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (selectedsBackup == null) {
                List selecteds = mapController.getSelectedNodes();
                selectedsBackup = selecteds.toArray(new NodeModel[selecteds.size()]);
            }
            mapController.moveNode(node, newIndex);
        }
        return selectedsBackup;
    }

    public int getRefX(NodeView node) {
        return node.getContent().getX() + node.getContent().getWidth() / 2;
    }

    private int calculateNewFreeNodeIndex(NodeView nodeV) {
        int result;
        NodeModel node = nodeV.getModel();
        if (SummaryNode.isHidden((NodeModel)node)) {
            return -1;
        }
        boolean left = nodeV.isTopOrLeft();
        int nodeY = this.getRefY(nodeV);
        NodeView parent = nodeV.getParentView();
        int newIndex = 0;
        int oldIndex = -1;
        int wrondSideCount = 0;
        int hiddenNodeCount = 0;
        int childCount = node.getParentNode().getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Component component = parent.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView siblingV = (NodeView)component;
            NodeModel sibling = siblingV.getModel();
            if (siblingV.isTopOrLeft() == left && !SummaryNode.isHidden((NodeModel)sibling) && this.getRefY(siblingV) > nodeY) break;
            if (siblingV != nodeV) {
                ++newIndex;
                if (siblingV.isTopOrLeft() != left) {
                    ++wrondSideCount;
                    continue;
                }
                wrondSideCount = 0;
                if (oldIndex >= 0 && SummaryNode.isHidden((NodeModel)sibling)) {
                    ++hiddenNodeCount;
                    continue;
                }
                hiddenNodeCount = 0;
                continue;
            }
            oldIndex = i;
        }
        if ((result = newIndex - wrondSideCount - hiddenNodeCount) == oldIndex) {
            return -1;
        }
        return result;
    }

    private int getRefY(NodeView sibling) {
        return sibling.getY() + sibling.getContent().getY();
    }

    private void resetPositions() {
        this.resetCommonGaps();
        NodeModel node = this.getNode();
        LocationModel.getModel((NodeModel)node).setShiftY(this.originalShiftY);
        this.resetHGaps();
    }

    private void resetCommonGaps() {
        this.resetBaseHGaps();
        this.resetVGaps();
    }

    private void resetBaseHGaps() {
        NodeModel node = this.getNode();
        if (this.movesMultipleNodes()) {
            for (int i = 0; i < this.parentSelection.size(); ++i) {
                LocationModel locationModel = LocationModel.getModel((NodeModel)this.parentSelection.get(i));
                locationModel.setBaseHGap(this.originalAssignedBaseHGaps.get(i));
            }
        } else {
            LocationModel locationModel = LocationModel.getModel((NodeModel)node.getParentNode());
            locationModel.setBaseHGap(this.originalAssignedBaseHGap);
        }
    }

    private void resetVGaps() {
        NodeModel node = this.getNode();
        if (this.movesMultipleNodes()) {
            for (int i = 0; i < this.parentSelection.size(); ++i) {
                LocationModel locationModel = LocationModel.getModel((NodeModel)this.parentSelection.get(i));
                locationModel.setVGap(this.originalAssignedVGaps.get(i));
            }
        } else {
            LocationModel locationModel = LocationModel.getModel((NodeModel)node.getParentNode());
            locationModel.setVGap(this.originalAssignedParentVGap);
        }
    }

    private void resetHGaps() {
        if (this.movesMultipleNodes()) {
            for (int i = 0; i < this.selection.size(); ++i) {
                LocationModel.getModel((NodeModel)this.selection.get(i)).setHGap(this.originalHGaps.get(i));
            }
        } else {
            LocationModel.getModel((NodeModel)this.getNode()).setHGap(this.originalHGap);
        }
    }

    private void resetDragStartingPoint() {
        this.dragStartingPoint = null;
        this.effectiveParentVGap = this.originalAssignedParentVGap = LocationModel.DEFAULT_VGAP;
        this.effectiveBaseHGap = this.originalAssignedBaseHGap = LocationModel.DEFAULT_HGAP;
        this.originalHGap = LocationModel.DEFAULT_HGAP;
        this.originalShiftY = LocationModel.DEFAULT_SHIFT_Y;
        this.originalAssignedVGaps = null;
        this.originalAssignedBaseHGaps = null;
        this.originalHGaps = null;
        this.parentSelection = null;
        this.selection = null;
        this.draggedNodeView = null;
    }

    private void stopDrag() {
        this.resetDragStartingPoint();
    }

    protected boolean editsOnDoubleClick() {
        return ResourceController.getResourceController().getBooleanProperty(EDIT_ON_DOUBLE_CLICK);
    }
}

