/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.AccessedNodes;
import org.freeplane.features.explorer.GlobalNodes;
import org.freeplane.features.explorer.MapExplorer;
import org.freeplane.features.explorer.NodeAlias;
import org.freeplane.features.explorer.NodeNotFoundException;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;

public class MapExplorerController
implements IExtension {
    private static final String TRUE = "true";
    private static final String GLOBALLY_VISIBLE = "GLOBALLY_VISIBLE";
    private static final String ALIAS = "ALIAS";
    public static final String GLOBAL_NODES = "GLOBAL_NODES";
    protected final ModeController modeController;

    public static void install(ModeController modeController) {
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        final MapReader mapReader = mapController.getMapReader();
        readManager.addAttributeHandler("node", ALIAS, new IAttributeHandler(){

            @Override
            public void setAttribute(Object node, String value) {
                NodeAlias.setAlias((NodeModel)node, value);
            }
        });
        readManager.addAttributeHandler("node", GLOBALLY_VISIBLE, new IAttributeHandler(){

            @Override
            public void setAttribute(Object node, String value) {
                if (Boolean.parseBoolean(value)) {
                    MapModel map = mapReader.getCurrentNodeTreeCreator().getCreatedMap();
                    GlobalNodes nodes = GlobalNodes.writeableOf(map);
                    nodes.makeGlobal((NodeModel)node);
                }
            }
        });
        writeManager.addAttributeWriter("node", new IAttributeWriter(){

            @Override
            public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
                NodeAlias alias;
                NodeModel node = (NodeModel)userObject;
                if (GlobalNodes.isGlobal(node)) {
                    writer.addAttribute(MapExplorerController.GLOBALLY_VISIBLE, MapExplorerController.TRUE);
                }
                if ((alias = node.getExtension(NodeAlias.class)) != null) {
                    writer.addAttribute(MapExplorerController.ALIAS, alias.value);
                }
            }
        });
    }

    public MapExplorerController(ModeController modeController) {
        this.modeController = modeController;
    }

    public boolean isGlobal(NodeModel node) {
        return GlobalNodes.isGlobal(node);
    }

    public MapExplorer getMapExplorer(NodeModel start, String path, AccessedNodes accessedNodes) {
        return new MapExplorer(start, path, accessedNodes);
    }

    public String getNodeReferenceSuggestion(NodeModel node) {
        String alias;
        StringBuilder sb = new StringBuilder();
        if (this.isGlobal(node)) {
            sb.append(':');
        }
        if (!(alias = this.getAlias(node)).isEmpty()) {
            sb.append('~').append(alias);
        } else {
            sb.append('\'').append(TextUtils.getShortText(HtmlUtils.htmlToPlain(node.getText()), 10, "...")).append('\'');
        }
        return sb.toString();
    }

    public String getAlias(NodeModel node) {
        return NodeAlias.getAlias(node);
    }

    public NodeModel getNodeAt(NodeModel start, String reference) {
        return this.getNodeAt(start, reference, AccessedNodes.IGNORE);
    }

    private NodeModel getNodeAt(NodeModel start, String reference, AccessedNodes accessedNodes) {
        block5: {
            if (reference.startsWith("ID")) {
                return start.getMap().getNodeForID(reference);
            }
            if (start != null && reference.startsWith("at(") && reference.endsWith(")")) {
                String path = reference.substring(3, reference.length() - 1);
                path = URLDecoder.decode(path, StandardCharsets.UTF_8);
                try {
                    return new MapExplorer(start, path, accessedNodes).getNode();
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    break block5;
                }
                catch (IllegalArgumentException e) {
                    LogUtils.warn("Invalid reference format in" + reference);
                    break block5;
                }
            }
            LogUtils.warn("Invalid reference format in" + reference);
        }
        return null;
    }
}

