/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ButtonModelStateChangeListenerForProperty;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.components.ToolbarLayout;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.resizer.UIComponentVisibilityDispatcher;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.menu.JUnitPanel;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.ApplyNoFilteringAction;
import org.freeplane.features.filter.ApplySelectedViewConditionAction;
import org.freeplane.features.filter.ApplyToVisibleAction;
import org.freeplane.features.filter.EditFilterAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterHistory;
import org.freeplane.features.filter.FilterMenuBuilder;
import org.freeplane.features.filter.FindAction;
import org.freeplane.features.filter.HideMatchingNodesAction;
import org.freeplane.features.filter.QuickAndFilterAction;
import org.freeplane.features.filter.QuickFilterAction;
import org.freeplane.features.filter.QuickFindAction;
import org.freeplane.features.filter.QuickFindAllAction;
import org.freeplane.features.filter.QuickHighlightAction;
import org.freeplane.features.filter.QuickOrFilterAction;
import org.freeplane.features.filter.ReapplyFilterAction;
import org.freeplane.features.filter.RedoFilterAction;
import org.freeplane.features.filter.SelectFilteredNodesAction;
import org.freeplane.features.filter.ShowAncestorsAction;
import org.freeplane.features.filter.ShowDescendantsAction;
import org.freeplane.features.filter.UndoFilterAction;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ConditionSnapshotFactory;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.condition.NoFilteringCondition;
import org.freeplane.features.filter.condition.SelectedViewCondition;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.map.CloneOfSelectedViewCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapNavigationUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLWriter;

public class FilterController
implements IExtension,
IMapViewChangeListener {
    public static final Color HIGHLIGHT_COLOR = Color.MAGENTA;
    public static int TOOLBAR_SIDE = 0;
    public static final String FREEPLANE_FILTER_EXTENSION_WITHOUT_DOT = "mmfilter";
    private static final ASelectableCondition NO_FILTERING = NoFilteringCondition.createCondition();
    private final ButtonModel applyToVisibleNodeOnly;
    private ConditionFactory conditionFactory;
    private DefaultConditionRenderer conditionRenderer = null;
    private final FilterChangeListener filterChangeListener;
    private DefaultComboBoxModel filterConditions;
    private final FilterMenuBuilder filterMenuBuilder;
    private JComponent filterToolbar;
    private final FilterHistory history;
    private final String pathToFilterFile;
    private ASelectableCondition selectedViewCondition;
    private ASelectableCondition cloneOfSelectedViewCondition;
    private final ButtonModel hideMatchingNodes;
    private final ButtonModel showAncestors;
    private final ButtonModel approximateMatchingButtonModel;
    private final ButtonModel ignoreDiacriticsButtonModel;
    private final ButtonModel caseSensitiveButtonModel;
    private final ButtonModel showDescendants;
    private final ButtonModel highlightNodes;
    private ASelectableCondition highlightCondition;
    private ConditionalStyleModel highlightedConditionContext;
    private JComboBox activeFilterConditionComboBox;
    private final FilterConditionEditor quickEditor;
    static final int USER_DEFINED_CONDITION_START_INDEX = 3;
    private final QuickFilterAction quickFilterAction;
    private int mapChangeCounter;

    public static FilterController getController(Controller controller) {
        return controller.getExtension(FilterController.class);
    }

    public static FilterController getCurrentFilterController() {
        return FilterController.getController(Controller.getCurrentController());
    }

    public static Filter getFilter(MapModel map) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            return selection.getFilter();
        }
        Filter fallbackFilter = map.getExtension(Filter.class);
        if (fallbackFilter == null) {
            fallbackFilter = Filter.createTransparentFilter();
            map.putExtension(Filter.class, fallbackFilter);
        }
        return fallbackFilter;
    }

    public static void setFilter(MapModel map, Filter filter) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            selection.setFilter(filter);
        } else {
            map.putExtension(Filter.class, filter);
        }
    }

    public static void install() {
        final Controller controller = Controller.getCurrentController();
        FilterController extension = new FilterController();
        controller.addExtension(FilterController.class, extension);
        controller.getExtension(HighlightController.class).addNodeHighlighter(new NodeHighlighter(){

            @Override
            public boolean isNodeHighlighted(NodeModel node, boolean isPrinting) {
                return !isPrinting && FilterController.getController(controller).isNodeHighlighted(node);
            }

            @Override
            public void configure(NodeModel node, Graphics2D g, boolean isPrinting) {
                g.setColor(HIGHLIGHT_COLOR);
            }
        });
    }

    public FilterController() {
        Controller controller = Controller.getCurrentController();
        this.filterMenuBuilder = new FilterMenuBuilder(controller, this);
        this.history = new FilterHistory();
        this.filterChangeListener = new FilterChangeListener();
        this.showAncestors = new JToggleButton.ToggleButtonModel();
        Filter transparentFilter = Filter.createTransparentFilter();
        this.hideMatchingNodes = new JToggleButton.ToggleButtonModel();
        this.hideMatchingNodes.setSelected(transparentFilter.areMatchingNodesHidden());
        this.hideMatchingNodes.addChangeListener(this.filterChangeListener);
        this.showAncestors.setSelected(transparentFilter.areAncestorsShown());
        this.showAncestors.addChangeListener(this.filterChangeListener);
        this.showAncestors.addChangeListener(new ButtonModelStateChangeListenerForProperty("filter.showAncestors"));
        this.showDescendants = new JToggleButton.ToggleButtonModel();
        this.showDescendants.setSelected(transparentFilter.areDescendantsShown());
        this.showDescendants.addChangeListener(this.filterChangeListener);
        this.showDescendants.addChangeListener(new ButtonModelStateChangeListenerForProperty("filter.showDescendants"));
        this.highlightNodes = new JToggleButton.ToggleButtonModel();
        this.highlightNodes.setSelected(false);
        this.applyToVisibleNodeOnly = new JToggleButton.ToggleButtonModel();
        this.applyToVisibleNodeOnly.setSelected(false);
        this.approximateMatchingButtonModel = new JToggleButton.ToggleButtonModel();
        this.approximateMatchingButtonModel.setSelected(false);
        this.ignoreDiacriticsButtonModel = new JToggleButton.ToggleButtonModel();
        this.ignoreDiacriticsButtonModel.setSelected(false);
        this.caseSensitiveButtonModel = new JToggleButton.ToggleButtonModel();
        this.caseSensitiveButtonModel.setSelected(false);
        controller.getMapViewManager().addMapViewChangeListener(this);
        ToggleFilterToolbarAction showFilterToolbar = new ToggleFilterToolbarAction("ShowFilterToolbarAction", "/filter_toolbar");
        this.quickEditor = new FilterConditionEditor(this, 0, FilterConditionEditor.Variant.FILTER_TOOLBAR);
        this.quickEditor.setEnterKeyActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((QuickFindAction)Controller.getCurrentController().getAction("QuickFindAction.FORWARD")).executeAction(true);
                if (FilterController.this.getHighlightNodes().isSelected()) {
                    FilterController.this.setHighlightCondition(FilterController.this.quickEditor.getCondition(), null);
                }
            }
        });
        controller.addAction(showFilterToolbar);
        controller.addAction(new ApplyNoFilteringAction(this));
        controller.addAction(new ApplySelectedViewConditionAction(this));
        controller.addAction(new EditFilterAction(this));
        controller.addAction(new UndoFilterAction(this));
        controller.addAction(new RedoFilterAction(this));
        controller.addAction(new ReapplyFilterAction(this));
        controller.addAction(new SelectFilteredNodesAction(this));
        controller.addAction(new HideMatchingNodesAction(this));
        controller.addAction(new ShowAncestorsAction(this));
        controller.addAction(new ShowDescendantsAction(this));
        controller.addAction(new ApplyToVisibleAction(this));
        this.quickFilterAction = new QuickFilterAction(this, this.quickEditor);
        controller.addAction(this.quickFilterAction);
        controller.addAction(new QuickAndFilterAction(this, this.quickEditor));
        controller.addAction(new QuickOrFilterAction(this, this.quickEditor));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.BACK));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.FORWARD));
        controller.addAction(new QuickFindAllAction(this, this.quickEditor));
        controller.addAction(new QuickHighlightAction(this, this.quickEditor));
        FindAction find = new FindAction();
        controller.addAction(find);
        controller.addAction(find.getFindNextAction());
        controller.addAction(find.getFindPreviousAction());
        this.pathToFilterFile = ResourceController.getResourceController().getFreeplaneUserDirectory() + File.separator + "auto." + FREEPLANE_FILTER_EXTENSION_WITHOUT_DOT;
    }

    private void addStandardConditions() {
        ASelectableCondition noFiltering = NO_FILTERING;
        this.filterConditions.insertElementAt(noFiltering, 0);
        if (this.selectedViewCondition == null) {
            this.selectedViewCondition = SelectedViewCondition.CreateCondition();
        }
        this.filterConditions.insertElementAt(this.selectedViewCondition, 1);
        if (this.filterConditions.getSelectedItem() == null) {
            this.filterConditions.setSelectedItem(noFiltering);
        }
        if (this.cloneOfSelectedViewCondition == null) {
            this.cloneOfSelectedViewCondition = CloneOfSelectedViewCondition.createCondition();
        }
        this.filterConditions.insertElementAt(this.cloneOfSelectedViewCondition, 2);
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        if (this.filterToolbar == null) {
            return;
        }
        this.getHistory().clear();
        this.updateUILater();
    }

    private void updateUILater() {
        ++this.mapChangeCounter;
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterController.this.mapChangeCounter--;
                if (0 == FilterController.this.mapChangeCounter) {
                    FilterController.this.updateUI();
                }
            }
        });
    }

    private void updateUI() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            this.filterToolbar.setEnabled(true);
            this.activeFilterConditionComboBox.setEnabled(true);
            this.quickEditor.setEnabled(true);
            Filter filter = selection.getFilter();
            this.quickEditor.filterChanged(filter);
            this.updateSettingsFromFilter(filter);
            this.quickFilterAction.setSelected(this.isFilterActive());
        } else {
            this.filterConditions.setSelectedItem(this.filterConditions.getElementAt(0));
            this.filterToolbar.setEnabled(false);
            this.quickEditor.setEnabled(false);
            this.activeFilterConditionComboBox.setEnabled(false);
        }
    }

    void applyFilter(boolean force) {
        this.quickFilterAction.setSelected(this.isFilterActive());
        ASelectableCondition selectedCondition = this.getSelectedCondition();
        Filter filter = this.createFilter(selectedCondition);
        ICondition condition = this.condition(filter);
        if (condition != selectedCondition && condition instanceof ASelectableCondition) {
            this.getFilterConditions().setSelectedItem(condition);
        } else {
            this.applyFilter(force, filter);
            this.getHistory().add(filter);
        }
    }

    public void applyNoFiltering(MapModel map) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            this.getFilterConditions().setSelectedItem(NO_FILTERING);
        } else {
            Filter filter = new Filter(NO_FILTERING, this.hideMatchingNodes.isSelected(), this.showAncestors.isSelected(), this.showDescendants.isSelected(), false, null);
            map.putExtension(Filter.class, filter);
            filter.calculateFilterResults(map);
        }
    }

    public void applyFilter(MapModel map, boolean force, Filter filter) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && selection.getMap() == map) {
            this.applyFilter(force, filter);
            this.updateSettingsFromFilter(filter);
            this.getHistory().add(filter);
        } else {
            Filter oldFilter = (Filter)map.putExtension(Filter.class, filter);
            if (oldFilter == null || force || !filter.canUseFilterResultsFrom(oldFilter)) {
                filter.calculateFilterResults(map);
                NodeModel selectionRoot = selection.getSelectionRoot();
                if (!selectionRoot.isRoot()) {
                    filter.resetFilter(selectionRoot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFilter(boolean force, Filter filter) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            try {
                filter.displayFilterStatus();
                Controller.getCurrentController().getViewController().setWaitingCursor(true);
                Filter oldFilter = selection.getFilter();
                selection.setFilter(filter);
                MapModel map = selection.getSelected().getMap();
                if (force || !filter.canUseFilterResultsFrom(oldFilter)) {
                    filter.calculateFilterResults(map);
                    NodeModel selectionRoot = selection.getSelectionRoot();
                    if (!selectionRoot.isRoot()) {
                        filter.resetFilter(selectionRoot);
                    }
                } else {
                    filter.useFilterResultsFrom(oldFilter);
                }
                this.refreshMap(this, map);
                this.selectVisibleNodes(selection);
            }
            finally {
                Controller.getCurrentController().getViewController().setWaitingCursor(false);
            }
        }
    }

    private void refreshMap(Object source, MapModel map) {
        Controller.getCurrentModeController().getMapController().fireMapChanged(new MapChangeEvent(source, map, Filter.class, null, this, false));
    }

    public void selectVisibleNodes(IMapSelection selection) {
        Filter filter = selection.getFilter();
        NodeModel selectedVisible = selection.getSelected().getVisibleAncestorOrSelf(filter);
        selection.preserveNodeLocationOnScreen(selectedVisible, 0.5f, 0.5f);
        Set<NodeModel> selectedNodes = selection.getSelection();
        NodeModel[] array = new NodeModel[selectedNodes.size()];
        boolean next = false;
        for (NodeModel node : selectedNodes.toArray(array)) {
            if (next) {
                if (node.hasVisibleContent(filter)) continue;
                selection.toggleSelected(node);
                continue;
            }
            next = true;
        }
        NodeModel selected = selection.getSelected();
        if (!selected.hasVisibleContent(filter)) {
            if (selection.getSelection().size() > 1) {
                selection.toggleSelected(selected);
            } else {
                selection.selectAsTheOnlyOneSelected(selected.getVisibleAncestorOrSelf(filter));
            }
        }
        selection.setSiblingMaxLevel(selection.getSelected().getNodeLevel(filter));
    }

    void applySelectedViewCondition() {
        if (this.getFilterConditions().getSelectedItem() != this.selectedViewCondition) {
            this.getFilterConditions().setSelectedItem(this.selectedViewCondition);
        } else {
            this.applyFilter(true);
        }
    }

    private Filter createFilter(ASelectableCondition selectedCondition) {
        ASelectableCondition filterCondition = selectedCondition == null || selectedCondition.equals(NO_FILTERING) ? null : (selectedCondition instanceof ConditionSnapshotFactory ? ((ConditionSnapshotFactory)((Object)selectedCondition)).createSnapshotCondition() : selectedCondition);
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Filter baseFilter = selection != null ? selection.getFilter() : null;
        Filter filter = new Filter(filterCondition, this.hideMatchingNodes.isSelected(), this.showAncestors.isSelected(), this.showDescendants.isSelected(), this.applyToVisibleNodeOnly.isSelected(), baseFilter);
        return filter;
    }

    private JComponent createFilterToolbar() {
        Controller controller = Controller.getCurrentController();
        AbstractButton undoBtn = FreeplaneToolBar.createButton(controller.getAction("UndoFilterAction"));
        AbstractButton redoBtn = FreeplaneToolBar.createButton(controller.getAction("RedoFilterAction"));
        JAutoToggleButton hideMatchingNodesBox = new JAutoToggleButton(controller.getAction("HideMatchingNodesAction"), this.hideMatchingNodes);
        hideMatchingNodesBox.setSelected(this.hideMatchingNodes.isSelected());
        JAutoToggleButton showAncestorsBox = new JAutoToggleButton(controller.getAction("ShowAncestorsAction"), this.showAncestors);
        showAncestorsBox.setSelected(this.showAncestors.isSelected());
        JAutoToggleButton showDescendantsBox = new JAutoToggleButton(controller.getAction("ShowDescendantsAction"), this.showDescendants);
        JAutoToggleButton applyToVisibleBox = new JAutoToggleButton(controller.getAction("ApplyToVisibleAction"), this.applyToVisibleNodeOnly);
        AbstractButton btnEdit = FreeplaneToolBar.createButton(controller.getAction("EditFilterAction"));
        this.activeFilterConditionComboBox = new JComboBox(this.getFilterConditions()){
            {
                this.setMaximumRowCount(10);
            }

            @Override
            public String getToolTipText() {
                return "tooltip";
            }

            @Override
            public JToolTip createToolTip() {
                JToolTip tip = new JToolTip(){

                    @Override
                    public void setTipText(String tipText) {
                        JComponent renderer = (JComponent)FilterController.this.conditionRenderer.getCellRendererComponent(FilterController.this.activeFilterConditionComboBox.getSelectedItem(), false);
                        if (renderer.getPreferredSize().width > FilterController.this.activeFilterConditionComboBox.getWidth() * 4 / 5) {
                            renderer.setBorder(BorderFactory.createRaisedBevelBorder());
                            this.add(renderer);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        if (this.getComponentCount() == 0) {
                            return new Dimension();
                        }
                        Component renderer = this.getComponent(0);
                        return renderer.getPreferredSize();
                    }

                    @Override
                    public void layout() {
                        if (this.getComponentCount() == 0) {
                            return;
                        }
                        Component renderer = this.getComponent(0);
                        renderer.setLocation(0, 0);
                        renderer.setSize(this.getSize());
                    }
                };
                tip.setComponent(this);
                return tip;
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                int position = this.getHeight() / 5;
                return new Point(position, position);
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.activeFilterConditionComboBox);
        this.activeFilterConditionComboBox.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        AbstractButton reapplyFilterBtn = FreeplaneToolBar.createButton(controller.getAction("ReapplyFilterAction"));
        AbstractButton selectFilteredNodesBtn = FreeplaneToolBar.createButton(controller.getAction("SelectFilteredNodesAction"));
        AbstractButton filterSelectedBtn = FreeplaneToolBar.createButton(controller.getAction("ApplySelectedViewConditionAction"));
        AbstractButton noFilteringBtn = FreeplaneToolBar.createButton(controller.getAction("ApplyNoFilteringAction"));
        AbstractButton applyFindPreviousBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.BACK"));
        AbstractButton applyFindNextBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAction.FORWARD"));
        AbstractButton applyQuickFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFilterAction"));
        AbstractButton applyAndFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickAndFilterAction"));
        AbstractButton applyOrFilterBtn = FreeplaneToolBar.createButton(controller.getAction("QuickOrFilterAction"));
        AbstractButton applyQuickSelectBtn = FreeplaneToolBar.createButton(controller.getAction("QuickFindAllAction"));
        AbstractButton applyQuickHighlightBtn = FreeplaneToolBar.createButton(controller.getAction("QuickHighlightAction"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        JComponent searchOptionPanel = this.quickEditor.getOptionPanel();
        constraints.weightx = 1.0;
        searchOptionPanel.add((Component)new JUnitPanel(), constraints);
        constraints.weightx = 0.0;
        searchOptionPanel.add((Component)applyQuickHighlightBtn, constraints);
        searchOptionPanel.add((Component)applyQuickSelectBtn, constraints);
        searchOptionPanel.add((Component)applyQuickFilterBtn, constraints);
        FreeplaneToolBar searchPanel = new FreeplaneToolBar("searchPanel", 0);
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        ((Container)searchPanel).add((Component)applyFindPreviousBtn, constraints);
        ((Container)searchPanel).add((Component)applyFindNextBtn, constraints);
        constraints.gridy = 1;
        ((Container)searchPanel).add((Component)applyAndFilterBtn, constraints);
        ((Container)searchPanel).add((Component)applyOrFilterBtn, constraints);
        FreeplaneToolBar filterOptionPanel = new FreeplaneToolBar("filterOptionPanel", 0);
        constraints.gridy = 0;
        constraints.gridwidth = 8;
        constraints.gridheight = 1;
        filterOptionPanel.add((Component)this.activeFilterConditionComboBox, constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        filterOptionPanel.add((Component)hideMatchingNodesBox, constraints);
        filterOptionPanel.add((Component)showAncestorsBox, constraints);
        filterOptionPanel.add((Component)showDescendantsBox, constraints);
        filterOptionPanel.add((Component)applyToVisibleBox, constraints);
        constraints.weightx = 1.0;
        filterOptionPanel.add((Component)new JUnitPanel(), constraints);
        constraints.weightx = 0.0;
        filterOptionPanel.add((Component)reapplyFilterBtn, constraints);
        filterOptionPanel.add((Component)selectFilteredNodesBtn, constraints);
        filterOptionPanel.add((Component)filterSelectedBtn, constraints);
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        filterOptionPanel.add((Component)undoBtn, constraints);
        filterOptionPanel.add((Component)redoBtn, constraints);
        constraints.gridy = 1;
        filterOptionPanel.add((Component)noFilteringBtn, constraints);
        filterOptionPanel.add((Component)btnEdit, constraints);
        DefaultConditionRenderer toolbarConditionRenderer = new DefaultConditionRenderer(TextUtils.getText("filter_no_filtering"), false);
        this.activeFilterConditionComboBox.setRenderer(toolbarConditionRenderer);
        JPanel filterToolbar = new JPanel();
        filterToolbar.setLayout(ToolbarLayout.horizontal());
        filterToolbar.add(new JSeparator(1));
        filterToolbar.add(this.quickEditor.getPanel());
        filterToolbar.add(searchPanel);
        filterToolbar.add(new JSeparator(1));
        filterToolbar.add(filterOptionPanel);
        filterToolbar.setVisible(ResourceController.getResourceController().getBooleanProperty("filter_toolbar_visible"));
        UIComponentVisibilityDispatcher.install(filterToolbar, "filter_toolbar_visible");
        return filterToolbar;
    }

    protected ButtonModel getApplyToVisibleNodeOnly() {
        return this.applyToVisibleNodeOnly;
    }

    public ConditionFactory getConditionFactory() {
        if (this.conditionFactory == null) {
            this.conditionFactory = new ConditionFactory();
        }
        return this.conditionFactory;
    }

    DefaultConditionRenderer getConditionRenderer() {
        if (this.conditionRenderer == null) {
            this.conditionRenderer = new DefaultConditionRenderer(TextUtils.getText("filter_no_filtering"), true);
        }
        return this.conditionRenderer;
    }

    public DefaultComboBoxModel getFilterConditions() {
        if (this.filterConditions == null) {
            this.initConditions();
        }
        return this.filterConditions;
    }

    public JComponent getFilterToolbar() {
        if (this.filterToolbar == null) {
            this.filterToolbar = this.createFilterToolbar();
        }
        return this.filterToolbar;
    }

    public FilterConditionEditor getQuickEditor() {
        return this.quickEditor;
    }

    ASelectableCondition getSelectedCondition() {
        return (ASelectableCondition)this.getFilterConditions().getSelectedItem();
    }

    public ButtonModel getShowAncestors() {
        return this.showAncestors;
    }

    public ButtonModel getHideMatchingNodes() {
        return this.hideMatchingNodes;
    }

    public ButtonModel getShowDescendants() {
        return this.showDescendants;
    }

    public ButtonModel getHighlightNodes() {
        return this.highlightNodes;
    }

    void setHighlightCondition(ASelectableCondition condition, ConditionalStyleModel highlightedConditionContext) {
        this.highlightedConditionContext = highlightedConditionContext;
        if (condition != null) {
            this.highlightCondition = condition;
            this.getHighlightNodes().setSelected(true);
        } else {
            this.highlightCondition = null;
        }
        JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (mapViewComponent != null) {
            mapViewComponent.repaint();
        }
    }

    private void initConditions() {
        this.filterConditions = new DefaultComboBoxModel();
        this.addStandardConditions();
        this.filterConditions.setSelectedItem(this.filterConditions.getElementAt(0));
        this.filterConditions.addListDataListener(this.filterChangeListener);
    }

    public void loadDefaultConditions() {
        try {
            this.loadConditions(this.getFilterConditions(), this.pathToFilterFile, false);
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }

    void loadConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile, boolean showPopupOnError) throws IOException {
        block5: {
            try {
                IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
                File filterFile = new File(pathToFilterFile);
                StdXMLReader reader = new StdXMLReader(new BufferedInputStream(new FileInputStream(filterFile)));
                parser.setReader(reader);
                reader.setSystemID(filterFile.toURL().toString());
                XMLElement loader = (XMLElement)parser.parse();
                Vector<XMLElement> conditions = loader.getChildren();
                for (int i = 0; i < conditions.size(); ++i) {
                    ASelectableCondition condition = this.getConditionFactory().loadCondition(conditions.get(i));
                    if (condition == null) continue;
                    filterConditionModel.addElement(condition);
                }
            }
            catch (FileNotFoundException parser) {
            }
            catch (AccessControlException parser) {
            }
            catch (Exception e) {
                LogUtils.warn(e);
                if (!showPopupOnError) break block5;
                UITools.errorMessage(TextUtils.getText("filters_not_loaded"));
            }
        }
    }

    public void saveConditions() {
        try {
            this.saveConditions(this.getFilterConditions(), this.pathToFilterFile);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    void saveConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile) throws IOException {
        XMLElement saver = new XMLElement();
        saver.setName("filter_conditions");
        for (int i = 0; i < filterConditionModel.getSize(); ++i) {
            ASelectableCondition cond = (ASelectableCondition)filterConditionModel.getElementAt(i);
            if (cond == null || !cond.canBePersisted()) continue;
            cond.toXml(saver);
        }
        try (FileWriter writer = new FileWriter(pathToFilterFile);){
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.write(saver, true);
        }
    }

    void setFilterConditions(DefaultComboBoxModel newConditionModel) {
        this.filterConditions.removeListDataListener(this.filterChangeListener);
        this.filterConditions.removeAllElements();
        for (int i = 0; i < newConditionModel.getSize(); ++i) {
            this.filterConditions.addElement(newConditionModel.getElementAt(i));
        }
        this.filterConditions.setSelectedItem(newConditionModel.getSelectedItem());
        this.addStandardConditions();
        this.filterConditions.addListDataListener(this.filterChangeListener);
        this.applyFilter(false);
        this.filterMenuBuilder.updateMenus();
    }

    private void updateSettingsFromFilter(Filter filter) {
        this.getFilterConditions().removeListDataListener(this.filterChangeListener);
        this.showAncestors.removeChangeListener(this.filterChangeListener);
        this.showDescendants.removeChangeListener(this.filterChangeListener);
        ICondition condition = this.condition(filter);
        if (condition instanceof ASelectableCondition) {
            this.filterConditions.setSelectedItem(condition);
        } else {
            this.filterConditions.setSelectedItem(NO_FILTERING);
        }
        this.hideMatchingNodes.setSelected(filter.areMatchingNodesHidden());
        this.showAncestors.setSelected(filter.areAncestorsShown());
        this.showDescendants.setSelected(filter.areDescendantsShown());
        this.applyToVisibleNodeOnly.setSelected(filter.appliesToVisibleNodesOnly());
        this.filterConditions.addListDataListener(this.filterChangeListener);
        this.showAncestors.addChangeListener(this.filterChangeListener);
        this.showDescendants.addChangeListener(this.filterChangeListener);
        this.quickFilterAction.setSelected(this.isFilterActive());
    }

    private ICondition condition(Filter filter) {
        ICondition condition = filter.getCondition();
        if (condition == null) {
            return NO_FILTERING;
        }
        return condition;
    }

    void updateSettingsFromHistory() {
        Filter filter = this.getHistory().getCurrentFilter();
        this.updateSettingsFromFilter(filter);
    }

    NodeModel findNextInSubtree(NodeModel start, NodeModel subtreeRoot, MapController.Direction direction, ICondition condition, Filter filter) {
        NodeModel next = this.findNext(start, subtreeRoot, direction, condition, filter);
        if (next == null && subtreeRoot != null && subtreeRoot != start) {
            next = condition == null || condition.checkNode(subtreeRoot) ? subtreeRoot : this.findNext(subtreeRoot, subtreeRoot, direction, condition, filter);
        }
        return next;
    }

    NodeModel findNext(NodeModel from, NodeModel end, MapController.Direction direction, ICondition condition, Filter filter) {
        block6: {
            NodeModel next = from;
            while (true) {
                switch (direction) {
                    case FORWARD: 
                    case FORWARD_N_FOLD: {
                        next = MapNavigationUtils.findNext(direction, next, end);
                        break;
                    }
                    case BACK: 
                    case BACK_N_FOLD: {
                        next = MapNavigationUtils.findPrevious(direction, next, end);
                    }
                }
                if (next == null) {
                    return null;
                }
                if (!next.hasVisibleContent(filter)) continue;
                if (next == from) break block6;
                if (condition == null || condition.checkNode(next)) break;
            }
            return next;
        }
        return null;
    }

    public void redo() {
        this.getHistory().redo();
        this.updateSettingsFromHistory();
    }

    public void undo() {
        this.getHistory().undo();
        this.updateSettingsFromHistory();
    }

    private boolean isNodeHighlighted(NodeModel node) {
        try {
            if (this.highlightedConditionContext != null) {
                this.highlightedConditionContext.setDisabled(true);
            }
            boolean bl = this.highlightCondition != null && this.highlightCondition.checkNode(node);
            return bl;
        }
        finally {
            if (this.highlightedConditionContext != null) {
                this.highlightedConditionContext.setDisabled(false);
            }
        }
    }

    public ButtonModel getApproximateMatchingButtonModel() {
        return this.approximateMatchingButtonModel;
    }

    public ButtonModel getIgnoreDiacriticsButtonModel() {
        return this.ignoreDiacriticsButtonModel;
    }

    public ButtonModel getCaseSensitiveButtonModel() {
        return this.caseSensitiveButtonModel;
    }

    public void apply(ASelectableCondition condition) {
        DefaultComboBoxModel filterConditions = this.getFilterConditions();
        if (condition.equals(filterConditions.getSelectedItem())) {
            this.applyFilter(true);
        } else {
            filterConditions.setSelectedItem(condition);
        }
    }

    public EntryVisitor getMenuBuilder() {
        return this.filterMenuBuilder;
    }

    public boolean isFilterActive() {
        ASelectableCondition selectedCondition = this.getSelectedCondition();
        return NO_FILTERING != selectedCondition && null != selectedCondition;
    }

    private FilterHistory getHistory() {
        return this.history;
    }

    private class FilterChangeListener
    implements ListDataListener,
    ChangeListener {
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() == -1) {
                FilterController.this.applyFilter(false);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FilterController.this.applyFilter(false);
        }
    }

    @SelectableAction(checkOnPopup=true)
    private class ToggleFilterToolbarAction
    extends ToggleToolbarAction {
        private ToggleFilterToolbarAction(String actionName, String toolbarName) {
            super(actionName, toolbarName);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComponent toolbar = this.getToolbar();
            if (toolbar == null) {
                return;
            }
            boolean visible = this.isVisible();
            if (visible && !FilterController.this.quickEditor.isInputFieldFocused() && EventQueue.getCurrentEvent() instanceof KeyEvent) {
                FilterController.this.quickEditor.focusInputField(true);
            } else {
                this.changeFocusWhenVisibilityChanges(toolbar);
                super.actionPerformed(event);
            }
        }

        private void changeFocusWhenVisibilityChanges(JComponent toolBar) {
            final JComponent editorPanel = FilterController.this.quickEditor.getPanel();
            editorPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    FilterController.this.quickEditor.focusInputField(true);
                    editorPanel.removeAncestorListener(this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    Component selectedComponent = Controller.getCurrentController().getMapViewManager().getSelectedComponent();
                    if (selectedComponent != null) {
                        selectedComponent.requestFocusInWindow();
                    }
                    editorPanel.removeAncestorListener(this);
                }
            });
        }
    }
}

