/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.NodeModel;

public abstract class NodeLinkModel {
    private String targetID;
    private final NodeModel source;

    public NodeLinkModel(NodeModel source, String targetID) {
        this.targetID = targetID;
        this.source = source;
    }

    public NodeModel getSource() {
        return this.source;
    }

    public NodeModel getTarget() {
        return this.getSource().getMap().getNodeForID(this.getTargetID());
    }

    public String getTargetID() {
        return this.targetID;
    }

    void setTargetID(String targetID) {
        this.targetID = targetID;
    }

    public boolean isSelfLink() {
        return this.getSource().createID().equals(this.getTargetID());
    }

    public Collection<NodeLinkModel> clones() {
        Clones sourceNodeClones = this.getSource().subtreeClones();
        if (sourceNodeClones.size() == 1) {
            return Arrays.asList(this);
        }
        ArrayList<NodeLinkModel> clones = new ArrayList<NodeLinkModel>(sourceNodeClones.size());
        for (NodeModel sourceClone : sourceNodeClones) {
            NodeLinkModel cloneForSource = this.cloneForSource(sourceClone);
            if (cloneForSource == null) continue;
            clones.add(cloneForSource);
        }
        return clones;
    }

    public abstract NodeLinkModel cloneForSource(NodeModel var1);

    public abstract NodeLinkModel cloneForSource(NodeModel var1, String var2);
}

