/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.FirstGroupNode;
import org.freeplane.features.map.FirstGroupNodeFlag;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNodeFlag;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.n3.nanoxml.XMLElement;

@NodeHookDescriptor(hookName="SummaryNode", onceForMap=false)
public class SummaryNode
extends PersistentNodeHook
implements IExtension {
    public static void install() {
        new SummaryNode();
        new FirstGroupNode();
    }

    public static boolean isFirstGroupNode(NodeModel nodeModel) {
        return nodeModel.containsExtension(FirstGroupNodeFlag.class);
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        return SummaryNodeFlag.SUMMARY;
    }

    @Override
    protected Class<? extends IExtension> getExtensionClass() {
        return SummaryNodeFlag.class;
    }

    @Override
    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    public static boolean isSummaryNode(NodeModel nodeModel) {
        return nodeModel.containsExtension(SummaryNodeFlag.class);
    }

    public static NodeModel getRealNode(NodeModel nodeModel) {
        if (!SummaryNode.isSummaryNode(nodeModel)) {
            return nodeModel;
        }
        for (int i = nodeModel.getChildCount() - 1; i >= 0; --i) {
            NodeModel child = nodeModel.getChildAt(i);
            if (SummaryNode.isHidden(child)) continue;
            return child;
        }
        return nodeModel;
    }

    public static boolean isHidden(NodeModel nodeModel) {
        return !nodeModel.isFolded() && (nodeModel.hasChildren() && SummaryNode.isSummaryNode(nodeModel) || SummaryNode.isFirstGroupNode(nodeModel)) && nodeModel.getText().isEmpty();
    }

    public static int getSummaryLevel(NodeModel root, NodeModel node) {
        if (node.isRoot() || node == root || !SummaryNode.isSummaryNode(node)) {
            return 0;
        }
        NodeModel parentNode = node.getParentNode();
        int index = parentNode.getIndex(node);
        boolean isleft = node.isTopOrLeft(root);
        int level = 1;
        for (int i = index - 1; i > 0; --i) {
            NodeModel child = parentNode.getChildAt(i);
            if (isleft != child.isTopOrLeft(root)) continue;
            if (SummaryNode.isSummaryNode(child)) {
                ++level;
                continue;
            }
            return level;
        }
        return level;
    }
}

