/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.Color;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.FontSizeExtension;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.CloudShape;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeBorderModel;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.StyleMapModel;
import org.freeplane.features.styles.StyleNode;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.features.url.MapVersionInterpreter;

public class MapStyleModel
implements IExtension {
    private static final int FREEPLANE_VERSION_WITH_RICH_SELECTION_STYLE = 14;
    public static final String STYLES_PREDEFINED = "styles.predefined";
    public static final String STYLES_USER_DEFINED = "styles.user-defined";
    private static final StyleTranslatedObject STYLE_USER_DEFINED_TRANSLATED_OBJECT = new StyleTranslatedObject("styles.user-defined");
    private static final StyleTranslatedObject STYLE_PREDEFINED_TRANSLATED_OBJECT = new StyleTranslatedObject("styles.predefined");
    public static final String STYLES_AUTOMATIC_LAYOUT = "styles.AutomaticLayout";
    public static final IStyle DEFAULT_STYLE = new StyleTranslatedObject("default");
    public static final IStyle NEW_STYLE = new StyleTranslatedObject("newStyle");
    public static final IStyle SELECTION_STYLE = new StyleTranslatedObject("defaultstyle.selection");
    public static final IStyle DETAILS_STYLE = new StyleTranslatedObject("defaultstyle.details");
    public static final IStyle ATTRIBUTE_STYLE = new StyleTranslatedObject("defaultstyle.attributes");
    public static final IStyle NOTE_STYLE = new StyleTranslatedObject("defaultstyle.note");
    public static final IStyle FLOATING_STYLE = new StyleTranslatedObject("defaultstyle.floating");
    private Map<IStyle, NodeModel> styleNodes;
    private NodeModel defaultStyleNode;
    private MapModel styleMap;
    private ConditionalStyleModel conditionalStyleModel;
    private final DefaultComboBoxModel stylesComboBoxModel;
    private final Map<String, String> properties;
    private Color backgroundColor;
    private float zoom = 1.0f;
    private MapViewLayout mapViewLayout = MapViewLayout.MAP;
    private Quantity<LengthUnit> maxNodeWidth = null;
    private Quantity<LengthUnit> minNodeWidth = null;
    ArrayList<ListDataListener> listeners = new ArrayList();
    public static final String FOLLOWED_MAP_LOCATION_PROPERTY = "followedMapLocation";
    public static final String FOLLOWED_TEMPLATE_LOCATION_PROPERTY = "followedTemplateLocation";
    public static final String ASSOCIATED_TEMPLATE_LOCATION_PROPERTY = "associatedTemplateLocation";
    public static final String FOLLOWED_MAP_LAST_TIME = "followedMapLastTime";

    public static boolean isDefaultStyleNode(NodeModel node) {
        return node.getUserObject().equals(DEFAULT_STYLE);
    }

    public static boolean isStyleNode(NodeModel node) {
        return node.isLeaf() && node.getMap().getClass().equals(StyleMapModel.class);
    }

    public static boolean isUserStyleNode(NodeModel node) {
        return node.isLeaf() && node.getParentNode().getUserObject().equals(STYLE_USER_DEFINED_TRANSLATED_OBJECT);
    }

    public static boolean isPredefinedStyleNode(NodeModel node) {
        return node.isLeaf() && node.getParentNode().getUserObject().equals(STYLE_PREDEFINED_TRANSLATED_OBJECT);
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    public static MapStyleModel getExtension(MapModel map) {
        MapStyleModel model = map.getRootNode().getExtension(MapStyleModel.class);
        if (model == null) {
            model = map.getExtension(MapStyleModel.class);
        }
        return Objects.requireNonNull(model);
    }

    public MapModel getStyleMap() {
        return this.styleMap;
    }

    static MapStyleModel getExtensionOrNull(NodeModel node) {
        return node.getExtension(MapStyleModel.class);
    }

    public MapStyleModel() {
        this.conditionalStyleModel = new ConditionalStyleModel();
        this.styleNodes = new LinkedHashMap<IStyle, NodeModel>();
        this.properties = new LinkedHashMap<String, String>();
        this.stylesComboBoxModel = new DefaultComboBoxModel();
    }

    public ConditionalStyleModel getConditionalStyleModel() {
        return this.conditionalStyleModel;
    }

    private void insertStyleMap(MapModel map, MapModel styleMap) {
        this.styleMap = styleMap;
        styleMap.putExtension(MapStyleModel.class, this);
        NodeModel rootNode = styleMap.getRootNode();
        this.createNodeStyleMap(rootNode);
        styleMap.putExtension(IUndoHandler.class, map.getExtension(IUndoHandler.class));
        this.initStylesComboBoxModel();
    }

    public void refreshStyles() {
        NodeModel rootNode = this.styleMap.getRootNode();
        this.styleNodes.clear();
        this.stylesComboBoxModel.removeAllElements();
        this.defaultStyleNode = null;
        this.createNodeStyleMap(rootNode);
    }

    void createStyleMap(MapModel parentMap, String styleMapStr) {
        ModeController modeController = Controller.getCurrentModeController();
        StyleMapModel styleMap = new StyleMapModel(parentMap.getNodeDuplicator(), parentMap.getIconRegistry(), AttributeRegistry.getRegistry(parentMap), modeController.getMapController());
        styleMap.createNewRoot();
        MapReader mapReader = modeController.getMapController().getMapReader();
        StringReader styleReader = new StringReader(styleMapStr);
        try {
            NodeModel selectionStyleNode;
            NodeModel newNode;
            FontSizeExtension fontSizeExtension;
            NodeLinks nodeLinks;
            HashMap<Object, Object> hints = new HashMap<Object, Object>();
            hints.put((Object)MapWriter.Hint.MODE, (Object)MapWriter.Mode.FILE);
            hints.put("folding_loaded", Boolean.TRUE);
            NodeModel root = mapReader.createNodeTreeFromXml((MapModel)styleMap, (Reader)styleReader, hints);
            NodeStyleModel.setShapeConfiguration(root, NodeGeometryModel.NULL_SHAPE.withShape(NodeStyleShape.oval).withUniform(true));
            NodeStyleModel.createNodeStyleModel(root).setFontSize(24);
            styleMap.setRoot(root);
            Quantity<LengthUnit> styleBlockGap = ResourceController.getResourceController().getLengthQuantityProperty("style_block_gap");
            LocationModel.createLocationModel(root).setVGap(styleBlockGap);
            this.insertStyleMap(parentMap, styleMap);
            NodeModel predefinedStyleParentNode = this.createStyleGroupNode(styleMap, STYLES_PREDEFINED);
            this.createStyleGroupNode(styleMap, STYLES_USER_DEFINED);
            this.createStyleGroupNode(styleMap, STYLES_AUTOMATIC_LAYOUT);
            if (this.defaultStyleNode == null) {
                this.defaultStyleNode = new NodeModel(DEFAULT_STYLE, styleMap);
                predefinedStyleParentNode.insert(this.defaultStyleNode, 0);
                this.addStyleNode(this.defaultStyleNode);
            }
            if (this.maxNodeWidth != null && null == NodeSizeModel.getMaxNodeWidth(this.defaultStyleNode)) {
                NodeSizeModel.setMaxNodeWidth(this.defaultStyleNode, this.maxNodeWidth);
            }
            if (this.minNodeWidth != null && null == NodeSizeModel.getMinNodeWidth(this.defaultStyleNode)) {
                NodeSizeModel.setNodeMinWidth(this.defaultStyleNode, this.minNodeWidth);
            }
            if (this.styleNodes.get(DETAILS_STYLE) == null) {
                NodeModel newNode2 = new NodeModel(DETAILS_STYLE, styleMap);
                predefinedStyleParentNode.insert(newNode2, 1);
                this.addStyleNode(newNode2);
            }
            if ((nodeLinks = NodeLinks.createLinkExtension(this.defaultStyleNode)).getLinks().isEmpty()) {
                this.defaultStyleNode.createID();
                LinkController linkController = LinkController.getController();
                ConnectorModel connector = new ConnectorModel(this.defaultStyleNode, this.defaultStyleNode.getID(), linkController.getStandardConnectorArrows(), linkController.getStandardDashArray(), linkController.getStandardConnectorColor(), linkController.getStandardConnectorOpacity(), linkController.getStandardConnectorShape(), linkController.getStandardConnectorWidth(), linkController.getStandardLabelFontFamily(), linkController.getStandardLabelFontSize());
                nodeLinks.addArrowlink(connector);
            }
            if (this.styleNodes.get(ATTRIBUTE_STYLE) == null) {
                NodeModel newNode3 = new NodeModel(ATTRIBUTE_STYLE, styleMap);
                int defaultFontSize = 9;
                NodeStyleModel.createNodeStyleModel(newNode3).setFontSize(9);
                predefinedStyleParentNode.insert(newNode3, 2);
                this.addStyleNode(newNode3);
            }
            if ((fontSizeExtension = parentMap.getExtension(FontSizeExtension.class)) != null) {
                NodeStyleModel.createNodeStyleModel(this.styleNodes.get(ATTRIBUTE_STYLE)).setFontSize(fontSizeExtension.fontSize);
            }
            if (this.styleNodes.get(NOTE_STYLE) == null) {
                newNode = new NodeModel(NOTE_STYLE, styleMap);
                NodeStyleModel.createNodeStyleModel(newNode).setBackgroundColor(Color.WHITE);
                predefinedStyleParentNode.insert(newNode, 3);
                this.addStyleNode(newNode);
            }
            if (this.styleNodes.get(FLOATING_STYLE) == null) {
                newNode = new NodeModel(FLOATING_STYLE, styleMap);
                EdgeModel.createEdgeModel(newNode).setStyle(EdgeStyle.EDGESTYLE_HIDDEN);
                CloudModel.createModel(newNode).setShape(CloudShape.ROUND_RECT);
                predefinedStyleParentNode.insert(newNode, 4);
                this.addStyleNode(newNode);
            }
            if ((selectionStyleNode = this.styleNodes.get(SELECTION_STYLE)) == null) {
                selectionStyleNode = new NodeModel(SELECTION_STYLE, styleMap);
                ResourceController resourceController = ResourceController.getResourceController();
                Color standardSelectionBackgroundColor = ColorUtils.stringToColor(resourceController.getProperty("standardselectednodecolor"));
                Color standardSelectionRectangleColor = ColorUtils.stringToColor(resourceController.getProperty("standardselectednoderectanglecolor"));
                NodeStyleModel.setBackgroundColor(selectionStyleNode, standardSelectionBackgroundColor);
                NodeBorderModel.setBorderColor(selectionStyleNode, standardSelectionRectangleColor);
                NodeBorderModel.setBorderColorMatchesEdgeColor(selectionStyleNode, false);
                predefinedStyleParentNode.insert(selectionStyleNode, 5);
                this.addStyleNode(selectionStyleNode);
            } else if (MapVersionInterpreter.isOlderThan(parentMap, 14)) {
                NodeStyleModel.setShapeConfiguration(selectionStyleNode, NodeGeometryModel.NULL_SHAPE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected NodeModel createStyleGroupNode(MapModel styleMap, String groupName) {
        NodeModel root = styleMap.getRootNode();
        NodeModel predefinedStyleParentNode = this.getStyleNodeGroup(styleMap, groupName);
        if (predefinedStyleParentNode == null) {
            predefinedStyleParentNode = new NodeModel(styleMap);
            predefinedStyleParentNode.setUserObject(new StyleTranslatedObject(groupName));
            predefinedStyleParentNode.setSide(NodeModel.Side.BOTTOM_OR_RIGHT);
            root.insert(predefinedStyleParentNode);
        }
        NodeStyleModel.setShape(predefinedStyleParentNode, NodeStyleShape.bubble);
        return predefinedStyleParentNode;
    }

    private void createNodeStyleMap(NodeModel node) {
        if (node.hasChildren()) {
            Enumeration<NodeModel> children = node.children();
            while (children.hasMoreElements()) {
                this.createNodeStyleMap(children.nextElement());
            }
            return;
        }
        if (node.depth() >= 2) {
            this.addStyleNode(node);
        }
    }

    public void addStyleNode(NodeModel node) {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof IStyle)) {
            String description = userObject != null ? userObject + ", " + userObject.getClass().getName() : "null";
            LogUtils.severe("Bad user object " + description);
            return;
        }
        IStyle style = (IStyle)userObject;
        if (null == this.styleNodes.put(style, node) && !MapStyleModel.isPredefinedStyleNode(node)) {
            this.stylesComboBoxModel.addElement(style);
        }
        if (style.equals(DEFAULT_STYLE)) {
            this.defaultStyleNode = node;
        }
    }

    private void initStylesComboBoxModel() {
        NodeModel levelStyleParentNode;
        this.stylesComboBoxModel.removeAllElements();
        this.stylesComboBoxModel.addElement(DEFAULT_STYLE);
        this.stylesComboBoxModel.addElement(FLOATING_STYLE);
        NodeModel userStyleParentNode = this.getStyleNodeGroup(this.styleMap, STYLES_USER_DEFINED);
        if (userStyleParentNode != null) {
            for (NodeModel userStyleNode : userStyleParentNode.getChildren()) {
                this.stylesComboBoxModel.addElement(userStyleNode.getUserObject());
            }
        }
        if ((levelStyleParentNode = this.getStyleNodeGroup(this.styleMap, STYLES_AUTOMATIC_LAYOUT)) != null) {
            for (NodeModel userStyleNode : levelStyleParentNode.getChildren()) {
                this.stylesComboBoxModel.addElement(userStyleNode.getUserObject());
            }
        }
    }

    public void removeStyleNode(NodeModel node) {
        Object userObject = node.getUserObject();
        if (null != this.styleNodes.remove(userObject)) {
            this.stylesComboBoxModel.removeElement(userObject);
        }
        if (userObject.equals(DEFAULT_STYLE)) {
            this.defaultStyleNode = null;
        }
    }

    public NodeModel getStyleNodeSafe(IStyle style) {
        NodeModel node = this.getStyleNode(style);
        if (node != null) {
            return node;
        }
        return this.defaultStyleNode;
    }

    public NodeModel getDefaultStyleNode() {
        return this.defaultStyleNode;
    }

    public NodeModel getStyleNode(IStyle style) {
        if (style instanceof StyleNode) {
            return ((StyleNode)style).getNode();
        }
        NodeModel node = this.styleNodes.get(style);
        return node;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Set<IStyle> getStyles() {
        return this.styleNodes.keySet();
    }

    public List<IStyle> getNodeStyles() {
        IStyle style;
        NodeModel userStyles = this.getStyleNodeGroup(this.styleMap, STYLES_USER_DEFINED);
        NodeModel levelStyles = this.getStyleNodeGroup(this.styleMap, STYLES_AUTOMATIC_LAYOUT);
        ArrayList<IStyle> styles = new ArrayList<IStyle>(2 + userStyles.getChildCount() + levelStyles.getChildCount());
        styles.add(DEFAULT_STYLE);
        styles.add(FLOATING_STYLE);
        for (NodeModel styleNode : userStyles.getChildren()) {
            style = (IStyle)styleNode.getUserObject();
            styles.add(style);
        }
        for (NodeModel styleNode : levelStyles.getChildren()) {
            style = (IStyle)styleNode.getUserObject();
            styles.add(style);
        }
        return styles;
    }

    public float getZoom() {
        return this.zoom;
    }

    public MapViewLayout getMapViewLayout() {
        return this.mapViewLayout;
    }

    void setMapViewLayout(MapViewLayout mapViewLayout) {
        this.mapViewLayout = mapViewLayout;
    }

    void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setMaxNodeWidth(Quantity<LengthUnit> maxNodeWidth) {
        this.maxNodeWidth = maxNodeWidth;
    }

    public void setMinNodeWidth(Quantity<LengthUnit> minNodeWidth) {
        this.minNodeWidth = minNodeWidth;
    }

    void setStylesFrom(MapStyleModel source, boolean overwrite) {
        if (overwrite && source.styleMap != null || this.styleMap == null) {
            this.setStylesFrom(source);
        }
        if (overwrite && source.backgroundColor != null || this.backgroundColor == null) {
            this.setBackgroundFrom(source);
        }
    }

    private void setBackgroundFrom(MapStyleModel source) {
        this.backgroundColor = source.backgroundColor;
    }

    private void setStylesFrom(MapStyleModel source) {
        this.styleMap = source.styleMap;
        this.styleMap.putExtension(MapStyleModel.class, this);
        this.styleNodes = source.styleNodes;
        this.defaultStyleNode = this.styleNodes.get(DEFAULT_STYLE);
        this.initStylesComboBoxModel();
        this.conditionalStyleModel = source.conditionalStyleModel;
    }

    void setNonStyleUserPropertiesFrom(MapStyleModel oldStyleModel) {
        String edgeColorConfiguration = this.properties.get("edgeColorConfiguration");
        this.properties.clear();
        this.properties.putAll(oldStyleModel.properties);
        if (edgeColorConfiguration != null) {
            this.properties.put("edgeColorConfiguration", edgeColorConfiguration);
        }
    }

    void addUserStylesFrom(MapStyleModel source) {
        NodeModel targetGroup = this.getStyleNodeGroup(this.styleMap, STYLES_USER_DEFINED);
        NodeModel sourceGroup = this.getStyleNodeGroup(source.styleMap, STYLES_USER_DEFINED);
        for (NodeModel styleNode : sourceGroup.getChildren()) {
            IStyle sourceStyle = (IStyle)styleNode.getUserObject();
            if (this.styleNodes.containsKey(sourceStyle)) continue;
            NodeModel duplicate = styleNode.duplicate(false);
            duplicate.setMap(targetGroup.getMap());
            targetGroup.insert(duplicate);
            this.styleNodes.put(sourceStyle, duplicate);
            this.stylesComboBoxModel.addElement(sourceStyle);
        }
    }

    void addConditionalStylesFrom(MapStyleModel source) {
        this.conditionalStyleModel.addDifferentConditions(source.conditionalStyleModel);
    }

    public void setProperty(String key, String value) {
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public NodeModel getStyleNodeGroup(NodeModel styleNode) {
        int depth = styleNode.depth();
        if (depth < 1) {
            return null;
        }
        NodeModel node = styleNode;
        for (int i = depth; i > 1; --i) {
            node = node.getParentNode();
        }
        return node;
    }

    public NodeModel getStyleNodeGroup(MapModel styleMap, String group) {
        NodeModel rootNode = styleMap.getRootNode();
        int childCount = rootNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeModel childNode = rootNode.getChildAt(i);
            StyleTranslatedObject userObject = (StyleTranslatedObject)childNode.getUserObject();
            if (!userObject.getObject().equals(group)) continue;
            return childNode;
        }
        return null;
    }

    ComboBoxModel getStylesAsComboBoxModel() {
        return this.stylesComboBoxModel;
    }

    void copyStyle(NodeModel copiedStyleNode, IStyle styleKey) {
        NodeModel targetStyleNode = this.getStyleNode(styleKey);
        ModeController modeController = Controller.getCurrentModeController();
        if (targetStyleNode == null) {
            NodeModel sourceGroupNode = copiedStyleNode.getParentNode();
            String group = (String)((StyleTranslatedObject)sourceGroupNode.getUserObject()).getObject();
            MapModel styleMap = this.getStyleMap();
            NodeModel targetGroupNode = this.getStyleNodeGroup(styleMap, group);
            if (group.equals(STYLES_AUTOMATIC_LAYOUT)) {
                while (targetGroupNode.getChildCount() < sourceGroupNode.getChildCount() - 1) {
                    NodeModel source = sourceGroupNode.getChildAt(targetGroupNode.getChildCount());
                    targetStyleNode = new NodeModel(styleMap);
                    targetStyleNode.setUserObject(source.getUserObject());
                    targetGroupNode.insert(targetStyleNode);
                    modeController.copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, source, targetStyleNode);
                    this.addStyleNode(targetStyleNode);
                }
            }
            targetStyleNode = new NodeModel(styleMap);
            targetStyleNode.setUserObject(copiedStyleNode.getUserObject());
            targetGroupNode.insert(targetStyleNode);
            this.addStyleNode(targetStyleNode);
        } else {
            modeController.removeExtensions((Object)LogicalStyleKeys.NODE_STYLE, targetStyleNode, targetStyleNode);
        }
        modeController.copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, copiedStyleNode, targetStyleNode);
    }
}

